/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.lang;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.mrjulsen.crn.client.ClientWrapper;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2590;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7417;
import org.jetbrains.annotations.Nullable;

public class ModTranslatableComponent
implements class_7417 {
    private static final Object[] NO_ARGS = new Object[0];
    private static final class_5348 TEXT_PERCENT = class_5348.method_29430((String)"%");
    private static final class_5348 TEXT_NULL = class_5348.method_29430((String)"null");
    private final String key;
    private final Object[] args;
    @Nullable
    private class_2477 decomposedWith;
    private List<class_5348> decomposedParts = ImmutableList.of();
    private static final Pattern FORMAT_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    public ModTranslatableComponent(String string) {
        this.key = string;
        this.args = NO_ARGS;
    }

    public ModTranslatableComponent(String string, Object ... objects) {
        this.key = string;
        this.args = objects;
    }

    private void decompose() {
        class_2477 language = ClientWrapper.getCurrentClientLanguage();
        if (language != this.decomposedWith) {
            this.decomposedWith = language;
            String string = language.method_48307(this.key);
            try {
                ImmutableList.Builder builder = ImmutableList.builder();
                Objects.requireNonNull(builder);
                this.decomposeTemplate(string, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                this.decomposedParts = builder.build();
            }
            catch (class_2590 var4) {
                this.decomposedParts = ImmutableList.of((Object)class_5348.method_29430((String)string));
            }
        }
    }

    private void decomposeTemplate(String string, Consumer<class_5348> consumer) {
        Matcher matcher = FORMAT_PATTERN.matcher(string);
        int i = 0;
        int j = 0;
        while (matcher.find(j)) {
            String string2;
            int k = matcher.start();
            int l = matcher.end();
            if (k > j) {
                string2 = string.substring(j, k);
                if (string2.indexOf(37) != -1) {
                    throw new IllegalArgumentException();
                }
                consumer.accept(class_5348.method_29430((String)string2));
            }
            string2 = matcher.group(2);
            String string3 = string.substring(k, l);
            if ("%".equals(string2) && "%%".equals(string3)) {
                consumer.accept(TEXT_PERCENT);
            } else {
                int m;
                if (!"s".equals(string2)) {
                    throw new IllegalArgumentException("Unsupported format: '" + string3 + "'");
                }
                String string4 = matcher.group(1);
                int n = m = string4 != null ? Integer.parseInt(string4) - 1 : i++;
                if (m < this.args.length) {
                    consumer.accept(this.getArgument(m));
                }
            }
            j = l;
        }
        if (j < string.length()) {
            String string5 = string.substring(j);
            if (string5.indexOf(37) != -1) {
                throw new IllegalArgumentException();
            }
            consumer.accept(class_5348.method_29430((String)string5));
        }
    }

    public final class_5348 getArgument(int i) {
        if (i >= this.args.length) {
            throw new IllegalArgumentException();
        }
        Object object = this.args[i];
        if (object instanceof class_2561) {
            return (class_2561)object;
        }
        return object == null ? TEXT_NULL : class_5348.method_29430((String)object.toString());
    }

    public <T> Optional<T> method_27660(class_5348.class_5246<T> styledContentConsumer, class_2583 style) {
        class_5348 formattedText;
        Optional optional;
        this.decompose();
        Iterator<class_5348> var3 = this.decomposedParts.iterator();
        do {
            if (var3.hasNext()) continue;
            return Optional.empty();
        } while (!(optional = (formattedText = var3.next()).method_27658(styledContentConsumer, style)).isPresent());
        return optional;
    }

    public <T> Optional<T> method_27659(class_5348.class_5245<T> contentConsumer) {
        class_5348 formattedText;
        Optional optional;
        this.decompose();
        Iterator<class_5348> var2 = this.decomposedParts.iterator();
        do {
            if (var2.hasNext()) continue;
            return Optional.empty();
        } while (!(optional = (formattedText = var2.next()).method_27657(contentConsumer)).isPresent());
        return optional;
    }

    public class_5250 method_10890(@Nullable class_2168 commandSourceStack, @Nullable class_1297 entity, int i) throws CommandSyntaxException {
        Object[] objects = new Object[this.args.length];
        for (int j = 0; j < objects.length; ++j) {
            Object object = this.args[j];
            objects[j] = object instanceof class_2561 ? class_2564.method_10881((class_2168)commandSourceStack, (class_2561)((class_2561)object), (class_1297)entity, (int)i) : object;
        }
        return class_5250.method_43477((class_7417)new ModTranslatableComponent(this.key, objects));
    }

    public boolean equals(Object object) {
        ModTranslatableComponent ModTranslatableComponent2;
        if (this == object) {
            return true;
        }
        if (object instanceof ModTranslatableComponent && this.key.equals((ModTranslatableComponent2 = (ModTranslatableComponent)object).getKey()) && Arrays.equals(this.args, ModTranslatableComponent2.getArgs())) {
            boolean var10000 = true;
            return var10000;
        }
        boolean var10000 = false;
        return var10000;
    }

    public int hashCode() {
        int i = this.key.hashCode();
        i = 31 * i + Arrays.hashCode(this.args);
        return i;
    }

    public String toString() {
        String var10000 = this.key;
        return "translation{key='" + var10000 + "', args=" + Arrays.toString(this.args) + "}";
    }

    public String getKey() {
        return this.key;
    }

    public Object[] getArgs() {
        return this.args;
    }
}

