/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import de.mrjulsen.crn.data.TagName;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.crn.util.Lock;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import java.util.AbstractMap;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class StationTag {
    public static final int MAX_NAME_LENGTH = 32;
    private static final String LEGACY_NBT_TAG_NAME = "AliasName";
    private static final String NBT_ID = "Id";
    private static final String NBT_TAG_NAME = "TagName";
    private static final String NBT_STATION_LIST = "Stations";
    private static final String NBT_STATION_MAP = "StationData";
    private static final String NBT_LAST_EDITOR = "LastEditor";
    private static final String NBT_LAST_EDITED_TIME = "LastEditedTimestamp";
    private static final String NBT_OWNER = "Owner";
    private static final String NBT_STATION_ENTRY_NAME = "Name";
    protected UUID id;
    protected TagName tagName;
    protected Map<String, StationInfo> stations = new HashMap<String, StationInfo>();
    protected Lock owner;
    protected Owner lastEditor;
    protected long lastEditedTime = 0L;

    protected StationTag(UUID id, TagName tagName, Lock owner, Map<String, StationInfo> initialValues, Owner lastEditor, long lastEditedTime) {
        this(id, tagName, owner, initialValues);
        this.lastEditor = lastEditor;
        this.lastEditedTime = lastEditedTime;
    }

    public StationTag(UUID id, TagName tagName, Owner owner, Map<String, StationInfo> initialValues) {
        this(id, tagName, new Lock(owner), initialValues);
    }

    public StationTag(UUID id, TagName tagName, Lock owner, Map<String, StationInfo> initialValues) {
        this(id, tagName, owner);
        this.stations.putAll(initialValues);
    }

    public StationTag(UUID id, TagName tagName, Owner owner) {
        this(id, tagName, new Lock(owner));
    }

    public StationTag(UUID id, TagName tagName, Lock owner) {
        this.id = id;
        this.tagName = tagName;
        this.owner = owner;
        this.updateLastEdited((Owner)owner.getOwner().orElse(null));
    }

    public StationTag(UUID id, TagName tagName, class_1657 owner, Map<String, StationInfo> initialValues) {
        this(id, tagName, new Owner(owner), initialValues);
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Lock getOwner() {
        return this.owner;
    }

    public StationTag copy() {
        return new StationTag(null, new TagName(this.getTagName().get()), this.getOwner(), new HashMap<String, StationInfo>(this.getAllStations()));
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        if (this.tagName == null) {
            return nbt;
        }
        DLUtils.doIfNotNull((Object)this.id, i -> nbt.method_25927(NBT_ID, i));
        nbt.method_10566(NBT_TAG_NAME, (class_2520)this.getTagName().toNbt());
        this.getLastEditor().ifPresent(x -> nbt.method_10566(NBT_LAST_EDITOR, (class_2520)x.toNbt()));
        nbt.method_10544(NBT_LAST_EDITED_TIME, this.lastEditedTime);
        nbt.method_10566(NBT_OWNER, (class_2520)this.owner.toNbt());
        class_2499 stationsList = new class_2499();
        this.stations.forEach((key, value) -> {
            class_2487 entry = new class_2487();
            entry.method_10582(NBT_STATION_ENTRY_NAME, key);
            value.writeNbt(entry);
            stationsList.add((Object)entry);
        });
        nbt.method_10566(NBT_STATION_MAP, (class_2520)stationsList);
        return nbt;
    }

    public static StationTag fromNbt(class_2487 nbt, UUID overwriteId) {
        Lock owner;
        UUID id = overwriteId == null ? (nbt.method_10545(NBT_ID) ? nbt.method_25926(NBT_ID) : null) : overwriteId;
        TagName name = TagName.fromNbt(nbt.method_10562(!nbt.method_10545(NBT_TAG_NAME) ? LEGACY_NBT_TAG_NAME : NBT_TAG_NAME));
        Owner lastEditor = nbt.method_10545(NBT_LAST_EDITOR) && nbt.method_10540(NBT_LAST_EDITOR) == 10 ? Owner.fromNbt(nbt.method_10562(NBT_LAST_EDITOR)) : null;
        long lastEditedTime = nbt.method_10537(NBT_LAST_EDITED_TIME);
        Lock lock = owner = nbt.method_10545(NBT_OWNER) && nbt.method_10540(NBT_OWNER) == 10 ? Lock.fromNbt(nbt.method_10562(NBT_OWNER)) : new Lock(new Owner((UUID)null));
        AbstractMap stations = nbt.method_10545(NBT_STATION_LIST) ? new HashMap<String, StationInfo>(nbt.method_10554(NBT_STATION_LIST, 8).stream().map(x -> ((class_2519)x).method_10714()).collect(Collectors.toMap(x -> x, x -> StationInfo.empty()))) : (nbt.method_10545(NBT_STATION_MAP) ? new HashMap<String, StationInfo>(nbt.method_10554(NBT_STATION_MAP, 10).stream().map(x -> (class_2487)x).collect(Collectors.toMap(x -> x.method_10558(NBT_STATION_ENTRY_NAME), x -> StationInfo.fromNbt(x)))) : new IdentityHashMap<String, StationInfo>());
        return new StationTag(id, name, owner, stations, lastEditor, lastEditedTime);
    }

    public Optional<Owner> getLastEditor() {
        return Optional.ofNullable(this.lastEditor);
    }

    private void updateLastEdited(Owner editor) {
        this.lastEditor = editor;
        this.lastEditedTime = new Date().getTime();
    }

    public void updateLastEdited(class_1657 player) {
        this.updateLastEdited(new Owner(player));
    }

    public Date getLastEditedTime() {
        return new Date(this.lastEditedTime);
    }

    public String getLastEditedTimeFormatted() {
        return DragonLib.DATE_FORMAT.format(this.getLastEditedTime());
    }

    public TagName getTagName() {
        return this.tagName;
    }

    public void updateInfoForStation(String station, StationInfo info) {
        if (this.stations.containsKey(station)) {
            this.stations.replace(station, info);
        }
    }

    public void add(String station, StationInfo info) {
        if (station.contains("*")) {
            Set<String> stationNames = TrainUtils.getAllStations().stream().map(x -> x.name).collect(Collectors.toSet());
            for (Map.Entry<String, List<String>> entry : ModUtils.mapWildcards(station, List.of(info.platform()), stationNames).entrySet()) {
                if (this.stations.containsKey(entry.getKey())) continue;
                String platformString = "";
                if (!entry.getValue().isEmpty()) {
                    platformString = entry.getValue().get(0);
                }
                this.stations.put(entry.getKey(), new StationInfo(platformString));
            }
            return;
        }
        if (!this.stations.containsKey(station)) {
            this.stations.put(station, info);
        }
    }

    public void addAll(Map<String, StationInfo> stations) {
        stations.forEach((key, value) -> {
            if (!this.stations.containsKey(key)) {
                this.stations.put((String)key, (StationInfo)value);
            }
        });
    }

    public boolean contains(String stationName) {
        String regex = stationName.isBlank() ? stationName : "\\Q" + stationName.replace("*", "\\E.*\\Q");
        for (String name : this.stations.keySet()) {
            if (!name.matches(regex)) continue;
            return true;
        }
        return false;
    }

    public boolean containsLiteral(String stationName) {
        return this.stations.containsKey(stationName);
    }

    public Set<String> getAllStationNames() {
        return Set.copyOf(this.stations.keySet());
    }

    public Map<String, StationInfo> getAllStations() {
        return Map.copyOf(this.stations);
    }

    public StationInfo getInfoForStation(String stationName) {
        return this.stations.containsKey(stationName) ? this.stations.get(stationName) : StationInfo.empty();
    }

    public void setName(TagName name) {
        this.tagName = name;
    }

    public void remove(String station) {
        this.stations.remove(station);
    }

    public ClientStationTag getClientTag(String station) {
        return new ClientStationTag(this.getTagName().get(), station, this.getInfoForStation(station), this.getId());
    }

    public String toString() {
        return this.getTagName().toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof StationTag) {
            StationTag alias = (StationTag)obj;
            if (!this.getTagName().equals(alias.getTagName())) {
                return false;
            }
            Set<String> stationNames = this.getAllStationNames();
            Set<String> otherStationNames = alias.getAllStationNames();
            if (stationNames.size() != otherStationNames.size()) {
                return false;
            }
            for (String name : stationNames) {
                if (otherStationNames.contains(name)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return 7 * Objects.hash(this.tagName);
    }

    public void applyFrom(StationTag newData) {
        this.tagName = newData.tagName;
        this.stations.clear();
        this.stations.putAll(newData.stations);
        this.lastEditedTime = newData.lastEditedTime;
        this.lastEditor = newData.lastEditor;
        this.owner = newData.owner;
    }

    public record StationInfo(String platform) {
        public static final int MAX_PLATFORM_NAME_LENGTH = 8;
        private static final String NBT_PLATFORM = "Platform";

        public static StationInfo empty() {
            return new StationInfo("");
        }

        public boolean isPlatformKnown() {
            return this.platform() != null && !this.platform().isBlank();
        }

        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10582(NBT_PLATFORM, this.platform());
            return nbt;
        }

        public void writeNbt(class_2487 nbt) {
            nbt.method_10582(NBT_PLATFORM, this.platform());
        }

        public static StationInfo fromNbt(class_2487 nbt) {
            return new StationInfo(nbt.method_10558(NBT_PLATFORM));
        }

        @Override
        public final boolean equals(Object obj) {
            if (obj instanceof StationInfo) {
                StationInfo other = (StationInfo)obj;
                return this.platform().equals(other.platform());
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return Objects.hash(this.platform());
        }
    }

    public record ClientStationTag(String tagName, String stationName, StationInfo info, UUID tagId) {
        public static final String NBT_TAG_NAME = "TagName";
        public static final String NBT_STATION_NAME = "StationName";
        public static final String NBT_STATION_INFO = "StationInfo";
        public static final String NBT_TAG_ID = "Id";

        public static ClientStationTag empty() {
            return new ClientStationTag("", "", StationInfo.empty(), new UUID(0L, 0L));
        }

        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10582("TagName", this.tagName());
            nbt.method_10582(NBT_STATION_NAME, this.stationName());
            nbt.method_10566(NBT_STATION_INFO, (class_2520)this.info().toNbt());
            nbt.method_25927("Id", this.tagId() == null ? new UUID(0L, 0L) : this.tagId());
            return nbt;
        }

        public static ClientStationTag fromNbt(class_2487 nbt) {
            if (nbt == null) {
                return ClientStationTag.empty();
            }
            return new ClientStationTag(nbt.method_10558("TagName"), nbt.method_10558(NBT_STATION_NAME), StationInfo.fromNbt(nbt.method_10562(NBT_STATION_INFO)), nbt.method_25926("Id"));
        }

        @Override
        public final boolean equals(Object other) {
            if (other instanceof ClientStationTag) {
                ClientStationTag o = (ClientStationTag)other;
                return o.tagName().equals(this.tagName()) && o.stationName().equals(this.stationName()) && o.info().equals(this.info());
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return 31 * Objects.hash(this.tagName, this.stationName, this.info);
        }
    }
}

