/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import de.mrjulsen.crn.util.Lock;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.DragonLib;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class TrainCategory {
    public static final int MAX_NAME_LENGTH = 32;
    private static final String NBT_ID = "Id";
    private static final String NBT_NAME = "Name";
    private static final String NBT_COLOR = "Color";
    private static final String NBT_LAST_EDITOR = "LastEditor";
    private static final String NBT_LAST_EDITED_TIME = "LastEditedTimestamp";
    private static final String NBT_OWNER = "Owner";
    private final UUID id;
    private String name;
    private int color = 0;
    protected final Lock owner;
    protected Owner lastEditor;
    protected long lastEditedTime = 0L;

    public TrainCategory(UUID id, String name, class_1657 player) {
        this(id, name, new Owner(player));
    }

    public TrainCategory(UUID id, String name, Owner owner) {
        this(id, name, new Lock(owner));
    }

    protected TrainCategory(UUID id, String name, Lock owner) {
        this.id = id;
        this.name = name;
        this.owner = owner;
        owner.getOwner().ifPresent(this::updateLastEdited);
    }

    public static UUID genMD5Uuid(String name) {
        byte[] nameBytes = name.getBytes(StandardCharsets.UTF_8);
        return UUID.nameUUIDFromBytes(nameBytes);
    }

    public UUID getId() {
        return this.id;
    }

    public String getCategoryName() {
        return this.name;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Lock getOwner() {
        return this.owner;
    }

    public Optional<Owner> getLastEditor() {
        return Optional.ofNullable(this.lastEditor);
    }

    private void updateLastEdited(Owner editor) {
        this.lastEditor = editor;
        this.lastEditedTime = new Date().getTime();
    }

    public void updateLastEdited(class_1657 player) {
        this.updateLastEdited(new Owner(player));
    }

    public Date getLastEditedTime() {
        return new Date(this.lastEditedTime);
    }

    public String getLastEditedTimeFormatted() {
        return DragonLib.DATE_FORMAT.format(this.getLastEditedTime());
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TrainCategory) {
            TrainCategory o = (TrainCategory)obj;
            return this.name.equals(o.name);
        }
        return false;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_25927(NBT_ID, this.id);
        this.getLastEditor().ifPresent(x -> nbt.method_10566(NBT_LAST_EDITOR, (class_2520)x.toNbt()));
        nbt.method_10544(NBT_LAST_EDITED_TIME, this.lastEditedTime);
        nbt.method_10566(NBT_OWNER, (class_2520)this.owner.toNbt());
        nbt.method_10582(NBT_NAME, this.getCategoryName());
        nbt.method_10569(NBT_COLOR, this.getColor());
        return nbt;
    }

    public static TrainCategory fromNbt(class_2487 nbt) {
        String name = nbt.method_10558(NBT_NAME);
        UUID id = nbt.method_10545(NBT_ID) ? nbt.method_25926(NBT_ID) : TrainCategory.genMD5Uuid(name);
        Owner lastEditor = nbt.method_10545(NBT_LAST_EDITOR) && nbt.method_10540(NBT_LAST_EDITOR) == 10 ? Owner.fromNbt(nbt.method_10562(NBT_LAST_EDITOR)) : null;
        long lastEditedTime = nbt.method_10537(NBT_LAST_EDITED_TIME);
        Lock owner = nbt.method_10545(NBT_OWNER) && nbt.method_10540(NBT_OWNER) == 10 ? Lock.fromNbt(nbt.method_10562(NBT_OWNER)) : new Lock(new Owner((UUID)null));
        TrainCategory category = new TrainCategory(id, name, owner);
        category.setColor(nbt.method_10550(NBT_COLOR));
        category.lastEditor = lastEditor;
        category.lastEditedTime = lastEditedTime;
        return category;
    }
}

