/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.navigation;

import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.data.SavedRoutesManager;
import de.mrjulsen.crn.data.navigation.ClientRoutePart;
import de.mrjulsen.crn.data.navigation.ClientTrainListener;
import de.mrjulsen.crn.data.navigation.Route;
import de.mrjulsen.crn.data.navigation.RoutePart;
import de.mrjulsen.crn.data.navigation.TransferConnection;
import de.mrjulsen.crn.data.train.ClientTrainStop;
import de.mrjulsen.crn.data.train.RoutePartProgressState;
import de.mrjulsen.crn.data.train.RouteProgressState;
import de.mrjulsen.crn.event.CRNEventsManager;
import de.mrjulsen.crn.event.events.DefaultTrainDataRefreshEvent;
import de.mrjulsen.crn.util.IListenable;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

public class ClientRoute
extends Route
implements AutoCloseable,
IListenable<ListenerNotificationData> {
    public static final String EVENT_UPDATE = "update";
    public static final String EVENT_ANNOUNCE_START = "announce_start";
    public static final String EVENT_ARRIVAL_AT_START = "arrival_at_start";
    public static final String EVENT_DEPARTURE_FROM_START = "departure_from_start";
    public static final String EVENT_WHILE_TRANSIT = "while_transit";
    public static final String EVENT_ANNOUNCE_STOPOVER = "announce_stopover";
    public static final String EVENT_ARRIVAL_AT_STOPOVER = "arrival_at_stopover";
    public static final String EVENT_DEPARTURE_AT_STOPOVER = "departure_from_stopover";
    public static final String EVENT_ANNOUNCE_TRANSFER_ARRIVAL_STATION = "announce_transfer_arrival_station";
    public static final String EVENT_ARRIVAL_AT_TRANSFER_ARRIVAL_STATION = "arrival_at_transfer_arrival_station";
    public static final String EVENT_DEPARTURE_FROM_TRANSFER_ARRIVAL_STATION = "departure_from_transfer_arrival_station";
    public static final String EVENT_WHILE_TRANSFER = "while_transfer";
    public static final String EVENT_ANNOUNCE_TRANSFER_DEPARTURE_STATION = "announce_transfer_departure_station";
    public static final String EVENT_ARRIVAL_AT_TRANSFER_DEPARTURE_STATION = "arrival_at_transfer_departure_station";
    public static final String EVENT_DEPARTURE_FROM_TRANSFER_DEPARTURE_STATION = "departure_from_transfer_departure_station";
    public static final String EVENT_ANNOUNCE_LAST_STOP = "announce_last_stop";
    public static final String EVENT_ARRIVAL_AT_LAST_STOP = "arrival_at_last_stop";
    public static final String EVENT_DEPARTURE_FROM_LAST_STOP = "departure_from_last_stop";
    public static final String EVENT_FIRST_STOP_STATION_CHANGED = "first_stop_station_changed";
    public static final String EVENT_FIRST_STOP_DELAYED = "first_stop_delayed";
    public static final String EVENT_TRANSFER_ARRIVAL_STATION_CHANGED = "transfer_arrival_station_changed";
    public static final String EVENT_TRANSFER_ARRIVAL_DELAYED = "transfer_arrival_delayed";
    public static final String EVENT_TRANSFER_DEPARTURE_STATION_CHANGED = "transfer_departure_station_changed";
    public static final String EVENT_TRANSFER_DEPARTURE_DELAYED = "transfer_departure_delayed";
    public static final String EVENT_LAST_STOP_STATION_CHANGED = "last_stop_station_changed";
    public static final String EVENT_LAST_STOP_DELAYED = "last_stop_delayed";
    public static final String EVENT_ANY_STOP_ANNOUNCED = "any_stop_announced";
    public static final String EVENT_ARRIVAL_AT_ANY_STOP = "arrival_at_any_stop";
    public static final String EVENT_DEPARTURE_FROM_ANY_STOP = "departure_from_any_stop";
    public static final String EVENT_ANNOUNCE_ANY_IMPORTANT_STATION = "announce_any_important_station";
    public static final String EVENT_ARRIVAL_AT_ANY_IMPORTANT_STATION = "arrival_at_any_important_station";
    public static final String EVENT_DEPARTURE_FROM_ANY_IMPORTANT_STATION = "departure_from_any_important_station";
    public static final String EVENT_ANY_STATION_DELAYED = "any_station_delayed";
    public static final String EVENT_ANY_STATION_CHANGED = "any_station_changed";
    public static final String EVENT_ANY_TRANSFER_ENDANGERED = "any_transfer_endangered";
    public static final String EVENT_ANY_TRANSFER_MISSED = "any_transfer_missed";
    public static final String EVENT_PART_CHANGED = "part_changed";
    public static final String EVENT_SCHEDULE_CHANGED = "schedule_changed";
    public static final String EVENT_ANY_TRAIN_CANCELLED = "train_cancelled";
    private static final String keyNotificationJourneyBeginsTitle = "gui.createrailwaysnavigator.route_overview.notification.journey_begins.title";
    private static final String keyNotificationJourneyBegins = "gui.createrailwaysnavigator.route_overview.notification.journey_begins";
    private static final String keyNotificationJourneyBeginsWithPlatform = "gui.createrailwaysnavigator.route_overview.notification.journey_begins_with_platform";
    private static final String keyNotificationPlatformChangedTitle = "gui.createrailwaysnavigator.route_overview.notification.platform_changed.title";
    private static final String keyNotificationPlatformChanged = "gui.createrailwaysnavigator.route_overview.notification.platform_changed";
    private static final String keyNotificationTrainDelayedTitle = "gui.createrailwaysnavigator.route_overview.notification.train_delayed.title";
    private static final String keyNotificationTrainDelayed = "gui.createrailwaysnavigator.route_overview.notification.train_delayed";
    private static final String keyNotificationTransferTitle = "gui.createrailwaysnavigator.route_overview.notification.transfer.title";
    private static final String keyNotificationTransfer = "gui.createrailwaysnavigator.route_overview.notification.transfer";
    private static final String keyNotificationTransferWithPlatform = "gui.createrailwaysnavigator.route_overview.notification.transfer_with_platform";
    private static final String keyNotificationConnectionEndangeredTitle = "gui.createrailwaysnavigator.route_overview.notification.connection_endangered.title";
    private static final String keyNotificationConnectionEndangered = "gui.createrailwaysnavigator.route_overview.notification.connection_endangered";
    private static final String keyNotificationConnectionMissedTitle = "gui.createrailwaysnavigator.route_overview.notification.connection_missed.title";
    private static final String keyNotificationConnectionMissed = "gui.createrailwaysnavigator.route_overview.notification.connection_missed";
    private static final String keyNotificationJourneyCompletedTitle = "gui.createrailwaysnavigator.route_overview.notification.journey_completed.title";
    private static final String keyNotificationJourneyCompleted = "gui.createrailwaysnavigator.route_overview.notification.journey_completed";
    private static final String keyNotificationConnectionCanceledTitle = "gui.createrailwaysnavigator.route_overview.connection_cancelled";
    private static final String keyNotificationConnectionCanceled = "gui.createrailwaysnavigator.route_overview.journey_interrupted";
    private final Map<String, IdentityHashMap<Object, Consumer<ListenerNotificationData>>> listeners = new HashMap<String, IdentityHashMap<Object, Consumer<ListenerNotificationData>>>();
    private final long id = System.nanoTime();
    private final Map<UUID, ClientRoutePart> listenerIds = new HashMap<UUID, ClientRoutePart>();
    private int listenersCount = 0;
    private boolean isClosed;
    private RouteProgressState progressState = RouteProgressState.BEFORE;
    private final Queue<QueuedAnnouncementEvent> queuedAnnouncements = new ConcurrentLinkedQueue<QueuedAnnouncementEvent>();
    private ClientRoutePart currentPart;
    private int currentPartIndex;
    private final Cache<List<ClientRoutePart>> clientParts = new Cache(() -> this.getParts().stream().filter(x -> x instanceof ClientRoutePart).map(x -> (ClientRoutePart)x).toList());
    private boolean savedRouteRemoved = false;
    private boolean showNotifications = false;
    private boolean stationChangedSent = false;
    private boolean scheduleChangedSent = false;
    private boolean stationDelayedSent = false;
    private boolean connectionWarningSent = false;
    private boolean cancelledSent = false;

    private void resetSpamBlockers() {
        this.stationChangedSent = false;
        this.scheduleChangedSent = false;
        this.connectionWarningSent = false;
        this.stationDelayedSent = false;
        this.cancelledSent = false;
    }

    public ClientRoute(List<RoutePart> parts, boolean realTimeTracker) {
        super(parts, realTimeTracker);
        this.currentPart = this.getFirstClientPart();
        if (((Boolean)ModCommonConfig.ADVANCED_LOGGING.get()).booleanValue()) {
            CreateRailwaysNavigator.LOGGER.info("Created new " + String.valueOf(this));
        }
        if (!realTimeTracker) {
            return;
        }
        this.getClientParts().forEach(x -> this.listenerIds.put(ClientTrainListener.register(x.getSessionId(), x.getTrainId(), x::update), (ClientRoutePart)x));
        CRNEventsManager.getEvent(DefaultTrainDataRefreshEvent.class).register("createrailwaysnavigator_" + this.id, this::update);
        this.addListener();
        this.createEvent(EVENT_UPDATE);
        this.createEvent(EVENT_ANNOUNCE_START);
        this.createEvent(EVENT_ARRIVAL_AT_START);
        this.createEvent(EVENT_DEPARTURE_FROM_START);
        this.createEvent(EVENT_WHILE_TRANSIT);
        this.createEvent(EVENT_ANNOUNCE_STOPOVER);
        this.createEvent(EVENT_ARRIVAL_AT_STOPOVER);
        this.createEvent(EVENT_DEPARTURE_AT_STOPOVER);
        this.createEvent(EVENT_ANNOUNCE_TRANSFER_ARRIVAL_STATION);
        this.createEvent(EVENT_ARRIVAL_AT_TRANSFER_ARRIVAL_STATION);
        this.createEvent(EVENT_DEPARTURE_FROM_TRANSFER_ARRIVAL_STATION);
        this.createEvent(EVENT_WHILE_TRANSFER);
        this.createEvent(EVENT_ANNOUNCE_TRANSFER_DEPARTURE_STATION);
        this.createEvent(EVENT_ARRIVAL_AT_TRANSFER_DEPARTURE_STATION);
        this.createEvent(EVENT_DEPARTURE_FROM_TRANSFER_DEPARTURE_STATION);
        this.createEvent(EVENT_ANNOUNCE_LAST_STOP);
        this.createEvent(EVENT_ARRIVAL_AT_LAST_STOP);
        this.createEvent(EVENT_DEPARTURE_FROM_LAST_STOP);
        this.createEvent(EVENT_FIRST_STOP_STATION_CHANGED);
        this.createEvent(EVENT_FIRST_STOP_DELAYED);
        this.createEvent(EVENT_TRANSFER_ARRIVAL_STATION_CHANGED);
        this.createEvent(EVENT_TRANSFER_ARRIVAL_DELAYED);
        this.createEvent(EVENT_TRANSFER_DEPARTURE_STATION_CHANGED);
        this.createEvent(EVENT_TRANSFER_DEPARTURE_DELAYED);
        this.createEvent(EVENT_LAST_STOP_STATION_CHANGED);
        this.createEvent(EVENT_LAST_STOP_DELAYED);
        this.createEvent(EVENT_ANY_STOP_ANNOUNCED);
        this.createEvent(EVENT_ARRIVAL_AT_ANY_STOP);
        this.createEvent(EVENT_DEPARTURE_FROM_ANY_STOP);
        this.createEvent(EVENT_ANNOUNCE_ANY_IMPORTANT_STATION);
        this.createEvent(EVENT_ARRIVAL_AT_ANY_IMPORTANT_STATION);
        this.createEvent(EVENT_DEPARTURE_FROM_ANY_IMPORTANT_STATION);
        this.createEvent(EVENT_ANY_STATION_DELAYED);
        this.createEvent(EVENT_ANY_STATION_CHANGED);
        this.createEvent(EVENT_ANY_TRANSFER_ENDANGERED);
        this.createEvent(EVENT_ANY_TRANSFER_MISSED);
        this.createEvent(EVENT_PART_CHANGED);
        this.createEvent(EVENT_SCHEDULE_CHANGED);
        this.createEvent(EVENT_ANY_TRAIN_CANCELLED);
        this.getFirstClientPart().listen(EVENT_ANNOUNCE_START, this, x -> {
            if (this.currentPartIndex > 0) {
                return;
            }
            this.sendNotification((class_2561)CustomLanguage.translate(keyNotificationJourneyBeginsTitle, this.getEnd().getRealTimeStationTag().tagName()), (class_2561)(this.getStart().getRealTimeStationTag().info().isPlatformKnown() ? CustomLanguage.translate(keyNotificationJourneyBeginsWithPlatform, this.getStart().getTrainDisplayName(), this.getStart().getDisplayTitle(), ModUtils.formatTime(this.getStart().getScheduledDepartureTime(), false), this.getStart().getRealTimeStationTag().info().platform()) : CustomLanguage.translate(keyNotificationJourneyBegins, this.getStart().getTrainDisplayName(), this.getStart().getDisplayTitle(), ModUtils.formatTime(this.getStart().getScheduledDepartureTime(), false))));
            this.queuedAnnouncements.add(new QueuedAnnouncementEvent(() -> {
                this.notifyListeners(EVENT_ANY_STOP_ANNOUNCED, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                this.notifyListeners(EVENT_ANNOUNCE_ANY_IMPORTANT_STATION, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                this.notifyListeners(EVENT_ANNOUNCE_START, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
            }, x.part(), x.trainStop()));
        });
        this.getFirstClientPart().listen(EVENT_ARRIVAL_AT_START, this, x -> {
            if (this.currentPartIndex != 0) {
                return;
            }
            this.progressState = RouteProgressState.AT_START;
            this.notifyListeners(EVENT_ARRIVAL_AT_ANY_STOP, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
            this.notifyListeners(EVENT_ARRIVAL_AT_ANY_IMPORTANT_STATION, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
            this.notifyListeners(EVENT_ARRIVAL_AT_START, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
        });
        this.getFirstClientPart().listen("departure_at_start", this, x -> {
            if (this.currentPartIndex != 0) {
                return;
            }
            this.progressState = RouteProgressState.TRAVELING;
            this.notifyListeners(EVENT_DEPARTURE_FROM_ANY_STOP, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
            this.notifyListeners(EVENT_DEPARTURE_FROM_ANY_IMPORTANT_STATION, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
            this.notifyListeners(EVENT_DEPARTURE_FROM_START, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
        });
        this.getFirstClientPart().listen(EVENT_FIRST_STOP_STATION_CHANGED, this, x -> {
            if (this.currentPartIndex > 0) {
                return;
            }
            this.notifyListeners(EVENT_ANY_STATION_CHANGED, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
            this.notifyListeners(EVENT_FIRST_STOP_STATION_CHANGED, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
        });
        this.getFirstClientPart().listen(EVENT_FIRST_STOP_DELAYED, this, x -> {
            if (this.currentPartIndex > 0) {
                return;
            }
            this.notifyListeners(EVENT_ANY_STATION_DELAYED, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
            this.notifyListeners(EVENT_FIRST_STOP_DELAYED, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
        });
        for (int i = 0; i < this.getParts().size(); ++i) {
            ClientRoutePart part = this.getClientParts().get(i);
            int k = i;
            if (i > 0) {
                part.listen(EVENT_ANNOUNCE_START, this, x -> {
                    if (this.currentPartIndex > k) {
                        return;
                    }
                    this.queuedAnnouncements.add(new QueuedAnnouncementEvent(() -> {
                        this.notifyListeners(EVENT_ANY_STOP_ANNOUNCED, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                        this.notifyListeners(EVENT_ANNOUNCE_ANY_IMPORTANT_STATION, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                        this.notifyListeners(EVENT_ANNOUNCE_TRANSFER_DEPARTURE_STATION, new ListenerNotificationData(this, x.part(), x.trainStop(), this.getConnectionWith(x.trainStop()).orElse(null)));
                    }, x.part(), x.trainStop()));
                });
                part.listen(EVENT_ARRIVAL_AT_START, this, x -> {
                    if (this.currentPartIndex != k) {
                        return;
                    }
                    this.progressState = RouteProgressState.BEFORE_CONTINUATION;
                    this.notifyListeners(EVENT_ARRIVAL_AT_ANY_STOP, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                    this.notifyListeners(EVENT_ARRIVAL_AT_ANY_IMPORTANT_STATION, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                    this.notifyListeners(EVENT_ARRIVAL_AT_TRANSFER_DEPARTURE_STATION, new ListenerNotificationData(this, x.part(), x.trainStop(), this.getConnectionWith(x.trainStop()).orElse(null)));
                });
                part.listen("departure_at_start", this, x -> {
                    if (this.currentPartIndex != k) {
                        return;
                    }
                    this.progressState = RouteProgressState.TRAVELING;
                    this.notifyListeners(EVENT_DEPARTURE_FROM_ANY_STOP, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                    this.notifyListeners(EVENT_DEPARTURE_FROM_ANY_IMPORTANT_STATION, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                    this.notifyListeners(EVENT_DEPARTURE_FROM_TRANSFER_DEPARTURE_STATION, new ListenerNotificationData(this, x.part(), x.trainStop(), this.getConnectionWith(x.trainStop()).orElse(null)));
                });
                part.listen(EVENT_FIRST_STOP_STATION_CHANGED, this, x -> {
                    if (this.currentPartIndex > k) {
                        return;
                    }
                    this.notifyListeners(EVENT_ANY_STATION_CHANGED, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                    this.notifyListeners(EVENT_TRANSFER_DEPARTURE_STATION_CHANGED, new ListenerNotificationData(this, x.part(), x.trainStop(), this.getConnectionWith(x.trainStop()).orElse(null)));
                });
                part.listen(EVENT_FIRST_STOP_DELAYED, this, x -> {
                    if (this.currentPartIndex > k) {
                        return;
                    }
                    this.notifyListeners(EVENT_ANY_STATION_DELAYED, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                    this.notifyListeners(EVENT_TRANSFER_DEPARTURE_DELAYED, new ListenerNotificationData(this, x.part(), x.trainStop(), this.getConnectionWith(x.trainStop()).orElse(null)));
                });
            }
            part.listen("next_stop_announced", this, x -> {
                if (this.currentPartIndex > k) {
                    return;
                }
                this.queuedAnnouncements.add(new QueuedAnnouncementEvent(() -> {
                    this.progressState = RouteProgressState.NEXT_STOP_ANNOUNCED;
                    this.notifyListeners(EVENT_ANY_STOP_ANNOUNCED, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                    this.notifyListeners(EVENT_ANNOUNCE_STOPOVER, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                }, x.part(), x.trainStop()));
            });
            part.listen(EVENT_ARRIVAL_AT_STOPOVER, this, x -> {
                if (this.currentPartIndex != k) {
                    return;
                }
                this.progressState = RouteProgressState.AT_STOPOVER;
                this.notifyListeners(EVENT_ARRIVAL_AT_ANY_STOP, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                this.notifyListeners(EVENT_ARRIVAL_AT_STOPOVER, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
            });
            part.listen("departure_at_stopover", this, x -> {
                if (this.currentPartIndex != k) {
                    return;
                }
                this.progressState = RouteProgressState.TRAVELING;
                this.notifyListeners(EVENT_DEPARTURE_FROM_ANY_STOP, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                this.notifyListeners(EVENT_DEPARTURE_AT_STOPOVER, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
            });
            part.listen(EVENT_SCHEDULE_CHANGED, this, x -> {
                if (this.scheduleChangedSent) {
                    return;
                }
                this.sendNotification((class_2561)CustomLanguage.translate("gui.createrailwaysnavigator.route_overview.notification.schedule_changed.title"), (class_2561)CustomLanguage.translate("gui.createrailwaysnavigator.route_overview.notification.schedule_changed"));
                this.notifyListeners(EVENT_SCHEDULE_CHANGED, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                this.scheduleChangedSent = true;
            });
            part.listen(EVENT_ANY_TRAIN_CANCELLED, this, x -> {
                if (this.cancelledSent) {
                    return;
                }
                this.sendNotification((class_2561)CustomLanguage.translate(keyNotificationConnectionCanceledTitle), (class_2561)CustomLanguage.translate(keyNotificationConnectionCanceled, x.part().getFirstStop().getTrainDisplayName()));
                this.notifyListeners(EVENT_ANY_TRAIN_CANCELLED, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                this.cancelledSent = true;
            });
            if (i >= parts.size() - 1) continue;
            part.listen("last_stop_announced", this, x -> {
                if (this.currentPartIndex > k) {
                    return;
                }
                this.queuedAnnouncements.add(new QueuedAnnouncementEvent(() -> {
                    this.progressState = RouteProgressState.TRANSFER_ANNOUNCED;
                    this.notifyListeners(EVENT_ANY_STOP_ANNOUNCED, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                    this.notifyListeners(EVENT_ANNOUNCE_ANY_IMPORTANT_STATION, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                    this.notifyListeners(EVENT_ANNOUNCE_TRANSFER_ARRIVAL_STATION, new ListenerNotificationData(this, x.part(), x.trainStop(), this.getConnectionWith(x.trainStop()).orElse(null)));
                }, x.part(), x.trainStop()));
            });
            part.listen(EVENT_ARRIVAL_AT_LAST_STOP, this, x -> {
                if (this.currentPartIndex != k) {
                    return;
                }
                this.progressState = RouteProgressState.AT_TRANSFER;
                this.notifyListeners(EVENT_ARRIVAL_AT_ANY_STOP, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                this.notifyListeners(EVENT_ARRIVAL_AT_ANY_IMPORTANT_STATION, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                this.notifyListeners(EVENT_ARRIVAL_AT_TRANSFER_ARRIVAL_STATION, new ListenerNotificationData(this, x.part(), x.trainStop(), this.getConnectionWith(x.trainStop()).orElse(null)));
            });
            part.listen("departure_at_last_stop", this, x -> {
                if (this.currentPartIndex != k) {
                    return;
                }
                this.progressState = RouteProgressState.WHILE_TRANSFER;
                this.notifyListeners(EVENT_DEPARTURE_FROM_ANY_STOP, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                this.notifyListeners(EVENT_DEPARTURE_FROM_ANY_IMPORTANT_STATION, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                this.notifyListeners(EVENT_DEPARTURE_FROM_TRANSFER_ARRIVAL_STATION, new ListenerNotificationData(this, x.part(), x.trainStop(), this.getConnectionWith(x.trainStop()).orElse(null)));
            });
            part.listen(EVENT_LAST_STOP_STATION_CHANGED, this, x -> {
                if (this.currentPartIndex > k) {
                    return;
                }
                this.notifyListeners(EVENT_ANY_STATION_CHANGED, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                this.notifyListeners(EVENT_TRANSFER_ARRIVAL_STATION_CHANGED, new ListenerNotificationData(this, x.part(), x.trainStop(), this.getConnectionWith(x.trainStop()).orElse(null)));
            });
            part.listen(EVENT_LAST_STOP_DELAYED, this, x -> {
                if (this.currentPartIndex > k) {
                    return;
                }
                this.notifyListeners(EVENT_ANY_STATION_DELAYED, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                this.notifyListeners(EVENT_TRANSFER_ARRIVAL_DELAYED, new ListenerNotificationData(this, x.part(), x.trainStop(), this.getConnectionWith(x.trainStop()).orElse(null)));
            });
        }
        this.getLastClientPart().listen("last_stop_announced", this, x -> {
            if (this.currentPartIndex > parts.size() - 1) {
                return;
            }
            this.queuedAnnouncements.add(new QueuedAnnouncementEvent(() -> {
                this.progressState = RouteProgressState.END_ANNOUNCED;
                this.notifyListeners(EVENT_ANY_STOP_ANNOUNCED, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                this.notifyListeners(EVENT_ANNOUNCE_ANY_IMPORTANT_STATION, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
                this.notifyListeners(EVENT_ANNOUNCE_LAST_STOP, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
            }, x.part(), x.trainStop()));
        });
        this.getLastClientPart().listen(EVENT_ARRIVAL_AT_LAST_STOP, this, x -> {
            if (this.currentPartIndex != parts.size() - 1) {
                return;
            }
            this.progressState = RouteProgressState.AT_END;
            this.notifyListeners(EVENT_ARRIVAL_AT_ANY_STOP, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
            this.notifyListeners(EVENT_ARRIVAL_AT_ANY_IMPORTANT_STATION, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
            this.notifyListeners(EVENT_ARRIVAL_AT_LAST_STOP, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
        });
        this.getLastClientPart().listen("departure_at_last_stop", this, x -> {
            if (this.currentPartIndex < parts.size() - 1) {
                return;
            }
            this.progressState = RouteProgressState.AFTER;
            this.sendNotification((class_2561)CustomLanguage.translate(keyNotificationJourneyCompletedTitle), (class_2561)CustomLanguage.translate(keyNotificationJourneyCompleted));
            if (!this.savedRouteRemoved) {
                this.savedRouteRemoved = true;
                SavedRoutesManager.removeRoute(this);
                SavedRoutesManager.push(true, null);
            }
            this.queuedAnnouncements.clear();
            this.notifyListeners(EVENT_DEPARTURE_FROM_ANY_STOP, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
            this.notifyListeners(EVENT_DEPARTURE_FROM_ANY_IMPORTANT_STATION, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
            this.notifyListeners(EVENT_DEPARTURE_FROM_LAST_STOP, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
        });
        this.getLastClientPart().listen(EVENT_LAST_STOP_STATION_CHANGED, this, x -> {
            if (this.currentPartIndex > parts.size() - 1) {
                return;
            }
            this.notifyListeners(EVENT_ANY_STATION_CHANGED, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
            this.notifyListeners(EVENT_LAST_STOP_STATION_CHANGED, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
        });
        this.getLastClientPart().listen(EVENT_LAST_STOP_DELAYED, this, x -> {
            if (this.currentPartIndex > parts.size() - 1) {
                return;
            }
            this.notifyListeners(EVENT_ANY_STATION_DELAYED, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
            this.notifyListeners(EVENT_LAST_STOP_DELAYED, new ListenerNotificationData(this, x.part(), x.trainStop(), null));
        });
        for (TransferConnection connection : this.getConnections()) {
            connection.listen("connection_endangered", this, x -> {
                if (this.connectionWarningSent) {
                    return;
                }
                this.queueConnectionEndangeredNotification((TransferConnection)x);
                this.notifyListeners(EVENT_ANY_TRANSFER_ENDANGERED, new ListenerNotificationData(this, null, null, (TransferConnection)x));
                this.connectionWarningSent = true;
            });
            connection.listen("connection_missed", this, x -> {
                if (this.connectionWarningSent) {
                    return;
                }
                this.queueConnectionMissedNotification((TransferConnection)x);
                this.notifyListeners(EVENT_ANY_TRANSFER_MISSED, new ListenerNotificationData(this, null, null, (TransferConnection)x));
                this.closeAll();
                this.connectionWarningSent = true;
            });
        }
        this.listen(EVENT_DEPARTURE_FROM_TRANSFER_ARRIVAL_STATION, this, p -> {
            int idx = parts.indexOf(p.part());
            if (idx >= 0 && idx < parts.size() - 1) {
                this.currentPart = this.getClientParts().get(idx + 1);
                this.currentPartIndex = idx + 1;
                ClientRoutePart part = this.getClientParts().get(this.currentPartIndex);
                this.notifyListeners(EVENT_PART_CHANGED, new ListenerNotificationData(this, part, part.getFirstClientStop(), p.connection()));
                if (part.getProgressState() != RoutePartProgressState.BEFORE && part.getProgressState() != RoutePartProgressState.AT_START) {
                    this.queueConnectionMissedNotification(p.connection());
                    this.notifyListeners(EVENT_ANY_TRANSFER_MISSED, new ListenerNotificationData(this, null, null, p.connection()));
                    this.closeAll();
                }
                return;
            }
            this.currentPart = p.part();
            this.currentPartIndex = idx;
        });
        this.listen(EVENT_ANY_STATION_CHANGED, this, p -> {
            if (this.stationChangedSent) {
                return;
            }
            this.sendNotification((class_2561)CustomLanguage.translate(keyNotificationPlatformChangedTitle), (class_2561)CustomLanguage.translate(keyNotificationPlatformChanged, p.trainStop().getTrainDisplayName(), p.trainStop().getRealTimeStationTag().info().platform()));
            this.stationChangedSent = true;
        });
        this.listen(EVENT_ANY_STATION_DELAYED, this, p -> {
            if (this.stationDelayedSent) {
                return;
            }
            this.queueDelayNotification(p.trainStop(), p.part().getFirstStop() == p.trainStop());
            this.stationDelayedSent = true;
        });
        this.listen(EVENT_ANNOUNCE_TRANSFER_ARRIVAL_STATION, this, p -> this.sendNotification((class_2561)CustomLanguage.translate(keyNotificationTransferTitle), (class_2561)(this.getStart().getRealTimeStationTag().info().isPlatformKnown() ? CustomLanguage.translate(keyNotificationTransferWithPlatform, p.connection().getDepartureStation().getTrainDisplayName(), p.connection().getDepartureStation().getDisplayTitle(), p.connection().getDepartureStation().getRealTimeStationTag().info().platform()) : CustomLanguage.translate(keyNotificationTransfer, p.connection().getDepartureStation().getTrainDisplayName(), p.connection().getDepartureStation().getDisplayTitle()))));
    }

    private void sendNotification(class_2561 title, class_2561 description) {
        if (this.shouldShowNotifications()) {
            ClientWrapper.sendCRNNotification(title, description);
        }
    }

    private void queueDelayNotification(ClientTrainStop stop, boolean start) {
        if (this.shouldShowNotifications()) {
            ClientWrapper.sendCRNNotification((class_2561)CustomLanguage.translate(keyNotificationTrainDelayedTitle, stop.getTrainDisplayName(), TimeUtils.parseDurationShort((long)((int)(start ? stop.getDepartureTimeDeviation() : stop.getArrivalTimeDeviation())))), (class_2561)CustomLanguage.translate(keyNotificationTrainDelayed, ModUtils.formatTime(start ? stop.getRoundedRealTimeDepartureTime() : stop.getRoundedRealTimeArrivalTime(), false), ModUtils.formatTime(start ? stop.getScheduledDepartureTime() : stop.getScheduledArrivalTime(), false), stop.getRealTimeStationTag().tagName()));
        }
    }

    private void queueConnectionEndangeredNotification(TransferConnection connection) {
        if (this.shouldShowNotifications()) {
            ClientWrapper.sendCRNNotification((class_2561)CustomLanguage.translate(keyNotificationConnectionEndangeredTitle), (class_2561)CustomLanguage.translate(keyNotificationConnectionEndangered, connection.getDepartureStation().getTrainDisplayName(), connection.getDepartureStation().getDisplayTitle()));
        }
    }

    private void queueConnectionMissedNotification(TransferConnection connection) {
        if (this.shouldShowNotifications()) {
            ClientWrapper.sendCRNNotification((class_2561)CustomLanguage.translate(keyNotificationConnectionMissedTitle), (class_2561)CustomLanguage.translate(keyNotificationConnectionMissed, connection.getDepartureStation().getTrainDisplayName(), connection.getDepartureStation().getDisplayTitle()));
        }
    }

    public static ClientRoute empty(boolean realTimeTracker) {
        return new ClientRoute(List.of(), realTimeTracker);
    }

    public RouteProgressState getState() {
        return this.progressState;
    }

    @Override
    public Map<String, IdentityHashMap<Object, Consumer<ListenerNotificationData>>> getListeners() {
        return this.listeners;
    }

    public boolean shouldShowNotifications() {
        return this.showNotifications;
    }

    public void setShowNotifications(boolean b) {
        this.showNotifications = b;
    }

    public List<ClientRoutePart> getClientParts() {
        return (List)this.clientParts.get();
    }

    public ClientRoutePart getFirstClientPart() {
        return this.getClientParts().get(0);
    }

    public ClientRoutePart getLastClientPart() {
        return this.getClientParts().get(this.getClientParts().size() - 1);
    }

    public ClientRoutePart getCurrentPart() {
        return this.currentPart;
    }

    public int getCurrentPartIndex() {
        return this.parts.indexOf(this.currentPart);
    }

    public void update() {
        if (this.isClosed) {
            return;
        }
        if (this.isAnyCancelled()) {
            this.closeAll();
            return;
        }
        this.notifyListeners(EVENT_UPDATE, new ListenerNotificationData(this, this.getCurrentPart(), this.getCurrentPart().getNextStop(), null));
        if (this.getState() == RouteProgressState.TRAVELING) {
            this.notifyListeners(EVENT_WHILE_TRANSIT, new ListenerNotificationData(this, this.getCurrentPart(), this.getCurrentPart().getNextStop(), null));
        } else if (this.getState() == RouteProgressState.WHILE_TRANSFER) {
            this.notifyListeners(EVENT_WHILE_TRANSFER, new ListenerNotificationData(this, this.getCurrentPart(), this.getCurrentPart().getNextStop(), null));
        }
        if (this.getState() == RouteProgressState.TRAVELING || this.getState() == RouteProgressState.WHILE_TRANSFER) {
            while (!this.queuedAnnouncements.isEmpty()) {
                QueuedAnnouncementEvent event = this.queuedAnnouncements.poll();
                if (this.getCurrentPart().getNextStop() != event.trainStop() || this.getCurrentPart() != event.part()) continue;
                event.callback().run();
                break;
            }
        }
        for (TransferConnection connection : this.getConnections()) {
            connection.update();
        }
        this.isCancelled.clear();
        this.resetSpamBlockers();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ROUTE[" + this.getStart().getRealTimeStationTag().tagName() + " -> " + this.getEnd().getRealTimeStationTag().tagName() + "]");
        return builder.toString();
    }

    public void addListener() {
        ++this.listenersCount;
    }

    @Override
    public void close() {
        --this.listenersCount;
        if (((Boolean)ModCommonConfig.ADVANCED_LOGGING.get()).booleanValue()) {
            CreateRailwaysNavigator.LOGGER.info("Route listener removed. Remaining: " + this.listenersCount);
        }
        if (this.listenersCount <= 0) {
            this.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        this.listenersCount = 0;
        Map<UUID, ClientRoutePart> map = this.listenerIds;
        synchronized (map) {
            for (Map.Entry<UUID, ClientRoutePart> e : this.listenerIds.entrySet()) {
                ClientTrainListener.unregister(e.getValue().getTrainId(), e.getKey());
            }
        }
        List<ClientRoutePart> clientParts = this.getClientParts();
        List<ClientRoutePart> list = clientParts;
        synchronized (list) {
            for (ClientRoutePart part : clientParts) {
                part.stopListeningAll(this);
                part.close();
            }
        }
        List<TransferConnection> connections = this.getConnections();
        List<TransferConnection> list2 = connections;
        synchronized (list2) {
            for (TransferConnection connection : connections) {
                connection.stopListeningAll(this);
                connection.close();
            }
        }
        this.stopListeningAll(this);
        CRNEventsManager.getEvent(DefaultTrainDataRefreshEvent.class).unregister("createrailwaysnavigator_" + this.id);
        this.clearEvents();
        this.isClosed = true;
        if (((Boolean)ModCommonConfig.ADVANCED_LOGGING.get()).booleanValue()) {
            CreateRailwaysNavigator.LOGGER.info("Route listener closed.");
        }
    }

    public static ClientRoute fromNbt(class_2487 nbt, boolean realTimeTracker) {
        return new ClientRoute(nbt.method_10554("Parts", 10).stream().map(x -> ClientRoutePart.fromNbt((class_2487)x)).toList(), realTimeTracker);
    }

    @Override
    public long timeOrderValue() {
        return this.getStart().getScheduledDepartureTime();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public record ListenerNotificationData(ClientRoute route, ClientRoutePart part, ClientTrainStop trainStop, TransferConnection connection) {
    }

    public record QueuedAnnouncementEvent(Runnable callback, ClientRoutePart part, ClientTrainStop trainStop) {
    }
}

