/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.navigation;

import com.google.common.collect.ImmutableList;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.data.ISavableNavigatorData;
import de.mrjulsen.crn.data.navigation.RoutePart;
import de.mrjulsen.crn.data.navigation.TransferConnection;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

public class Route
implements ISavableNavigatorData {
    protected static final String NBT_PARTS = "Parts";
    protected final List<RoutePart> parts;
    protected final List<TransferConnection> connections;
    protected final Cache<Boolean> isCancelled = new Cache(() -> this.getParts().stream().anyMatch(x -> x.isCancelled()));

    public Route(List<RoutePart> parts, boolean realTimeTracker) {
        this.parts = parts;
        this.connections = TransferConnection.getConnections(parts);
    }

    public static Route empty(boolean realTimeTracker) {
        return new Route(List.of(), realTimeTracker);
    }

    public List<TransferConnection> getConnections() {
        return this.connections;
    }

    public Optional<TransferConnection> getConnectionWith(TrainStop stop) {
        for (TransferConnection connection : this.getConnections()) {
            if (connection.getArrivalStation() != stop && connection.getDepartureStation() != stop) continue;
            return Optional.ofNullable(connection);
        }
        return Optional.empty();
    }

    public RoutePart getFirstPart() {
        return this.parts.get(0);
    }

    public RoutePart getLastPart() {
        return this.parts.get(this.parts.size() - 1);
    }

    public TrainStop getStart() {
        return this.getFirstPart().getFirstStop();
    }

    public TrainStop getEnd() {
        return this.getLastPart().getLastStop();
    }

    public ImmutableList<RoutePart> getParts() {
        return ImmutableList.copyOf(this.parts);
    }

    public int getTransferCount() {
        return this.parts.size() - 1;
    }

    public long departureIn() {
        return this.getFirstPart().departureIn();
    }

    public long arrivalAtDestinationIn() {
        return this.getLastPart().timeUntilEnd();
    }

    public long travelTime() {
        return this.arrivalAtDestinationIn() - this.departureIn();
    }

    public boolean isAnyCancelled() {
        return (Boolean)this.isCancelled.get();
    }

    public boolean isPartReachable(RoutePart part) {
        int idx = this.parts.indexOf(part);
        if (idx <= 0) {
            return true;
        }
        for (int i = 0; i < this.connections.size(); ++i) {
            if (!this.connections.get(i).isConnectionMissed()) continue;
            return i >= idx;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ROUTE[" + this.getStart().getRealTimeStationTag().tagName() + " -> " + this.getEnd().getRealTimeStationTag().tagName() + "]");
        return builder.toString();
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        class_2499 list = new class_2499();
        for (RoutePart part : this.parts) {
            list.add((Object)part.toNbt());
        }
        nbt.method_10566(NBT_PARTS, (class_2520)list);
        return nbt;
    }

    public static Route fromNbt(class_2487 nbt, boolean realTimeTracker) {
        return new Route(nbt.method_10554(NBT_PARTS, 10).stream().map(x -> RoutePart.fromNbt((class_2487)x)).toList(), realTimeTracker);
    }

    @Override
    public List<ISavableNavigatorData.SavableNavigatorDataLine> getOverviewData() {
        ArrayList<ISavableNavigatorData.SavableNavigatorDataLine> lines = new ArrayList<ISavableNavigatorData.SavableNavigatorDataLine>();
        lines.add(new ISavableNavigatorData.SavableNavigatorDataLine((class_2561)TextUtils.text((String)(ModUtils.formatTime(this.getStart().getScheduledDepartureTime(), false) + "   " + this.getStart().getRealTimeStationTag().tagName())), ModGuiIcons.ROUTE_START.getAsSprite(16, 16)));
        lines.add(new ISavableNavigatorData.SavableNavigatorDataLine((class_2561)TextUtils.text((String)(ModUtils.formatTime(this.getEnd().getScheduledArrivalTime(), false) + "   " + this.getEnd().getRealTimeStationTag().tagName())), ModGuiIcons.ROUTE_END.getAsSprite(16, 16)));
        lines.add(new ISavableNavigatorData.SavableNavigatorDataLine((class_2561)TextUtils.translate((String)"gui.createrailwaysnavigator.route_overview.date", (Object[])new Object[]{(this.getStart().getScheduledDepartureTime() + DragonLib.daytimeShift()) / DragonLib.ticksPerDay(), ModUtils.formatTime(this.getStart().getScheduledDepartureTime(), false)}).method_27693(" | ").method_27693(TimeUtils.parseDurationShort((long)this.departureIn())), ModGuiIcons.CALENDAR.getAsSprite(16, 16)));
        lines.add(new ISavableNavigatorData.SavableNavigatorDataLine((class_2561)TextUtils.translate((String)"gui.createrailwaysnavigator.route_overview.transfers", (Object[])new Object[]{this.getTransferCount()}).method_10852((class_2561)TextUtils.text((String)(" | " + TimeUtils.parseDurationShort((long)this.travelTime())))), ModGuiIcons.INFO.getAsSprite(16, 16)));
        if (this.isAnyCancelled()) {
            lines.add(new ISavableNavigatorData.SavableNavigatorDataLine((class_2561)TextUtils.translate((String)"gui.createrailwaysnavigator.route_overview.cancelled").method_27692(class_124.field_1061), ModGuiIcons.IMPORTANT.getAsSprite(16, 16)));
        }
        return lines;
    }

    @Override
    public ISavableNavigatorData.SavableNavigatorDataLine getTitle() {
        return new ISavableNavigatorData.SavableNavigatorDataLine((class_2561)TextUtils.translate((String)"gui.createrailwaysnavigator.saved_routes.saved_route"), ModGuiIcons.BOOKMARK.getAsSprite(16, 16));
    }

    @Override
    public long timeOrderValue() {
        return this.getStart().getScheduledDepartureTime();
    }
}

