/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.schedule.condition.ScheduledDelay;
import com.simibubi.create.content.trains.schedule.condition.TimedWaitCondition;
import com.simibubi.create.content.trains.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.trains.schedule.destination.ScheduleInstruction;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Pair;
import de.mrjulsen.crn.api.IPredictableWaitCondition;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.data.ETimeSource;
import de.mrjulsen.crn.data.schedule.INavigationExtension;
import de.mrjulsen.crn.data.schedule.condition.IDelayedWaitCondition;
import de.mrjulsen.crn.data.schedule.instruction.PrioritizedDestinationInstruction;
import de.mrjulsen.crn.data.train.DepartureHistory;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import dev.architectury.utils.GameInstance;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class TrainSeparationCondition
extends ScheduledDelay
implements IDelayedWaitCondition,
IPredictableWaitCondition {
    @Deprecated
    public static final String NBT_TIME = "Value";
    @Deprecated
    public static final String NBT_TIME_UNIT = "TimeUnit";
    public static final String NBT_TICKS = "Ticks";
    public static final String NBT_TRAIN_FILTER = "TrainFilter";
    public static final String NBT_TIME_SOURCE = "TimeSource";

    public TrainSeparationCondition() {
        this.data.method_10567(NBT_TRAIN_FILTER, DepartureHistory.ETrainFilter.ANY.getIndex());
        this.data.method_10569(NBT_TICKS, 100);
        this.data.method_10567(NBT_TIME_SOURCE, ETimeSource.REAL_LIFE.getIndex());
    }

    public Pair<class_1799, class_2561> getSummary() {
        return Pair.of((Object)class_1799.field_8037, (Object)TextUtils.translate((String)("createrailwaysnavigator.schedule.condition." + this.getId().method_12832() + ".title"), (Object[])new Object[]{this.formatTime(true)}));
    }

    public class_1799 getSecondLineIcon() {
        return new class_1799((class_1935)class_1802.field_8537);
    }

    public int totalWaitTicks() {
        return 0;
    }

    private int getSeparationTime() {
        if (this.data.method_10545(NBT_TICKS)) {
            return this.data.method_10550(NBT_TICKS);
        }
        return 0;
    }

    protected class_2561 formatTime(boolean compact) {
        int remainingTicks = this.getSeparationTime();
        switch (this.getTimeSource()) {
            case IN_GAME: {
                int[] t = TrainSeparationCondition.toInGameTime(remainingTicks);
                if (compact) {
                    return TextUtils.text((String)String.format("%d:%02d:%02d", t[2], t[1], t[0]));
                }
                return TextUtils.text((String)String.format("%dd %dh %dm", t[2], t[1], t[0]));
            }
        }
        int[] t = TrainSeparationCondition.toRealLifeTime(remainingTicks);
        if (compact) {
            return TextUtils.text((String)String.format("%d:%02d,%02d", t[2], t[1], t[0]));
        }
        return TextUtils.text((String)String.format("%dm %ds %dt", t[2], t[1], t[0]));
    }

    public List<class_2561> getTitleAs(String type) {
        return ImmutableList.of((Object)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().method_12832())), (Object)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().method_12832() + ".description"), (Object[])new Object[]{this.formatTime(false), TextUtils.translate((String)this.getTimeSource().getValueTranslationKey("createrailwaysnavigator")).getString()}).method_27692(class_124.field_1062), (Object)TextUtils.translate((String)this.getTrainFilter().getValueTranslationKey("createrailwaysnavigator")).method_27692(class_124.field_1075));
    }

    public boolean tickCompletion(class_1937 level, Train train, class_2487 context) {
        ScheduleEntry entry = (ScheduleEntry)train.runtime.getSchedule().entries.get(train.runtime.currentEntry);
        ((INavigationExtension)train.navigation).addDelayedWaitCondition((de.mrjulsen.mcdragonlib.data.Pair<IDelayedWaitCondition, IDelayedWaitCondition.DelayedWaitConditionContext>)de.mrjulsen.mcdragonlib.data.Pair.of((Object)this, (Object)new IDelayedWaitCondition.DelayedWaitConditionContext(level, train, context, train.getCurrentStation(), entry)));
        return true;
    }

    @Override
    public boolean runDelayed(IDelayedWaitCondition.DelayedWaitConditionContext context) {
        int delayValue = this.getSeparationTime();
        long lastDepartureTimestamp = Long.MIN_VALUE;
        ScheduleEntry entry = context.scheduleEntry();
        ScheduleInstruction scheduleInstruction = entry.instruction;
        if (scheduleInstruction instanceof PrioritizedDestinationInstruction) {
            PrioritizedDestinationInstruction instruction = (PrioritizedDestinationInstruction)scheduleInstruction;
            stationName = instruction.getFilters();
            lastDepartureTimestamp = stationName.stream().mapToLong(x -> DepartureHistory.getLatestDepartureFor(this.getTrainFilter(), context.train(), x)).max().orElse(0L);
        } else {
            stationName = entry.instruction;
            if (stationName instanceof DestinationInstruction) {
                DestinationInstruction instruction = (DestinationInstruction)stationName;
                stationName = instruction.getFilter();
                lastDepartureTimestamp = DepartureHistory.getLatestDepartureFor(this.getTrainFilter(), context.train(), (String)stationName);
            }
        }
        if (GameInstance.getServer() != null && lastDepartureTimestamp + (long)delayValue < GameInstance.getServer().method_30002().method_8510()) {
            DepartureHistory.updateDepartures(context.station().name, context.train());
            return true;
        }
        return false;
    }

    public class_2960 getId() {
        return new class_2960("createrailwaysnavigator", "train_separation");
    }

    public DepartureHistory.ETrainFilter getTrainFilter() {
        return DepartureHistory.ETrainFilter.getByIndex(this.data.method_10571(NBT_TRAIN_FILTER));
    }

    public ETimeSource getTimeSource() {
        return ETimeSource.getByIndex(this.data.method_10571(NBT_TIME_SOURCE));
    }

    @Environment(value=EnvType.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        ClientWrapper.initTimingAdjustmentGui(this, builder);
    }

    @Override
    public long waitUntil(long worldTime) {
        return worldTime + (long)this.totalWaitTicks();
    }

    public static int[] toRealLifeTime(int ticks) {
        int t = ticks;
        int m = t / 1200;
        int s = (t %= 1200) / 20;
        return new int[]{t %= 20, s, m};
    }

    public static int[] toInGameTime(int ticks) {
        int t = ticks;
        int d = (int)((long)t / DragonLib.ticksPerDay());
        t = (int)((long)t % DragonLib.ticksPerDay());
        int h = (int)((long)t / DragonLib.ticksPerIngameHour());
        t = (int)((long)t % DragonLib.ticksPerIngameHour());
        int m = (int)((long)t / (DragonLib.ticksPerIngameHour() / 60L));
        return new int[]{m, h, d};
    }

    public static int toTicksFromRealLife(int[] t) {
        return t[2] * TimedWaitCondition.TimeUnit.MINUTES.ticksPer + t[1] * TimedWaitCondition.TimeUnit.SECONDS.ticksPer + t[0];
    }

    public static int toTicksFromInGame(int[] t) {
        return (int)((long)t[2] * DragonLib.ticksPerDay() + (long)t[1] * DragonLib.ticksPerIngameHour() + (long)t[0] * (DragonLib.ticksPerIngameHour() / 60L));
    }
}

