/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.schedule.instruction;

import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.content.trains.schedule.destination.ScheduleInstruction;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Pair;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.data.TrainCategory;
import de.mrjulsen.crn.data.TrainLine;
import de.mrjulsen.crn.data.schedule.instruction.IPredictableInstruction;
import de.mrjulsen.crn.data.schedule.instruction.IStationTagInstruction;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.ScheduleSection;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.crn.registry.ModBlocks;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5244;
import net.minecraft.class_5250;

public class TravelSectionInstruction
extends ScheduleInstruction
implements IStationTagInstruction,
IPredictableInstruction {
    @Deprecated
    public static final String LEGACY_NBT_TRAIN_CATEGORY = "TrainGroup";
    public static final String NBT_TRAIN_CATEGORY = "TrainCategory";
    public static final String NBT_TRAIN_LINE = "TrainLine";
    public static final String NBT_INCLUDE_PREVIOUS_STATION = "IncludePreviousStation";
    public static final String NBT_USABLE = "Usable";
    private final class_5250 txtNone = TextUtils.translate((String)"gui.createrailwaysnavigator.section_settings.none").method_27692(class_124.field_1080);
    private final class_5250 txtLoading = TextUtils.empty().method_10852(Constants.TEXT_LOADING).method_27692(class_124.field_1080).method_27692(class_124.field_1056);
    private UUID lastCategoryId = null;
    private UUID lastLineId = null;
    private TrainCategory category;
    private TrainLine line;

    protected void readAdditional(class_2487 tag) {
        super.readAdditional(tag);
        if (!tag.method_10545(NBT_INCLUDE_PREVIOUS_STATION)) {
            tag.method_10556(NBT_INCLUDE_PREVIOUS_STATION, false);
        }
        if (!tag.method_10545(NBT_USABLE)) {
            tag.method_10556(NBT_USABLE, true);
        }
    }

    public Pair<class_1799, class_2561> getSummary() {
        return Pair.of((Object)new class_1799((class_1935)ModBlocks.ADVANCED_DISPLAY.get()), (Object)TextUtils.translate((String)("createrailwaysnavigator.schedule.instruction." + this.getId().method_12832())).method_27692(class_124.field_1075));
    }

    public class_2960 getId() {
        return new class_2960("createrailwaysnavigator", "travel_section");
    }

    public boolean supportsConditions() {
        return false;
    }

    private void requestCategory(UUID categoryId) {
        this.lastCategoryId = null;
        this.category = null;
        if (categoryId == null) {
            return;
        }
        DataAccessor.getFromServer((Object)categoryId, ModAccessorTypes.GET_TRAIN_CATEGORY, category -> {
            this.lastCategoryId = categoryId;
            this.category = category.orElse(null);
        });
    }

    private void requestLine(UUID lineId) {
        this.lastLineId = null;
        this.line = null;
        if (lineId == null) {
            return;
        }
        DataAccessor.getFromServer((Object)lineId, ModAccessorTypes.GET_TRAIN_LINE, line -> {
            this.lastLineId = lineId;
            this.line = line.orElse(null);
        });
    }

    public List<class_2561> getTitleAs(String type) {
        UUID categoryId = null;
        UUID lineId = null;
        if (this.data.method_10545(LEGACY_NBT_TRAIN_CATEGORY)) {
            categoryId = this.data.method_10540(LEGACY_NBT_TRAIN_CATEGORY) == 8 ? TrainCategory.genMD5Uuid(this.data.method_10558(LEGACY_NBT_TRAIN_CATEGORY)) : this.data.method_25926(LEGACY_NBT_TRAIN_CATEGORY);
        } else if (this.data.method_10545(NBT_TRAIN_CATEGORY)) {
            categoryId = this.data.method_25926(NBT_TRAIN_CATEGORY);
        }
        if (this.data.method_10545(NBT_TRAIN_LINE)) {
            lineId = this.data.method_10540(NBT_TRAIN_LINE) == 8 ? TrainLine.genMD5Uuid(this.data.method_10558(NBT_TRAIN_LINE)) : this.data.method_25926(NBT_TRAIN_LINE);
        }
        if (this.lastCategoryId == null || categoryId == null || !this.lastCategoryId.equals(categoryId)) {
            this.requestCategory(categoryId);
        }
        if (this.lastLineId == null || lineId == null || !this.lastLineId.equals(lineId)) {
            this.requestLine(lineId);
        }
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        lines.add((class_2561)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().method_12832())).method_27692(class_124.field_1065));
        lines.add((class_2561)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().method_12832() + ".description")).method_27692(class_124.field_1080));
        lines.add((class_2561)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().method_12832() + ".train_category")).method_27692(class_124.field_1062).method_10852((class_2561)(this.lastCategoryId == null && this.category != null ? this.txtLoading : (this.category == null ? this.txtNone : TextUtils.text((String)this.category.getCategoryName()).method_27692(class_124.field_1068)))));
        lines.add((class_2561)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().method_12832() + ".train_line")).method_27692(class_124.field_1062).method_10852((class_2561)(this.lastLineId == null && this.line != null ? this.txtLoading : (this.line == null ? this.txtNone : TextUtils.text((String)this.line.getLineName()).method_27692(class_124.field_1068)))));
        if (this.data.method_10545(NBT_INCLUDE_PREVIOUS_STATION)) {
            lines.add((class_2561)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().method_12832() + ".include_previous_station")).method_27692(class_124.field_1062).method_10852(this.data.method_10577(NBT_INCLUDE_PREVIOUS_STATION) ? class_5244.field_24336 : class_5244.field_24337));
        }
        if (this.data.method_10545(NBT_USABLE)) {
            lines.add((class_2561)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().method_12832() + ".usable")).method_27692(class_124.field_1062).method_10852(this.data.method_10577(NBT_USABLE) ? class_5244.field_24336 : class_5244.field_24337));
        }
        return lines;
    }

    @Environment(value=EnvType.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        ClientWrapper.initScheduleSectionInstruction(this, builder);
    }

    @Override
    public void run(ScheduleRuntime runtime, TrainData data, Train train, int index) {
        DLUtils.doIfNotNull((Object)data, x -> {
            x.addScheduleSection(this.getSectionData((TrainData)x, index));
            x.changeCurrentSection(index);
        });
    }

    private ScheduleSection getSectionData(TrainData data, int index) {
        String categoryNbtKey = null;
        categoryNbtKey = this.data.method_10545(LEGACY_NBT_TRAIN_CATEGORY) ? LEGACY_NBT_TRAIN_CATEGORY : NBT_TRAIN_CATEGORY;
        return new ScheduleSection(data, index, !this.data.method_10545(categoryNbtKey) || this.data.method_10540(categoryNbtKey) != 8 && this.data.method_10540(categoryNbtKey) != 11 ? null : (TrainCategory)GlobalSettings.getInstance().getTrainCategory(this.data.method_10540(categoryNbtKey) == 8 ? TrainCategory.genMD5Uuid(this.data.method_10558(categoryNbtKey)) : this.data.method_25926(categoryNbtKey)).orElse(null), !this.data.method_10545(NBT_TRAIN_LINE) || this.data.method_10540(NBT_TRAIN_LINE) != 8 && this.data.method_10540(NBT_TRAIN_LINE) != 11 ? null : (TrainLine)GlobalSettings.getInstance().getTrainLine(this.data.method_10540(NBT_TRAIN_LINE) == 8 ? TrainCategory.genMD5Uuid(this.data.method_10558(NBT_TRAIN_LINE)) : this.data.method_25926(NBT_TRAIN_LINE)).orElse(null), this.data.method_10577(NBT_INCLUDE_PREVIOUS_STATION), this.data.method_10577(NBT_USABLE));
    }

    @Override
    public void predict(TrainData data, ScheduleRuntime runtime, int indexInSchedule, Train train) {
        DLUtils.doIfNotNull((Object)data, x -> x.addScheduleSection(this.getSectionData((TrainData)x, indexInSchedule)));
    }
}

