/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.storage;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.station.GlobalStation;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.TagName;
import de.mrjulsen.crn.data.TrainCategory;
import de.mrjulsen.crn.data.TrainLine;
import de.mrjulsen.crn.data.UserSettings;
import de.mrjulsen.crn.data.train.ScheduleSection;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.data.INBTSerializable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class GlobalSettings
implements INBTSerializable {
    @Deprecated
    public static final String LEGACY_FILENAME = "createrailwaysnavigator_global_settings.dat";
    @Deprecated
    private static final String LEGACY_NBT_TRAIN_GROUPS = "TrainGroups";
    public static final String FILENAME = "createrailwaysnavigator_global_settings.nbt";
    public static final int DATA_VERSION = 2;
    private static final String NBT_VERSION = "Version";
    private static final String NBT_STATION_TAGS = "StationTags";
    private static final String NBT_TRAIN_CATEGORIES = "TrainCategories";
    private static final String NBT_STATION_BLACKLIST = "StationBlacklist";
    private static final String NBT_TRAIN_BLACKLIST = "TrainBlacklist";
    private static final String NBT_TRAIN_LINES = "TrainLines";
    private final MinecraftServer server;
    private final Map<UUID, StationTag> stationTags = new ConcurrentHashMap<UUID, StationTag>();
    private final Map<UUID, TrainCategory> trainCategories = new ConcurrentHashMap<UUID, TrainCategory>();
    private final Map<UUID, TrainLine> trainLines = new ConcurrentHashMap<UUID, TrainLine>();
    private final Set<String> stationBlacklist = new ConcurrentSkipListSet<String>();
    private final Set<String> trainBlacklist = new ConcurrentSkipListSet<String>();
    private static GlobalSettings instance;

    private GlobalSettings(MinecraftServer server) {
        this.server = server;
    }

    public static boolean modificationsAllowed(class_1657 player) {
        return player.method_5687(((Integer)ModCommonConfig.GLOBAL_SETTINGS_PERMISSION_LEVEL.get()).intValue());
    }

    public static synchronized GlobalSettings getInstance() {
        if (instance == null) {
            try {
                instance = GlobalSettings.open(ModCommonEvents.getCurrentServer().get());
            }
            catch (Exception e) {
                CreateRailwaysNavigator.LOGGER.error("Unable to open settings file.", (Throwable)e);
                instance = new GlobalSettings(ModCommonEvents.getCurrentServer().get());
            }
        }
        return instance;
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public static void clearInstance() {
        if (instance != null) {
            instance.close();
        }
        instance = null;
    }

    public synchronized void save() {
        class_2487 nbt = this.serializeNbt();
        try {
            class_2507.method_30614((class_2487)nbt, (File)new File(this.server.method_27050(new class_5218("data/createrailwaysnavigator_global_settings.nbt")).toString()));
            if (((Boolean)ModCommonConfig.ADVANCED_LOGGING.get()).booleanValue()) {
                CreateRailwaysNavigator.LOGGER.info("Saved global settings.");
            }
        }
        catch (IOException e) {
            CreateRailwaysNavigator.LOGGER.error("Unable to save global settings.", (Throwable)e);
        }
    }

    public static synchronized GlobalSettings open(MinecraftServer server) throws Exception {
        File legacyFile = new File(server.method_27050(new class_5218("data/createrailwaysnavigator_global_settings.dat")).toString());
        File settingsFile = new File(server.method_27050(new class_5218("data/createrailwaysnavigator_global_settings.nbt")).toString());
        GlobalSettings file = new GlobalSettings(server);
        if (legacyFile.exists()) {
            CreateRailwaysNavigator.LOGGER.warn("A legacy global settings file was found. Try to load it.");
            file.deserializeNbtLegacy(class_2507.method_30613((File)legacyFile).method_10562("data"));
            legacyFile.delete();
        } else if (settingsFile.exists()) {
            file.deserializeNbt(class_2507.method_30613((File)settingsFile));
        }
        return file;
    }

    public synchronized class_2487 serializeNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10569(NBT_VERSION, 2);
        class_2487 stationsComp = new class_2487();
        this.stationTags.entrySet().forEach(x -> stationsComp.method_10566(((UUID)x.getKey()).toString(), (class_2520)((StationTag)x.getValue()).toNbt()));
        nbt.method_10566(NBT_STATION_TAGS, (class_2520)stationsComp);
        class_2487 trainCategoriesComp = new class_2487();
        this.trainCategories.entrySet().forEach(x -> trainCategoriesComp.method_10566(((UUID)x.getKey()).toString(), (class_2520)((TrainCategory)x.getValue()).toNbt()));
        nbt.method_10566(NBT_TRAIN_CATEGORIES, (class_2520)trainCategoriesComp);
        class_2499 stationsBlacklist = new class_2499();
        this.stationBlacklist.forEach(x -> stationsBlacklist.add((Object)class_2519.method_23256((String)x)));
        nbt.method_10566(NBT_STATION_BLACKLIST, (class_2520)stationsBlacklist);
        class_2499 trainsBlacklist = new class_2499();
        this.trainBlacklist.forEach(x -> trainsBlacklist.add((Object)class_2519.method_23256((String)x)));
        nbt.method_10566(NBT_TRAIN_BLACKLIST, (class_2520)trainsBlacklist);
        class_2487 trainLinesComp = new class_2487();
        this.trainLines.entrySet().forEach(x -> trainLinesComp.method_10566(((UUID)x.getKey()).toString(), (class_2520)((TrainLine)x.getValue()).toNbt()));
        nbt.method_10566(NBT_TRAIN_LINES, (class_2520)trainLinesComp);
        return nbt;
    }

    public void deserializeNbt(class_2487 nbt) {
        int version = nbt.method_10550(NBT_VERSION);
        class_2487 stationsComp = nbt.method_10562(NBT_STATION_TAGS);
        this.stationTags.putAll(stationsComp.method_10541().stream().map(x -> StationTag.fromNbt(stationsComp.method_10562(x), UUID.fromString(x))).collect(Collectors.toMap(x -> x.getId(), x -> x)));
        class_2487 trainCategoiesComp = version <= 1 ? nbt.method_10562(LEGACY_NBT_TRAIN_GROUPS) : nbt.method_10562(NBT_TRAIN_CATEGORIES);
        this.trainCategories.putAll(trainCategoiesComp.method_10541().stream().map(x -> TrainCategory.fromNbt(trainCategoiesComp.method_10562(x))).collect(Collectors.toMap(x -> x.getId(), x -> x)));
        this.stationBlacklist.addAll(nbt.method_10554(NBT_STATION_BLACKLIST, 8).stream().map(x -> ((class_2519)x).method_10714()).toList());
        this.trainBlacklist.addAll(nbt.method_10554(NBT_TRAIN_BLACKLIST, 8).stream().map(x -> ((class_2519)x).method_10714()).toList());
        class_2487 trainLinesComp = nbt.method_10562(NBT_TRAIN_LINES);
        this.trainLines.putAll(trainLinesComp.method_10541().stream().map(x -> TrainLine.fromNbt(trainLinesComp.method_10562(x))).collect(Collectors.toMap(x -> x.getId(), x -> x)));
    }

    @Deprecated
    private void deserializeNbtLegacy(class_2487 nbt) {
        String NBT_ALIAS_REGISTRY = "RegisteredAliasData";
        String NBT_BLACKLIST = NBT_STATION_BLACKLIST;
        String NBT_TRAIN_BLACKLIST = NBT_TRAIN_BLACKLIST;
        String NBT_TRAIN_GROUP_REGISTRY = "RegisteredTrainGroups";
        List<Object> aliasData = new ArrayList();
        List<Object> trainGroupData = new ArrayList();
        List<Object> blacklistData = new ArrayList();
        List<Object> trainBlacklistData = new ArrayList();
        if (nbt.method_10545("RegisteredAliasData")) {
            aliasData = nbt.method_10554("RegisteredAliasData", 10).stream().map(x -> (class_2487)x).toList();
        }
        if (nbt.method_10545("RegisteredTrainGroups")) {
            trainGroupData = nbt.method_10554("RegisteredTrainGroups", 10).stream().map(x -> (class_2487)x).toList();
        }
        if (nbt.method_10545(NBT_STATION_BLACKLIST)) {
            blacklistData = nbt.method_10554(NBT_STATION_BLACKLIST, 8).stream().map(x -> ((class_2519)x).method_10714()).toList();
        }
        if (nbt.method_10545(NBT_TRAIN_BLACKLIST)) {
            trainBlacklistData = nbt.method_10554(NBT_TRAIN_BLACKLIST, 8).stream().map(x -> ((class_2519)x).method_10714()).toList();
        }
        LinkedHashSet usedIds = new LinkedHashSet();
        this.stationTags.putAll(aliasData.stream().map(x -> {
            UUID id;
            while (usedIds.contains(id = UUID.randomUUID())) {
            }
            usedIds.add(id);
            return StationTag.fromNbt(x, id);
        }).collect(Collectors.toMap(x -> x.getId(), x -> x)));
        usedIds.clear();
        this.trainCategories.putAll(trainGroupData.stream().map(x -> TrainCategory.fromNbt(x)).collect(Collectors.toMap(x -> x.getId(), x -> x)));
        this.stationBlacklist.addAll(blacklistData);
        this.trainBlacklist.addAll(trainBlacklistData);
        this.save();
    }

    public void close() {
        this.save();
    }

    public boolean hasStationTag(GlobalStation station) {
        return this.hasStationTag(station.name);
    }

    public boolean hasStationTag(String stationName) {
        for (StationTag tag : this.stationTags.values()) {
            if (!tag.contains(stationName)) continue;
            return true;
        }
        return false;
    }

    public boolean stationTagExists(String tagName) {
        return this.stationTagExists(TagName.of(tagName));
    }

    public boolean stationTagExists(TagName tagName) {
        for (StationTag tag : this.stationTags.values()) {
            if (!tag.getTagName().equals(tagName)) continue;
            return true;
        }
        return false;
    }

    public boolean stationTagExists(UUID id) {
        if (id == null) {
            return false;
        }
        return this.stationTags.containsKey(id);
    }

    public StationTag getOrCreateStationTagFor(GlobalStation station) {
        return this.getOrCreateStationTagFor(station.name);
    }

    public StationTag getOrCreateStationTagFor(TagName tagName) {
        return this.getTagByName(tagName).orElse(this.getOrCreateStationTagFor(tagName.get()));
    }

    public StationTag getOrCreateStationTagFor(String stationName) {
        return this.getOrCreateStationTagFor(stationName, null);
    }

    public StationTag getOrCreateStationTagFor(String stationName, Owner owner) {
        if (stationName.contains("*")) {
            return this.getOrCreateTagForWildcard(stationName, owner);
        }
        for (StationTag tag : this.stationTags.values()) {
            if (!tag.contains(stationName)) continue;
            return tag;
        }
        return new StationTag(null, TagName.of(stationName), owner, Map.of(stationName, StationTag.StationInfo.empty()));
    }

    private StationTag getOrCreateTagForWildcard(String stationName, Owner owner) {
        String regex = stationName.isBlank() ? stationName : "\\Q" + stationName.replace("*", "\\E.*\\Q") + "\\E";
        for (StationTag tag : this.stationTags.values()) {
            for (String name : tag.getAllStationNames()) {
                if (!name.matches(regex)) continue;
                return tag;
            }
        }
        return new StationTag(null, TagName.of(stationName), owner, Map.of(stationName, StationTag.StationInfo.empty()));
    }

    public StationTag createOrGetStationTag(String name) {
        return this.createOrGetStationTag(TagName.of(name));
    }

    public StationTag createOrGetStationTag(TagName name) {
        return this.createOrGetStationTag(name, null);
    }

    public StationTag createOrGetStationTag(TagName name, Owner owner) {
        UUID newId;
        Optional<StationTag> tag = this.getTagByName(name);
        if (tag.isPresent()) {
            return tag.get();
        }
        while (this.stationTags.containsKey(newId = UUID.randomUUID())) {
        }
        StationTag newTag = new StationTag(newId, name, owner);
        this.stationTags.put(newId, newTag);
        return newTag;
    }

    public StationTag registerStationTag(StationTag tag) {
        UUID newId;
        while (this.stationTags.containsKey(newId = UUID.randomUUID())) {
        }
        tag.setId(newId);
        this.stationTags.put(newId, tag);
        return tag;
    }

    public Optional<StationTag> getTagByName(TagName name) {
        for (StationTag tag : this.stationTags.values()) {
            if (!tag.getTagName().equals(name)) continue;
            return Optional.ofNullable(tag);
        }
        return Optional.empty();
    }

    public Optional<StationTag> getStationTag(UUID id) {
        return Optional.ofNullable(this.stationTagExists(id) ? this.stationTags.get(id) : null);
    }

    public boolean removeStationTag(String name) {
        return this.removeStationTag(TagName.of(name));
    }

    public boolean removeStationTag(TagName name) {
        return this.stationTags.values().removeIf(x -> x.getTagName().equals(name));
    }

    public StationTag removeStationTag(UUID id) {
        return this.stationTags.remove(id);
    }

    public List<StationTag> getAllStationTags() {
        return new ArrayList<StationTag>(this.stationTags.values());
    }

    public boolean trainCategoryExists(UUID id) {
        if (id == null) {
            return false;
        }
        return this.trainCategories.containsKey(id);
    }

    public TrainCategory createOrGetTrainCategory(String name) {
        return this.createOrGetTrainCategory(name, null);
    }

    public TrainCategory createOrGetTrainCategory(String name, Owner owner) {
        UUID id;
        Optional<TrainCategory> tag = this.getTrainCategoryByName(name);
        if (tag.isPresent()) {
            return tag.get();
        }
        while (this.trainCategories.containsKey(id = UUID.randomUUID())) {
        }
        TrainCategory newCategory = new TrainCategory(id, name, owner);
        this.trainCategories.put(newCategory.getId(), newCategory);
        return newCategory;
    }

    public Optional<TrainCategory> getTrainCategory(UUID id) {
        return Optional.ofNullable(this.trainCategoryExists(id) ? this.trainCategories.get(id) : null);
    }

    public Optional<TrainCategory> getTrainCategoryByName(String name) {
        for (TrainCategory category : this.trainCategories.values()) {
            if (!category.getCategoryName().equals(name)) continue;
            return Optional.of(category);
        }
        return Optional.empty();
    }

    public TrainCategory removeTrainCategory(UUID id) {
        return this.trainCategories.remove(id);
    }

    public ImmutableList<TrainCategory> getAllTrainCategories() {
        return ImmutableList.copyOf(this.trainCategories.values());
    }

    public boolean isTrainExcludedByUser(Train train, UserSettings settings) {
        return TrainListener.getTrainData(train.id).map(data -> {
            if (data.getSections().isEmpty()) {
                return false;
            }
            for (ScheduleSection section : data.getSections()) {
                if (!section.isUsable() || section.getTrainCategory().map(x -> settings.navigationExcludedTrainCategories.getValue().contains(x.getId())).orElse(false).booleanValue()) continue;
                return false;
            }
            return true;
        }).orElse(false);
    }

    public boolean isTrainStationExcludedByUser(Train train, TrainPrediction at, UserSettings settings) {
        return at.getSection().getTrainCategory().map(x -> !at.getSection().isUsable() || settings.navigationExcludedTrainCategories.getValue().contains(x.getId())).orElse(false);
    }

    public boolean isTrainStationExcludedByUser(Train train, TrainStop at, UserSettings settings) {
        return TrainListener.getTrainData(train.id).map(data -> {
            ScheduleSection section = data.getSectionByIndex(at.getSectionIndex());
            return section.getTrainCategory().map(x -> !section.isUsable() || settings.navigationExcludedTrainCategories.getValue().contains(x.getId())).orElse(false);
        }).orElse(false);
    }

    public boolean isStationBlacklisted(GlobalStation station) {
        return this.isStationBlacklisted(station.name);
    }

    public boolean isStationBlacklisted(String name) {
        return this.stationBlacklist.contains(name);
    }

    public void blacklistStation(GlobalStation station) {
        this.blacklistStation(station.name);
    }

    public void blacklistStation(String stationName) {
        if (ModUtils.hasWildcards(stationName)) {
            this.stationBlacklist.addAll(ModUtils.wildcardMatches(stationName, TrainUtils.getAllStationNames()));
            return;
        }
        this.stationBlacklist.add(stationName);
    }

    public boolean removeStationFromBlacklist(GlobalStation station) {
        return this.removeStationFromBlacklist(station.name);
    }

    public boolean removeStationFromBlacklist(String stationName) {
        return this.stationBlacklist.removeIf(x -> x.equals(stationName));
    }

    public boolean isEntireStationTagBlacklisted(StationTag tag) {
        if (tag == null) {
            return true;
        }
        Set<String> names = tag.getAllStationNames();
        for (String name : names) {
            if (this.isStationBlacklisted(name)) continue;
            return false;
        }
        return !names.isEmpty();
    }

    public ImmutableList<String> getAllBlacklistedStations() {
        return ImmutableList.copyOf(this.stationBlacklist);
    }

    public boolean isTrainBlacklisted(Train train) {
        return this.isTrainBlacklisted(train.name.getString());
    }

    public boolean isTrainBlacklisted(String trainName) {
        return this.trainBlacklist.contains(trainName);
    }

    public void blacklistTrain(Train train) {
        this.blacklistTrain(train.name.getString());
    }

    public void blacklistTrain(String trainName) {
        if (ModUtils.hasWildcards(trainName)) {
            this.trainBlacklist.addAll(ModUtils.wildcardMatches(trainName, TrainUtils.getTrainNames()));
            return;
        }
        this.trainBlacklist.add(trainName);
    }

    public boolean removeTrainFromBlacklist(Train train) {
        return this.removeTrainFromBlacklist(train.name.getString());
    }

    public boolean removeTrainFromBlacklist(String trainName) {
        return this.trainBlacklist.removeIf(x -> x.equals(trainName));
    }

    public ImmutableList<String> getAllBlacklistedTrains() {
        return ImmutableList.copyOf(this.trainBlacklist);
    }

    public boolean trainLineExists(UUID id) {
        if (id == null) {
            return false;
        }
        return this.trainLines.containsKey(id);
    }

    public TrainLine createOrGetTrainLine(String name) {
        return this.createOrGetTrainLine(name, null);
    }

    public TrainLine createOrGetTrainLine(String name, Owner owner) {
        UUID id;
        Optional<TrainLine> tag = this.getTrainLineByName(name);
        if (tag.isPresent()) {
            return tag.get();
        }
        while (this.trainCategories.containsKey(id = UUID.randomUUID())) {
        }
        TrainLine newLine = new TrainLine(id, name, owner);
        this.trainLines.put(newLine.getId(), newLine);
        return newLine;
    }

    public Optional<TrainLine> getTrainLine(UUID id) {
        return Optional.ofNullable(this.trainLineExists(id) ? this.trainLines.get(id) : null);
    }

    public Optional<TrainLine> getTrainLineByName(String name) {
        for (TrainLine line : this.trainLines.values()) {
            if (!line.getLineName().equals(name)) continue;
            return Optional.of(line);
        }
        return Optional.empty();
    }

    public TrainLine removeTrainLine(UUID id) {
        return this.trainLines.remove(id);
    }

    public ImmutableList<TrainLine> getAllTrainLines() {
        return ImmutableList.copyOf(this.trainLines.values());
    }
}

