/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.storage;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class RecentSearchQueries {
    private static final int MAX = 5;
    private static final String NBT_QUERIES = "Queries";
    private final List<RecentSearchQuery> queries = new LinkedList<RecentSearchQuery>();

    public void add(RecentSearchQuery query) {
        for (int i = 0; i < this.queries.size(); ++i) {
            if (!this.queries.get(i).equals(query)) continue;
            this.queries.remove(i);
        }
        while (this.queries.size() >= 5) {
            this.queries.remove(0);
        }
        this.queries.add(query);
    }

    public RecentSearchQuery[] getAll() {
        return (RecentSearchQuery[])this.queries.toArray(RecentSearchQuery[]::new);
    }

    public void clear() {
        this.queries.clear();
    }

    public boolean isEmpty() {
        return this.queries.isEmpty();
    }

    public RecentSearchQuery get(int i) {
        return this.queries.get(i);
    }

    public int size() {
        return this.queries.size();
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        class_2499 list = new class_2499();
        for (RecentSearchQuery query : this.queries) {
            list.add((Object)query.toNbt());
        }
        nbt.method_10566(NBT_QUERIES, (class_2520)list);
        return nbt;
    }

    public static RecentSearchQueries fromNbt(class_2487 nbt) {
        RecentSearchQueries queries = new RecentSearchQueries();
        queries.queries.addAll(nbt.method_10554(NBT_QUERIES, 10).stream().map(x -> RecentSearchQuery.fromNbt((class_2487)x)).toList());
        return queries;
    }

    public void remove(RecentSearchQuery query) {
        this.queries.removeIf(query::equals);
    }

    public static class RecentSearchQuery {
        private static final String NBT_START = "Start";
        private static final String NBT_END = "End";
        private static final String NBT_CREATION_TIME = "creationTime";
        private final String startStation;
        private final String destinationStation;
        private final long time;

        private RecentSearchQuery(String startStation, String destinationStation, long time) {
            this.startStation = startStation;
            this.destinationStation = destinationStation;
            this.time = time;
        }

        public RecentSearchQuery(String startStation, String destinationStation) {
            this(startStation, destinationStation, new Date().getTime());
        }

        public String getStartStation() {
            return this.startStation;
        }

        public String getDestinationStation() {
            return this.destinationStation;
        }

        public long getCreationTime() {
            return this.time;
        }

        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10582(NBT_START, this.startStation);
            nbt.method_10582(NBT_END, this.destinationStation);
            nbt.method_10544(NBT_CREATION_TIME, this.time);
            return nbt;
        }

        public static RecentSearchQuery fromNbt(class_2487 nbt) {
            return new RecentSearchQuery(nbt.method_10558(NBT_START), nbt.method_10558(NBT_END), nbt.method_10537(NBT_CREATION_TIME));
        }

        public boolean equals(Object obj) {
            if (obj instanceof RecentSearchQuery) {
                RecentSearchQuery o = (RecentSearchQuery)obj;
                return this.startStation.equals(o.startStation) && this.destinationStation.equals(o.destinationStation);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.startStation, this.destinationStation);
        }

        public String toString() {
            return String.format("%s -> %s", this.startStation, this.destinationStation);
        }
    }
}

