/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train;

import com.simibubi.create.content.trains.entity.Train;
import de.mrjulsen.crn.data.TrainCategory;
import de.mrjulsen.crn.data.TrainLine;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.ScheduleSection;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.core.ITranslatableEnum;
import de.mrjulsen.mcdragonlib.data.Pair;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.server.MinecraftServer;

public final class DepartureHistory {
    private static final String NBT_DATA = "DepartureHistory";
    private static final Map<String, Data> departuresByStation = new ConcurrentHashMap<String, Data>();

    private DepartureHistory() {
    }

    public static void clear() {
        departuresByStation.clear();
    }

    public static void updateDepartures(String stationName, Train train) {
        departuresByStation.computeIfAbsent(stationName, x -> new Data()).setDeparture(train);
    }

    public static Map<String, Data> getDeparturesAtStation(String stationFilter) {
        return departuresByStation.entrySet().stream().filter(entry -> TrainUtils.stationMatches((String)entry.getKey(), stationFilter)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static long getLatestDepartureFor(ETrainFilter trainFilter, Train train, String stationName) {
        long latestDepartureTime = Long.MIN_VALUE;
        Map<String, Data> dataSrc = DepartureHistory.getDeparturesAtStation(stationName);
        Optional<TrainData> data = TrainListener.getTrainData(train);
        if (!data.isPresent()) {
            return latestDepartureTime;
        }
        Optional<TrainCategory> category = data.get().getCurrentSection().getTrainCategory();
        Optional<TrainLine> line = data.get().getCurrentSection().getTrainLine();
        block5: for (Map.Entry<String, Data> e : dataSrc.entrySet()) {
            switch (trainFilter.ordinal()) {
                case 2: {
                    latestDepartureTime = Math.max(latestDepartureTime, category.map(x -> ((Data)e.getValue()).getDepartureByCategory((TrainCategory)x).orElse(Long.MIN_VALUE)).orElse(Long.MIN_VALUE));
                    continue block5;
                }
                case 1: {
                    latestDepartureTime = Math.max(latestDepartureTime, line.map(x -> ((Data)e.getValue()).getDepartureByLine((TrainLine)x).orElse(Long.MIN_VALUE)).orElse(Long.MIN_VALUE));
                    continue block5;
                }
                case 3: {
                    latestDepartureTime = Math.max(latestDepartureTime, Optional.ofNullable(train.name).map(x -> ((Data)e.getValue()).getDepartureByName(x.getString()).orElse(Long.MIN_VALUE)).orElse(Long.MIN_VALUE));
                    continue block5;
                }
            }
            latestDepartureTime = Math.max(latestDepartureTime, e.getValue().getLastDepartureTime());
        }
        return latestDepartureTime;
    }

    public static void validate() {
        departuresByStation.keySet().retainAll(TrainUtils.getAllStations().stream().map(x -> x.name).toList());
    }

    public static int debug_dataCount() {
        return departuresByStation.size();
    }

    public static class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        class_2487 data = new class_2487();
        for (Map.Entry<String, Data> e : departuresByStation.entrySet()) {
            data.method_10566(e.getKey(), (class_2520)e.getValue().toNbt());
        }
        nbt.method_10566(NBT_DATA, (class_2520)data);
        return nbt;
    }

    public static void fromNbt(class_2487 nbt) {
        departuresByStation.clear();
        class_2487 data = nbt.method_10562(NBT_DATA);
        for (String key : data.method_10541()) {
            departuresByStation.put(key, Data.fromNbt(data.method_10562(key)));
        }
    }

    public static class Data {
        private static final String NBT_LAST_DEPARTURE = "LastDeparture";
        private static final String NBT_LINES = "Lines";
        private static final String NBT_CATEGORIES = "Categories";
        private static final String NBT_NAMES = "Names";
        private long lastDepartureTime = Long.MIN_VALUE;
        private Map<TrainLine, Long> lastDepartureByLine = new ConcurrentHashMap<TrainLine, Long>();
        private Map<TrainCategory, Long> lastDepartureByCategory = new ConcurrentHashMap<TrainCategory, Long>();
        private Map<String, Long> lastDepartureByTrainName = new ConcurrentHashMap<String, Long>();

        public void setDeparture(Train train) {
            this.lastDepartureTime = ((MinecraftServer)DragonLib.getCurrentServer().get()).method_30002().method_8510();
            this.lastDepartureByTrainName.put(train.name.getString(), this.lastDepartureTime);
            TrainListener.getTrainData(train.id).ifPresent(data -> {
                ScheduleSection section = data.getCurrentSection();
                section.getTrainLine().ifPresent(x -> this.lastDepartureByLine.put((TrainLine)x, this.lastDepartureTime));
                section.getTrainCategory().ifPresent(x -> this.lastDepartureByCategory.put((TrainCategory)x, this.lastDepartureTime));
            });
        }

        public long getLastDepartureTime(ETrainFilter filter, String trainName, @Nullable ScheduleSection section) {
            return switch (filter.ordinal()) {
                case 2 -> {
                    if (section != null) {
                        yield section.getTrainCategory().map(x -> this.lastDepartureByCategory.getOrDefault(x, Long.MIN_VALUE)).orElse(Long.MIN_VALUE);
                    }
                    yield Long.MIN_VALUE;
                }
                case 1 -> {
                    if (section != null) {
                        yield section.getTrainLine().map(x -> this.lastDepartureByLine.getOrDefault(x, Long.MIN_VALUE)).orElse(Long.MIN_VALUE);
                    }
                    yield Long.MIN_VALUE;
                }
                case 3 -> {
                    if (trainName != null) {
                        yield this.lastDepartureByTrainName.getOrDefault(trainName, Long.MIN_VALUE);
                    }
                    yield Long.MIN_VALUE;
                }
                default -> this.lastDepartureTime;
            };
        }

        public long getLastDepartureTime() {
            return this.lastDepartureTime;
        }

        public Map<TrainLine, Long> getLastDeparturesByLine() {
            return this.lastDepartureByLine;
        }

        public Map<TrainCategory, Long> getLastDeparturesByCategory() {
            return this.lastDepartureByCategory;
        }

        public Map<String, Long> getLastDeparturesByTrainName() {
            return this.lastDepartureByTrainName;
        }

        public Optional<Long> getDepartureByCategory(TrainCategory category) {
            return Optional.ofNullable(this.lastDepartureByCategory.containsKey(category) ? this.lastDepartureByCategory.get(category) : null);
        }

        public Optional<Long> getDepartureByLine(TrainLine line) {
            return Optional.ofNullable(this.lastDepartureByLine.containsKey(line) ? this.lastDepartureByLine.get(line) : null);
        }

        public Optional<Long> getDepartureByName(String name) {
            return Optional.ofNullable(this.lastDepartureByTrainName.containsKey(name) ? this.lastDepartureByTrainName.get(name) : null);
        }

        public long debug_cachedDataCount() {
            return 1 + this.lastDepartureByLine.size() + this.lastDepartureByCategory.size();
        }

        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10544(NBT_LAST_DEPARTURE, this.lastDepartureTime);
            class_2487 linesList = new class_2487();
            for (Map.Entry<TrainLine, Long> entry : this.lastDepartureByLine.entrySet()) {
                linesList.method_10544(entry.getKey().getId().toString(), entry.getValue().longValue());
            }
            nbt.method_10566(NBT_LINES, (class_2520)linesList);
            class_2487 categoriesList = new class_2487();
            for (Map.Entry<TrainCategory, Long> entry : this.lastDepartureByCategory.entrySet()) {
                categoriesList.method_10544(entry.getKey().getId().toString(), entry.getValue().longValue());
            }
            nbt.method_10566(NBT_CATEGORIES, (class_2520)categoriesList);
            class_2487 class_24872 = new class_2487();
            for (Map.Entry<String, Long> e : this.lastDepartureByTrainName.entrySet()) {
                class_24872.method_10544(e.getKey(), e.getValue().longValue());
            }
            nbt.method_10566(NBT_NAMES, (class_2520)class_24872);
            return nbt;
        }

        public static Data fromNbt(class_2487 nbt) {
            Data data = new Data();
            data.lastDepartureTime = nbt.method_10537(NBT_LAST_DEPARTURE);
            class_2487 linesList = nbt.method_10562(NBT_LINES);
            for (Object key : linesList.method_10541()) {
                GlobalSettings.getInstance().getTrainLine(UUID.fromString((String)key)).ifPresent(arg_0 -> Data.lambda$fromNbt$5(data, linesList, (String)key, arg_0));
            }
            class_2487 categoriesList = nbt.method_10562(NBT_CATEGORIES);
            for (String key : categoriesList.method_10541()) {
                GlobalSettings.getInstance().getTrainCategory(UUID.fromString(key)).ifPresent(x -> data.lastDepartureByCategory.put((TrainCategory)x, categoriesList.method_10537(key)));
            }
            class_2487 namesList = nbt.method_10562(NBT_NAMES);
            for (String key : namesList.method_10541()) {
                data.lastDepartureByTrainName.put(key, namesList.method_10537(key));
            }
            return data;
        }

        private static /* synthetic */ void lambda$fromNbt$5(Data data, class_2487 linesList, String key, TrainLine x) {
            data.lastDepartureByLine.put(x, linesList.method_10537(key));
        }
    }

    public static enum ETrainFilter implements ITranslatableEnum
    {
        ANY(0, "any"),
        SAME_LINE(1, "same_line"),
        SAME_CATEGORY(2, "same_category"),
        SAME_NAME(3, "same_name");

        private final byte index;
        private final String name;

        private ETrainFilter(byte index, String name) {
            this.index = index;
            this.name = name;
        }

        public byte getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public static ETrainFilter getByIndex(byte i) {
            return Arrays.stream(ETrainFilter.values()).filter(x -> x.getIndex() == i).findFirst().orElse(ANY);
        }

        public String getEnumName() {
            return "train_filter";
        }

        public String getEnumValueName() {
            return this.name;
        }
    }

    public static class Stats {
        private static final String NBT_LAST_DEPARTURE = "LastDeparture";
        private static final String NBT_LINE = "Line";
        private static final String NBT_CATEGORY = "Category";
        private static final String NBT_NAME = "Name";
        private final long lastDeparture;
        private final Map<String, Long> departuresByCategory;
        private final Map<String, Long> departuresByLine;
        private final Map<String, Long> departuresByName;
        private final Optional<Pair<String, Long>> latestCategoryDeparture;
        private final Optional<Pair<String, Long>> latestLineDeparture;
        private final Optional<Pair<String, Long>> latestNameDeparture;

        public Stats(long lastDeparture, Map<String, Long> departuresByCategory, Map<String, Long> departuresByLine, Map<String, Long> departuresByName) {
            this.lastDeparture = lastDeparture;
            this.departuresByCategory = departuresByCategory;
            this.departuresByLine = departuresByLine;
            this.departuresByName = departuresByName;
            this.latestCategoryDeparture = departuresByCategory.entrySet().stream().max((a, b) -> Long.compare((Long)a.getValue(), (Long)b.getValue())).map(p -> new Pair((Object)((String)p.getKey()), (Object)((Long)p.getValue())));
            this.latestLineDeparture = departuresByLine.entrySet().stream().max((a, b) -> Long.compare((Long)a.getValue(), (Long)b.getValue())).map(p -> new Pair((Object)((String)p.getKey()), (Object)((Long)p.getValue())));
            this.latestNameDeparture = departuresByName.entrySet().stream().max((a, b) -> Long.compare((Long)a.getValue(), (Long)b.getValue())).map(p -> new Pair((Object)((String)p.getKey()), (Object)((Long)p.getValue())));
        }

        public static Stats of(Data data) {
            Map<String, Long> categories = data.getLastDeparturesByCategory().entrySet().stream().collect(Collectors.toMap(p -> ((TrainCategory)p.getKey()).getCategoryName(), p -> (Long)p.getValue()));
            Map<String, Long> lines = data.getLastDeparturesByLine().entrySet().stream().collect(Collectors.toMap(p -> ((TrainLine)p.getKey()).getLineName(), p -> (Long)p.getValue()));
            Map<String, Long> names = data.getLastDeparturesByTrainName().entrySet().stream().collect(Collectors.toMap(p -> (String)p.getKey(), p -> (Long)p.getValue()));
            return new Stats(data.getLastDepartureTime(), categories, lines, names);
        }

        public static Stats ofStation(String stationName) {
            return DepartureHistory.getDeparturesAtStation(stationName).values().stream().map(Stats::of).findFirst().orElse(Stats.empty());
        }

        public static Stats empty() {
            return new Stats(-1L, Map.of(), Map.of(), Map.of());
        }

        public boolean isEmpty() {
            return this.getLastDeparture() < 0L && this.getDeparturesByCategory().isEmpty() && this.getDeparturesByLine().isEmpty() && this.getDeparturesByName().isEmpty();
        }

        public long getLastDeparture() {
            return this.lastDeparture;
        }

        public Map<String, Long> getDeparturesByCategory() {
            return this.departuresByCategory;
        }

        public Map<String, Long> getDeparturesByLine() {
            return this.departuresByLine;
        }

        public Map<String, Long> getDeparturesByName() {
            return this.departuresByName;
        }

        public Optional<Pair<String, Long>> getLatestCategoryDeparture() {
            return this.latestCategoryDeparture;
        }

        public Optional<Pair<String, Long>> getLatestLineDeparture() {
            return this.latestLineDeparture;
        }

        public Optional<Pair<String, Long>> getLatestNameDeparture() {
            return this.latestNameDeparture;
        }

        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            class_2487 categoriesTag = new class_2487();
            for (Map.Entry<String, Long> entry : this.departuresByCategory.entrySet()) {
                categoriesTag.method_10544(entry.getKey(), entry.getValue().longValue());
            }
            class_2487 linesTag = new class_2487();
            for (Map.Entry<String, Long> entry : this.departuresByLine.entrySet()) {
                linesTag.method_10544(entry.getKey(), entry.getValue().longValue());
            }
            class_2487 class_24872 = new class_2487();
            for (Map.Entry<String, Long> e : this.departuresByName.entrySet()) {
                class_24872.method_10544(e.getKey(), e.getValue().longValue());
            }
            nbt.method_10544(NBT_LAST_DEPARTURE, this.lastDeparture);
            nbt.method_10566(NBT_CATEGORY, (class_2520)categoriesTag);
            nbt.method_10566(NBT_LINE, (class_2520)linesTag);
            nbt.method_10566(NBT_NAME, (class_2520)class_24872);
            return nbt;
        }

        public static Stats fromNbt(class_2487 nbt) {
            HashMap<String, Long> categories = new HashMap<String, Long>();
            class_2487 categoriesTag = nbt.method_10562(NBT_CATEGORY);
            for (String key : categoriesTag.method_10541()) {
                categories.put(key, categoriesTag.method_10537(key));
            }
            HashMap<String, Long> lines = new HashMap<String, Long>();
            class_2487 linesTag = nbt.method_10562(NBT_LINE);
            for (String key : linesTag.method_10541()) {
                lines.put(key, linesTag.method_10537(key));
            }
            HashMap<String, Long> names = new HashMap<String, Long>();
            class_2487 namesTag = nbt.method_10562(NBT_NAME);
            for (String key : namesTag.method_10541()) {
                names.put(key, namesTag.method_10537(key));
            }
            return new Stats(nbt.method_10537(NBT_LAST_DEPARTURE), categories, lines, names);
        }
    }
}

