/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train;

import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.station.GlobalStation;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.data.schedule.INavigationExtension;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.DepartureHistory;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.crn.event.CRNEventsManager;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.crn.event.events.GlobalTrainDisplayDataRefreshEventPost;
import de.mrjulsen.crn.event.events.GlobalTrainDisplayDataRefreshEventPre;
import de.mrjulsen.crn.event.events.ScheduleResetEvent;
import de.mrjulsen.crn.event.events.TotalDurationTimeChangedEvent;
import de.mrjulsen.crn.event.events.TrainArrivalAndDepartureEvent;
import de.mrjulsen.mcdragonlib.DragonLib;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_5218;

public final class TrainListener {
    private static final String FILENAME = "createrailwaysnavigator_train_data.nbt";
    private static final String NBT_TRAIN_DATA = "TrainData";
    private static final String NBT_DEPARTURE_HISTORY = "DepartureHistory";
    private static final ConcurrentHashMap<UUID, TrainData> data = new ConcurrentHashMap();
    public static final Map<String, Collection<TrainPrediction>> statusByDestination = new HashMap<String, Collection<TrainPrediction>>();
    private static boolean trainDataListenerActive = false;
    private static long currentTrainDataListenerId = 0L;
    private static final Queue<Runnable> trainDataHookTasks = new ConcurrentLinkedQueue<Runnable>();

    public static Optional<TrainData> getTrainData(Train train) {
        return TrainListener.getTrainData(train.id);
    }

    public static Optional<TrainData> getTrainData(UUID trainId) {
        return TrainListener.hasTrainData(trainId) ? Optional.ofNullable(data.get(trainId)) : Optional.empty();
    }

    public static boolean hasTrainData(Train train) {
        return TrainListener.hasTrainData(train.id);
    }

    public static boolean hasTrainData(UUID trainId) {
        return data.containsKey(trainId);
    }

    public static Collection<TrainData> getAllTrainData() {
        return data.values();
    }

    public static void resetTrainData() {
        data.clear();
    }

    public static void resetTrainData(Train train) {
        TrainListener.resetTrainData(train.id);
    }

    public static void resetTrainData(UUID trainId) {
        data.remove(trainId);
    }

    public static void init() {
        CRNEventsManager.getEvent(GlobalTrainDisplayDataRefreshEventPre.class).register("createrailwaysnavigator", () -> TrainListener.queueTrainListenerTask(() -> {
            try {
                DepartureHistory.validate();
                TrainListener.refreshPre();
            }
            catch (Exception e) {
                DragonLib.LOGGER.error("Cannot run train listener task 'TrainListener#GlobalTrainDisplayDataRefreshEventPre': {}", (Object)e.getMessage(), (Object)e);
            }
        }));
        CRNEventsManager.getEvent(GlobalTrainDisplayDataRefreshEventPost.class).register("createrailwaysnavigator", () -> TrainListener.queueTrainListenerTask(() -> {
            try {
                TrainUtils.refreshCache();
                TrainListener.refreshPost();
            }
            catch (Exception e) {
                DragonLib.LOGGER.error("Cannot run train listener task 'TrainListener#GlobalTrainDisplayDataRefreshEventPost': {}", (Object)e.getMessage(), (Object)e);
            }
        }));
        CRNEventsManager.getEvent(TotalDurationTimeChangedEvent.class).register("createrailwaysnavigator", (train, old, newDuration) -> {
            if (((Boolean)ModCommonConfig.ADVANCED_LOGGING.get()).booleanValue()) {
                CreateRailwaysNavigator.LOGGER.info("The total duration of the train {} ({}) has changed from {} Ticks to {} Ticks. This will result in changes to the scheduled departure times!", new Object[]{train.name.getString(), train.id, old, newDuration});
            }
        });
        CRNEventsManager.getEvent(TrainArrivalAndDepartureEvent.class).register("createrailwaysnavigator", (train, station, isArrival) -> TrainListener.queueTrainListenerTask(() -> {
            try {
                if (TrainUtils.canReadTrainNavigation(train)) {
                    if (!isArrival && station.isPresent() && !((INavigationExtension)train.navigation).isDelayedWaitConditionPending()) {
                        DepartureHistory.updateDepartures(((GlobalStation)station.get()).name, train);
                    }
                } else if (((Boolean)ModCommonConfig.ADVANCED_LOGGING.get()).booleanValue()) {
                    DragonLib.LOGGER.warn("Cannot run train listener task 'TrainListener#TrainArrivalAndDepartureEvent:2'. Unable to read the train navigation of train {}.", train == null ? "null" : train.id);
                }
            }
            catch (Exception e) {
                DragonLib.LOGGER.error("Cannot run train listener task 'TrainListener#TrainArrivalAndDepartureEvent': {}", (Object)e.getMessage(), (Object)e);
            }
        }));
        CRNEventsManager.getEvent(ScheduleResetEvent.class).register("createrailwaysnavigator", (train, soft) -> TrainListener.queueTrainListenerTask(() -> {
            try {
                if (soft && data.containsKey(train.id)) {
                    TrainData trainData = data.get(train.id);
                    trainData.softResetPredictions();
                } else {
                    TrainListener.resetTrainData(train);
                }
            }
            catch (Exception e) {
                DragonLib.LOGGER.error("Cannot run train listener task 'TrainListener#ScheduleResetEvent': {}", (Object)e.getMessage(), (Object)e);
            }
        }));
    }

    public static Set<Train> getAllTrains() {
        HashSet<Train> result = new HashSet<Train>(data.size());
        for (TrainData v : data.values()) {
            result.add(v.getTrain());
        }
        return result;
    }

    public static boolean allTrainsInitialized() {
        for (TrainData data : TrainListener.data.values()) {
            if (GlobalSettings.getInstance().isTrainBlacklisted(data.getTrain()) || !data.hasPredictions() || data.getTrain().runtime.paused || data.getTrain().derailed || data.getTrain().runtime.completed || !TrainUtils.isTrainValid(data.getTrain()) || data.isInitialized() && !data.isPreInitializationPhase()) continue;
            return false;
        }
        return true;
    }

    public static void start() {
        new Thread(() -> {
            long id;
            TrainListener.init();
            while (currentTrainDataListenerId == (id = System.nanoTime())) {
            }
            currentTrainDataListenerId = id;
            trainDataListenerActive = true;
            trainDataHookTasks.clear();
            data.clear();
            try {
                TrainListener.load();
            }
            catch (Exception e) {
                CreateRailwaysNavigator.LOGGER.error("Unable to load train listener data.", (Throwable)e);
            }
            long threadId = id;
            new Thread(() -> {
                try {
                    while (currentTrainDataListenerId == threadId && trainDataListenerActive) {
                        while (!trainDataHookTasks.isEmpty()) {
                            try {
                                trainDataHookTasks.poll().run();
                            }
                            catch (Exception e) {
                                CreateRailwaysNavigator.LOGGER.error("Error while executing train listener task.", (Throwable)e);
                            }
                        }
                        try {
                            TimeUnit.SECONDS.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            CreateRailwaysNavigator.LOGGER.error("Error while waiting for next task.", (Throwable)e);
                        }
                    }
                    TrainListener.save();
                    data.clear();
                    trainDataHookTasks.clear();
                    CreateRailwaysNavigator.LOGGER.info("Train listener has been stopped.");
                }
                catch (Exception e) {
                    CreateRailwaysNavigator.LOGGER.error("Error while executing Train Listener.", (Throwable)e);
                }
            }, "CRN Train Listener").start();
            CreateRailwaysNavigator.LOGGER.info("Train listener has been started.");
        }, "CRN Train Listener Launcher").start();
    }

    public static void stop() {
        trainDataListenerActive = false;
        CreateRailwaysNavigator.LOGGER.info("Stopping train listener...");
    }

    public static synchronized void save() {
        if (!trainDataListenerActive) {
            return;
        }
        class_2487 dataNbt = new class_2487();
        data.entrySet().forEach(x -> dataNbt.method_10566(((UUID)x.getKey()).toString(), (class_2520)((TrainData)x.getValue()).toNbt()));
        class_2487 nbt = new class_2487();
        nbt.method_10566(NBT_TRAIN_DATA, (class_2520)dataNbt);
        nbt.method_10566(NBT_DEPARTURE_HISTORY, (class_2520)DepartureHistory.toNbt());
        try {
            class_2507.method_30614((class_2487)nbt, (File)new File(ModCommonEvents.getCurrentServer().get().method_27050(new class_5218("data/createrailwaysnavigator_train_data.nbt")).toString()));
            CreateRailwaysNavigator.LOGGER.debug("Saved train listener data.");
        }
        catch (IOException e) {
            CreateRailwaysNavigator.LOGGER.error("Unable to save train listener data.", (Throwable)e);
        }
    }

    private static void load() throws IOException {
        File settingsFile = new File(ModCommonEvents.getCurrentServer().get().method_27050(new class_5218("data/createrailwaysnavigator_train_data.nbt")).toString());
        if (!settingsFile.exists()) {
            return;
        }
        class_2487 nbt = class_2507.method_30613((File)settingsFile);
        class_2487 dataNbt = nbt.method_10562(NBT_TRAIN_DATA);
        for (String key : dataNbt.method_10541()) {
            try {
                UUID id = UUID.fromString(key);
                TrainData.fromNbt(dataNbt.method_10562(key)).ifPresent(x -> data.put(id, (TrainData)x));
            }
            catch (Exception e) {
                CreateRailwaysNavigator.LOGGER.warn("Unable to read train listener train data with ID '" + key + "'. " + e.getMessage(), (Throwable)e);
            }
        }
        DepartureHistory.fromNbt(nbt.method_10562(NBT_DEPARTURE_HISTORY));
    }

    private static void queueTrainListenerTask(Runnable task) {
        trainDataHookTasks.add(task);
    }

    public static synchronized void refreshPre() throws Exception {
        if (!trainDataListenerActive) {
            return;
        }
        statusByDestination.clear();
        Set<Train> trains = TrainUtils.getTrains(true);
        Iterator<Train> iterator = trains.iterator();
        while (iterator.hasNext()) {
            Train train = iterator.next();
            try {
                if (GlobalSettings.getInstance().isTrainBlacklisted(train)) {
                    iterator.remove();
                    data.remove(train.id);
                    continue;
                }
                TrainData trainData = data.computeIfAbsent(train.id, x -> TrainData.of(train));
                trainData.refreshPre();
                for (TrainPrediction p : trainData.getPredictions()) {
                    statusByDestination.computeIfAbsent(p.getTargetedStationName(), $ -> new HashSet()).add(p);
                }
            }
            catch (Exception e) {
                throw new Exception("Unable to process train: " + String.valueOf(train.name) + " (" + String.valueOf(train.id) + ")", e);
            }
        }
    }

    public static synchronized void refreshPost() {
        if (!trainDataListenerActive) {
            return;
        }
        for (TrainData train : data.values()) {
            train.refreshPost();
        }
    }

    public static synchronized void tick() {
        if (!trainDataListenerActive) {
            return;
        }
        for (TrainData train : data.values()) {
            train.tick();
        }
    }
}

