/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train;

import com.google.common.base.Objects;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.schedule.condition.ScheduleWaitCondition;
import com.simibubi.create.content.trains.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.trains.schedule.destination.ScheduleInstruction;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.api.IPredictableWaitCondition;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.PredictionTimes;
import de.mrjulsen.crn.data.train.ScheduleSection;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.crn.data.train.ValueWatcher;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.crn.exceptions.RuntimeSideException;
import de.mrjulsen.crn.mixin.ScheduleRuntimeAccessor;
import de.mrjulsen.crn.util.PrimaryStringSelector;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

public class TrainPrediction
implements Comparable<TrainPrediction> {
    private static final String NBT_ENTRY_INDEX = "EntryIndex";
    private static final String NBT_STATION_FILTER = "StationFilter";
    private static final String NBT_STATION_NAME = "StationName";
    private static final String NBT_TITLE = "Title";
    private static final String NBT_CYCLE = "Cycle";
    private static final String NBT_TRANSIT_TIME = "TransitTime";
    private static final String NBT_SCHEDULED_TIMES = "ScheduledTimes";
    private static final String NBT_REAL_TIMES = "RealTimes";
    private static final String NBT_AVERAGE_STAY_DURATION = "AverageStayDuration";
    private final transient TrainData data;
    private final int entryIndex;
    private String title;
    private String stationFilter;
    private String stationName;
    private final PrimaryStringSelector recentStationNames = new PrimaryStringSelector(10);
    private PredictionTimes scheduledTimes = new PredictionTimes(this, 0L, 0L, 0L, 0L);
    private PredictionTimes realTimes = new PredictionTimes(this, 0L, 0L, 0L, 0L);
    private int averageStayDuration = -1;
    private int cycle;
    private final ValueWatcher transitTime = new ValueWatcher((Integer)ModCommonConfig.TOTAL_DURATION_DEVIATION_THRESHOLD.get(), (Integer)ModCommonConfig.TOTAL_DURATION_BUFFER_SIZE.get() * 2 + 1, () -> this.getData().updateTotalDuration());
    private long previousScheduledArrivalTime;
    private long previousScheduledDepartureTime;
    private long previousRealTimeArrivalTime;
    private long previousRealTimeDepartureTime;
    private boolean shouldSoftReset;
    private final Cache<Boolean> isCustomTitle = new Cache(() -> {
        if (this.getTitle() == null || this.getTitle().isEmpty()) {
            return false;
        }
        if (this.getData().getPredictionsChronologically().isEmpty()) {
            return false;
        }
        TrainPrediction nextPrediction = this.getData().getPredictionsChronologically().get((this.getData().getPredictionsChronologically().indexOf(this) + 1) % this.getData().getPredictionsChronologically().size());
        return !this.getTitle().matches(nextPrediction.getTargetedStationName());
    });
    private final Cache<Boolean> isLastStopOfSection = new Cache(() -> {
        ScheduleSection section = this.getSection();
        return section.isFinalStop(this);
    });
    private final Cache<StationTag> tagCache = new Cache(() -> GlobalSettings.getInstance().getOrCreateStationTagFor(this.getTargetedStationName()));
    private final Cache<StationTag> estimatedTagCache = new Cache(() -> GlobalSettings.getInstance().getOrCreateStationTagFor(this.getScheduledStationName()));
    private final Cache<ScheduleSection> section;
    private boolean preInitialized = false;

    public TrainPrediction(TrainData data, int entryIndex, String stationFilter, String stationName, String title) {
        this.entryIndex = entryIndex;
        this.data = data;
        this.stationFilter = stationFilter;
        int size = data.getTrain().runtime.getSchedule().entries.size();
        String text = title;
        if (text.isBlank()) {
            for (int i = 1; i < size; ++i) {
                int j = (entryIndex + i) % size;
                ScheduleEntry scheduleEntry = (ScheduleEntry)data.getTrain().runtime.getSchedule().entries.get(j);
                ScheduleInstruction scheduleInstruction = scheduleEntry.instruction;
                if (!(scheduleInstruction instanceof DestinationInstruction)) continue;
                DestinationInstruction instruction = (DestinationInstruction)scheduleInstruction;
                text = instruction.getFilter().replaceAll("\\*", "").trim();
                break;
            }
        }
        this.title = text;
        this.stationName = stationName;
        this.section = new Cache(() -> data.getSectionForIndex(entryIndex));
    }

    public void preInit() {
        int createTransitTime;
        if (this.preInitialized || this.isInitialized()) {
            return;
        }
        List<Integer> createTransitTimes = ((ScheduleRuntimeAccessor)this.data.getTrain().runtime).crn$getTransitTicks();
        int n = createTransitTime = this.entryIndex < createTransitTimes.size() ? createTransitTimes.get(this.entryIndex) : -1;
        if (createTransitTime >= 0 && !this.data.isPreInitializationPhase()) {
            this.transitTime().add(createTransitTime, false);
        }
        this.preInitialized = true;
    }

    public static TrainPrediction unpredictable(TrainData data) {
        CreateRailwaysNavigator.LOGGER.warn("Train " + data.getTrain().name.getString() + " (" + String.valueOf(data.getTrain().id) + ") is unpredictable!");
        return new TrainPrediction(data, -1, "", "", "");
    }

    private void reset() {
        this.scheduledTimes = this.realTimes;
        this.shouldSoftReset = false;
    }

    public void queueReset() {
        this.shouldSoftReset = true;
    }

    public TrainData getData() {
        return this.data;
    }

    public int getEntryIndex() {
        return this.entryIndex;
    }

    public String getTargetedStationName() {
        return this.stationName;
    }

    public String getStationFilter() {
        return this.stationFilter;
    }

    private String getEstimatedStationName() {
        return this.recentStationNames.getCurrentPrimary();
    }

    public String getScheduledStationName() {
        if (TrainUtils.stationExists(this.getStationFilter())) {
            return this.getStationFilter();
        }
        if (this.getEstimatedStationName() != null && TrainUtils.stationExists(this.getEstimatedStationName())) {
            return this.getEstimatedStationName();
        }
        return this.getTargetedStationName();
    }

    public String getRealTimeStationName() {
        if (TrainUtils.stationExists(this.getTargetedStationName()) || this.getEstimatedStationName() == null) {
            return this.getTargetedStationName();
        }
        return this.getEstimatedStationName();
    }

    public StationTag getEstimatedStationTag() throws RuntimeSideException {
        if (!ModCommonEvents.hasServer()) {
            throw new RuntimeSideException(false);
        }
        return (StationTag)this.estimatedTagCache.get();
    }

    public String getTitle() {
        return this.title;
    }

    public boolean hasCustomTitle() {
        return (Boolean)this.isCustomTitle.get();
    }

    public int getAverageStayDuration() {
        return this.averageStayDuration <= 0 ? (int)this.scheduled().stayDuration() : this.averageStayDuration;
    }

    public ValueWatcher transitTime() {
        return this.transitTime;
    }

    public PredictionTimes scheduled() {
        return this.scheduledTimes;
    }

    public PredictionTimes realTime() {
        return this.realTimes;
    }

    public long getArrivalTimeDeviation() {
        return this.realTime().arrivalTime() - this.scheduled().arrivalTime();
    }

    public long getDepartureTimeDeviation() {
        return this.realTime().departureTime() - this.scheduled().departureTime();
    }

    public long getBufferTime() {
        return Math.max(this.scheduled().stayDuration() - this.scheduled().minStayDuration(), 0L);
    }

    public long getBufferTimeLeft() {
        return this.getBufferTime() - this.data.waitingAtStationTicks();
    }

    public long getScheduledArrivalDay() {
        return this.scheduled().arrivalTime() / DragonLib.ticksPerDay();
    }

    public long getScheduledDepartureDay() {
        return this.scheduled().departureTime() / DragonLib.ticksPerDay();
    }

    public long getRealTimeArrivalDay() {
        return this.realTime().arrivalTime() / DragonLib.ticksPerDay();
    }

    public long getRealTimeDepartureDay() {
        return this.realTime().departureTime() / DragonLib.ticksPerDay();
    }

    public void nextCycle() {
        this.previousScheduledArrivalTime = this.scheduled().arrivalTime();
        this.previousScheduledDepartureTime = this.scheduled().departureTime();
        this.previousRealTimeArrivalTime = this.realTime().arrivalTime();
        this.previousRealTimeDepartureTime = this.realTime().departureTime();
        ++this.cycle;
        this.scheduled().shift(this.data.getTotalDuration(), false);
    }

    public int getCurrentCycle() {
        return this.cycle;
    }

    public long getPreviousScheduledArrivalTime() {
        return this.previousScheduledArrivalTime;
    }

    public long getPreviousScheduledDepartureTime() {
        return this.previousScheduledDepartureTime;
    }

    public long getPreviousRealTimeArrivalTime() {
        return this.previousRealTimeArrivalTime;
    }

    public long getPreviousRealTimeDepartureTime() {
        return this.previousRealTimeDepartureTime;
    }

    void updateAverageStayDuration(int value) {
        int oldAverageStayDuration = this.averageStayDuration;
        this.averageStayDuration = this.averageStayDuration < 0 ? value : (this.averageStayDuration + value) / 2;
        if (Math.abs(oldAverageStayDuration - this.averageStayDuration) > (Integer)ModCommonConfig.TOTAL_DURATION_DEVIATION_THRESHOLD.get()) {
            // empty if block
        }
    }

    public int estimateCycleIn(int ticks) {
        return this.getCurrentCycle() + ticks / this.data.getTotalDuration();
    }

    public long getRuntime() {
        return DragonLib.getCurrentWorldTime() - this.scheduled().refreshTime();
    }

    public boolean hasDepartedOnce() {
        return this.getCurrentCycle() > 0;
    }

    public boolean isArrivalDelayed() {
        return this.realTime().arrivalTime() - (long)((Integer)ModCommonConfig.SCHEDULE_DEVIATION_THRESHOLD.get()).intValue() > this.scheduled().arrivalTime();
    }

    public boolean isDepartureDelayed() {
        return this.realTime().departureTime() - (long)((Integer)ModCommonConfig.SCHEDULE_DEVIATION_THRESHOLD.get()).intValue() > this.scheduled().departureTime();
    }

    public boolean isAnyDelayed() {
        return this.isArrivalDelayed() || this.isDepartureDelayed();
    }

    public boolean isInitialized() {
        return this.scheduled() != null && this.transitTime().isInitialized();
    }

    public StationTag getStationTag() throws RuntimeSideException {
        if (!ModCommonEvents.hasServer()) {
            throw new RuntimeSideException(false);
        }
        return (StationTag)this.tagCache.get();
    }

    public ScheduleSection getSection() {
        ScheduleSection sec = (ScheduleSection)this.section.get();
        if (sec.isDefault()) {
            this.section.clear();
        }
        return sec;
    }

    public String getSectionDestinationText() {
        ScheduleSection sec = (ScheduleSection)this.section.get();
        if (sec.isDefault()) {
            this.section.clear();
        }
        return (Boolean)this.isLastStopOfSection.get() != false && !sec.shouldIncludeNextStationOfNextSection() ? sec.nextSection().getDisplayText() : sec.getDisplayText();
    }

    public void updateRealTime(String stationFilter, String stationName, long refreshTime, long arrivalTime, String title) {
        this.isCustomTitle.clear();
        this.stationFilter = stationFilter == null ? this.stationFilter : stationFilter;
        this.stationName = stationName == null ? this.stationName : stationName;
        this.title = title;
        PredictionTimes.DepartureTime departures = TrainPrediction.estimateDepartures(this.getData().getTrain(), this.entryIndex, arrivalTime);
        this.realTimes = new PredictionTimes(this, refreshTime, arrivalTime, departures.defaultDepartureTime(), departures.minDepartureTime());
        if (this.scheduled() == null || this.shouldSoftReset) {
            this.reset();
        }
        this.resetAllTimedCaches();
    }

    private void resetAllTimedCaches() {
        this.tagCache.clear();
        this.estimatedTagCache.clear();
    }

    public void onReachStation() {
        this.recentStationNames.addString(this.stationName);
    }

    public static PredictionTimes.DepartureTime estimateDepartures(Train train, int entryIndex, long triggerTime) {
        ScheduleEntry scheduleEntry = (ScheduleEntry)train.runtime.getSchedule().entries.get(entryIndex);
        long[] currentTime = new long[]{triggerTime, triggerTime};
        for (List list : scheduleEntry.conditions) {
            for (ScheduleWaitCondition condition : list) {
                if (!(condition instanceof IPredictableWaitCondition)) continue;
                IPredictableWaitCondition c = (IPredictableWaitCondition)condition;
                currentTime[0] = c.waitUntil(currentTime[0]);
                currentTime[1] = c.waitMinUntil(currentTime[1]);
            }
        }
        return new PredictionTimes.DepartureTime(currentTime[0], currentTime[1]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof TrainPrediction)) return false;
        TrainPrediction o = (TrainPrediction)obj;
        if (!this.scheduled().equals(o.scheduled())) return false;
        if (this.entryIndex != o.entryIndex) return false;
        if (!this.stationName.equals(o.stationName)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.scheduled(), this.realTime(), this.entryIndex, this.stationName});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean similarTo(Object obj) {
        if (!(obj instanceof TrainPrediction)) return false;
        TrainPrediction o = (TrainPrediction)obj;
        if (!this.stationName.equals(o.stationName)) return false;
        if (this.entryIndex != o.entryIndex) return false;
        return true;
    }

    public String toString() {
        return this.formattedText().getString();
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10569(NBT_ENTRY_INDEX, this.entryIndex);
        nbt.method_10582(NBT_STATION_FILTER, this.stationFilter == null ? "" : this.stationFilter);
        nbt.method_10582(NBT_STATION_NAME, this.stationName == null ? "" : this.stationName);
        nbt.method_10582(NBT_TITLE, this.title == null ? "" : this.title);
        if (this.scheduled() != null) {
            nbt.method_10566(NBT_SCHEDULED_TIMES, (class_2520)this.scheduled().toNbt());
        }
        if (this.realTime() != null) {
            nbt.method_10566(NBT_REAL_TIMES, (class_2520)this.realTime().toNbt());
        }
        nbt.method_10569(NBT_CYCLE, this.cycle);
        nbt.method_10569(NBT_TRANSIT_TIME, this.transitTime().value());
        nbt.method_10569(NBT_AVERAGE_STAY_DURATION, this.getAverageStayDuration());
        return nbt;
    }

    public static TrainPrediction fromNbt(TrainData data, class_2487 nbt) {
        TrainPrediction pred = new TrainPrediction(data, nbt.method_10550(NBT_ENTRY_INDEX), nbt.method_10558(NBT_STATION_FILTER), nbt.method_10558(NBT_STATION_NAME), nbt.method_10558(NBT_TITLE));
        pred.deserializeNbt(nbt);
        return pred;
    }

    protected void deserializeNbt(class_2487 nbt) {
        if (nbt.method_10545(NBT_SCHEDULED_TIMES)) {
            this.scheduledTimes = PredictionTimes.fromNbt(this, nbt.method_10562(NBT_SCHEDULED_TIMES));
        }
        if (nbt.method_10545(NBT_REAL_TIMES)) {
            this.realTimes = PredictionTimes.fromNbt(this, nbt.method_10562(NBT_REAL_TIMES));
        }
        this.cycle = nbt.method_10550(NBT_CYCLE);
        this.transitTime.forceValue(nbt.method_10550(NBT_TRANSIT_TIME));
        this.averageStayDuration = nbt.method_10550(NBT_AVERAGE_STAY_DURATION);
    }

    public class_2561 formattedText() {
        return TextUtils.text((String)("[ " + this.entryIndex + " ]: ")).method_27692(class_124.field_1068).method_10852((class_2561)TextUtils.text((String)this.getTargetedStationName()).method_27692(class_124.field_1068)).method_10852((class_2561)TextUtils.text((String)", ").method_27692(class_124.field_1068)).method_10852((class_2561)TextUtils.text((String)("*" + this.getCurrentCycle())).method_27692(class_124.field_1054)).method_10852((class_2561)TextUtils.text((String)", ").method_27692(class_124.field_1068)).method_10852((class_2561)TextUtils.text((String)("sA: " + this.scheduled().arrivalTime())).method_27692(class_124.field_1078)).method_10852((class_2561)TextUtils.text((String)", ").method_27692(class_124.field_1068)).method_10852((class_2561)TextUtils.text((String)("rA: " + this.realTime().arrivalTime())).method_27692(class_124.field_1060)).method_10852((class_2561)TextUtils.text((String)", ").method_27692(class_124.field_1068)).method_10852((class_2561)TextUtils.text((String)("d: " + this.getArrivalTimeDeviation() + " / " + this.getDepartureTimeDeviation())).method_27692(class_124.field_1065)).method_10852((class_2561)TextUtils.text((String)", ").method_27692(class_124.field_1068)).method_10852((class_2561)TextUtils.text((String)("B: " + this.getBufferTime())).method_27692(class_124.field_1077)).method_10852((class_2561)TextUtils.text((String)", ").method_27692(class_124.field_1068)).method_10852((class_2561)TextUtils.text((String)("W: " + this.scheduled().stayDuration() + " / " + this.scheduled().minStayDuration())).method_27692(class_124.field_1075)).method_10852((class_2561)TextUtils.text((String)", ").method_27692(class_124.field_1068)).method_10852((class_2561)TextUtils.text((String)("S: " + String.valueOf(this.getSection()))).method_27692(class_124.field_1061)).method_10852((class_2561)TextUtils.text((String)", ").method_27692(class_124.field_1068)).method_10852((class_2561)TextUtils.text((String)("T: " + this.title)).method_27692(class_124.field_1076)).method_10852((class_2561)TextUtils.text((String)", ").method_27692(class_124.field_1068)).method_10852((class_2561)TextUtils.text((String)("Z: " + this.getStationFilter() + " / " + this.getTargetedStationName() + " / " + this.getEstimatedStationName())).method_27692(class_124.field_1064));
    }

    public void shiftTime(long l) {
        DLUtils.doIfNotNull((Object)this.scheduled(), x -> x.shift(l, true));
        DLUtils.doIfNotNull((Object)this.realTime(), x -> x.shift(l, true));
    }

    @Override
    public int compareTo(TrainPrediction o) {
        return Long.compare(this.scheduled().arrivalTime(), o.scheduled().arrivalTime());
    }
}

