/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train;

import com.google.common.collect.ImmutableMap;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.exceptions.RuntimeSideException;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.Single;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_5250;

public class TrainStatus {
    private static final Registry REGISTRY = Registry.create("createrailwaysnavigator");
    public static final TrainStatus DEFAULT_DELAY = REGISTRY.registerDefault("default_delay", new TrainStatus(TrainStatusCategory.TRAIN, TrainStatusType.DELAY, () -> CustomLanguage.translate("gui.createrailwaysnavigator.train_status.unknown_delay"), null));
    public static final TrainStatus DELAY_FROM_PREVIOUS_JOURNEY = REGISTRY.registerDefault("delay_from_previous_journey", new TrainStatus(TrainStatusCategory.TRAIN, TrainStatusType.DELAY, () -> CustomLanguage.translate("gui.createrailwaysnavigator.train_status.delay_previous_journey"), null));
    public static final TrainStatus CANCELLED = REGISTRY.registerDefault("cancelled", new TrainStatus(TrainStatusCategory.TRAIN, TrainStatusType.DELAY, () -> CustomLanguage.translate("gui.createrailwaysnavigator.route_overview.cancelled"), null));
    public static final int HEIGHT = 9;
    private final TrainStatusType importance;
    private final TrainStatusCategory category;
    private final Supplier<class_5250> text;
    private final Predicate<TrainData> trigger;
    private class_2960 location;

    public TrainStatus(TrainStatusCategory category, TrainStatusType importance, Supplier<class_5250> text, Predicate<TrainData> trigger) {
        this.importance = importance;
        this.category = category;
        this.text = text;
        this.trigger = trigger;
    }

    public TrainStatusType getImportance() {
        return this.importance;
    }

    public class_5250 getText() {
        return this.text.get();
    }

    public boolean isTriggerd(TrainData data) {
        return this.trigger != null && this.trigger.test(data);
    }

    public CompiledTrainStatus compile() {
        return new CompiledTrainStatus(this.location, this.category, this.importance, (class_2561)this.getText());
    }

    public class_2960 getLocation() {
        return this.location;
    }

    private void setLocation(class_2960 location) {
        this.location = location;
    }

    public static enum TrainStatusType {
        MESSAGE_DEFAULT(0, -1),
        MESSAGE_WARN(1, class_124.field_1065.method_532()),
        MESSAGE_IMPORTANT(2, -48574),
        DELAY(3, -48574);

        private final byte index;
        private final int color;

        private TrainStatusType(byte index, int color) {
            this.index = index;
            this.color = color;
        }

        public byte getIndex() {
            return this.index;
        }

        public int getColor() {
            return this.color;
        }

        public static TrainStatusType getByIndex(int index) {
            return Arrays.stream(TrainStatusType.values()).filter(x -> x.getIndex() == index).findFirst().orElse(MESSAGE_DEFAULT);
        }
    }

    public static enum TrainStatusCategory {
        TRAIN(0),
        STATION(1);

        private final byte index;

        private TrainStatusCategory(byte index) {
            this.index = index;
        }

        public byte getIndex() {
            return this.index;
        }

        public static TrainStatusCategory getByIndex(int index) {
            return Arrays.stream(TrainStatusCategory.values()).filter(x -> x.getIndex() == index).findFirst().orElse(TRAIN);
        }
    }

    public record CompiledTrainStatus(class_2960 id, TrainStatusCategory category, TrainStatusType type, class_2561 text) {
        public static final String NBT_CATEGORY = "Category";
        public static final String NBT_TYPE = "Type";
        public static final String NBT_TEXT = "Text";
        public static final String NBT_REASON = "Reason";

        public int render(Graphics graphics, Single<class_327> font, int x, int y, int maxWidth) {
            int color = this.type().getColor();
            float scale = 0.75f;
            graphics.poseStack().method_22903();
            graphics.poseStack().method_46416((float)x, (float)y, 0.0f);
            GuiUtils.setTint((int)color);
            ModGuiIcons.IMPORTANT.render(graphics, -4, -3);
            graphics.poseStack().method_22905(0.75f, 0.75f, 1.0f);
            int height = (int)((float)ClientWrapper.renderMultilineLabelSafe(graphics, 13, 2, (class_327)font.getFirst(), this.text(), (int)((float)maxWidth / 0.75f), color) * 0.75f);
            graphics.poseStack().method_22909();
            return Math.max(9, height + 2);
        }

        public static List<CompiledTrainStatus> load(Collection<class_2960> ids) throws RuntimeSideException {
            if (Platform.getEnv() == EnvType.SERVER) {
                throw new RuntimeSideException(true);
            }
            ArrayList<CompiledTrainStatus> status = new ArrayList<CompiledTrainStatus>(ids.size());
            for (class_2960 loc : ids) {
                status.add(((TrainStatus)Registry.getRegisteredStatus().get((Object)loc)).compile());
            }
            return status;
        }

        public static CompiledTrainStatus load(class_2960 id) throws RuntimeSideException {
            if (Platform.getEnv() == EnvType.SERVER) {
                throw new RuntimeSideException(true);
            }
            return ((TrainStatus)Registry.getRegisteredStatus().get((Object)id)).compile();
        }
    }

    public static class Registry {
        private static final Map<class_2960, TrainStatus> registeredStatusInfos = new HashMap<class_2960, TrainStatus>();
        private final String modid;

        private Registry(String modid) {
            this.modid = modid;
        }

        public static Registry create(String modid) {
            return new Registry(modid);
        }

        public static ImmutableMap<class_2960, TrainStatus> getRegisteredStatus() {
            return ImmutableMap.copyOf(registeredStatusInfos);
        }

        public TrainStatus register(String name, TrainStatus statusPattern) {
            class_2960 loc = new class_2960(this.modid, name);
            statusPattern.setLocation(loc);
            registeredStatusInfos.put(loc, statusPattern);
            return statusPattern;
        }

        public TrainStatus registerDefault(String name, TrainStatus statusPattern) {
            class_2960 loc = new class_2960(this.modid, name);
            statusPattern.setLocation(loc);
            registeredStatusInfos.put(loc, statusPattern);
            return statusPattern;
        }

        public TrainStatus unregister(class_2960 location) {
            return registeredStatusInfos.remove(location);
        }

        public TrainStatus get(class_2960 location) {
            return registeredStatusInfos.get(location);
        }

        public boolean isRegistered(class_2960 location) {
            return registeredStatusInfos.containsKey(location);
        }

        public void delete(String modid) {
            registeredStatusInfos.keySet().removeIf(x -> x.method_12836().equals(modid));
        }
    }
}

