/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train;

import com.simibubi.create.content.trains.entity.TrainIconType;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.TagName;
import de.mrjulsen.crn.data.TrainInfo;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.crn.data.train.TrainState;
import de.mrjulsen.crn.exceptions.RuntimeSideException;
import de.mrjulsen.mcdragonlib.DragonLib;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class TrainStop
implements Comparable<TrainStop> {
    protected static final String NBT_SCHEDULE_INDEX = "ScheduleIndex";
    protected static final String NBT_SECTION_INDEX = "SectionIndex";
    protected static final String NBT_TRAIN_ID = "TrainId";
    protected static final String NBT_TRAIN_NAME = "TrainName";
    protected static final String NBT_TRAIN_ICON = "TrainIcon";
    protected static final String NBT_TRAIN_INFO = "TrainInfo";
    protected static final String NBT_SCHEDULE_TITLE = "ScheduleTitle";
    protected static final String NBT_TERMINUS_TEXT = "TerminusText";
    protected static final String NBT_STAY_DURATION = "StayDuration";
    protected static final String NBT_IS_CUSTOM_TITLE = "IsCustomTitle";
    protected static final String NBT_SIMULATED_TIME = "SimulationTime";
    protected static final String NBT_SCHEDULED_DEPARTURE_TIME = "ScheduledDeparture";
    protected static final String NBT_SCHEDULED_ARRIVAL_TIME = "ScheduledArrival";
    protected static final String NBT_CYCLE = "Cycle";
    protected static final String NBT_TAG = "StationTag";
    protected static final String NBT_REAL_TIME_ARRIVAL_TIME = "RealArrival";
    protected static final String NBT_REAL_TIME_DEPARTURE_TIME = "RealDeparture";
    protected static final String NBT_REAL_CYCLE = "RealCycle";
    protected static final String NBT_REAL_TIME_TAG = "RealTimeTag";
    protected static final String NBT_STATE = "State";
    protected final int scheduleIndex;
    protected final int sectionIndex;
    protected final UUID trainId;
    protected final String trainName;
    protected final TrainIconType trainIcon;
    protected final TrainInfo trainInfo;
    protected final String scheduleTitle;
    protected final String terminusText;
    protected final int stayDuration;
    protected final boolean isCustomTitle;
    protected boolean simulated;
    protected long simulationTime;
    protected long scheduledDepartureTime;
    protected long scheduledArrivalTime;
    protected int cycle;
    protected StationTag.ClientStationTag tag;
    protected long realTimeArrivalTime;
    protected long realTimeDepartureTime;
    protected int realTimeCycle = -1;
    protected StationTag.ClientStationTag realTimeTag;
    protected int realTimeTicksUntilArrival = -1;
    protected TrainState trainState = TrainState.BEFORE;

    public TrainStop(int scheduleIndex, int sectionIndex, UUID trainId, String trainName, TrainIconType trainIcon, TrainInfo trainInfo, String scheduleTitle, boolean isCustomTitle, String terminusText, int stayDuration, boolean simulated, long scheduledDepartureTime, long scheduledArrivalTime, int cycle, StationTag.ClientStationTag tag, long realTimeArrivalTime, long realTimeDepartureTime, int realTimeCycle, StationTag.ClientStationTag realTimeTag, int realTimeTicksUntilArrival, TrainState trainPosition) {
        this.scheduleIndex = scheduleIndex;
        this.sectionIndex = sectionIndex;
        this.trainId = trainId;
        this.trainName = trainName;
        this.trainIcon = trainIcon;
        this.trainInfo = trainInfo;
        this.scheduleTitle = scheduleTitle;
        this.isCustomTitle = isCustomTitle;
        this.terminusText = terminusText;
        this.stayDuration = stayDuration;
        this.simulated = simulated;
        this.scheduledDepartureTime = scheduledDepartureTime;
        this.scheduledArrivalTime = scheduledArrivalTime;
        this.cycle = cycle;
        this.tag = tag;
        this.realTimeArrivalTime = realTimeArrivalTime;
        this.realTimeDepartureTime = realTimeDepartureTime;
        this.realTimeCycle = realTimeCycle;
        this.realTimeTag = realTimeTag;
        this.realTimeTicksUntilArrival = realTimeTicksUntilArrival;
        this.trainState = trainPosition;
    }

    public TrainStop(TrainPrediction prediction) {
        this(prediction.getStationTag(), prediction, false);
    }

    public TrainStop(StationTag tag, TrainPrediction prediction, boolean lastCycle) {
        this(prediction.getEntryIndex(), prediction.getSection().getScheduleIndex(), prediction.getData().getTrainId(), prediction.getData().getTrain().name.getString(), prediction.getData().getTrain().icon, prediction.getData().getTrainInfo(prediction.getEntryIndex()), prediction.getTitle(), prediction.hasCustomTitle(), prediction.getSectionDestinationText(), (int)prediction.scheduled().stayDuration(), false, lastCycle ? prediction.getPreviousScheduledDepartureTime() : prediction.scheduled().departureTime(), lastCycle ? prediction.getPreviousScheduledArrivalTime() : prediction.scheduled().arrivalTime(), prediction.getCurrentCycle() - (lastCycle ? 1 : 0), GlobalSettings.getInstance().getOrCreateStationTagFor(prediction.getScheduledStationName()).getClientTag(prediction.getScheduledStationName()), lastCycle ? prediction.getPreviousRealTimeArrivalTime() : prediction.realTime().arrivalTime(), lastCycle ? prediction.getPreviousRealTimeDepartureTime() : prediction.realTime().departureTime(), prediction.getCurrentCycle() - (lastCycle ? 1 : 0), GlobalSettings.getInstance().getOrCreateStationTagFor(prediction.getRealTimeStationName()).getClientTag(prediction.getRealTimeStationName()), (int)prediction.realTime().arrivalIn(), TrainState.BEFORE);
    }

    public TrainStop copy() {
        return new TrainStop(this.scheduleIndex, this.sectionIndex, this.trainId, this.trainName, this.trainIcon, this.trainInfo, this.scheduleTitle, this.isCustomTitle, this.terminusText, this.stayDuration, this.simulated, this.scheduledDepartureTime, this.scheduledArrivalTime, this.cycle, this.tag, this.realTimeArrivalTime, this.realTimeDepartureTime, this.realTimeCycle, this.realTimeTag, this.realTimeTicksUntilArrival, this.trainState);
    }

    public void simulateTicks(long ticks) {
        if (((Boolean)ModCommonConfig.EXPERIMENT_SIMULATION_ALGORITHM.get()).booleanValue()) {
            this.simulateTicksNew(ticks);
        } else {
            this.simulateTicksLegacy(ticks);
        }
    }

    private void simulateTicksLegacy(long ticks) {
        this.simulated = true;
        int totalDuration = TrainListener.getTrainData(this.getTrainId()).map(TrainData::getTotalDuration).orElse(-1);
        if (totalDuration <= 0) {
            return;
        }
        long scheduledTimeUntilArrival = this.getScheduledArrivalTime() - DragonLib.getCurrentWorldTime();
        int simulationCycles = (int)(ticks / (long)totalDuration);
        long simulationRemaining = ticks % (long)totalDuration;
        if (simulationRemaining > 0L && simulationRemaining >= scheduledTimeUntilArrival) {
            ++simulationCycles;
        }
        this.cycle += simulationCycles;
        this.scheduledArrivalTime += (long)(simulationCycles * totalDuration);
        this.scheduledDepartureTime += (long)(simulationCycles * totalDuration);
        this.realTimeArrivalTime += (long)(simulationCycles * totalDuration);
        this.realTimeDepartureTime += (long)(simulationCycles * totalDuration);
        this.realTimeTicksUntilArrival = -1;
        this.simulationTime += ticks;
    }

    private void simulateTicksNew(long ticks) {
        this.simulated = true;
        TrainData.SimulationResult res = TrainListener.getTrainData(this.getTrainId()).get().simulate(this.scheduleIndex, ticks);
        this.cycle += res.cycles();
        this.scheduledArrivalTime = res.arrivalTime();
        this.scheduledDepartureTime = res.departureTime();
        this.realTimeArrivalTime = res.arrivalTime();
        this.realTimeDepartureTime = res.departureTime();
        this.realTimeTicksUntilArrival = -1;
        this.simulationTime += ticks;
    }

    public void simulateCycles(int cycles) {
        if (cycles == 0) {
            return;
        }
        TrainListener.getTrainData(this.getTrainId()).ifPresent(x -> this.simulateTicks(cycles * x.getTotalDuration()));
    }

    public static TrainStop simulateCyclesBack(TrainPrediction prediction) {
        return new TrainStop(prediction.getStationTag(), prediction, true);
    }

    public boolean isSimulated() {
        return this.simulated;
    }

    public long getSimulationTime() {
        return this.simulationTime;
    }

    public UUID getTrainId() {
        return this.trainId;
    }

    public String getTrainName() {
        return this.trainName;
    }

    public TrainIconType getTrainIcon() {
        return this.trainIcon;
    }

    public TrainInfo getTrainInfo() {
        return this.trainInfo;
    }

    public int getScheduleIndex() {
        return this.scheduleIndex;
    }

    public int getSectionIndex() {
        return this.sectionIndex;
    }

    public String getTerminusText() {
        return this.terminusText;
    }

    public boolean hasCustomTitle() {
        return this.isCustomTitle;
    }

    public String getScheduleTitle() {
        return this.scheduleTitle;
    }

    public String getDisplayTitle() {
        return this.hasCustomTitle() || this.getTerminusText() == null || this.getTerminusText().isEmpty() ? this.getScheduleTitle() : this.getTerminusText();
    }

    public String getTrainDisplayName() {
        return this.getTrainInfo() == null || this.getTrainInfo().line() == null || this.getTrainInfo().line().getLineName().isEmpty() ? this.getTrainName() : this.getTrainInfo().line().getLineName();
    }

    public int getTrainDisplayColor() {
        if (this.getTrainInfo() != null && this.getTrainInfo().line() != null && this.getTrainInfo().line().getColor() != 0) {
            return this.getTrainInfo().line().getColor();
        }
        if (this.getTrainInfo() != null && this.getTrainInfo().category() != null && this.getTrainInfo().category().getColor() != 0) {
            return this.getTrainInfo().category().getColor();
        }
        return -13027015;
    }

    public int getStayTime() {
        return this.stayDuration;
    }

    public StationTag getTag() throws RuntimeSideException {
        if (!DragonLib.hasServer()) {
            throw new RuntimeSideException(false);
        }
        return GlobalSettings.getInstance().getStationTag(this.getRealTimeStationTag().tagId()).orElse(GlobalSettings.getInstance().getOrCreateStationTagFor(TagName.of(this.getRealTimeStationTag().tagName())));
    }

    public StationTag.ClientStationTag getScheduledStationTag() {
        return this.tag;
    }

    public int getScheduledCycle() {
        return this.cycle;
    }

    public int getRealTimeCycle() {
        return this.realTimeCycle;
    }

    public StationTag.ClientStationTag getRealTimeStationTag() {
        return this.realTimeTag;
    }

    public long getScheduledDepartureTime() {
        return this.scheduledDepartureTime;
    }

    public long getScheduledArrivalTime() {
        return this.scheduledArrivalTime;
    }

    public long getRealTimeArrivalTime() {
        return this.realTimeArrivalTime;
    }

    public long getRealTimeDepartureTime() {
        return this.realTimeDepartureTime;
    }

    public long getArrivalTimeDeviation() {
        return this.getRealTimeArrivalTime() - this.getScheduledArrivalTime();
    }

    public long getDepartureTimeDeviation() {
        return this.getRealTimeDepartureTime() - this.getScheduledDepartureTime();
    }

    public int getTicksUntilArrival() {
        return this.realTimeTicksUntilArrival;
    }

    public long getScheduledArrivalDay() {
        return this.getScheduledArrivalTime() / DragonLib.ticksPerDay();
    }

    public long getScheduledDepartureDay() {
        return this.getScheduledDepartureDay() / DragonLib.ticksPerDay();
    }

    public long getRealTimeArrivalDay() {
        return this.getRealTimeArrivalTime() / DragonLib.ticksPerDay();
    }

    public long getRealTimeDepartureDay() {
        return this.getRealTimeDepartureTime() / DragonLib.ticksPerDay();
    }

    public TrainState getState() {
        return this.trainState;
    }

    public boolean isArrivalDelayed() {
        return this.getArrivalTimeDeviation() >= (long)((Integer)ModCommonConfig.SCHEDULE_DEVIATION_THRESHOLD.get()).intValue();
    }

    public boolean isDepartureDelayed() {
        return this.getDepartureTimeDeviation() >= (long)((Integer)ModCommonConfig.SCHEDULE_DEVIATION_THRESHOLD.get()).intValue();
    }

    public boolean isAnyDelayed() {
        return this.isArrivalDelayed() || this.isDepartureDelayed();
    }

    public boolean hasTrackChanged() {
        return !this.realTimeTag.info().equals(this.tag.info());
    }

    public boolean shouldRenderRealTime() {
        return this.getRealTimeCycle() >= this.getScheduledCycle();
    }

    public boolean isStationInfoChanged() {
        return !this.getScheduledStationTag().info().equals(this.getRealTimeStationTag().info());
    }

    public boolean isDeparted() {
        return this.trainState == TrainState.AFTER;
    }

    @Override
    public int compareTo(TrainStop o) {
        return Long.compare(this.getScheduledArrivalTime(), o.getScheduledArrivalTime());
    }

    public class_2487 toNbt(boolean includeRealTime) {
        class_2487 nbt = new class_2487();
        nbt.method_10569(NBT_SCHEDULE_INDEX, this.scheduleIndex);
        nbt.method_10569(NBT_SECTION_INDEX, this.sectionIndex);
        nbt.method_25927(NBT_TRAIN_ID, this.trainId);
        nbt.method_10582(NBT_TRAIN_NAME, this.trainName);
        nbt.method_10582(NBT_TRAIN_ICON, this.trainIcon.getId().toString());
        nbt.method_10566(NBT_TRAIN_INFO, (class_2520)this.trainInfo.toNbt());
        nbt.method_10582(NBT_SCHEDULE_TITLE, this.scheduleTitle);
        nbt.method_10582(NBT_TERMINUS_TEXT, this.terminusText);
        nbt.method_10569(NBT_STAY_DURATION, this.stayDuration);
        nbt.method_10556(NBT_IS_CUSTOM_TITLE, this.isCustomTitle);
        nbt.method_10566(NBT_TAG, (class_2520)this.tag.toNbt());
        nbt.method_10544(NBT_SIMULATED_TIME, this.simulationTime);
        nbt.method_10544(NBT_SCHEDULED_ARRIVAL_TIME, this.scheduledArrivalTime);
        nbt.method_10544(NBT_SCHEDULED_DEPARTURE_TIME, this.scheduledDepartureTime);
        nbt.method_10569(NBT_CYCLE, this.cycle);
        nbt.method_10544(NBT_REAL_TIME_ARRIVAL_TIME, this.realTimeArrivalTime);
        nbt.method_10544(NBT_REAL_TIME_DEPARTURE_TIME, this.realTimeDepartureTime);
        nbt.method_10569(NBT_REAL_CYCLE, this.realTimeCycle);
        nbt.method_10566(NBT_REAL_TIME_TAG, (class_2520)this.realTimeTag.toNbt());
        return nbt;
    }

    public static TrainStop fromNbt(class_2487 nbt) {
        return new TrainStop(nbt.method_10550(NBT_SCHEDULE_INDEX), nbt.method_10550(NBT_SECTION_INDEX), nbt.method_25926(NBT_TRAIN_ID), nbt.method_10558(NBT_TRAIN_NAME), TrainIconType.byId((class_2960)new class_2960(nbt.method_10558(NBT_TRAIN_ICON))), TrainInfo.fromNbt(nbt.method_10562(NBT_TRAIN_INFO)), nbt.method_10558(NBT_SCHEDULE_TITLE), nbt.method_10577(NBT_IS_CUSTOM_TITLE), nbt.method_10558(NBT_TERMINUS_TEXT), nbt.method_10550(NBT_STAY_DURATION), nbt.method_10537(NBT_SIMULATED_TIME) != 0L, nbt.method_10537(NBT_SCHEDULED_DEPARTURE_TIME), nbt.method_10537(NBT_SCHEDULED_ARRIVAL_TIME), nbt.method_10550(NBT_CYCLE), StationTag.ClientStationTag.fromNbt(nbt.method_10562(NBT_TAG)), nbt.method_10537(NBT_REAL_TIME_ARRIVAL_TIME), nbt.method_10537(NBT_REAL_TIME_DEPARTURE_TIME), nbt.method_10550(NBT_REAL_CYCLE), StationTag.ClientStationTag.fromNbt(nbt.method_10562(NBT_REAL_TIME_TAG)), 0, TrainState.BEFORE);
    }
}

