/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train.portable;

import com.simibubi.create.content.trains.entity.TrainIconType;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainStatus;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.crn.exceptions.RuntimeSideException;
import de.mrjulsen.mcdragonlib.data.Cache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class BasicTrainDisplayData {
    private final UUID id;
    private final String name;
    private final int color;
    private final TrainIconType icon;
    private final Collection<class_2960> statusLocations;
    private final boolean cancelled;
    private final Cache<List<TrainStatus.CompiledTrainStatus>> clientStatus;
    private static final String NBT_ID = "Id";
    private static final String NBT_NAME = "Name";
    private static final String NBT_ICON = "Icon";
    private static final String NBT_COLOR = "Color";
    private static final String NBT_STATUS = "Status";
    private static final String NBT_CANCELLED = "Cancelled";

    private BasicTrainDisplayData(UUID id, String name, int color, TrainIconType icon, Collection<class_2960> statusLocations, boolean cancelled) {
        this.id = id;
        this.name = name;
        this.color = color;
        this.icon = icon;
        this.statusLocations = statusLocations;
        this.cancelled = cancelled;
        this.clientStatus = new Cache(() -> TrainStatus.CompiledTrainStatus.load(statusLocations));
    }

    public static BasicTrainDisplayData empty() {
        return new BasicTrainDisplayData(new UUID(0L, 0L), "", 0, TrainIconType.getDefault(), List.of(), true);
    }

    public static BasicTrainDisplayData of(UUID train) throws RuntimeSideException {
        if (!ModCommonEvents.hasServer()) {
            throw new RuntimeSideException(false);
        }
        return TrainListener.getTrainData(train).map(data -> new BasicTrainDisplayData(data.getTrainId(), data.getTrainDisplayName(), data.getCurrentSection().getTrainLine().map(x -> x.getColor()).orElse(0), data.getTrain().icon, new ArrayList<class_2960>(data.getStatus()), data.isCancelled())).orElse(BasicTrainDisplayData.empty());
    }

    public static BasicTrainDisplayData of(TrainStop stop) throws RuntimeSideException {
        if (!ModCommonEvents.hasServer()) {
            throw new RuntimeSideException(false);
        }
        return TrainListener.getTrainData(stop.getTrainId()).map(data -> new BasicTrainDisplayData(stop.getTrainId(), stop.getTrainDisplayName(), data.getSectionForIndex(stop.getScheduleIndex()).getTrainLine().map(x -> x.getColor()).orElse(0), stop.getTrainIcon(), new ArrayList<class_2960>(data.getStatus()), data.isCancelled())).orElse(BasicTrainDisplayData.empty());
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public TrainIconType getIcon() {
        return this.icon;
    }

    public List<TrainStatus.CompiledTrainStatus> getStatus() {
        return (List)this.clientStatus.get();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public int getColor() {
        return this.color;
    }

    public boolean hasColor() {
        return this.color != 0;
    }

    public boolean hasStatusInfo() {
        return !this.getStatus().isEmpty();
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        class_2499 statusList = new class_2499();
        for (class_2960 s : this.statusLocations) {
            statusList.add((Object)class_2519.method_23256((String)s.toString()));
        }
        nbt.method_25927(NBT_ID, this.id);
        nbt.method_10582(NBT_NAME, this.name);
        nbt.method_10582(NBT_ICON, this.icon.getId().toString());
        nbt.method_10569(NBT_COLOR, this.color);
        nbt.method_10566(NBT_STATUS, (class_2520)statusList);
        nbt.method_10556(NBT_CANCELLED, this.cancelled);
        return nbt;
    }

    public static BasicTrainDisplayData fromNbt(class_2487 nbt) {
        return new BasicTrainDisplayData(nbt.method_25926(NBT_ID), nbt.method_10558(NBT_NAME), nbt.method_10550(NBT_COLOR), TrainIconType.byId((class_2960)new class_2960(nbt.method_10558(NBT_ICON))), nbt.method_10554(NBT_STATUS, 8).stream().map(x -> new class_2960(((class_2519)x).method_10714())).toList(), nbt.method_10577(NBT_CANCELLED));
    }

    public final boolean equals(Object obj) {
        BasicTrainDisplayData o;
        return obj instanceof BasicTrainDisplayData && (o = (BasicTrainDisplayData)obj).getId().equals(this.getId());
    }

    public final int hashCode() {
        return Objects.hash(this.getId());
    }
}

