/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.event;

import com.mojang.brigadier.CommandDispatcher;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.block.display.AdvancedDisplayTarget;
import de.mrjulsen.crn.cmd.DebugCommand;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.DepartureHistory;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.event.CRNCommonEventsRegistryEvent;
import de.mrjulsen.crn.event.CRNEventsManager;
import de.mrjulsen.crn.event.events.GlobalTrainDisplayDataRefreshEventPost;
import de.mrjulsen.crn.event.events.GlobalTrainDisplayDataRefreshEventPre;
import de.mrjulsen.crn.event.events.ScheduleResetEvent;
import de.mrjulsen.crn.event.events.SubmitTrainPredictionsEvent;
import de.mrjulsen.crn.event.events.TotalDurationTimeChangedEvent;
import de.mrjulsen.crn.event.events.TrainArrivalAndDepartureEvent;
import de.mrjulsen.crn.event.events.TrainDestinationChangedEvent;
import de.mrjulsen.crn.registry.ModExtras;
import de.mrjulsen.mcdragonlib.internal.ClientWrapper;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.TickEvent;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;

public class ModCommonEvents {
    private static long lastTicks = 0L;
    private static MinecraftServer currentServer;

    public static void init() {
        LifecycleEvent.SETUP.register(() -> CreateRailwaysNavigator.LOGGER.info("Welcome to the CREATE RAILWAYS NAVIGATOR mod by MRJULSEN."));
        LifecycleEvent.SERVER_LEVEL_LOAD.register(level -> ModExtras.init());
        LifecycleEvent.SERVER_STARTED.register(server -> {
            currentServer = server;
            CRNEventsManager.registerEvent(GlobalTrainDisplayDataRefreshEventPost::new);
            CRNEventsManager.registerEvent(GlobalTrainDisplayDataRefreshEventPre::new);
            CRNEventsManager.registerEvent(TrainDestinationChangedEvent::new);
            CRNEventsManager.registerEvent(TrainArrivalAndDepartureEvent::new);
            CRNEventsManager.registerEvent(SubmitTrainPredictionsEvent::new);
            CRNEventsManager.registerEvent(ScheduleResetEvent::new);
            CRNEventsManager.registerEvent(TotalDurationTimeChangedEvent::new);
            CRNEventsManager.getEvent(CRNCommonEventsRegistryEvent.class).run();
            TrainListener.start();
            AdvancedDisplayTarget.start();
        });
        LifecycleEvent.SERVER_STOPPING.register(server -> {
            GlobalSettings.clearInstance();
            TrainListener.stop();
            AdvancedDisplayTarget.stop();
            CRNEventsManager.clearEvents();
            DepartureHistory.clear();
        });
        LifecycleEvent.SERVER_STOPPED.register(server -> {
            currentServer = null;
        });
        LifecycleEvent.SERVER_STARTING.register(server -> {});
        TickEvent.SERVER_POST.register(server -> {
            if (ModCommonEvents.hasServer()) {
                long currentTicks = ModCommonEvents.getPhysicalLevel().method_30271();
                long diff = currentTicks - lastTicks;
                if (Math.abs(diff) > 1L) {
                    for (TrainData data : TrainListener.getAllTrainData()) {
                        data.shiftTime(diff);
                    }
                    if (((Boolean)ModCommonConfig.ADVANCED_LOGGING.get()).booleanValue()) {
                        CreateRailwaysNavigator.LOGGER.info("All times have been corrected: " + diff + " Ticks");
                    }
                }
                lastTicks = currentTicks;
            }
        });
        CommandRegistrationEvent.EVENT.register((dispatcher, context, selection) -> DebugCommand.register((CommandDispatcher<class_2168>)dispatcher, selection));
        LifecycleEvent.SERVER_LEVEL_SAVE.register(server -> {
            if (!ModCommonEvents.getCurrentServer().isPresent()) {
                return;
            }
            if (server != ModCommonEvents.getCurrentServer().get().method_30002()) {
                return;
            }
            TrainListener.save();
            if (GlobalSettings.hasInstance()) {
                GlobalSettings.getInstance().save();
            }
        });
    }

    public static boolean hasServer() {
        return currentServer != null;
    }

    public static Optional<MinecraftServer> getCurrentServer() {
        return Optional.ofNullable(currentServer);
    }

    public static class_1937 getPhysicalLevel() {
        return ModCommonEvents.hasServer() ? ModCommonEvents.getCurrentServer().get().method_30002() : ClientWrapper.getClientLevel();
    }
}

