/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.mixin;

import com.simibubi.create.content.trains.display.GlobalTrainDisplayData;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.DiscoveredPath;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.content.trains.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.trains.schedule.destination.ScheduleInstruction;
import com.simibubi.create.content.trains.station.GlobalStation;
import de.mrjulsen.crn.data.schedule.INavigationExtension;
import de.mrjulsen.crn.data.schedule.instruction.ICustomSuggestionsInstruction;
import de.mrjulsen.crn.data.schedule.instruction.PrioritizedDestinationInstruction;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.event.CRNEventsManager;
import de.mrjulsen.crn.event.events.ScheduleResetEvent;
import de.mrjulsen.crn.event.events.SubmitTrainPredictionsEvent;
import de.mrjulsen.crn.event.events.TrainDestinationChangedEvent;
import de.mrjulsen.crn.mixin.ScheduleRuntimeAccessor;
import de.mrjulsen.crn.util.PenaltyResult;
import de.mrjulsen.mcdragonlib.data.MapCache;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.PatternSyntaxException;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ScheduleRuntime.class})
public class ScheduleRuntimeMixin {
    public ScheduleRuntime self() {
        return (ScheduleRuntime)this;
    }

    public ScheduleRuntimeAccessor accessor() {
        return (ScheduleRuntimeAccessor)((Object)this);
    }

    @Inject(method={"submitPredictions"}, remap=false, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void onSubmitPredictions(CallbackInfoReturnable<Collection<GlobalTrainDisplayData.TrainDeparturePrediction>> cir, Collection<GlobalTrainDisplayData.TrainDeparturePrediction> predictions, int entryCount, int accumulatedTime, int current) {
        if (CRNEventsManager.isRegistered(SubmitTrainPredictionsEvent.class)) {
            CRNEventsManager.getEvent(SubmitTrainPredictionsEvent.class).run(this.accessor().crn$getTrain(), predictions, entryCount, accumulatedTime, current);
        }
    }

    @Inject(method={"<init>"}, remap=false, at={@At(value="TAIL")})
    public void onResetWhileInit(CallbackInfo ci) {
        if (CRNEventsManager.isRegistered(ScheduleResetEvent.class)) {
            CRNEventsManager.getEvent(ScheduleResetEvent.class).run(this.accessor().crn$getTrain(), true);
        }
    }

    @Inject(method={"setSchedule", "discardSchedule"}, remap=false, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/schedule/ScheduleRuntime;reset()V")})
    public void onReset(CallbackInfo ci) {
        if (CRNEventsManager.isRegistered(ScheduleResetEvent.class)) {
            CRNEventsManager.getEvent(ScheduleResetEvent.class).run(this.accessor().crn$getTrain(), false);
        }
    }

    @Inject(method={"startCurrentInstruction"}, remap=false, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void onStartCurrentInstructionRetFabric(CallbackInfoReturnable<DiscoveredPath> cir, ScheduleEntry entry, ScheduleInstruction instruction) {
        if (CRNEventsManager.isRegistered(TrainDestinationChangedEvent.class) && cir.getReturnValue() != null && instruction instanceof DestinationInstruction) {
            CRNEventsManager.getEvent(TrainDestinationChangedEvent.class).run(this.accessor().crn$getTrain(), this.accessor().crn$getTrain().getCurrentStation(), ((DiscoveredPath)cir.getReturnValue()).destination, this.self().currentEntry);
        }
    }

    @Inject(method={"startCurrentInstruction"}, remap=false, at={@At(value="TAIL")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    public void onStartCurrentInstructionPost(CallbackInfoReturnable<Object> cir, ScheduleEntry entry, ScheduleInstruction instruction) {
        if (instruction instanceof ICustomSuggestionsInstruction) {
            ICustomSuggestionsInstruction custom = (ICustomSuggestionsInstruction)instruction;
            TrainListener.getTrainData(this.accessor().crn$getTrain().id).ifPresent(x -> custom.run(this.self(), (TrainData)x, this.accessor().crn$getTrain(), this.self().currentEntry));
            this.self().state = ScheduleRuntime.State.PRE_TRANSIT;
            ++this.self().currentEntry;
        }
        cir.setReturnValue(null);
    }

    @Inject(method={"startCurrentInstruction"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    public void startCurrentInstructionHeadForge(CallbackInfoReturnable<DiscoveredPath> cir) {
        ScheduleEntry entry = (ScheduleEntry)this.self().getSchedule().entries.get(this.self().currentEntry);
        ScheduleInstruction instruction = entry.instruction;
        DiscoveredPath res = this.crn$customDestinationInstructions(this.self(), entry, instruction);
        if (res != null) {
            cir.setReturnValue((Object)res);
        }
    }

    @Unique
    private DiscoveredPath crn$customDestinationInstructions(ScheduleRuntime runtime, ScheduleEntry entry, ScheduleInstruction instruction) {
        if (instruction instanceof PrioritizedDestinationInstruction) {
            PrioritizedDestinationInstruction destination = (PrioritizedDestinationInstruction)instruction;
            ScheduleRuntimeAccessor accessor = (ScheduleRuntimeAccessor)runtime;
            Train train = accessor.crn$getTrain();
            List<String> filters = destination.getFilters();
            INavigationExtension ext = (INavigationExtension)train.navigation;
            DiscoveredPath selectedDestination = null;
            int selectedPainCount = Integer.MAX_VALUE;
            boolean anyMatch = false;
            MapCache navigationCache = new MapCache(station -> train.navigation.findPathTo(station, Double.MAX_VALUE), Object::hashCode);
            if (!train.hasForwardConductor() && !train.hasBackwardConductor()) {
                train.status.missingConductor();
                accessor.crn$setCooldown(accessor.crn$getInterval());
                return null;
            }
            for (String regex : filters) {
                AtomicInteger painCount = new AtomicInteger(0);
                GlobalStation bestStation = null;
                DiscoveredPath bestPath = null;
                double bestCost = Double.MAX_VALUE;
                for (GlobalStation globalStation : train.graph.getPoints(EdgePointType.STATION)) {
                    try {
                        if (!globalStation.name.matches(regex)) {
                        }
                    }
                    catch (PatternSyntaxException ignored) {}
                    continue;
                    DiscoveredPath discoveredPath = (DiscoveredPath)navigationCache.get((Object)globalStation, (Object)globalStation);
                    if (discoveredPath == null || discoveredPath.cost < 0.0 || discoveredPath.cost > bestCost) continue;
                    bestStation = globalStation;
                    bestPath = discoveredPath;
                    bestCost = discoveredPath.cost;
                }
                if (bestStation == null) continue;
                anyMatch = true;
                if (destination.shouldAvoidTrains() && (bestStation.getImminentTrain() != null && bestStation.getImminentTrain() != train || bestStation.getPresentTrain() != null && bestStation.getPresentTrain() != train || bestStation.getNearestTrain() != null && bestStation.getNearestTrain() != train)) {
                    painCount.addAndGet(1);
                }
                ext.getPenaltiesByDirection().ifPresent(x -> {
                    for (PenaltyResult.Type type : x.getPenalties().keySet()) {
                        if (destination.shouldAvoidRedSignals() && type == PenaltyResult.Type.REDSTONE_RED_SIGNAL) {
                            painCount.addAndGet(1);
                            continue;
                        }
                        if (!destination.shouldAvoidTrains() || type.getCategory() != PenaltyResult.Category.TRAINS && type != PenaltyResult.Type.RED_SIGNAL) continue;
                        painCount.addAndGet(1);
                    }
                });
                if (painCount.get() >= selectedPainCount) continue;
                selectedPainCount = painCount.get();
                selectedDestination = bestPath;
                if (painCount.get() > 0) continue;
                break;
            }
            if (selectedDestination == null) {
                if (anyMatch) {
                    train.status.failedNavigation();
                } else {
                    train.status.failedNavigationNoTarget(String.join((CharSequence)", ", filters));
                }
                accessor.crn$setCooldown(accessor.crn$getInterval());
                return null;
            }
            return selectedDestination;
        }
        return null;
    }
}

