/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.cts;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionWorld;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import de.mrjulsen.crn.block.AbstractAdvancedSidedDisplayBlock;
import de.mrjulsen.crn.block.IBlockGetter;
import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.block.properties.ESide;
import de.mrjulsen.crn.client.AdvancedDisplaysRegistry;
import de.mrjulsen.mcdragonlib.net.IPacketBase;
import dev.architectury.networking.NetworkManager;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3499;
import org.apache.commons.lang3.tuple.MutablePair;

public class AdvancedDisplayUpdatePacket
implements IPacketBase<AdvancedDisplayUpdatePacket> {
    private class_2338 pos;
    private int entityId;
    private boolean isOnContraption;
    private AdvancedDisplaysRegistry.DisplayTypeResourceKey key;
    private boolean doubleSided;
    private IDisplaySettings settings;

    public AdvancedDisplayUpdatePacket() {
    }

    public AdvancedDisplayUpdatePacket(class_1937 level, class_2338 pos, AbstractContraptionEntity contraption, AdvancedDisplaysRegistry.DisplayTypeResourceKey key, boolean doubleSided, IDisplaySettings settings) {
        this.pos = pos;
        this.isOnContraption = contraption != null;
        this.entityId = this.isOnContraption ? contraption.method_5628() : 0;
        this.key = key;
        this.doubleSided = doubleSided;
        this.settings = settings;
        if (this.isOnContraption) {
            this.applyContraption(contraption, this);
        } else {
            this.apply(level, this);
        }
    }

    protected AdvancedDisplayUpdatePacket(class_2338 pos, int entityId, boolean isOnContraption, AdvancedDisplaysRegistry.DisplayTypeResourceKey key, boolean doubleSided, IDisplaySettings settings) {
        this.pos = pos;
        this.entityId = entityId;
        this.isOnContraption = isOnContraption;
        this.key = key;
        this.doubleSided = doubleSided;
        this.settings = settings;
    }

    public void encode(AdvancedDisplayUpdatePacket packet, class_2540 buffer) {
        class_2487 k = new class_2487();
        packet.key.toNbt(k);
        buffer.method_10807(packet.pos);
        buffer.method_10794(k);
        buffer.writeBoolean(packet.doubleSided);
        buffer.writeBoolean(packet.isOnContraption);
        buffer.writeInt(packet.entityId);
        buffer.method_10794(packet.settings.serializeNbt());
    }

    public AdvancedDisplayUpdatePacket decode(class_2540 buffer) {
        class_2338 pos = buffer.method_10811();
        AdvancedDisplaysRegistry.DisplayTypeResourceKey key = AdvancedDisplaysRegistry.DisplayTypeResourceKey.fromNbt(buffer.method_10798());
        boolean doubleSided = buffer.readBoolean();
        boolean isOnContraption = buffer.readBoolean();
        int entityId = buffer.readInt();
        IDisplaySettings settings = AdvancedDisplaysRegistry.createSettings(key);
        settings.deserializeNbt(buffer.method_10798());
        return new AdvancedDisplayUpdatePacket(pos, entityId, isOnContraption, key, doubleSided, settings);
    }

    private void apply(class_1937 level, AdvancedDisplayUpdatePacket packet) {
        class_2586 class_25862;
        if (level.method_8477(packet.pos) && (class_25862 = level.method_8321(packet.pos)) instanceof AdvancedDisplayBlockEntity) {
            AdvancedDisplayBlockEntity blockEntity = (AdvancedDisplayBlockEntity)class_25862;
            blockEntity.applyToAll(be -> {
                be.setDisplayType(level, packet.key, packet.settings);
                if (level.method_8320(be.method_11016()).method_26204() instanceof AbstractAdvancedSidedDisplayBlock) {
                    class_2680 state = level.method_8320(be.method_11016());
                    state = (class_2680)state.method_11657(AbstractAdvancedSidedDisplayBlock.SIDE, (Comparable)((Object)(packet.doubleSided ? ESide.BOTH : ESide.FRONT)));
                    level.method_8501(be.method_11016(), state);
                }
                be.notifyUpdate();
            }, new IBlockGetter.WorldBlockGetter(level));
        }
    }

    private void applyContraption(AbstractContraptionEntity contraptionEntity, AdvancedDisplayUpdatePacket packet) {
        Object object;
        Contraption contraption = contraptionEntity.getContraption();
        ContraptionWorld level = contraption.getContraptionWorld();
        HashSet<class_2338> blockEntityPositions = new HashSet<class_2338>();
        class_2338.class_2339 pos = packet.pos.method_25503();
        MutablePair rootActor = contraption.getActorAt((class_2338)pos);
        if (rootActor == null || rootActor.right == null) {
            return;
        }
        MovementContext rootCtx = (MovementContext)rootActor.getRight();
        class_2350 side = ((class_2350)rootCtx.state.method_11654((class_2769)class_2383.field_11177)).method_10160();
        int width = rootCtx.blockEntityData.method_10571("XSize");
        int height = rootCtx.blockEntityData.method_10571("YSize");
        packet.key.toNbt(rootCtx.blockEntityData);
        packet.key.toNbt(rootCtx.data);
        rootCtx.blockEntityData.method_10566("DisplaySettings", (class_2520)packet.settings.serializeNbt());
        rootCtx.data.method_10566("DisplaySettings", (class_2520)packet.settings.serializeNbt());
        blockEntityPositions.add(new class_2338(pos.method_10263(), pos.method_10264(), pos.method_10260()));
        class_3499.class_3501 rootInfo = (class_3499.class_3501)contraption.getBlocks().get(pos);
        if (rootInfo.comp_1342().method_26204() instanceof AbstractAdvancedSidedDisplayBlock) {
            class_2680 newState = (class_2680)rootInfo.comp_1342().method_11657(AbstractAdvancedSidedDisplayBlock.SIDE, (Comparable)((Object)(packet.doubleSided ? ESide.BOTH : ESide.FRONT)));
            contraption.getBlocks().put(pos, new class_3499.class_3501(rootInfo.comp_1341(), newState, rootInfo.comp_1343()));
            contraption.deferInvalidate = true;
        }
        if (contraption.presentBlockEntities.containsKey(pos) && (object = contraption.presentBlockEntities.get(pos)) instanceof AdvancedDisplayBlockEntity) {
            AdvancedDisplayBlockEntity be = (AdvancedDisplayBlockEntity)object;
            be.setDisplayType((class_1937)level, packet.key, packet.settings);
            be.method_31664(((class_3499.class_3501)contraption.getBlocks().get(pos)).comp_1342());
            if (level.method_8608()) {
                be.getRenderer().update((class_1937)level, (class_2338)pos, be.method_11010(), (class_2586)be, (Object)AdvancedDisplayBlockEntity.EUpdateReason.LAYOUT_CHANGED);
            }
        }
        for (int i = 0; i < width && i < 16; ++i) {
            class_2338 newPos = pos.method_10079(side, i);
            for (int j = 0; j < height && j < 16; ++j) {
                class_3499.class_3501 info;
                Object v;
                class_2338 newPos2 = newPos.method_10079(class_2350.field_11033, j);
                MutablePair actor = contraption.getActorAt(newPos2);
                if (actor == null || actor.right == null) continue;
                blockEntityPositions.add(new class_2338(newPos2.method_10263(), newPos2.method_10264(), newPos2.method_10260()));
                MovementContext ctx = (MovementContext)actor.getRight();
                packet.key.toNbt(ctx.blockEntityData);
                packet.key.toNbt(ctx.data);
                ctx.blockEntityData.method_10566("DisplaySettings", (class_2520)packet.settings.serializeNbt());
                ctx.data.method_10566("DisplaySettings", (class_2520)packet.settings.serializeNbt());
                if (contraption.presentBlockEntities.containsKey(newPos2) && (v = contraption.presentBlockEntities.get(newPos2)) instanceof AdvancedDisplayBlockEntity) {
                    AdvancedDisplayBlockEntity be = (AdvancedDisplayBlockEntity)v;
                    be.setDisplayType((class_1937)level, packet.key, packet.settings);
                }
                if (!((info = (class_3499.class_3501)contraption.getBlocks().get(newPos2)).comp_1342().method_26204() instanceof AbstractAdvancedSidedDisplayBlock)) continue;
                class_2680 newState = (class_2680)info.comp_1342().method_11657(AbstractAdvancedSidedDisplayBlock.SIDE, (Comparable)((Object)(packet.doubleSided ? ESide.BOTH : ESide.FRONT)));
                contraption.getBlocks().put(newPos2, new class_3499.class_3501(newPos2, newState, info.comp_1343()));
            }
        }
        IBlockGetter.ContraptionBlockGetter getter = new IBlockGetter.ContraptionBlockGetter(contraptionEntity);
        for (MutablePair a : contraption.getActors()) {
            class_2586 blockEntity = getter.getBlockEntity(((class_3499.class_3501)a.getLeft()).comp_1341());
            if (!(blockEntity instanceof AdvancedDisplayBlockEntity)) continue;
            AdvancedDisplayBlockEntity be = (AdvancedDisplayBlockEntity)blockEntity;
            be.updateControllerStatus2(getter);
        }
    }

    public void handle(AdvancedDisplayUpdatePacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            class_1657 player = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            if (player != null) {
                class_1937 level = player.method_37908();
                if (packet.isOnContraption) {
                    class_1297 patt0$temp = level.method_8469(packet.entityId);
                    if (patt0$temp instanceof AbstractContraptionEntity) {
                        AbstractContraptionEntity ce = (AbstractContraptionEntity)patt0$temp;
                        this.applyContraption(ce, packet);
                    }
                } else {
                    this.apply(level, packet);
                }
            }
        });
    }
}

