/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.registry;

import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.station.GlobalStation;
import de.mrjulsen.crn.CRNPlatformSpecific;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.data.NearestTrackStationResult;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.TagName;
import de.mrjulsen.crn.data.TrainCategory;
import de.mrjulsen.crn.data.TrainLine;
import de.mrjulsen.crn.data.UserSettings;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.navigation.ClientRoutePart;
import de.mrjulsen.crn.data.navigation.NavigatableGraph;
import de.mrjulsen.crn.data.navigation.Route;
import de.mrjulsen.crn.data.navigation.RoutePart;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.storage.GlobalSettingsClient;
import de.mrjulsen.crn.data.train.ClientTrainStop;
import de.mrjulsen.crn.data.train.DepartureHistory;
import de.mrjulsen.crn.data.train.ScheduleSection;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.crn.data.train.portable.NextConnectionsDisplayData;
import de.mrjulsen.crn.data.train.portable.TrainDisplayData;
import de.mrjulsen.crn.debug.TrainDebugData;
import de.mrjulsen.crn.network.packets.stc.ServerErrorPacket;
import de.mrjulsen.crn.registry.data.NextConnectionsRequestData;
import de.mrjulsen.crn.util.Lock;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessorType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public final class ModAccessorTypes {
    public static final DataAccessorType<String, StationTag, StationTag> GET_STATION_TAG = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "get_station_tag"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.method_10582("Data", in), nbt -> nbt.method_10558("Data"), (player, in, temp, nbt, iteration) -> {
        nbt.method_10566("Data", (class_2520)GlobalSettings.getInstance().getOrCreateStationTagFor((String)in).toNbt());
        return false;
    }, (hasMore, previousData, iteration, nbt) -> StationTag.fromNbt(nbt.method_10562("Data"), null)));
    public static final DataAccessorType<TagName, StationTag, StationTag> GET_STATION_TAG_BY_TAG_NAME = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "get_station_tag_by_tag_name"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.method_10582("Data", in.get()), nbt -> TagName.of(nbt.method_10558("Data")), (player, in, temp, nbt, iteration) -> {
        nbt.method_10566("Data", (class_2520)GlobalSettings.getInstance().getOrCreateStationTagFor((TagName)in).toNbt());
        return false;
    }, (hasMore, previousData, iteration, nbt) -> StationTag.fromNbt(nbt.method_10562("Data"), null)));
    public static final DataAccessorType<GlobalSettingsClient.CreateStationTagData, Optional<StationTag>, Optional<StationTag>> CREATE_STATION_TAG = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "create_station_tag"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> {
        nbt.method_10582("Name", in.name());
        if (in.owner() != null) {
            nbt.method_10566("Owner", (class_2520)in.owner().toNbt());
        }
    }, nbt -> new GlobalSettingsClient.CreateStationTagData(nbt.method_10558("Name"), nbt.method_10545("Owner") ? Owner.fromNbt(nbt.method_10562("Owner")) : null), (player, in, temp, nbt, iteration) -> {
        if (!GlobalSettings.modificationsAllowed(player)) {
            return false;
        }
        nbt.method_10566("Data", (class_2520)GlobalSettings.getInstance().createOrGetStationTag(TagName.of(in.name()), in.owner()).toNbt());
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.method_10545("Data") ? StationTag.fromNbt(nbt.method_10562("Data"), null) : null)));
    public static final DataAccessorType<StationTag, Void, Void> REGISTER_STATION_TAG = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "register_station_tag"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> nbt.method_10566("Data", (class_2520)in.toNbt()), nbt -> StationTag.fromNbt(nbt.method_10562("Data"), null), (player, in, temp, nbt, iteration) -> {
        if (!GlobalSettings.modificationsAllowed(player)) {
            return false;
        }
        in.updateLastEdited(player);
        GlobalSettings.getInstance().registerStationTag((StationTag)in);
        return false;
    }));
    public static final DataAccessorType<UUID, Void, Void> DELETE_STATION_TAG = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "delete_station_tag"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> nbt.method_25927("Data", in), nbt -> nbt.method_25926("Data"), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getStationTag((UUID)in).ifPresent(x -> {
            if (!x.getOwner().isAllowed(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            GlobalSettings.getInstance().removeStationTag((UUID)in);
        });
        return false;
    }));
    public static final DataAccessorType<GlobalSettingsClient.UpdateStationTagNameData, Void, Void> UPDATE_STATION_TAG_NAME = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "update_station_tag_name"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> {
        nbt.method_25927("Id", in.tagId());
        nbt.method_10582("Name", in.name());
    }, nbt -> new GlobalSettingsClient.UpdateStationTagNameData(nbt.method_25926("Id"), nbt.method_10558("Name")), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getStationTag(in.tagId()).ifPresent(x -> {
            if (!x.getOwner().isAllowed(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            x.updateLastEdited(player);
            x.setName(TagName.of(in.name()));
        });
        return false;
    }));
    public static final DataAccessorType<Lock.PermissionsUpdateData, Optional<StationTag>, Optional<StationTag>> UPDATE_STATION_TAG_PERMISSIONS = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "update_station_tag_permissions"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.method_10566("Data", (class_2520)in.toNbt()), nbt -> Lock.PermissionsUpdateData.fromNbt(nbt.method_10562("Data")), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getStationTag(in.id()).ifPresent(tag -> {
            if (!tag.getOwner().isAdmin(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            if (in.state() != null) {
                tag.getOwner().set(in.state());
            }
            if (in.trusted() != null) {
                tag.getOwner().updateTrusted(in.trusted());
            }
            if (in.newOwner() != null) {
                tag.getOwner().setOwner(in.newOwner());
                tag.getOwner().addTrusted(new Owner(player));
            }
            nbt.method_10566("Data", (class_2520)tag.toNbt());
        });
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.method_10545("Data") ? StationTag.fromNbt(nbt.method_10562("Data"), null) : null)));
    public static final DataAccessorType<GlobalSettingsClient.AddStationTagEntryData, Optional<StationTag>, Optional<StationTag>> ADD_STATION_TAG_ENTRY = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "add_station_tag_entry"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> {
        nbt.method_25927("Id", in.tagId());
        nbt.method_10582("Name", in.station());
        nbt.method_10566("Info", (class_2520)in.info().toNbt());
    }, nbt -> new GlobalSettingsClient.AddStationTagEntryData(nbt.method_25926("Id"), nbt.method_10558("Name"), StationTag.StationInfo.fromNbt(nbt.method_10562("Info"))), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getStationTag(in.tagId()).ifPresent(x -> {
            if (!x.getOwner().isAllowed(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            x.add(in.station(), in.info());
            x.updateLastEdited(player);
            nbt.method_10566("Data", (class_2520)x.toNbt());
        });
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.method_10545("Data") ? StationTag.fromNbt(nbt.method_10562("Data"), null) : null)));
    public static final DataAccessorType<GlobalSettingsClient.AddStationTagEntryData, Optional<StationTag>, Optional<StationTag>> UPDATE_STATION_TAG_ENTRY = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "update_station_tag_entry"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> {
        nbt.method_25927("Id", in.tagId());
        nbt.method_10582("Name", in.station());
        nbt.method_10566("Info", (class_2520)in.info().toNbt());
    }, nbt -> new GlobalSettingsClient.AddStationTagEntryData(nbt.method_25926("Id"), nbt.method_10558("Name"), StationTag.StationInfo.fromNbt(nbt.method_10562("Info"))), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getStationTag(in.tagId()).ifPresent(x -> {
            if (!x.getOwner().isAllowed(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            x.updateInfoForStation(in.station(), in.info());
            x.updateLastEdited(player);
            nbt.method_10566("Data", (class_2520)x.toNbt());
        });
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.method_10545("Data") ? StationTag.fromNbt(nbt.method_10562("Data"), null) : null)));
    public static final DataAccessorType<GlobalSettingsClient.RemoveStationTagEntryData, Optional<StationTag>, Optional<StationTag>> REMOVE_STATION_TAG_ENTRY = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "remove_station_tag_entry"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> {
        nbt.method_25927("Id", in.tagId());
        nbt.method_10582("Name", in.station());
    }, nbt -> new GlobalSettingsClient.RemoveStationTagEntryData(nbt.method_25926("Id"), nbt.method_10558("Name")), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getStationTag(in.tagId()).ifPresent(x -> {
            if (!x.getOwner().isAllowed(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            x.remove(in.station());
            x.updateLastEdited(player);
            nbt.method_10566("Data", (class_2520)x.toNbt());
        });
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.method_10545("Data") ? StationTag.fromNbt(nbt.method_10562("Data"), null) : null)));
    public static final DataAccessorType<Void, Collection<StationTag>, Collection<StationTag>> GET_ALL_STATION_TAGS = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "get_all_station_tags"), (DataAccessorType)DataAccessorType.Builder.createNoInputChunked((player, in, temp, nbt, iteration) -> {
        Queue tags;
        if (temp.getFirst() == null) {
            temp.setFirst(new ConcurrentLinkedQueue(GlobalSettings.getInstance().getAllStationTags().stream().sorted((a, b) -> a.getTagName().get().compareToIgnoreCase(b.getTagName().get())).toList()));
        }
        if ((tags = (Queue)temp.getFirst()).isEmpty()) {
            return false;
        }
        for (int i = 0; i < 64 && !tags.isEmpty(); ++i) {
            nbt.method_10566("Data" + i, (class_2520)((StationTag)tags.poll()).toNbt());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.method_10541().forEach(x -> l.add(StationTag.fromNbt(nbt.method_10562(x), null)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<Boolean, Collection<StationTag>, Collection<StationTag>> GET_ALL_STATIONS_AS_TAGS = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "get_all_stations_as_tags"), (DataAccessorType)DataAccessorType.Builder.createChunked((in, nbt) -> nbt.method_10556("Data", in.booleanValue()), nbt -> nbt.method_10577("Data"), (player, in, temp, nbt, iteration) -> {
        Queue tags;
        if (temp.getFirst() == null) {
            temp.setFirst(new ConcurrentLinkedQueue<StationTag>(TrainUtils.getAllStations().stream().filter(x -> in == false || !GlobalSettings.getInstance().isStationBlacklisted((GlobalStation)x)).map(x -> GlobalSettings.getInstance().getOrCreateStationTagFor((GlobalStation)x)).distinct().sorted((a, b) -> a.getTagName().get().compareToIgnoreCase(b.getTagName().get())).toList()));
        }
        if ((tags = (Queue)temp.getFirst()).isEmpty()) {
            return false;
        }
        for (int i = 0; i < 64 && !tags.isEmpty(); ++i) {
            nbt.method_10566("Data" + i, (class_2520)((StationTag)tags.poll()).toNbt());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.method_10541().forEach(x -> l.add(StationTag.fromNbt(nbt.method_10562(x), null)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<Void, List<TrainCategory>, List<TrainCategory>> GET_ALL_TRAIN_CATEGORIES = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "get_all_train_categories"), (DataAccessorType)DataAccessorType.Builder.createNoInputChunked((player, in, temp, nbt, iteration) -> {
        Queue tags;
        if (temp.getFirst() == null) {
            temp.setFirst(new ConcurrentLinkedQueue<TrainCategory>((Collection<TrainCategory>)GlobalSettings.getInstance().getAllTrainCategories()));
        }
        if ((tags = (Queue)temp.getFirst()).isEmpty()) {
            return false;
        }
        for (int i = 0; i < 64 && !tags.isEmpty(); ++i) {
            nbt.method_10566("Data" + i, (class_2520)((TrainCategory)tags.poll()).toNbt());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.method_10541().forEach(x -> l.add(TrainCategory.fromNbt(nbt.method_10562(x))));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<UUID, Void, Void> DELETE_TRAIN_CATEGORY = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "delete_train_category"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> nbt.method_25927("Data", in), nbt -> nbt.method_25926("Data"), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getTrainCategory((UUID)in).ifPresent(x -> {
            if (!x.getOwner().isAllowed(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            GlobalSettings.getInstance().removeTrainCategory((UUID)in);
        });
        return false;
    }));
    public static final DataAccessorType<UUID, Optional<TrainCategory>, Optional<TrainCategory>> GET_TRAIN_CATEGORY = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "get_train_category"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.method_25927("Data", in), nbt -> nbt.method_25926("Data"), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getTrainCategory((UUID)in).ifPresent(x -> nbt.method_10566("Data", (class_2520)x.toNbt()));
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.method_10545("Data") ? TrainCategory.fromNbt(nbt.method_10562("Data")) : null)));
    public static final DataAccessorType<GlobalSettingsClient.UpdateTrainCategoryColorData, Void, Void> UPDATE_TRAIN_CATEGORY_COLOR = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "update_train_category_color"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> {
        nbt.method_25927("Id", in.id());
        nbt.method_10569("Color", in.color());
    }, nbt -> new GlobalSettingsClient.UpdateTrainCategoryColorData(nbt.method_25926("Id"), nbt.method_10550("Color")), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getTrainCategory(in.id()).ifPresent(x -> {
            if (!x.getOwner().isAllowed(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            x.setColor(in.color());
        });
        return false;
    }));
    public static final DataAccessorType<GlobalSettingsClient.UpdateTrainCategoryNameData, Optional<TrainCategory>, Optional<TrainCategory>> UPDATE_TRAIN_CATEGORY_NAME = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "update_train_category_name"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> {
        nbt.method_25927("Id", in.id());
        nbt.method_10582("Name", in.name());
    }, nbt -> new GlobalSettingsClient.UpdateTrainCategoryNameData(nbt.method_25926("Id"), nbt.method_10558("Name")), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getTrainCategory(in.id()).ifPresent(x -> {
            if (!x.getOwner().isAllowed(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            x.setName(in.name());
            nbt.method_10566("Data", (class_2520)x.toNbt());
        });
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.method_10545("Data") ? TrainCategory.fromNbt(nbt.method_10562("Data")) : null)));
    public static final DataAccessorType<String, Optional<TrainCategory>, Optional<TrainCategory>> CREATE_TRAIN_CATEGORY = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "create_train_category"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.method_10582("Data", in), nbt -> nbt.method_10558("Data"), (player, in, temp, nbt, iteration) -> {
        if (!GlobalSettings.modificationsAllowed(player)) {
            return false;
        }
        TrainCategory category = GlobalSettings.getInstance().createOrGetTrainCategory((String)in, new Owner(player));
        nbt.method_10566("Data", (class_2520)category.toNbt());
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.method_10545("Data") ? TrainCategory.fromNbt(nbt.method_10562("Data")) : null)));
    public static final DataAccessorType<Lock.PermissionsUpdateData, Optional<TrainCategory>, Optional<TrainCategory>> UPDATE_TRAIN_CATEGORY_PERMISSIONS = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "update_train_category_permissions"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.method_10566("Data", (class_2520)in.toNbt()), nbt -> Lock.PermissionsUpdateData.fromNbt(nbt.method_10562("Data")), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getTrainCategory(in.id()).ifPresent(tag -> {
            if (!tag.getOwner().isAdmin(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            if (in.state() != null) {
                tag.getOwner().set(in.state());
            }
            if (in.trusted() != null) {
                tag.getOwner().updateTrusted(in.trusted());
            }
            if (in.newOwner() != null) {
                tag.getOwner().setOwner(in.newOwner());
                tag.getOwner().addTrusted(new Owner(player));
            }
            nbt.method_10566("Data", (class_2520)tag.toNbt());
        });
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.method_10545("Data") ? TrainCategory.fromNbt(nbt.method_10562("Data")) : null)));
    public static final DataAccessorType<String, Collection<String>, Collection<String>> ADD_STATION_TO_BLACKLIST = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "add_station_to_blacklist"), (DataAccessorType)DataAccessorType.Builder.createChunked((in, nbt) -> nbt.method_10582("Data", in), nbt -> nbt.method_10558("Data"), (player, in, temp, nbt, iteration) -> {
        if (!GlobalSettings.modificationsAllowed(player)) {
            return false;
        }
        if (temp.getFirst() == null) {
            GlobalSettings.getInstance().blacklistStation((String)in);
            temp.setFirst(new ConcurrentLinkedQueue<String>((Collection<String>)GlobalSettings.getInstance().getAllBlacklistedStations()));
        }
        Queue tags = (Queue)temp.getFirst();
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.method_10582("Data" + i, (String)tags.poll());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.method_10541().forEach(x -> l.add(nbt.method_10558(x)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<String, Collection<String>, Collection<String>> REMOVE_STATION_FROM_BLACKLIST = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "remove_station_from_blacklist"), (DataAccessorType)DataAccessorType.Builder.createChunked((in, nbt) -> nbt.method_10582("Data", in), nbt -> nbt.method_10558("Data"), (player, in, temp, nbt, iteration) -> {
        if (!GlobalSettings.modificationsAllowed(player)) {
            return false;
        }
        if (temp.getFirst() == null) {
            GlobalSettings.getInstance().removeStationFromBlacklist((String)in);
            temp.setFirst(new ConcurrentLinkedQueue<String>((Collection<String>)GlobalSettings.getInstance().getAllBlacklistedStations()));
        }
        Queue tags = (Queue)temp.getFirst();
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.method_10582("Data" + i, (String)tags.poll());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.method_10541().forEach(x -> l.add(nbt.method_10558(x)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<Void, List<String>, List<String>> GET_BLACKLISTED_STATIONS = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "get_blacklisted_stations"), (DataAccessorType)DataAccessorType.Builder.createNoInputChunked((player, in, temp, nbt, iteration) -> {
        if (temp.getFirst() == null) {
            temp.setFirst(new ConcurrentLinkedQueue<String>((Collection<String>)GlobalSettings.getInstance().getAllBlacklistedStations()));
        }
        Queue tags = (Queue)temp.getFirst();
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.method_10582("Data" + i, (String)tags.poll());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.method_10541().forEach(x -> l.add(nbt.method_10558(x)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<String, Collection<String>, Collection<String>> ADD_TRAIN_TO_BLACKLIST = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "add_train_to_blacklist"), (DataAccessorType)DataAccessorType.Builder.createChunked((in, nbt) -> nbt.method_10582("Data", in), nbt -> nbt.method_10558("Data"), (player, in, temp, nbt, iteration) -> {
        if (!GlobalSettings.modificationsAllowed(player)) {
            return false;
        }
        if (temp.getFirst() == null) {
            GlobalSettings.getInstance().blacklistTrain((String)in);
            temp.setFirst(new ConcurrentLinkedQueue<String>((Collection<String>)GlobalSettings.getInstance().getAllBlacklistedTrains()));
        }
        Queue tags = (Queue)temp.getFirst();
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.method_10582("Data" + i, (String)tags.poll());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.method_10541().forEach(x -> l.add(nbt.method_10558(x)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<String, Collection<String>, Collection<String>> REMOVE_TRAIN_FROM_BLACKLIST = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "remove_train_from_blacklist"), (DataAccessorType)DataAccessorType.Builder.createChunked((in, nbt) -> nbt.method_10582("Data", in), nbt -> nbt.method_10558("Data"), (player, in, temp, nbt, iteration) -> {
        if (!GlobalSettings.modificationsAllowed(player)) {
            return false;
        }
        if (temp.getFirst() == null) {
            GlobalSettings.getInstance().removeTrainFromBlacklist((String)in);
            temp.setFirst(new ConcurrentLinkedQueue<String>((Collection<String>)GlobalSettings.getInstance().getAllBlacklistedTrains()));
        }
        Queue tags = (Queue)temp.getFirst();
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.method_10582("Data" + i, (String)tags.poll());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.method_10541().forEach(x -> l.add(nbt.method_10558(x)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<Void, List<String>, List<String>> GET_BLACKLISTED_TRAINS = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "get_blacklisted_trains"), (DataAccessorType)DataAccessorType.Builder.createNoInputChunked((player, in, temp, nbt, iteration) -> {
        if (temp.getFirst() == null) {
            temp.setFirst(new ConcurrentLinkedQueue<String>((Collection<String>)GlobalSettings.getInstance().getAllBlacklistedTrains()));
        }
        Queue tags = (Queue)temp.getFirst();
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.method_10582("Data" + i, (String)tags.poll());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.method_10541().forEach(x -> l.add(nbt.method_10558(x)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<UUID, ClientRoutePart.TrainRealTimeData, ClientRoutePart.TrainRealTimeData> UPDATE_REALTIME = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "update_realtime"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.method_25927("Data", in), nbt -> nbt.method_25926("Data"), (player, in, temp, nbt, iteration) -> {
        TrainListener.getTrainData(in).ifPresent(data -> {
            List<TrainPrediction> predictions = data.getPredictions();
            HashMap<Integer, ClientTrainStop.TrainStopRealTimeData> values = new HashMap<Integer, ClientTrainStop.TrainStopRealTimeData>();
            for (TrainPrediction prediction : predictions) {
                ClientTrainStop.TrainStopRealTimeData realTimeData = new ClientTrainStop.TrainStopRealTimeData(prediction.getStationTag().getClientTag(prediction.getTargetedStationName()), prediction.getEntryIndex(), prediction.scheduled().arrivalTime(), prediction.scheduled().departureTime(), prediction.realTime().arrivalTime(), prediction.realTime().departureTime(), (int)prediction.realTime().arrivalIn(), prediction.getCurrentCycle());
                values.put(realTimeData.entryIndex(), realTimeData);
            }
            nbt.method_10566("Data", (class_2520)ClientRoutePart.TrainRealTimeData.createServer(data.getSessionId(), values, data.getStatus(), data.isCancelled()).toNbt());
        });
        return false;
    }, (hasMore, previousData, iteration, nbt) -> nbt.method_10545("Data") ? ClientRoutePart.TrainRealTimeData.fromNbt(nbt.method_10562("Data")) : null));
    public static final DataAccessorType<UUID, UserSettings, UserSettings> GET_USER_SETTINGS = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "get_user_settings"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.method_25927("Data", in), nbt -> nbt.method_25926("Data"), (player, in, temp, nbt, iteration) -> {
        nbt.method_10566("Data", (class_2520)UserSettings.getSettingsFor(in, false).toNbt());
        nbt.method_25927("Id", in);
        return false;
    }, (hasMore, list, iteration, nbt) -> UserSettings.fromNbt(nbt.method_10562("Data"), nbt.method_25926("Id"), false)));
    public static final DataAccessorType<UserSettings, Void, Void> SAVE_USER_SETTINGS = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "save_user_settings"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> {
        nbt.method_10566("Data", (class_2520)in.toNbt());
        nbt.method_25927("Id", in.getOwnerId());
    }, nbt -> UserSettings.fromNbt(nbt.method_10562("Data"), nbt.method_25926("Id"), false), (player, in, temp, nbt, iteration) -> {
        in.save();
        return false;
    }));
    public static final DataAccessorType<class_2338, NearestTrackStationResult, NearestTrackStationResult> GET_NEAREST_STATION = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "get_nearest_station"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> {
        nbt.method_10569("x", in.method_10263());
        nbt.method_10569("y", in.method_10264());
        nbt.method_10569("z", in.method_10260());
    }, nbt -> new class_2338(nbt.method_10550("x"), nbt.method_10550("y"), nbt.method_10550("z")), (player, in, temp, nbt, iteration) -> {
        NearestTrackStationResult result = NearestTrackStationResult.empty();
        try {
            result = TrainUtils.getNearestTrackStation(player.method_37908(), (class_2382)in);
        }
        catch (Exception e) {
            CreateRailwaysNavigator.LOGGER.error("Error while trying to find nearest track station.", (Throwable)e);
            CreateRailwaysNavigator.net().CHANNEL.sendToPlayer((class_3222)player, (Object)new ServerErrorPacket(e.getMessage()));
        }
        nbt.method_10566("Data", (class_2520)result.toNbt());
        return false;
    }, (hasMore, list, iteration, nbt) -> NearestTrackStationResult.fromNbt(nbt.method_10562("Data"))));
    public static final DataAccessorType<UUID, TrainDisplayData, TrainDisplayData> GET_TRAIN_DISPLAY_DATA_FROM_SERVER = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "get_train_display_data"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.method_25927("Data", in), nbt -> nbt.method_25926("Data"), (player, in, temp, nbt, iteration) -> {
        Optional<Train> trainOpt = TrainUtils.getTrain(in);
        if (!trainOpt.isPresent() || !TrainUtils.isTrainUsable(trainOpt.get()) || GlobalSettings.getInstance().isTrainBlacklisted(trainOpt.get())) {
            nbt.method_10566("Data", (class_2520)TrainDisplayData.empty().toNbt());
            return false;
        }
        nbt.method_10566("Data", (class_2520)TrainDisplayData.of(trainOpt.get()).toNbt());
        return false;
    }, (hasMore, list, iteration, nbt) -> TrainDisplayData.fromNbt(nbt.method_10562("Data"))));
    public static final DataAccessorType<NextConnectionsRequestData, NextConnectionsDisplayData, NextConnectionsDisplayData> GET_NEXT_CONNECTIONS_DISPLAY_DATA = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "get_next_connections_display_data"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.method_10566("Data", (class_2520)in.toNbt()), nbt -> NextConnectionsRequestData.fromNbt(nbt.method_10562("Data")), (player, in, temp, nbt, iteration) -> {
        nbt.method_10566("Data", (class_2520)NextConnectionsDisplayData.at(in.stationName(), in.selfTrainId()).toNbt());
        return false;
    }, (hasMore, list, iteration, nbt) -> NextConnectionsDisplayData.fromNbt(nbt.method_10562("Data"))));
    public static final DataAccessorType<Void, Collection<String>, Collection<String>> GET_ALL_TRAIN_NAMES = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "get_all_train_names"), (DataAccessorType)DataAccessorType.Builder.createNoInputChunked((player, in, temp, nbt, iteration) -> {
        if (temp.getFirst() == null) {
            temp.setFirst(new ConcurrentLinkedQueue<String>(TrainUtils.getTrains(false).stream().map(x -> x.name.getString()).toList()));
        }
        Queue tags = (Queue)temp.getFirst();
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.method_10582("Data" + i, (String)tags.poll());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.method_10541().forEach(x -> l.add(nbt.method_10558(x)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<Void, Collection<String>, Collection<String>> GET_ALL_STATION_NAMES = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "get_all_station_names"), (DataAccessorType)DataAccessorType.Builder.createNoInputChunked((player, in, temp, nbt, iteration) -> {
        if (temp.getFirst() == null) {
            temp.setFirst(new ConcurrentLinkedQueue<String>(TrainUtils.getAllStations().stream().map(x -> x.name).toList()));
        }
        Queue tags = (Queue)temp.getFirst();
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.method_10582("Data" + i, (String)tags.poll());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.method_10541().forEach(x -> l.add(nbt.method_10558(x)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<Void, List<TrainLine>, List<TrainLine>> GET_ALL_TRAIN_LINES = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "get_all_train_lines"), (DataAccessorType)DataAccessorType.Builder.createNoInputChunked((player, in, temp, nbt, iteration) -> {
        Queue tags;
        if (temp.getFirst() == null) {
            temp.setFirst(new ConcurrentLinkedQueue<TrainLine>((Collection<TrainLine>)GlobalSettings.getInstance().getAllTrainLines()));
        }
        if ((tags = (Queue)temp.getFirst()).isEmpty()) {
            return false;
        }
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.method_10566("Data" + i, (class_2520)((TrainLine)tags.poll()).toNbt());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.method_10541().forEach(x -> l.add(TrainLine.fromNbt(nbt.method_10562(x))));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<UUID, Void, Void> DELETE_TRAIN_LINE = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "delete_train_line"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> nbt.method_25927("Data", in), nbt -> nbt.method_25926("Data"), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getTrainLine((UUID)in).ifPresent(x -> {
            if (!x.getOwner().isAllowed(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            GlobalSettings.getInstance().removeTrainLine((UUID)in);
        });
        return false;
    }));
    public static final DataAccessorType<UUID, Optional<TrainLine>, Optional<TrainLine>> GET_TRAIN_LINE = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "get_train_line"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.method_25927("Data", in), nbt -> nbt.method_25926("Data"), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getTrainLine((UUID)in).ifPresent(x -> nbt.method_10566("Data", (class_2520)x.toNbt()));
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.method_10545("Data") ? TrainLine.fromNbt(nbt.method_10562("Data")) : null)));
    public static final DataAccessorType<GlobalSettingsClient.UpdateTrainLineColorData, Void, Void> UPDATE_TRAIN_LINE_COLOR = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "update_train_line_color"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> {
        nbt.method_25927("Id", in.id());
        nbt.method_10569("Color", in.color());
    }, nbt -> new GlobalSettingsClient.UpdateTrainLineColorData(nbt.method_25926("Id"), nbt.method_10550("Color")), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getTrainLine(in.id()).ifPresent(x -> {
            if (!x.getOwner().isAllowed(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            x.setColor(in.color());
        });
        return false;
    }));
    public static final DataAccessorType<GlobalSettingsClient.UpdateTrainLineNameData, Optional<TrainLine>, Optional<TrainLine>> UPDATE_TRAIN_LINE_NAME = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "update_train_line_name"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> {
        nbt.method_25927("Id", in.id());
        nbt.method_10582("Name", in.name());
    }, nbt -> new GlobalSettingsClient.UpdateTrainLineNameData(nbt.method_25926("Id"), nbt.method_10558("Name")), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getTrainLine(in.id()).ifPresent(x -> {
            if (!x.getOwner().isAllowed(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            x.setName(in.name());
            nbt.method_10566("Data", (class_2520)x.toNbt());
        });
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.method_10545("Data") ? TrainLine.fromNbt(nbt.method_10562("Data")) : null)));
    public static final DataAccessorType<String, Optional<TrainLine>, Optional<TrainLine>> CREATE_TRAIN_LINE = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "create_train_line"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.method_10582("Data", in), nbt -> nbt.method_10558("Data"), (player, in, temp, nbt, iteration) -> {
        if (!GlobalSettings.modificationsAllowed(player)) {
            return false;
        }
        TrainLine line = GlobalSettings.getInstance().createOrGetTrainLine((String)in, new Owner(player));
        nbt.method_10566("Data", (class_2520)line.toNbt());
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.method_10545("Data") ? TrainLine.fromNbt(nbt.method_10562("Data")) : null)));
    public static final DataAccessorType<Lock.PermissionsUpdateData, Optional<TrainLine>, Optional<TrainLine>> UPDATE_TRAIN_LINE_PERMISSIONS = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "update_train_line_permissions"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.method_10566("Data", (class_2520)in.toNbt()), nbt -> Lock.PermissionsUpdateData.fromNbt(nbt.method_10562("Data")), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getTrainLine(in.id()).ifPresent(tag -> {
            if (!tag.getOwner().isAdmin(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            if (in.state() != null) {
                tag.getOwner().set(in.state());
            }
            if (in.trusted() != null) {
                tag.getOwner().updateTrusted(in.trusted());
            }
            if (in.newOwner() != null) {
                tag.getOwner().setOwner(in.newOwner());
                tag.getOwner().addTrusted(new Owner(player));
            }
            nbt.method_10566("Data", (class_2520)tag.toNbt());
        });
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.method_10545("Data") ? TrainLine.fromNbt(nbt.method_10562("Data")) : null)));
    public static final DataAccessorType<NavigationData, List<ClientRoute>, List<ClientRoute>> NAVIGATE = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "navigate"), (DataAccessorType)DataAccessorType.Builder.createChunked((in, nbt) -> {
        nbt.method_10582("Start", in.start());
        nbt.method_10582("End", in.end());
        nbt.method_25927("Player", in.player());
    }, nbt -> new NavigationData(nbt.method_10558("Start"), nbt.method_10558("End"), nbt.method_25926("Player")), (player, in, temp, nbt, iteration) -> {
        try {
            Queue tags;
            if (temp.getFirst() == null) {
                GlobalSettings settings = GlobalSettings.getInstance();
                List<Route> routes = NavigatableGraph.searchRoutes(settings.getTagByName(TagName.of(in.start())).orElse(settings.getOrCreateStationTagFor(in.start())), settings.getTagByName(TagName.of(in.end())).orElse(settings.getOrCreateStationTagFor(in.end())), in.player(), true);
                temp.setFirst(new ConcurrentLinkedQueue<Route>(routes));
            }
            if ((tags = (Queue)temp.getFirst()).isEmpty()) {
                return false;
            }
            Route r = (Route)tags.poll();
            nbt.method_10566("Data", (class_2520)r.toNbt());
            return !tags.isEmpty();
        }
        catch (Exception e) {
            CreateRailwaysNavigator.LOGGER.error("Navigation error.", (Throwable)e);
            return false;
        }
    }, (hasMore, list, iteration, nbt) -> {
        if (!nbt.method_10545("Data")) {
            return List.of();
        }
        if (list == null) {
            list = new ArrayList<ClientRoute>();
        }
        list.add(ClientRoute.fromNbt(nbt.method_10562("Data"), true));
        return list;
    }, chunks -> chunks));
    public static final DataAccessorType<DepartureRoutesData, List<Pair<Boolean, ClientRoute>>, List<Pair<Boolean, ClientRoute>>> GET_DEPARTURE_AND_ARRIVAL_ROUTES_AT = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "get_departure_and_arrival_routes_at"), (DataAccessorType)DataAccessorType.Builder.createChunked((in, nbt) -> {
        nbt.method_10582("Station", in.stationTagName());
        nbt.method_25927("Player", in.player());
    }, nbt -> new DepartureRoutesData(nbt.method_10558("Station"), nbt.method_25926("Player")), (player, in, temp, nbt, iteration) -> {
        try {
            Queue tags;
            if (temp.getFirst() == null) {
                UserSettings settings = UserSettings.getSettingsFor(in.player(), true);
                StationTag station = GlobalSettings.getInstance().getOrCreateStationTagFor(TagName.of(in.stationTagName()));
                Set<Train> trains = TrainUtils.getDepartingTrainsAt(station);
                trains.removeIf(x -> !TrainUtils.isTrainUsable(x) || GlobalSettings.getInstance().isTrainBlacklisted((Train)x) || !TrainListener.hasTrainData(x));
                LinkedList<Pair> routesL = new LinkedList<Pair>();
                for (Train train : trains) {
                    TrainData data = TrainListener.getTrainData(train.id).get();
                    List<TrainPrediction> matchingPredictions = data.getPredictionsChronologically();
                    for (int i = 0; i < matchingPredictions.size(); ++i) {
                        ScheduleSection section;
                        TrainPrediction prediction = matchingPredictions.get(i);
                        if (!prediction.getStationTag().equals(station) || !(section = prediction.getSection()).isUsable() && (!section.isFirstStop(prediction) || !section.previousSection().isUsable() || !section.previousSection().shouldIncludeNextStationOfNextSection()) || section.getTrainCategory().map(x -> settings.searchExcludedTrainCaegories.getValue().contains(x.getId())).orElse(false).booleanValue()) continue;
                        ScheduleSection previousSection = section.previousSection();
                        boolean isStart = section.isFirstStop(prediction);
                        boolean isLast = section.isFinalStop(prediction);
                        boolean isStartAndFinal = isStart && previousSection.isUsable() && previousSection.shouldIncludeNextStationOfNextSection() && previousSection.getTrainCategory().map(x -> !settings.searchExcludedTrainCaegories.getValue().contains(x.getId())).orElse(true) != false;
                        TrainStop stop = new TrainStop(prediction);
                        stop.simulateTicks(settings.searchDepartureInTicks.getValue().intValue());
                        TrainPrediction fromPrediction = section.getFirstStop().get();
                        TrainStop from = new TrainStop(fromPrediction);
                        Route route = new Route(List.of(new RoutePart(data.getSessionId(), train.id, List.of(stop, from), section.getAllStops(settings.searchDepartureInTicks.getValue().intValue(), prediction.getEntryIndex()))), false);
                        if ((!isStart || isStartAndFinal) && section.getTrainCategory().map(x -> !settings.searchExcludedTrainCaegories.getValue().contains(x.getId())).orElse(true).booleanValue()) {
                            Route selectedRoute = route;
                            if (isStartAndFinal) {
                                TrainPrediction frPred = previousSection.getFirstStop().get();
                                TrainStop fr = new TrainStop(frPred);
                                selectedRoute = new Route(List.of(new RoutePart(data.getSessionId(), train.id, List.of(stop, fr), previousSection.getAllStops(settings.searchDepartureInTicks.getValue().intValue(), prediction.getEntryIndex()))), false);
                            }
                            routesL.add(Pair.of((Object)true, (Object)selectedRoute));
                        }
                        if (!section.isUsable() || isLast && !section.shouldIncludeNextStationOfNextSection() || !section.getTrainCategory().map(x -> !settings.searchExcludedTrainCaegories.getValue().contains(x.getId())).orElse(true).booleanValue()) continue;
                        routesL.add(Pair.of((Object)false, (Object)route));
                    }
                }
                Collections.sort(routesL, (a, b) -> {
                    long val1 = (Boolean)a.getFirst() != false ? ((Route)a.getSecond()).getStart().getScheduledArrivalTime() : ((Route)a.getSecond()).getStart().getScheduledDepartureTime();
                    long val2 = (Boolean)b.getFirst() != false ? ((Route)b.getSecond()).getStart().getScheduledArrivalTime() : ((Route)b.getSecond()).getStart().getScheduledDepartureTime();
                    return Long.compare(val1, val2);
                });
                temp.setFirst(new ConcurrentLinkedQueue(routesL));
            }
            if ((tags = (Queue)temp.getFirst()).isEmpty()) {
                return false;
            }
            Pair r = (Pair)tags.poll();
            nbt.method_10556("IsArrival", ((Boolean)r.getFirst()).booleanValue());
            nbt.method_10566("Data", (class_2520)((Route)r.getSecond()).toNbt());
            return !tags.isEmpty();
        }
        catch (Exception e) {
            CreateRailwaysNavigator.LOGGER.error("Schedule board generation error.", (Throwable)e);
            return false;
        }
    }, (hasMore, list, iteration, nbt) -> {
        if (!nbt.method_10545("Data")) {
            return List.of();
        }
        if (list == null) {
            list = new ArrayList<Pair>();
        }
        list.add(Pair.of((Object)nbt.method_10577("IsArrival"), (Object)ClientRoute.fromNbt(nbt.method_10562("Data"), false)));
        return list;
    }, chunks -> chunks));
    public static final DataAccessorType<DeparturesData, List<ClientTrainStop>, List<ClientTrainStop>> GET_DEPARTURES_AT = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "get_departures_at"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> {
        nbt.method_25927("Tag", in.stationTagId());
        nbt.method_25927("Train", in.trainId());
        nbt.method_10556("RealTimeOnly", in.realTimeOnly());
    }, nbt -> new DeparturesData(nbt.method_25926("Tag"), nbt.method_25926("Train"), nbt.method_10577("RealTimeOnly")), (player, in, temp, nbt, iteration) -> {
        try {
            if (!GlobalSettings.getInstance().stationTagExists(in.stationTagId())) {
                return false;
            }
            StationTag tag = GlobalSettings.getInstance().getStationTag(in.stationTagId()).get();
            class_2499 list = new class_2499();
            for (TrainStop stop : TrainUtils.getDeparturesAt(tag, in.trainId(), in.realTimeOnly())) {
                list.add((Object)stop.toNbt(true));
            }
            nbt.method_10566("Data", (class_2520)list);
        }
        catch (Exception e) {
            CreateRailwaysNavigator.LOGGER.error("Next connections error.", (Throwable)e);
        }
        return false;
    }, (hasMore, data, iteration, nbt) -> nbt.method_10545("Data") ? nbt.method_10554("Data", 10).stream().map(x -> (ClientTrainStop)ClientTrainStop.fromNbt((class_2487)x)).toList() : List.of()));
    public static final DataAccessorType<Void, Boolean, Boolean> ALL_TRAINS_INITIALIZED = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "all_trains_initialized"), (DataAccessorType)DataAccessorType.Builder.createNoInput((player, in, temp, nbt, iteration) -> {
        nbt.method_10556("Data", TrainListener.allTrainsInitialized());
        return false;
    }, (hasMore, data, iteration, nbt) -> nbt.method_10577("Data")));
    public static final DataAccessorType<Void, List<TrainDebugData>, List<TrainDebugData>> GET_ALL_TRAINS_DEBUG_DATA = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "get_all_trains_debug_data"), (DataAccessorType)DataAccessorType.Builder.createNoInput((player, in, temp, nbt, iteration) -> {
        class_2499 list = new class_2499();
        for (TrainData x : TrainListener.getAllTrainData()) {
            list.add((Object)TrainDebugData.fromTrain(x).toNbt());
        }
        nbt.method_10566("Data", (class_2520)list);
        return false;
    }, (hasMore, data, iteration, nbt) -> nbt.method_10554("Data", 10).stream().map(x -> TrainDebugData.fromNbt((class_2487)x)).toList()));
    public static final DataAccessorType<Void, Void, Void> SHOW_TRAIN_DEBUG_SCREEN = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "show_train_debug_screen"), (DataAccessorType)DataAccessorType.Builder.createNoIO((player, in, temp, nbt, iteration) -> {
        ClientWrapper.showTrainDebugScreen();
        return false;
    }));
    public static final DataAccessorType<UUID, Void, Void> TRAIN_SOFT_RESET = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "train_soft_reset"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> nbt.method_25927("Data", in), nbt -> nbt.method_25926("Data"), (player, in, temp, nbt, iteration) -> {
        TrainListener.getTrainData(in).ifPresent(TrainData::softResetPredictions);
        return false;
    }));
    public static final DataAccessorType<UUID, Void, Void> TRAIN_HARD_RESET = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "train_hard_reset"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> nbt.method_25927("Data", in), nbt -> nbt.method_25926("Data"), (player, in, temp, nbt, iteration) -> {
        TrainListener.getTrainData(in).ifPresent(TrainData::hardResetPredictions);
        return false;
    }));
    public static final DataAccessorType<String, DepartureHistory.Stats, DepartureHistory.Stats> GET_STATION_DEPARTURE_HISTORY = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "get_station_departure_history"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.method_10582("Data", in), nbt -> nbt.method_10558("Data"), (player, in, temp, nbt, iteration) -> {
        nbt.method_10566("Data", (class_2520)DepartureHistory.Stats.ofStation(in).toNbt());
        return false;
    }, (hasMore, data, iteration, nbt) -> DepartureHistory.Stats.fromNbt(nbt.method_10562("Data"))));
    public static final DataAccessorType<Void, List<Owner>, List<Owner>> GET_ONLINE_PLAYERS = DataAccessorType.register((class_2960)new class_2960("createrailwaysnavigator", "get_online_players"), (DataAccessorType)DataAccessorType.Builder.createNoInput((player, in, temp, nbt, iteration) -> {
        class_2499 list = new class_2499();
        list.addAll(CRNPlatformSpecific.getAllKnownPlayers().entrySet().stream().map(e -> new Owner((UUID)e.getKey()).toNbt()).toList());
        nbt.method_10566("Data", (class_2520)list);
        return false;
    }, (hasMore, data, iteration, nbt) -> nbt.method_10554("Data", 10).stream().map(x -> Owner.fromNbt((class_2487)x)).sorted((a, b) -> a.name().compareToIgnoreCase(b.name())).toList()));

    public static void init() {
    }

    public record DeparturesData(UUID stationTagId, UUID trainId, boolean realTimeOnly) {
    }

    public record DepartureRoutesData(String stationTagName, UUID player) {
    }

    public record NavigationData(String start, String end, UUID player) {
    }
}

