/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.util;

import com.google.common.collect.ImmutableSet;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.exceptions.RuntimeSideException;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.core.IIterableEnum;
import de.mrjulsen.mcdragonlib.core.ITranslatableEnum;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import dev.architectury.platform.Platform;
import dev.architectury.utils.GameInstance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class Lock {
    private static final String NBT_STATE = "State";
    private static final String NBT_TRUSTED = "Trusted";
    public static final String TRANSLATION_KEY_TRUSTED_PLAYERS = "gui.createrailwaysnavigator.lock.trusted_players";
    public static final String TRANSLATION_KEY_TRANSFER_OWNERSHIP = "gui.createrailwaysnavigator.lock.transfer_ownership";
    private final class_5250 charAllowed = TextUtils.text((String)"\u2714").method_27692(class_124.field_1060);
    private final class_5250 charTrusted = TextUtils.text((String)"\u2714").method_27692(class_124.field_1065);
    private final class_5250 charLocked = TextUtils.text((String)"\u274c").method_27692(class_124.field_1061);
    private final class_5250 txtPermissions = TextUtils.translate((String)"gui.createrailwaysnavigator.lock.permissions");
    private final class_5250 txtRightClickOptions = TextUtils.translate((String)"gui.createrailwaysnavigator.lock.right_click_options").method_27692(class_124.field_1063).method_27692(class_124.field_1056);
    private final class_5250 txtNoOwner = TextUtils.translate((String)"gui.createrailwaysnavigator.lock.no_owner");
    private final String keyStatus = "gui.createrailwaysnavigator.lock.state";
    private final String keyOwner = "gui.createrailwaysnavigator.lock.owner";
    private Owner owner;
    private LockState state = LockState.UNLOCKED;
    private final Set<Owner> trusted = new HashSet<Owner>();

    private Lock(LockState status, Owner owner, Set<Owner> trusted) {
        this.state = status;
        this.owner = owner;
        this.trusted.addAll(trusted);
    }

    public Lock(Owner owner) {
        this(LockState.UNLOCKED, owner, new HashSet<Owner>());
    }

    public Lock() {
        this(LockState.UNLOCKED, null, new HashSet<Owner>());
    }

    public void set(LockState state) {
        this.state = state;
    }

    public LockState get() {
        return this.state;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAllowed(Owner target) throws RuntimeSideException {
        if (!DragonLib.hasServer()) {
            throw new RuntimeSideException(false);
        }
        if (this.owner == null) return true;
        if (this.isAdmin(target)) return true;
        if (this.owner.equals(target)) return true;
        switch (this.state.ordinal()) {
            case 1: {
                if (!this.isTrusted(target)) return false;
            }
            default: {
                return true;
            }
        }
    }

    public boolean isAdmin(Owner target) throws RuntimeSideException {
        if (!DragonLib.hasServer()) {
            throw new RuntimeSideException(false);
        }
        return this.owner != null && (this.owner.equals(target) || (Integer)ModCommonConfig.GLOBAL_SETTINGS_ADMIN_PERMISSION_LEVEL.get() >= 0 && GameInstance.getServer().method_3760().method_14602(target.uuid()).method_5687(((Integer)ModCommonConfig.GLOBAL_SETTINGS_ADMIN_PERMISSION_LEVEL.get()).intValue()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAllowed() throws RuntimeSideException {
        if (Platform.getEnv() != EnvType.CLIENT) {
            throw new RuntimeSideException(true);
        }
        Owner self = ClientWrapper.getMe();
        if (this.owner == null) return true;
        if (this.isAdmin()) return true;
        if (this.owner.equals(self)) return true;
        switch (this.state.ordinal()) {
            case 1: {
                if (!this.isTrusted(self)) return false;
            }
            default: {
                return true;
            }
        }
    }

    public boolean isAdmin() throws RuntimeSideException {
        if (Platform.getEnv() != EnvType.CLIENT) {
            throw new RuntimeSideException(true);
        }
        Owner self = ClientWrapper.getMe();
        return this.owner != null && (this.owner.equals(self) || (Integer)ModCommonConfig.GLOBAL_SETTINGS_ADMIN_PERMISSION_LEVEL.get() >= 0 && ClientWrapper.getClientPlayer().method_5687(((Integer)ModCommonConfig.GLOBAL_SETTINGS_ADMIN_PERMISSION_LEVEL.get()).intValue()));
    }

    public Set<Owner> getTrusted() {
        return ImmutableSet.copyOf(this.trusted);
    }

    public void addTrusted(Owner target) {
        this.trusted.add(target);
    }

    public void updateTrusted(Set<Owner> targets) {
        this.trusted.clear();
        this.trusted.addAll(targets);
    }

    public boolean isTrusted(Owner target) {
        return this.trusted.contains(target);
    }

    public void removeTrusted(Owner target) {
        this.trusted.remove(target);
    }

    public Optional<Owner> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    public void setOwner(Owner newOwner) {
        this.owner = newOwner;
    }

    public List<class_5348> asText(Owner target) {
        ArrayList<class_5348> texts = new ArrayList<class_5348>(4);
        texts.add((class_5348)TextUtils.empty().method_10852((class_2561)this.txtPermissions).method_27693(" ").method_10852((class_2561)(this.isTrusted(target) ? this.charTrusted : (this.isAllowed() ? this.charAllowed : this.charLocked))));
        texts.add((class_5348)TextUtils.translate((String)"gui.createrailwaysnavigator.lock.state", (Object[])new Object[]{this.get().getFormattedText()}).method_27692(class_124.field_1080));
        texts.add((class_5348)TextUtils.translate((String)"gui.createrailwaysnavigator.lock.owner", (Object[])new Object[]{this.getOwner().map(x -> x.name().isBlank() ? this.txtNoOwner : TextUtils.text((String)x.name()).method_27692(class_124.field_1060)).orElse(this.txtNoOwner)}).method_27692(class_124.field_1080));
        if (this.isAdmin()) {
            texts.add((class_5348)this.txtRightClickOptions);
        }
        return texts;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10567(NBT_STATE, this.state.getIndex());
        if (this.owner != null) {
            this.owner.toNbt(nbt);
        }
        class_2499 list = new class_2499();
        for (Owner t : this.trusted) {
            list.add((Object)t.toNbt());
        }
        nbt.method_10566(NBT_TRUSTED, (class_2520)list);
        return nbt;
    }

    public static Lock fromNbt(class_2487 nbt) {
        return new Lock(LockState.getByIndex(nbt.method_10571(NBT_STATE)), Owner.fromNbt(nbt), nbt.method_10554(NBT_TRUSTED, 10).stream().map(x -> Owner.fromNbt((class_2487)x)).collect(Collectors.toSet()));
    }

    public static enum LockState implements ITranslatableEnum,
    IIterableEnum<LockState>
    {
        UNLOCKED("unlocked", 0, ModGuiIcons.UNLOCKED, key -> TextUtils.translate((String)key).method_27692(class_124.field_1060)),
        LOCKED("locked", 127, ModGuiIcons.LOCKED, key -> TextUtils.translate((String)key).method_27692(class_124.field_1061));

        private final String name;
        private final byte index;
        private final ModGuiIcons icon;
        private final Function<String, class_2561> text;

        private LockState(String name, byte index, ModGuiIcons icon, Function<String, class_2561> text) {
            this.name = name;
            this.index = index;
            this.icon = icon;
            this.text = text;
        }

        public byte getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public class_2561 getFormattedText() {
            return this.text.apply(this.getValueTranslationKey("createrailwaysnavigator"));
        }

        public Sprite getIcon() {
            return this.icon.getAsSprite(16, 16);
        }

        public static LockState getByIndex(int i) {
            return Arrays.stream(LockState.values()).filter(x -> x.getIndex() == i).findFirst().orElse(UNLOCKED);
        }

        public String getEnumName() {
            return "lock_state";
        }

        public String getEnumValueName() {
            return this.getName();
        }

        public LockState[] getValues() {
            return LockState.values();
        }
    }

    public record PermissionsUpdateData(UUID id, Owner newOwner, LockState state, Set<Owner> trusted) {
        private static final String NBT_ID = "Id";
        private static final String NBT_STATE = "State";
        private static final String NBT_NEW_OWNER = "NewOwner";
        private static final String NBT_TRUSTED = "Trusted";

        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_25927(NBT_ID, this.id);
            if (this.state != null) {
                nbt.method_10567("State", this.state.getIndex());
            }
            if (this.trusted != null) {
                class_2499 list = new class_2499();
                for (Owner t : this.trusted) {
                    list.add((Object)t.toNbt());
                }
                nbt.method_10566("Trusted", (class_2520)list);
            }
            if (this.newOwner != null) {
                nbt.method_10566(NBT_NEW_OWNER, (class_2520)this.newOwner.toNbt());
            }
            return nbt;
        }

        public static PermissionsUpdateData fromNbt(class_2487 nbt) {
            return new PermissionsUpdateData(nbt.method_25926(NBT_ID), nbt.method_10545(NBT_NEW_OWNER) ? Owner.fromNbt(nbt.method_10562(NBT_NEW_OWNER)) : null, nbt.method_10545("State") ? LockState.getByIndex(nbt.method_10571("State")) : null, nbt.method_10545("Trusted") ? nbt.method_10554("Trusted", 10).stream().map(x -> Owner.fromNbt((class_2487)x)).collect(Collectors.toSet()) : null);
        }
    }
}

