/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.util;

import de.mrjulsen.crn.CRNPlatformSpecific;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.mcdragonlib.DragonLib;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2487;

public class Owner {
    private static final String NBT_ID = "OwnerId";
    private static final String NBT_NAME = "Name";
    private final UUID id;
    private final String name;

    public Owner(class_1657 player) {
        this(player.method_5667());
    }

    public Owner(UUID id) {
        this(id, id == null ? "Server" : CRNPlatformSpecific.getLastKnownPlayerName(id).orElse("?"));
    }

    public Owner(UUID id, String name) {
        this.name = name;
        this.id = id;
    }

    public Owner() {
        this((UUID)null);
    }

    public UUID uuid() {
        return this.id == null ? Constants.ZERO_UUID : this.id;
    }

    public String name() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Owner) {
            Owner o = (Owner)obj;
            return this.id == o.id || this.id != null && o.id != null && this.id.equals(o.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id == null ? Constants.ZERO_UUID.hashCode() : this.id.hashCode();
    }

    public String toString() {
        return String.format("%s[%s]", this.name, this.id == null ? Constants.ZERO_UUID : this.id);
    }

    public void toNbt(class_2487 nbt) {
        if (this.id != null) {
            nbt.method_25927(NBT_ID, this.id);
        }
        if (this.name != null) {
            nbt.method_10582(NBT_NAME, this.name);
        }
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        this.toNbt(nbt);
        return nbt;
    }

    public static Owner fromNbt(class_2487 nbt) {
        if (nbt.method_10545(NBT_ID)) {
            if (!DragonLib.hasServer() && nbt.method_10545(NBT_NAME)) {
                return new Owner(nbt.method_25926(NBT_ID), nbt.method_10558(NBT_NAME));
            }
            return new Owner(nbt.method_25926(NBT_ID));
        }
        return new Owner((UUID)null);
    }
}

