/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.player.permission.impl;

import dev.ftb.mods.ftbranks.api.FTBRanksAPI;
import dev.ftb.mods.ftbranks.api.OptionalBoolean;
import dev.ftb.mods.ftbranks.api.PermissionValue;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nonnull;
import net.minecraft.class_3222;
import xaero.pac.common.server.player.permission.api.IPermissionNodeAPI;
import xaero.pac.common.server.player.permission.api.IPlayerPermissionSystemAPI;

public class PlayerFTBPermissionSystem
implements IPlayerPermissionSystemAPI {
    @Override
    @Nonnull
    public OptionalInt getIntPermission(@Nonnull class_3222 player, @Nonnull IPermissionNodeAPI<Integer> node) {
        String nodeString = node.getNodeString();
        if (nodeString.isEmpty()) {
            return OptionalInt.empty();
        }
        return FTBRanksAPI.getPermissionValue((class_3222)player, (String)nodeString).asInteger();
    }

    @Override
    public boolean getPermission(@Nonnull class_3222 player, @Nonnull IPermissionNodeAPI<Boolean> node) {
        return FTBRanksAPI.getPermissionValue((class_3222)player, (String)node.getNodeString()).asBooleanOrFalse();
    }

    @Override
    @Nonnull
    public <T> Optional<T> getPermissionTyped(@Nonnull class_3222 player, @Nonnull IPermissionNodeAPI<T> node) {
        Object value;
        String nodeString = node.getNodeString();
        if (nodeString.isEmpty()) {
            return Optional.empty();
        }
        PermissionValue permissionValue = FTBRanksAPI.getPermissionValue((class_3222)player, (String)nodeString);
        Optional optional = permissionValue.asNumber();
        if (optional.isEmpty()) {
            OptionalBoolean optionalBoolean = permissionValue.asBoolean();
            if (optionalBoolean.isPresent()) {
                optional = Optional.of(optionalBoolean.get());
            } else {
                optional = permissionValue.asString();
                if (optional.isEmpty()) {
                    return Optional.empty();
                }
            }
        }
        if ((value = optional.get()).getClass() != node.getType()) {
            return Optional.empty();
        }
        Object valueCast = value;
        return Optional.of(valueCast);
    }
}

