/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.gui;

import java.util.Arrays;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_327;

@Environment(value=EnvType.CLIENT)
public final class FontHelper {
    private FontHelper() {
        throw new IllegalStateException("Can't touch this");
    }

    public static List<String> wrap(class_327 font, String str, int wrapWidth) {
        return Arrays.asList(FontHelper.wrapFormattedStringToWidth(font, str, wrapWidth).split("\n"));
    }

    private static String wrapFormattedStringToWidth(class_327 font, String str, int wrapWidth) {
        int j = FontHelper.sizeStringToWidth(font, str, wrapWidth);
        if (str.length() <= j) {
            return str;
        }
        String s1 = str.substring(0, j);
        char c0 = str.charAt(j);
        boolean flag = c0 == ' ' || c0 == '\n';
        String s2 = FontHelper.getFormatFromString(s1) + str.substring(j + (flag ? 1 : 0));
        return s1 + "\n" + FontHelper.wrapFormattedStringToWidth(font, s2, wrapWidth);
    }

    private static int sizeStringToWidth(class_327 font, String str, int wrapWidth) {
        int l;
        int j = str.length();
        int k = 0;
        int i1 = -1;
        boolean flag = false;
        for (l = 0; l < j; ++l) {
            char c0 = str.charAt(l);
            switch (c0) {
                case '\n': {
                    --l;
                    break;
                }
                case '\u00a7': {
                    char c1;
                    if (l >= j - 1) break;
                    if ((c1 = str.charAt(++l)) != 'l' && c1 != 'L') {
                        if (c1 != 'r' && c1 != 'R' && !FontHelper.isFormatColor(c1)) break;
                        flag = false;
                        break;
                    }
                    flag = true;
                    break;
                }
                case ' ': {
                    i1 = l;
                }
                default: {
                    k += font.method_1727(String.valueOf(c0));
                    if (!flag) break;
                    ++k;
                }
            }
            if (c0 == '\n') {
                i1 = ++l;
                break;
            }
            if (k > wrapWidth) break;
        }
        return l != j && i1 != -1 && i1 < l ? i1 : l;
    }

    private static boolean isFormatColor(char colorChar) {
        return colorChar >= '0' && colorChar <= '9' || colorChar >= 'a' && colorChar <= 'f' || colorChar >= 'A' && colorChar <= 'F';
    }

    private static boolean isFormatSpecial(char formatChar) {
        return formatChar >= 'k' && formatChar <= 'o' || formatChar >= 'K' && formatChar <= 'O' || formatChar == 'r' || formatChar == 'R';
    }

    private static String getFormatFromString(String text) {
        Object s1 = "";
        int i = -1;
        int j = text.length();
        while ((i = text.indexOf(167, i + 1)) != -1) {
            if (i >= j - 1) continue;
            char c0 = text.charAt(i + 1);
            if (FontHelper.isFormatColor(c0)) {
                s1 = "\u00a7" + c0;
                continue;
            }
            if (!FontHelper.isFormatSpecial(c0)) continue;
            s1 = (String)s1 + "\u00a7" + c0;
        }
        return s1;
    }
}

