/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.weapon;

import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.entity.misc.WeaponMount;
import immersive_aircraft.entity.weapon.BulletWeapon;
import immersive_aircraft.network.c2s.FireMessage;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_7923;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class BombBay
extends BulletWeapon {
    private static final float MAX_COOLDOWN = 1.0f;
    private float cooldown = 0.0f;

    public BombBay(VehicleEntity entity, class_1799 stack, WeaponMount mount, int slot) {
        super(entity, stack, mount, slot);
    }

    @Override
    protected float getBarrelLength() {
        return 0.25f;
    }

    @Override
    protected Vector4f getBarrelOffset() {
        return new Vector4f(0.0f, -0.8f, 0.0f, 1.0f);
    }

    public float getVelocity() {
        return 0.0f;
    }

    @Override
    protected class_1297 getBullet(class_1297 shooter, Vector4f position, Vector3f direction) {
        Vector3f vel = direction.mul(this.getVelocity(), new Vector3f());
        class_1799 stack = this.getAmmoStack();
        String string = stack != null ? class_7923.field_41178.method_10221((Object)stack.method_7909()).toString() : "minecraft:tnt";
        String identifier = Config.getInstance().bombBayEntity.getOrDefault(string, "immersive_aircraft:tiny_tnt");
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10582("id", identifier);
        compoundTag.method_10569("Fuse", 80);
        return class_1299.method_17842((class_2487)compoundTag, (class_1937)shooter.method_37908(), e -> {
            e.method_5808((double)position.x(), (double)position.y(), (double)position.z(), e.method_36454(), e.method_36455());
            e.method_18800((double)vel.x(), (double)vel.y(), (double)vel.z());
            return e;
        });
    }

    @Override
    public void tick() {
        this.cooldown -= 0.05f;
    }

    @Override
    public void fire(Vector3f direction) {
        if (this.spentAmmo(Config.getInstance().bombBayAmmunition, 20)) {
            super.fire(direction);
        }
    }

    @Override
    public void clientFire(int index) {
        if (this.cooldown <= 0.0f) {
            this.cooldown = 1.0f;
            NetworkHandler.sendToServer(new FireMessage(this.getSlot(), index, this.getDirection()));
        }
    }

    private Vector3f getDirection() {
        Vector3f direction = new Vector3f(0.0f, 1.0f, 0.0f);
        direction.mul((Matrix3fc)new Matrix3f((Matrix4fc)this.getMount().transform()));
        direction.mul((Matrix3fc)this.getEntity().getVehicleNormalTransform());
        return direction;
    }
}

