/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.parallelgearbox;

import com.hlysine.create_connected.content.parallelgearbox.ParallelGearboxBlockEntity;
import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2741;
import net.minecraft.class_2769;

public class ParallelGearboxInstance
extends KineticBlockEntityInstance<ParallelGearboxBlockEntity> {
    protected final EnumMap<class_2350, RotatingData> keys = new EnumMap(class_2350.class);
    protected class_2350 sourceFacing;

    public ParallelGearboxInstance(MaterialManager materialManager, ParallelGearboxBlockEntity blockEntity) {
        super(materialManager, (KineticBlockEntity)blockEntity);
        class_2350.class_2351 boxAxis = (class_2350.class_2351)this.blockState.method_11654((class_2769)class_2741.field_12496);
        int blockLight = this.world.method_8314(class_1944.field_9282, this.pos);
        int skyLight = this.world.method_8314(class_1944.field_9284, this.pos);
        this.updateSourceFacing();
        Material rotatingMaterial = this.getRotatingMaterial();
        for (class_2350 direction : Iterate.directions) {
            class_2350.class_2351 axis = direction.method_10166();
            if (boxAxis == axis) continue;
            Instancer shaft = rotatingMaterial.getModel(AllPartialModels.SHAFT_HALF, this.blockState, direction);
            RotatingData key = (RotatingData)shaft.createInstance();
            key.setRotationAxis(class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis).method_23955()).setRotationalSpeed(this.getSpeed(direction)).setRotationOffset(this.getRotationOffset(axis)).setColor((KineticBlockEntity)blockEntity).setPosition(this.getInstancePosition()).setBlockLight(blockLight).setSkyLight(skyLight);
            this.keys.put(direction, key);
        }
    }

    private float getSpeed(class_2350 direction) {
        float speed = ((ParallelGearboxBlockEntity)this.blockEntity).getSpeed();
        if (speed != 0.0f && this.sourceFacing != null) {
            speed *= ParallelGearboxBlockEntity.getRotationSpeedModifier(direction, this.sourceFacing);
        }
        return speed;
    }

    protected void updateSourceFacing() {
        if (((ParallelGearboxBlockEntity)this.blockEntity).hasSource()) {
            class_2338 source = ((ParallelGearboxBlockEntity)this.blockEntity).source.method_10059((class_2382)this.pos);
            this.sourceFacing = class_2350.method_10147((float)source.method_10263(), (float)source.method_10264(), (float)source.method_10260());
        } else {
            this.sourceFacing = null;
        }
    }

    public void update() {
        this.updateSourceFacing();
        for (Map.Entry<class_2350, RotatingData> key : this.keys.entrySet()) {
            class_2350 direction = key.getKey();
            class_2350.class_2351 axis = direction.method_10166();
            this.updateRotation(key.getValue(), axis, this.getSpeed(direction));
        }
    }

    public void updateLight() {
        this.relight(this.pos, this.keys.values().stream());
    }

    public void remove() {
        this.keys.values().forEach(InstanceData::delete);
        this.keys.clear();
    }
}

