/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.sequencedpulsegenerator;

import com.hlysine.create_connected.content.sequencedpulsegenerator.SequencedPulseGeneratorBlock;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.EndInstruction;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.Instruction;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.InstructionResult;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.LoopForInstruction;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.LoopIfInstruction;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.LoopInstruction;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.OutputInstruction;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.WaitForInstruction;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Vector;
import java.util.function.Function;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;

public class SequencedPulseGeneratorBlockEntity
extends SmartBlockEntity {
    public static final int INSTRUCTION_CAPACITY = 7;
    private static final int MAX_RECURSION_DEPTH = 10;
    private static final float PARTICLE_DENSITY = 0.2f;
    Vector<Instruction> instructions = Instruction.createDefault();
    int currentInstruction = -1;
    int currentSignal = 0;
    boolean poweredPreviously = false;
    boolean isPowered;
    int infiniteLoopCounter = 0;

    public SequencedPulseGeneratorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public boolean isIdle() {
        return this.currentInstruction < 0;
    }

    public int getCurrentSignal() {
        return this.currentSignal;
    }

    public boolean isPoweredPreviously() {
        return this.poweredPreviously;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public Instruction getCurrentInstruction() {
        return this.currentInstruction >= 0 && this.currentInstruction < this.instructions.size() ? this.instructions.get(this.currentInstruction) : null;
    }

    private void executeInstruction(Function<Instruction, Function<SequencedPulseGeneratorBlockEntity, InstructionResult>> instructionEvent, boolean allowImmediate) {
        this.executeInstruction(instructionEvent, allowImmediate, 0);
    }

    private void applySignal() {
        if ((Boolean)this.method_11010().method_11654((class_2769)SequencedPulseGeneratorBlock.POWERING) != this.currentSignal > 0) {
            this.field_11863.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)SequencedPulseGeneratorBlock.POWERING, (Comparable)Boolean.valueOf(this.currentSignal > 0)), 2);
        }
        ((SequencedPulseGeneratorBlock)this.method_11010().method_26204()).method_9997(this.field_11863, this.method_11016(), this.method_11010());
    }

    private void executeInstruction(Function<Instruction, Function<SequencedPulseGeneratorBlockEntity, InstructionResult>> instructionEvent, boolean allowImmediate, int recursionDepth) {
        Instruction instruction = this.getCurrentInstruction();
        if (instruction == null) {
            this.currentInstruction = -1;
            if (this.currentSignal != 0) {
                this.currentSignal = 0;
                this.applySignal();
            }
            return;
        }
        InstructionResult result = instructionEvent.apply(instruction).apply(this);
        int prevSignal = this.currentSignal;
        this.currentSignal = instruction.getSignal();
        if (prevSignal != this.currentSignal) {
            this.applySignal();
        }
        this.currentInstruction = result.getNextInstruction(this.currentInstruction);
        if (result.isImmediate() && allowImmediate) {
            if (recursionDepth < 10) {
                this.executeInstruction(instructionEvent, true, recursionDepth + 1);
            } else {
                ++this.infiniteLoopCounter;
                if (this.field_11863.method_8409().method_43057() < 0.2f) {
                    class_243 loc = class_243.method_24955((class_2382)this.method_11016());
                    ((class_3218)this.field_11863).method_14199((class_2394)class_2398.field_11251, loc.field_1352, loc.field_1351, loc.field_1350, 2, 0.1, 0.0, 0.1, 0.01);
                }
                if (!this.field_11863.method_8608() && this.infiniteLoopCounter > 101) {
                    this.infiniteLoopCounter = 0;
                }
            }
        } else {
            this.infiniteLoopCounter = 0;
        }
        if (recursionDepth == 0) {
            this.notifyUpdate();
        }
    }

    public void tick() {
        super.tick();
        if (this.isIdle()) {
            return;
        }
        if (this.field_11863.field_9236) {
            return;
        }
        this.isPowered = (Boolean)this.method_11010().method_11654((class_2769)class_2312.field_10911);
        this.executeInstruction(i -> i::tick, true);
    }

    private void resetAllInstructions() {
        Vector newInstructions = new Vector(this.instructions.capacity());
        this.instructions.forEach(i -> newInstructions.add(i.copy()));
        this.instructions = newInstructions;
    }

    public void onRedstoneUpdate(boolean isPowered) {
        this.isPowered = isPowered;
        if (isPowered == this.poweredPreviously) {
            return;
        }
        if (!this.poweredPreviously && isPowered && !this.isIdle()) {
            this.executeInstruction(i -> i::onRisingEdge, false);
        }
        if (this.poweredPreviously && !isPowered && !this.isIdle()) {
            this.executeInstruction(i -> i::onFallingEdge, false);
        }
        this.poweredPreviously = isPowered;
        if (!this.isIdle() || !isPowered) {
            return;
        }
        if (!this.field_11863.method_49803(this.field_11867)) {
            this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)class_2312.field_10911, (Comparable)Boolean.valueOf(false)), 3);
            return;
        }
        this.currentInstruction = 0;
        this.resetAllInstructions();
        this.executeInstruction(i -> i::tick, true);
    }

    public void reset() {
        this.resetAllInstructions();
        this.currentInstruction = -1;
        this.infiniteLoopCounter = 0;
        this.currentSignal = 0;
        this.applySignal();
        this.notifyUpdate();
    }

    protected void write(class_2487 nbt, boolean clientPacket) {
        nbt.method_10569("InstructionIndex", this.currentInstruction);
        nbt.method_10556("PrevPowered", this.poweredPreviously);
        nbt.method_10569("CurrentSignal", this.currentSignal);
        nbt.method_10566("Instructions", (class_2520)Instruction.serializeAll(this.instructions));
        super.write(nbt, clientPacket);
    }

    protected void read(class_2487 nbt, boolean clientPacket) {
        this.currentInstruction = nbt.method_10550("InstructionIndex");
        this.poweredPreviously = nbt.method_10577("PrevPowered");
        this.currentSignal = nbt.method_10550("CurrentSignal");
        class_2499 list = nbt.method_10554("Instructions", 10);
        this.instructions = Instruction.deserializeAll(list);
        super.read(nbt, clientPacket);
    }

    static {
        Instruction.register(new OutputInstruction(10, 15));
        Instruction.register(new WaitForInstruction(1, 0));
        Instruction.register(new LoopForInstruction(3));
        Instruction.register(new LoopIfInstruction(1));
        Instruction.register(new LoopInstruction());
        Instruction.register(new EndInstruction());
    }
}

