/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.config.state;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.tectonic.Tectonic;
import dev.worldgen.tectonic.config.state.V2ConfigState;

public class ConfigState {
    public static final Codec<ConfigState> BASE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)General.CODEC.fieldOf("general").forGetter(state -> state.general), (App)GlobalTerrain.CODEC.fieldOf("global_terrain").orElse((Object)GlobalTerrain.DEFAULT).forGetter(state -> state.globalTerrain), (App)Continents.CODEC.fieldOf("continents").orElse((Object)Continents.DEFAULT).forGetter(state -> state.continents), (App)Islands.CODEC.fieldOf("islands").orElse((Object)Islands.DEFAULT).forGetter(state -> state.islands), (App)Oceans.CODEC.fieldOf("oceans").orElse((Object)Oceans.DEFAULT).forGetter(state -> state.oceans), (App)Biomes.CODEC.fieldOf("biomes").orElse((Object)Biomes.DEFAULT).forGetter(state -> state.biomes)).apply((Applicative)instance, ConfigState::new));
    public static final Codec<ConfigState> CODEC = Tectonic.withAlternative(BASE_CODEC, V2ConfigState.CODEC, V2ConfigState::upgrade);
    public General general;
    public GlobalTerrain globalTerrain;
    public Continents continents;
    public Islands islands;
    public Oceans oceans;
    public Biomes biomes;

    public ConfigState(General general, GlobalTerrain globalTerrain, Continents continents, Islands islands, Oceans oceans, Biomes biomes) {
        this.general = general;
        this.globalTerrain = globalTerrain;
        this.continents = continents;
        this.islands = islands;
        this.oceans = oceans;
        this.biomes = biomes;
    }

    public double getValue(String option) {
        return switch (option) {
            case "vertical_scale" -> this.globalTerrain.verticalScale;
            case "lava_tunnels" -> {
                if (this.globalTerrain.lavaTunnels) {
                    yield 1.0;
                }
                yield 0.0;
            }
            case "ocean_offset" -> this.continents.oceanOffset;
            case "continents_scale" -> this.continents.continentsScale;
            case "erosion_scale" -> this.continents.erosionScale;
            case "ridge_scale" -> this.continents.ridgeScale;
            case "underground_rivers" -> {
                if (this.continents.undergroundRivers) {
                    yield -1.0;
                }
                yield 0.0;
            }
            case "flat_terrain_skew" -> this.continents.flatTerrainSkew;
            case "rolling_hills" -> {
                if (this.continents.rollingHills) {
                    yield 1.0;
                }
                yield 0.0;
            }
            case "jungle_pillars" -> {
                if (this.continents.junglePillars) {
                    yield 1.0;
                }
                yield 0.0;
            }
            case "ocean_depth" -> this.oceans.oceanDepth;
            case "deep_ocean_depth" -> this.oceans.deepOceanDepth;
            case "islands_scale" -> this.islands.noiseScale;
            case "temperature_multiplier" -> this.biomes.temperatureMultiplier;
            case "temperature_scale" -> this.biomes.temperatureScale;
            case "vegetation_multiplier" -> this.biomes.vegetationMultiplier;
            case "vegetation_scale" -> this.biomes.vegetationScale;
            default -> 0.0;
        };
    }

    public static class General {
        public static final boolean MOD_ENABLED = true;
        public static final int SNOW_START_OFFSET = 128;
        public static final General DEFAULT = new General(true, 128);
        public static final Codec<General> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("mod_enabled").forGetter(general -> general.modEnabled), (App)Codec.INT.fieldOf("snow_start_offset").orElse((Object)128).forGetter(general -> general.snowStartOffset)).apply((Applicative)instance, General::new));
        public boolean modEnabled;
        public int snowStartOffset;

        public General(boolean modEnabled, int snowStartOffset) {
            this.modEnabled = modEnabled;
            this.snowStartOffset = snowStartOffset;
        }
    }

    public static class GlobalTerrain {
        public static final double VERTICAL_SCALE = 1.125;
        public static final boolean INCREASED_HEIGHT = false;
        public static final boolean LAVA_TUNNELS = true;
        public static final GlobalTerrain DEFAULT = new GlobalTerrain(1.125, false, true);
        public static final Codec<GlobalTerrain> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("vertical_scale").orElse((Object)1.125).forGetter(globalTerrain -> globalTerrain.verticalScale), (App)Codec.BOOL.fieldOf("increased_height").orElse((Object)false).forGetter(globalTerrain -> globalTerrain.increasedHeight), (App)Codec.BOOL.fieldOf("lava_tunnels").orElse((Object)true).forGetter(globalTerrain -> globalTerrain.lavaTunnels)).apply((Applicative)instance, GlobalTerrain::new));
        public double verticalScale;
        public boolean increasedHeight;
        public boolean lavaTunnels;

        public GlobalTerrain(double verticalScale, boolean increasedHeight, boolean lavaTunnels) {
            this.verticalScale = verticalScale;
            this.increasedHeight = increasedHeight;
            this.lavaTunnels = lavaTunnels;
        }
    }

    public static class Continents {
        public static final double OCEAN_OFFSET = -0.8;
        public static final double CONTINENTS_SCALE = 0.13;
        public static final double EROSION_SCALE = 0.25;
        public static final double RIDGE_SCALE = 0.25;
        public static final boolean UNDERGROUND_RIVERS = true;
        public static final boolean RIVER_LANTERNS = true;
        public static final double FLAT_TERRAIN_SKEW = 0.1;
        public static final boolean ROLLING_HILLS = true;
        public static final boolean JUNGLE_PILLARS = true;
        public static final Continents DEFAULT = new Continents(-0.8, 0.13, 0.25, 0.25, true, true, 0.1, true, true);
        public static final Codec<Continents> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("ocean_offset").orElse((Object)-0.8).forGetter(continents -> continents.oceanOffset), (App)Codec.DOUBLE.fieldOf("continents_scale").orElse((Object)0.13).forGetter(continents -> continents.continentsScale), (App)Codec.DOUBLE.fieldOf("erosion_scale").orElse((Object)0.25).forGetter(continents -> continents.erosionScale), (App)Codec.DOUBLE.fieldOf("ridge_scale").orElse((Object)0.25).forGetter(continents -> continents.ridgeScale), (App)Codec.BOOL.fieldOf("underground_rivers").orElse((Object)true).forGetter(continents -> continents.undergroundRivers), (App)Codec.BOOL.fieldOf("river_lanterns").orElse((Object)true).forGetter(continents -> continents.riverLanterns), (App)Codec.DOUBLE.fieldOf("flat_terrain_skew").orElse((Object)0.1).forGetter(continents -> continents.flatTerrainSkew), (App)Codec.BOOL.fieldOf("rolling_hills").orElse((Object)true).forGetter(continents -> continents.rollingHills), (App)Codec.BOOL.fieldOf("jungle_pillars").orElse((Object)true).forGetter(continents -> continents.junglePillars)).apply((Applicative)instance, Continents::new));
        public double oceanOffset;
        public double continentsScale;
        public double erosionScale;
        public double ridgeScale;
        public boolean undergroundRivers;
        public boolean riverLanterns;
        public double flatTerrainSkew;
        public boolean rollingHills;
        public boolean junglePillars;

        public Continents(double oceanOffset, double continentsScale, double erosionScale, double ridgeScale, boolean undergroundRivers, boolean riverLanterns, double flatTerrainSkew, boolean rollingHills, boolean junglePillars) {
            this.oceanOffset = oceanOffset;
            this.continentsScale = continentsScale;
            this.erosionScale = erosionScale;
            this.ridgeScale = ridgeScale;
            this.undergroundRivers = undergroundRivers;
            this.riverLanterns = riverLanterns;
            this.flatTerrainSkew = flatTerrainSkew;
            this.rollingHills = rollingHills;
            this.junglePillars = junglePillars;
        }
    }

    public static class Islands {
        public static final boolean ENABLED = true;
        public static final double NOISE_SCALE = 0.11;
        public static final Islands DEFAULT = new Islands(true, 0.11);
        public static final Codec<Islands> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("enabled").orElse((Object)true).forGetter(islands -> islands.enabled), (App)Codec.DOUBLE.fieldOf("noise_scale").orElse((Object)0.11).forGetter(islands -> islands.noiseScale)).apply((Applicative)instance, Islands::new));
        public boolean enabled;
        public double noiseScale;

        public Islands(boolean enabled, double noiseScale) {
            this.enabled = enabled;
            this.noiseScale = noiseScale;
        }
    }

    public static class Oceans {
        public static final double OCEAN_DEPTH = -0.22;
        public static final double DEEP_OCEAN_DEPTH = -0.45;
        public static final int MONUMENT_OFFSET = -30;
        public static final boolean REMOVE_FROZEN_OCEAN_ICE = false;
        public static final Oceans DEFAULT = new Oceans(-0.22, -0.45, -30, false);
        public static final Codec<Oceans> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("ocean_depth").orElse((Object)-0.22).forGetter(oceans -> oceans.oceanDepth), (App)Codec.DOUBLE.fieldOf("deep_ocean_depth").orElse((Object)-0.45).forGetter(oceans -> oceans.deepOceanDepth), (App)Codec.INT.fieldOf("monument_offset").orElse((Object)-30).forGetter(oceans -> oceans.monumentOffset), (App)Codec.BOOL.fieldOf("remove_frozen_ocean_ice").orElse((Object)false).forGetter(oceans -> oceans.removeFrozenOceanIce)).apply((Applicative)instance, Oceans::new));
        public double oceanDepth;
        public double deepOceanDepth;
        public int monumentOffset;
        public boolean removeFrozenOceanIce;

        public Oceans(double oceanDepth, double deepOceanDepth, int monumentOffset, boolean removeFrozenOceanIce) {
            this.oceanDepth = oceanDepth;
            this.deepOceanDepth = deepOceanDepth;
            this.monumentOffset = monumentOffset;
            this.removeFrozenOceanIce = removeFrozenOceanIce;
        }
    }

    public static class Biomes {
        public static final double TEMPERATURE_MULTIPLIER = 1.0;
        public static final double TEMPERATURE_SCALE = 0.25;
        public static final double VEGETATION_MULTIPLIER = 1.0;
        public static final double VEGETATION_SCALE = 0.25;
        public static final Biomes DEFAULT = new Biomes(1.0, 0.25, 1.0, 0.25);
        public static final Codec<Biomes> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("temperature_multiplier").orElse((Object)1.0).forGetter(biomes -> biomes.temperatureMultiplier), (App)Codec.DOUBLE.fieldOf("temperature_scale").orElse((Object)0.25).forGetter(biomes -> biomes.temperatureScale), (App)Codec.DOUBLE.fieldOf("vegetation_multiplier").orElse((Object)1.0).forGetter(biomes -> biomes.vegetationMultiplier), (App)Codec.DOUBLE.fieldOf("vegetation_scale").orElse((Object)0.25).forGetter(biomes -> biomes.vegetationScale)).apply((Applicative)instance, Biomes::new));
        public double temperatureMultiplier;
        public double temperatureScale;
        public double vegetationMultiplier;
        public double vegetationScale;

        public Biomes(double temperatureMultiplier, double temperatureScale, double vegetationMultiplier, double vegetationScale) {
            this.temperatureMultiplier = temperatureMultiplier;
            this.temperatureScale = temperatureScale;
            this.vegetationMultiplier = vegetationMultiplier;
            this.vegetationScale = vegetationScale;
        }
    }
}

