/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.loaders.fabric;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.ModifierPredicate;
import dev.worldgen.tectonic.config.ConfigHandler;

public record TectonicModifierPredicate(String key) implements ModifierPredicate
{
    public static final Codec<TectonicModifierPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("key").forGetter(TectonicModifierPredicate::key)).apply((Applicative)instance, TectonicModifierPredicate::new));

    public boolean test() {
        return switch (this.key) {
            case "disable_islands" -> {
                if (!ConfigHandler.getState().islands.enabled) {
                    yield true;
                }
                yield false;
            }
            case "increased_height" -> ConfigHandler.getState().globalTerrain.increasedHeight;
            case "remove_frozen_ocean_ice" -> ConfigHandler.getState().oceans.removeFrozenOceanIce;
            case "river_lanterns" -> ConfigHandler.getState().continents.riverLanterns;
            default -> false;
        };
    }

    public Codec<? extends ModifierPredicate> codec() {
        return CODEC;
    }
}

