/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.animation;

import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.class_2487;
import net.minecraft.class_3532;

public class LerpedFloat {
    protected Interpolator interpolator;
    protected float previousValue;
    protected float value;
    protected Chaser chaseFunction;
    protected float chaseTarget;
    protected float chaseSpeed;
    protected boolean angularChase;
    protected boolean forcedSync;

    public LerpedFloat(Interpolator interpolator) {
        this.interpolator = interpolator;
        this.startWithValue(0.0);
        this.forcedSync = true;
    }

    public static LerpedFloat linear() {
        return new LerpedFloat((p, c, t) -> (float)class_3532.method_16436((double)p, (double)c, (double)t));
    }

    public static LerpedFloat angular() {
        LerpedFloat lerpedFloat = new LerpedFloat(AngleHelper::angleLerp);
        lerpedFloat.angularChase = true;
        return lerpedFloat;
    }

    public LerpedFloat startWithValue(double value) {
        float f;
        this.previousValue = f = (float)value;
        this.chaseTarget = f;
        this.value = f;
        return this;
    }

    public LerpedFloat chase(double value, double speed, Chaser chaseFunction) {
        this.updateChaseTarget((float)value);
        this.chaseSpeed = (float)speed;
        this.chaseFunction = chaseFunction;
        return this;
    }

    public LerpedFloat disableSmartAngleChasing() {
        this.angularChase = false;
        return this;
    }

    public void updateChaseTarget(float target) {
        if (this.angularChase) {
            target = this.value + AngleHelper.getShortestAngleDiff(this.value, target);
        }
        this.chaseTarget = target;
    }

    public boolean updateChaseSpeed(double speed) {
        float prevSpeed = this.chaseSpeed;
        this.chaseSpeed = (float)speed;
        return !class_3532.method_20390((double)prevSpeed, (double)speed);
    }

    public void tickChaser() {
        this.previousValue = this.value;
        if (this.chaseFunction == null) {
            return;
        }
        if (class_3532.method_20390((double)this.value, (double)this.chaseTarget)) {
            this.value = this.chaseTarget;
            return;
        }
        this.value = this.chaseFunction.chase(this.value, this.chaseSpeed, this.chaseTarget);
    }

    public void setValueNoUpdate(double value) {
        this.value = (float)value;
    }

    public void setValue(double value) {
        this.previousValue = this.value;
        this.value = (float)value;
    }

    public float getValue() {
        return this.getValue(1.0f);
    }

    public float getValue(float partialTicks) {
        return this.interpolator.interpolate(partialTicks, this.previousValue, this.value);
    }

    public boolean settled() {
        return class_3532.method_20390((double)this.previousValue, (double)this.value) && (this.chaseFunction == null || class_3532.method_20390((double)this.value, (double)this.chaseTarget));
    }

    public float getChaseTarget() {
        return this.chaseTarget;
    }

    public void forceNextSync() {
        this.forcedSync = true;
    }

    public class_2487 writeNBT() {
        class_2487 compoundNBT = new class_2487();
        compoundNBT.method_10548("Speed", this.chaseSpeed);
        compoundNBT.method_10548("Target", this.chaseTarget);
        compoundNBT.method_10548("Value", this.value);
        if (this.forcedSync) {
            compoundNBT.method_10556("Force", true);
        }
        this.forcedSync = false;
        return compoundNBT;
    }

    public void readNBT(class_2487 compoundNBT, boolean clientPacket) {
        if (!clientPacket || compoundNBT.method_10545("Force")) {
            this.startWithValue(compoundNBT.method_10583("Value"));
        }
        this.readChaser(compoundNBT);
    }

    protected void readChaser(class_2487 compoundNBT) {
        this.chaseSpeed = compoundNBT.method_10583("Speed");
        this.chaseTarget = compoundNBT.method_10583("Target");
    }

    @FunctionalInterface
    public static interface Interpolator {
        public float interpolate(double var1, double var3, double var5);
    }

    @FunctionalInterface
    public static interface Chaser {
        public static final Chaser IDLE = (c, s, t) -> (float)c;
        public static final Chaser EXP = Chaser.exp(Double.MAX_VALUE);
        public static final Chaser LINEAR = (c, s, t) -> (float)(c + class_3532.method_15350((double)(t - c), (double)(-s), (double)s));

        public static Chaser exp(double maxEffectiveSpeed) {
            return (c, s, t) -> (float)(c + class_3532.method_15350((double)((t - c) * s), (double)(-maxEffectiveSpeed), (double)maxEffectiveSpeed));
        }

        public float chase(double var1, double var3, double var5);
    }
}

