/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.fabric;

import com.mojang.brigadier.CommandDispatcher;
import dcshadow.net.kyori.adventure.text.Component;
import dcshadow.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.addon.AddonLoader;
import de.erdbeerbaerlp.dcintegration.common.addon.DiscordAddonMeta;
import de.erdbeerbaerlp.dcintegration.common.storage.CommandRegistry;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.Localization;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.LinkManager;
import de.erdbeerbaerlp.dcintegration.common.util.DiscordMessage;
import de.erdbeerbaerlp.dcintegration.common.util.DownloadSourceChecker;
import de.erdbeerbaerlp.dcintegration.common.util.McServerInterface;
import de.erdbeerbaerlp.dcintegration.common.util.MessageUtils;
import de.erdbeerbaerlp.dcintegration.common.util.MinecraftPermission;
import de.erdbeerbaerlp.dcintegration.common.util.TextColors;
import de.erdbeerbaerlp.dcintegration.common.util.UpdateChecker;
import de.erdbeerbaerlp.dcintegration.fabric.api.FabricDiscordEventHandler;
import de.erdbeerbaerlp.dcintegration.fabric.bstats.Metrics;
import de.erdbeerbaerlp.dcintegration.fabric.command.McCommandDiscord;
import de.erdbeerbaerlp.dcintegration.fabric.util.FabricMessageUtils;
import de.erdbeerbaerlp.dcintegration.fabric.util.FabricServerInterface;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.dv8tion.jda.api.utils.messages.MessageCreateData;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7471;
import net.minecraft.server.MinecraftServer;

public class DiscordIntegrationMod
implements DedicatedServerModInitializer {
    public static final String MODID = "dcintegration";
    public static final ArrayList<UUID> timeouts = new ArrayList();
    public static boolean stopped = false;
    public static Metrics bstats;

    public static class_7471 handleChatMessage(class_7471 message, class_3222 player) {
        if (DiscordIntegration.INSTANCE == null) {
            return message;
        }
        if (!((FabricServerInterface)DiscordIntegration.INSTANCE.getServerInterface()).playerHasPermissions((class_1657)player, MinecraftPermission.SEMD_MESSAGES, MinecraftPermission.USER)) {
            return message;
        }
        if (LinkManager.isPlayerLinked((UUID)player.method_5667()) && LinkManager.getLink(null, (UUID)player.method_5667()).settings.hideFromDiscord) {
            return message;
        }
        class_7471 finalMessage = message;
        String text = MessageUtils.escapeMarkdown((String)message.method_46291().getString());
        MessageEmbed embed = FabricMessageUtils.genItemStackEmbedIfAvailable(message.method_46291());
        if (DiscordIntegration.INSTANCE != null) {
            if (DiscordIntegration.INSTANCE.callEvent(e -> {
                if (e instanceof FabricDiscordEventHandler) {
                    return ((FabricDiscordEventHandler)((Object)e)).onMcChatMessage(finalMessage.method_46291(), player);
                }
                return false;
            })) {
                return message;
            }
            GuildMessageChannel channel = DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.chatOutputChannelID);
            if (channel == null) {
                return message;
            }
            String json = class_2561.class_2562.method_10867((class_2561)message.method_46291());
            Component comp = GsonComponentSerializer.gson().deserialize((Object)json);
            if (DiscordIntegration.INSTANCE.callEvent(e -> e.onMinecraftMessage(comp, player.method_5667()))) {
                return message;
            }
            if (!Localization.instance().discordChatMessage.isBlank()) {
                if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.chatMessages.asEmbed) {
                    String avatarURL = Configuration.instance().webhook.playerAvatarURL.replace("%uuid%", player.method_5667().toString()).replace("%uuid_dashless%", player.method_5667().toString().replace("-", "")).replace("%name%", player.method_5477().getString()).replace("%randomUUID%", UUID.randomUUID().toString());
                    if (!Configuration.instance().embedMode.chatMessages.customJSON.isBlank()) {
                        b = Configuration.instance().embedMode.chatMessages.toEmbedJson(Configuration.instance().embedMode.chatMessages.customJSON.replace("%uuid%", player.method_5667().toString()).replace("%uuid_dashless%", player.method_5667().toString().replace("-", "")).replace("%name%", FabricMessageUtils.formatPlayerName(player)).replace("%randomUUID%", UUID.randomUUID().toString()).replace("%avatarURL%", avatarURL).replace("%msg%", text).replace("%playerColor%", "" + TextColors.generateFromUUID((UUID)player.method_5667()).getRGB()));
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.chatOutputChannelID));
                    } else {
                        b = Configuration.instance().embedMode.chatMessages.toEmbed();
                        if (Configuration.instance().embedMode.chatMessages.generateUniqueColors) {
                            b = b.setColor(TextColors.generateFromUUID((UUID)player.method_5667()));
                        }
                        b = b.setAuthor(FabricMessageUtils.formatPlayerName(player), null, avatarURL).setDescription((CharSequence)text);
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.chatOutputChannelID));
                    }
                } else {
                    DiscordIntegration.INSTANCE.sendMessage(FabricMessageUtils.formatPlayerName(player), player.method_5667().toString(), new DiscordMessage(embed, text, true), (MessageChannel)channel);
                }
            }
            if (!Configuration.instance().compatibility.disableParsingMentionsIngame) {
                String editedJson = (String)GsonComponentSerializer.gson().serialize(MessageUtils.mentionsToNames((Component)comp, (Guild)channel.getGuild()));
                class_5250 txt = class_2561.class_2562.method_10877((String)editedJson);
                message = class_7471.method_45041((String)txt.getString());
            }
        }
        return message;
    }

    public void onInitializeServer() {
        bstats = new Metrics(9765);
        try {
            DiscordIntegration.loadConfigs();
            ServerLifecycleEvents.SERVER_STARTED.register(this::serverStarted);
            if (!Configuration.instance().general.botToken.equals("INSERT BOT TOKEN HERE")) {
                ServerLifecycleEvents.SERVER_STARTING.register(this::serverStarting);
                ServerLifecycleEvents.SERVER_STOPPED.register(this::serverStopped);
                ServerLifecycleEvents.SERVER_STOPPING.register(this::serverStopping);
            } else {
                DiscordIntegration.LOGGER.error("Please check the config file and set an bot token");
            }
        }
        catch (IOException e) {
            DiscordIntegration.LOGGER.error("Config loading failed");
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            DiscordIntegration.LOGGER.error("Failed to read config file! Please check your config file!\nError description: " + e.getMessage());
            DiscordIntegration.LOGGER.error("\nStacktrace: ");
            e.printStackTrace();
        }
    }

    private void serverStarting(MinecraftServer minecraftServer) {
        DiscordIntegration.INSTANCE = new DiscordIntegration((McServerInterface)new FabricServerInterface(minecraftServer));
        try {
            DiscordIntegration.LOGGER.info("Waiting for JDA to initialize to send starting message... (max 5 seconds before skipping)");
            for (int i = 0; i <= 5 && DiscordIntegration.INSTANCE.getJDA() == null; ++i) {
                Thread.sleep(1000L);
            }
            if (DiscordIntegration.INSTANCE.getJDA() != null) {
                Thread.sleep(2000L);
                CommandRegistry.registerDefaultCommands();
                if (!Localization.instance().serverStarting.isEmpty() && !Localization.instance().serverStarting.isBlank() && DiscordIntegration.INSTANCE.getChannel() != null) {
                    MessageCreateData m = Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.startMessages.asEmbed ? ((MessageCreateBuilder)new MessageCreateBuilder().setEmbeds(new MessageEmbed[]{Configuration.instance().embedMode.startMessages.toEmbed().setDescription((CharSequence)Localization.instance().serverStarting).build()})).build() : new MessageCreateBuilder().addContent(Localization.instance().serverStarting).build();
                    DiscordIntegration.startingMsg = DiscordIntegration.INSTANCE.sendMessageReturns(m, DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                }
            }
        }
        catch (InterruptedException | NullPointerException exception) {
            // empty catch block
        }
        new McCommandDiscord((CommandDispatcher<class_2168>)minecraftServer.method_3734().method_9235());
    }

    private void serverStarted(MinecraftServer minecraftServer) {
        DiscordIntegration.LOGGER.info("Started");
        if (DiscordIntegration.INSTANCE != null) {
            DiscordIntegration.started = new Date().getTime();
            if (!Localization.instance().serverStarted.isBlank()) {
                if (DiscordIntegration.startingMsg != null) {
                    if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.startMessages.asEmbed) {
                        if (!Configuration.instance().embedMode.startMessages.customJSON.isBlank()) {
                            EmbedBuilder b = Configuration.instance().embedMode.startMessages.toEmbedJson(Configuration.instance().embedMode.startMessages.customJSON);
                            DiscordIntegration.startingMsg.thenAccept(a -> a.editMessageEmbeds(new MessageEmbed[]{b.build()}).queue());
                        } else {
                            DiscordIntegration.startingMsg.thenAccept(a -> a.editMessageEmbeds(new MessageEmbed[]{Configuration.instance().embedMode.startMessages.toEmbed().setDescription((CharSequence)Localization.instance().serverStarted).build()}).queue());
                        }
                    } else {
                        DiscordIntegration.startingMsg.thenAccept(a -> a.editMessage((CharSequence)Localization.instance().serverStarted).queue());
                    }
                } else if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.startMessages.asEmbed) {
                    if (!Configuration.instance().embedMode.startMessages.customJSON.isBlank()) {
                        EmbedBuilder b = Configuration.instance().embedMode.startMessages.toEmbedJson(Configuration.instance().embedMode.startMessages.customJSON);
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                    } else {
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(Configuration.instance().embedMode.startMessages.toEmbed().setDescription((CharSequence)Localization.instance().serverStarted).build()), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                    }
                } else {
                    DiscordIntegration.INSTANCE.sendMessage(Localization.instance().serverStarted, (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                }
            }
            DiscordIntegration.INSTANCE.startThreads();
        }
        UpdateChecker.runUpdateCheck((String)"https://raw.githubusercontent.com/ErdbeerbaerLP/Discord-Integration-Fabric/1.20.2/update-checker.json");
        if (!DownloadSourceChecker.checkDownloadSource((File)new File(DiscordIntegrationMod.class.getProtectionDomain().getCodeSource().getLocation().getPath().split("%")[0]))) {
            DiscordIntegration.LOGGER.warn("You likely got this mod from a third party website.");
            DiscordIntegration.LOGGER.warn("Some of such websites are distributing malware or old versions.");
            DiscordIntegration.LOGGER.warn("Download this mod from an official source (https://www.curseforge.com/minecraft/mc-mods/dcintegration) to hide this message");
            DiscordIntegration.LOGGER.warn("This warning can also be suppressed in the config file");
        }
        bstats.addCustomChart(new Metrics.DrilldownPie("addons", () -> {
            HashMap map = new HashMap();
            if (Configuration.instance().bstats.sendAddonStats) {
                for (DiscordAddonMeta m : AddonLoader.getAddonMetas()) {
                    HashMap<String, Integer> entry = new HashMap<String, Integer>();
                    entry.put(m.getVersion(), 1);
                    map.put(m.getName(), entry);
                }
            }
            return map;
        }));
    }

    private void serverStopping(MinecraftServer minecraftServer) {
        Metrics.MetricsBase.scheduler.shutdownNow();
        if (DiscordIntegration.INSTANCE != null) {
            if (!Localization.instance().serverStopped.isBlank()) {
                if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.stopMessages.asEmbed) {
                    if (!Configuration.instance().embedMode.stopMessages.customJSON.isBlank()) {
                        EmbedBuilder b = Configuration.instance().embedMode.stopMessages.toEmbedJson(Configuration.instance().embedMode.stopMessages.customJSON);
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()));
                    } else {
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(Configuration.instance().embedMode.stopMessages.toEmbed().setDescription((CharSequence)Localization.instance().serverStopped).build()));
                    }
                } else {
                    DiscordIntegration.INSTANCE.sendMessage(Localization.instance().serverStopped);
                }
            }
            DiscordIntegration.INSTANCE.stopThreads();
        }
        stopped = true;
    }

    private void serverStopped(MinecraftServer minecraftServer) {
        Metrics.MetricsBase.scheduler.shutdownNow();
        if (DiscordIntegration.INSTANCE != null) {
            if (!stopped && DiscordIntegration.INSTANCE.getJDA() != null) {
                minecraftServer.execute(() -> {
                    DiscordIntegration.INSTANCE.stopThreads();
                    if (!Localization.instance().serverCrash.isBlank()) {
                        try {
                            if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.stopMessages.asEmbed) {
                                DiscordIntegration.INSTANCE.sendMessageReturns(((MessageCreateBuilder)new MessageCreateBuilder().addEmbeds(new MessageEmbed[]{Configuration.instance().embedMode.stopMessages.toEmbed().setDescription((CharSequence)Localization.instance().serverCrash).build()})).build(), DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID)).get();
                            } else {
                                DiscordIntegration.INSTANCE.sendMessageReturns(((MessageCreateBuilder)new MessageCreateBuilder().setContent(Localization.instance().serverCrash)).build(), DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID)).get();
                            }
                        }
                        catch (InterruptedException | ExecutionException exception) {
                            // empty catch block
                        }
                    }
                });
            }
            DiscordIntegration.INSTANCE.kill(false);
        }
    }
}

