/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.fabric.mixin;

import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.fabric.DiscordIntegrationMod;
import de.erdbeerbaerlp.dcintegration.fabric.bstats.Metrics;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public class MixinMinecraftServer {
    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo info) {
        Metrics.capturedServer.set((MinecraftServer)this);
        DiscordIntegrationMod.bstats.addCustomChart(new Metrics.SimplePie("webhook_mode", () -> Configuration.instance().webhook.enable ? "Enabled" : "Disabled"));
        DiscordIntegrationMod.bstats.addCustomChart(new Metrics.SimplePie("command_log", () -> !Configuration.instance().commandLog.channelID.equals("0") ? "Enabled" : "Disabled"));
        DiscordIntegrationMod.bstats.addCustomChart(new Metrics.SimplePie("loader", () -> Metrics.capturedServer.get().getServerModName()));
    }

    @Inject(method={"shutdown"}, at={@At(value="HEAD")})
    private void onShutdown(CallbackInfo info) {
        Metrics.capturedServer.compareAndSet((MinecraftServer)this, null);
    }
}

