/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.fabric.mixin;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.StringReader;
import dcshadow.net.kyori.adventure.text.Component;
import dcshadow.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.WorkThread;
import de.erdbeerbaerlp.dcintegration.common.compat.FloodgateUtils;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.Localization;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.LinkManager;
import de.erdbeerbaerlp.dcintegration.common.util.DiscordMessage;
import de.erdbeerbaerlp.dcintegration.common.util.TextColors;
import de.erdbeerbaerlp.dcintegration.fabric.util.FabricMessageUtils;
import java.net.SocketAddress;
import java.util.UUID;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.UserSnowflake;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.minecraft.class_2178;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3324.class})
public class PlayerManagerMixin {
    @Inject(method={"checkCanJoin"}, at={@At(value="HEAD")}, cancellable=true)
    public void canJoin(SocketAddress address, GameProfile profile, CallbackInfoReturnable<class_2561> cir) {
        if (DiscordIntegration.INSTANCE == null) {
            return;
        }
        LinkManager.checkGlobalAPI((UUID)profile.getId());
        Component eventKick = (Component)DiscordIntegration.INSTANCE.callEventO(e -> e.onPlayerJoin(profile.getId()));
        if (eventKick != null) {
            String jsonComp = ((String)GsonComponentSerializer.gson().serialize(eventKick)).replace("\\\\n", "\n");
            try {
                class_2561 comp = class_2178.method_9281().method_9283(new StringReader(jsonComp));
                cir.setReturnValue((Object)comp);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        if (Configuration.instance().linking.whitelistMode && DiscordIntegration.INSTANCE.getServerInterface().isOnlineMode()) {
            try {
                if (!LinkManager.isPlayerLinked((UUID)profile.getId())) {
                    cir.setReturnValue((Object)class_2561.method_30163((String)Localization.instance().linking.notWhitelistedCode.replace("%code%", "" + (FloodgateUtils.isBedrockPlayer((UUID)profile.getId()) ? LinkManager.genBedrockLinkNumber((UUID)profile.getId()) : LinkManager.genLinkNumber((UUID)profile.getId())))));
                } else if (!DiscordIntegration.INSTANCE.canPlayerJoin(profile.getId())) {
                    cir.setReturnValue((Object)class_2561.method_30163((String)Localization.instance().linking.notWhitelistedRole));
                }
            }
            catch (IllegalStateException e3) {
                cir.setReturnValue((Object)class_2561.method_30163((String)("An error occured\nPlease check Server Log for more information\n\n" + e3)));
                e3.printStackTrace();
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"onPlayerConnect"})
    private void onPlayerJoin(class_2535 conn, class_3222 p, CallbackInfo ci) {
        if (DiscordIntegration.INSTANCE != null) {
            if (LinkManager.isPlayerLinked((UUID)p.method_5667()) && LinkManager.getLink(null, (UUID)p.method_5667()).settings.hideFromDiscord) {
                return;
            }
            LinkManager.checkGlobalAPI((UUID)p.method_5667());
            if (!Localization.instance().playerJoin.isBlank()) {
                if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.playerJoinMessage.asEmbed) {
                    String avatarURL = Configuration.instance().webhook.playerAvatarURL.replace("%uuid%", p.method_5667().toString()).replace("%uuid_dashless%", p.method_5667().toString().replace("-", "")).replace("%name%", p.method_5477().getString()).replace("%randomUUID%", UUID.randomUUID().toString());
                    if (!Configuration.instance().embedMode.playerJoinMessage.customJSON.isBlank()) {
                        EmbedBuilder b = Configuration.instance().embedMode.playerJoinMessage.toEmbedJson(Configuration.instance().embedMode.playerJoinMessage.customJSON.replace("%uuid%", p.method_5667().toString()).replace("%uuid_dashless%", p.method_5667().toString().replace("-", "")).replace("%name%", FabricMessageUtils.formatPlayerName(p)).replace("%randomUUID%", UUID.randomUUID().toString()).replace("%avatarURL%", avatarURL).replace("%playerColor%", "" + TextColors.generateFromUUID((UUID)p.method_5667()).getRGB()));
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()));
                    } else {
                        EmbedBuilder b = Configuration.instance().embedMode.playerJoinMessage.toEmbed();
                        b.setAuthor(FabricMessageUtils.formatPlayerName(p), null, avatarURL).setDescription((CharSequence)Localization.instance().playerJoin.replace("%player%", FabricMessageUtils.formatPlayerName(p)));
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                    }
                } else {
                    DiscordIntegration.INSTANCE.sendMessage(Localization.instance().playerJoin.replace("%player%", FabricMessageUtils.formatPlayerName(p)), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                }
            }
            WorkThread.executeJob(() -> {
                Member member;
                if (Configuration.instance().linking.linkedRoleID.equals("0")) {
                    return;
                }
                UUID uuid = p.method_5667();
                if (!LinkManager.isPlayerLinked((UUID)uuid)) {
                    return;
                }
                Guild guild = DiscordIntegration.INSTANCE.getChannel().getGuild();
                Role linkedRole = guild.getRoleById(Configuration.instance().linking.linkedRoleID);
                if (LinkManager.isPlayerLinked((UUID)uuid) && !(member = DiscordIntegration.INSTANCE.getMemberById(LinkManager.getLink(null, (UUID)uuid).discordID)).getRoles().contains(linkedRole)) {
                    guild.addRoleToMember((UserSnowflake)member, linkedRole).queue();
                }
            });
        }
    }
}

