/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.fabric.util;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dcshadow.com.vdurmont.emoji.EmojiParser;
import dcshadow.net.kyori.adventure.text.Component;
import dcshadow.net.kyori.adventure.text.TextReplacementConfig;
import dcshadow.net.kyori.adventure.text.event.ClickEvent;
import dcshadow.net.kyori.adventure.text.event.HoverEvent;
import dcshadow.net.kyori.adventure.text.event.HoverEventSource;
import dcshadow.net.kyori.adventure.text.format.Style;
import dcshadow.net.kyori.adventure.text.format.TextColor;
import dcshadow.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import dcshadow.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.Localization;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.LinkManager;
import de.erdbeerbaerlp.dcintegration.common.util.ComponentUtils;
import de.erdbeerbaerlp.dcintegration.common.util.McServerInterface;
import de.erdbeerbaerlp.dcintegration.common.util.MinecraftPermission;
import de.erdbeerbaerlp.dcintegration.fabric.command.DCCommandSender;
import de.erdbeerbaerlp.dcintegration.fabric.util.FabricMessageUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.entities.emoji.EmojiUnion;
import net.dv8tion.jda.api.interactions.InteractionHook;
import net.dv8tion.jda.api.requests.RestAction;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2178;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;

public class FabricServerInterface
implements McServerInterface {
    private final MinecraftServer server;

    public FabricServerInterface(MinecraftServer minecraftServer) {
        this.server = minecraftServer;
    }

    public int getMaxPlayers() {
        return this.server.method_3802();
    }

    public int getOnlinePlayers() {
        return this.server.method_3788();
    }

    public void sendIngameMessage(Component msg) {
        List l = this.server.method_3760().method_14571();
        try {
            for (class_3222 p : l) {
                if (!this.playerHasPermissions((class_1657)p, MinecraftPermission.READ_MESSAGES, MinecraftPermission.USER)) {
                    return;
                }
                if (DiscordIntegration.INSTANCE.ignoringPlayers.contains(p.method_5667()) || LinkManager.isPlayerLinked((UUID)p.method_5667()) && LinkManager.getLink(null, (UUID)p.method_5667()).settings.ignoreDiscordChatIngame) continue;
                Map.Entry ping = ComponentUtils.parsePing((Component)msg, (UUID)p.method_5667(), (String)p.method_5477().getString());
                String jsonComp = ((String)GsonComponentSerializer.gson().serialize((Component)ping.getValue())).replace("\\\\n", "\n");
                class_2561 comp = class_2178.method_9281().method_9283(new StringReader(jsonComp));
                p.method_7353(comp, false);
                if (!((Boolean)ping.getKey()).booleanValue() || !LinkManager.isPlayerLinked((UUID)p.method_5667()) || !LinkManager.getLink(null, (UUID)p.method_5667()).settings.pingSound) continue;
                p.field_13987.method_14364((class_2596)new class_2767((class_6880)class_3417.field_14622, class_3419.field_15250, p.method_19538().field_1352, p.method_19538().field_1351, p.method_19538().field_1350, 1.0f, 1.0f, this.server.method_30002().method_8412()));
            }
            String jsonComp = ((String)GsonComponentSerializer.gson().serialize(msg)).replace("\\\\n", "\n");
            class_2561 comp = class_2178.method_9281().method_9283(new StringReader(jsonComp));
            this.server.method_43496(comp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendIngameReaction(Member member, RestAction<Message> retrieveMessage, UUID targetUUID, EmojiUnion reactionEmote) {
        List l = this.server.method_3760().method_14571();
        for (class_3222 p : l) {
            if (!this.playerHasPermissions((class_1657)p, MinecraftPermission.READ_MESSAGES, MinecraftPermission.USER)) {
                return;
            }
            if (!p.method_5667().equals(targetUUID) || DiscordIntegration.INSTANCE.ignoringPlayers.contains(p.method_5667()) || !LinkManager.isPlayerLinked((UUID)p.method_5667()) || LinkManager.getLink(null, (UUID)p.method_5667()).settings.ignoreDiscordChatIngame || LinkManager.getLink(null, (UUID)p.method_5667()).settings.ignoreReactions) continue;
            Object emote = reactionEmote.getType() == Emoji.Type.UNICODE ? EmojiParser.parseToAliases((String)reactionEmote.getName()) : ":" + reactionEmote.getName() + ":";
            Style.Builder memberStyle = Style.style();
            if (Configuration.instance().messages.discordRoleColorIngame) {
                memberStyle = memberStyle.color(TextColor.color((int)member.getColorRaw()));
            }
            Component user = Component.text((String)member.getEffectiveName()).style(memberStyle.clickEvent(ClickEvent.suggestCommand((String)("<@" + member.getId() + ">"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)Localization.instance().discordUserHover.replace("%user#tag%", member.getUser().getAsTag()).replace("%user%", member.getEffectiveName()).replace("%id%", member.getUser().getId())))));
            TextReplacementConfig userReplacer = ComponentUtils.replaceLiteral((String)"%user%", (Component)user);
            TextReplacementConfig emoteReplacer = ComponentUtils.replaceLiteral((String)"%emote%", (String)emote);
            Component out = LegacyComponentSerializer.legacySection().deserialize(Localization.instance().reactionMessage).replaceText(userReplacer).replaceText(emoteReplacer);
            if (Localization.instance().reactionMessage.contains("%msg%")) {
                retrieveMessage.submit().thenAccept(m -> {
                    String msg = FabricMessageUtils.formatEmoteMessage((List)m.getMentions().getCustomEmojis(), (String)m.getContentDisplay());
                    TextReplacementConfig msgReplacer = ComponentUtils.replaceLiteral((String)"%msg%", (String)msg);
                    this.sendReactionMCMessage(p, out.replaceText(msgReplacer));
                });
                continue;
            }
            this.sendReactionMCMessage(p, out);
        }
    }

    private void sendReactionMCMessage(class_3222 target, Component msgComp) {
        String jsonComp = ((String)GsonComponentSerializer.gson().serialize(msgComp)).replace("\\\\n", "\n");
        try {
            class_2561 comp = class_2178.method_9281().method_9283(new StringReader(jsonComp));
            target.method_7353(comp, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void runMcCommand(String cmd, CompletableFuture<InteractionHook> cmdMsg, User user) {
        DCCommandSender s = new DCCommandSender(cmdMsg, user, this.server);
        try {
            this.server.method_3734().method_9235().execute(cmd.trim(), (Object)s);
        }
        catch (CommandSyntaxException e) {
            s.method_9213(class_2561.method_30163((String)e.getMessage()));
        }
    }

    public HashMap<UUID, String> getPlayers() {
        HashMap<UUID, String> players = new HashMap<UUID, String>();
        for (class_3222 p : this.server.method_3760().method_14571()) {
            players.put(p.method_5667(), p.method_5476().getString().isEmpty() ? p.method_5477().getString() : p.method_5476().getString());
        }
        return players;
    }

    public void sendIngameMessage(String msg, UUID player) {
        class_3222 p = this.server.method_3760().method_14602(player);
        if (p != null) {
            p.method_43496(class_2561.method_30163((String)msg));
        }
    }

    public boolean isOnlineMode() {
        return Configuration.instance().bungee.isBehindBungee || this.server.method_3828();
    }

    public String getNameFromUUID(UUID uuid) {
        return this.server.method_3844().fillProfileProperties(new GameProfile(uuid, ""), false).getName();
    }

    public String getLoaderName() {
        return "Fabric";
    }

    public boolean playerHasPermissions(UUID player, String ... permissions) {
        for (String permission : permissions) {
            for (MinecraftPermission perm : MinecraftPermission.values()) {
                if (!perm.getAsString().equals(permission) || !((Boolean)Permissions.check((UUID)player, (String)perm.getAsString(), (boolean)perm.getDefaultValue()).join()).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public String runMCCommand(String cmd) {
        DCCommandSender s = new DCCommandSender(this.server);
        try {
            this.server.method_3734().method_9235().execute(cmd.trim(), (Object)s);
            return s.message.toString();
        }
        catch (CommandSyntaxException e) {
            return e.getMessage();
        }
    }

    public boolean playerHasPermissions(class_1657 player, String ... permissions) {
        for (String permission : permissions) {
            for (MinecraftPermission value : MinecraftPermission.values()) {
                if (!value.getAsString().equals(permission) || !Permissions.check((class_1297)player, (String)value.getAsString(), (boolean)value.getDefaultValue())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean playerHasPermissions(class_1657 player, MinecraftPermission ... permissions) {
        String[] permissionStrings = new String[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            permissionStrings[i] = permissions[i].getAsString();
        }
        return this.playerHasPermissions(player, permissionStrings);
    }
}

