/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.blocks.bronze_saw;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.saw.CuttingRecipe;
import com.simibubi.create.content.kinetics.saw.SawBlockEntity;
import com.simibubi.create.content.kinetics.saw.SawFilterSlot;
import com.simibubi.create.content.processing.recipe.ProcessingInventory;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.recipe.RecipeConditions;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.TreeCutter;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2211;
import net.minecraft.class_2248;
import net.minecraft.class_2266;
import net.minecraft.class_2283;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2391;
import net.minecraft.class_2393;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2511;
import net.minecraft.class_2520;
import net.minecraft.class_2523;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3956;
import net.minecraft.class_3975;
import uwu.lopyluna.create_dd.blocks.drill.bronze.BronzeDrillBlock;
import uwu.lopyluna.create_dd.config.DDConfigs;
import uwu.lopyluna.create_dd.registry.DDTags;

public class BronzeSawBlockEntity
extends SawBlockEntity {
    private static final Object cuttingRecipesKey = new Object();
    private int recipeIndex;
    private FilteringBehaviour filtering;
    private class_1799 playEvent;

    public BronzeSawBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.inventory = new ProcessingInventory(this::start).withSlotLimit((Boolean)DDConfigs.server().recipes.bulkCutting.get() == false);
        this.inventory.remainingTime = -1.0f;
        this.recipeIndex = 0;
        this.playEvent = class_1799.field_8037;
    }

    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10566("Inventory", (class_2520)this.inventory.serializeNBT());
        compound.method_10569("RecipeIndex", this.recipeIndex);
        super.write(compound, clientPacket);
        if (!clientPacket || this.playEvent.method_7960()) {
            return;
        }
        compound.method_10566("PlayEvent", this.playEvent.serializeNBT());
        this.playEvent = class_1799.field_8037;
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.inventory.deserializeNBT(compound.method_10562("Inventory"));
        this.recipeIndex = compound.method_10550("RecipeIndex");
        if (compound.method_10545("PlayEvent")) {
            this.playEvent = class_1799.method_7915((class_2487)compound.method_10562("PlayEvent"));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (!this.playEvent.method_7960()) {
            boolean isWood = false;
            class_1792 item = this.playEvent.method_7909();
            if (item instanceof class_1747) {
                class_2248 block = ((class_1747)item).method_7711();
                isWood = block.method_9573(block.method_9564()) == class_2498.field_11547;
            }
            this.spawnEventParticles(this.playEvent);
            this.playEvent = class_1799.field_8037;
            if (!isWood) {
                AllSoundEvents.SAW_ACTIVATE_STONE.playAt(this.field_11863, (class_2382)this.field_11867, 3.0f, 1.0f, true);
            } else {
                AllSoundEvents.SAW_ACTIVATE_WOOD.playAt(this.field_11863, (class_2382)this.field_11867, 3.0f, 1.0f, true);
            }
            return;
        }
    }

    protected class_2338 getBreakingPos() {
        return this.method_11016().method_10093((class_2350)this.method_11010().method_11654((class_2769)BronzeDrillBlock.FACING));
    }

    protected float getBreakSpeed() {
        return Math.abs(this.getSpeed() / 35.0f);
    }

    public boolean canBreak(class_2680 stateToBreak, float blockHardness) {
        boolean sawable = BronzeSawBlockEntity.isSawable(stateToBreak);
        return super.canBreak(stateToBreak, blockHardness) && sawable;
    }

    public static boolean isSawable(class_2680 stateToBreak) {
        if (stateToBreak.method_26164(class_3481.field_15462)) {
            return false;
        }
        if (TreeCutter.isLog((class_2680)stateToBreak) || stateToBreak.method_26164(class_3481.field_15503)) {
            return true;
        }
        if (TreeCutter.isRoot((class_2680)stateToBreak)) {
            return true;
        }
        class_2248 block = stateToBreak.method_26204();
        if (block instanceof class_2211) {
            return true;
        }
        if (block instanceof class_2511) {
            return true;
        }
        if (block instanceof class_2266) {
            return true;
        }
        if (block instanceof class_2523) {
            return true;
        }
        if (block instanceof class_2391) {
            return true;
        }
        if (block instanceof class_2393) {
            return true;
        }
        if (block instanceof class_2283) {
            return true;
        }
        if (TreeCutter.canDynamicTreeCutFrom((class_2248)block)) {
            return true;
        }
        if (stateToBreak.method_26164(DDTags.AllBlockTags.bronze_saw_immune.tag)) {
            return false;
        }
        return stateToBreak.method_26164(DDTags.AllBlockTags.bronze_saw_valid.tag);
    }

    public void tick() {
        if (this.shouldRun() && this.ticksUntilNextProgress < 0) {
            this.destroyNextTick();
        }
        super.tick();
        if (!this.canProcess()) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.inventory.remainingTime == -1.0f) {
            if (!this.inventory.method_5442() && !this.inventory.appliedRecipe) {
                this.start(this.inventory.getStackInSlot(0));
            }
            return;
        }
        float processingSpeed = class_3532.method_15363((float)(Math.abs(this.getSpeed()) / 24.0f), (float)1.0f, (float)128.0f);
        this.inventory.remainingTime -= processingSpeed;
        if (this.inventory.remainingTime > 0.0f) {
            this.spawnParticles(this.inventory.getStackInSlot(0));
        }
        if (this.inventory.remainingTime < 5.0f && !this.inventory.appliedRecipe) {
            if (this.field_11863.field_9236 && !this.isVirtual()) {
                return;
            }
            this.playEvent = this.inventory.getStackInSlot(0);
            this.applyRecipe();
            this.inventory.appliedRecipe = true;
            this.inventory.recipeDuration = 20.0f;
            this.inventory.remainingTime = 20.0f;
            this.sendData();
            return;
        }
        class_243 itemMovement = this.getItemMovementVec();
        class_2350 itemMovementFacing = class_2350.method_10142((double)itemMovement.field_1352, (double)itemMovement.field_1351, (double)itemMovement.field_1350);
        if (this.inventory.remainingTime > 0.0f) {
            return;
        }
        this.inventory.remainingTime = 0.0f;
        for (int slot = 0; slot < this.inventory.getSlots().size(); ++slot) {
            class_1799 tryExportingToBeltFunnel;
            class_1799 stack = this.inventory.getStackInSlot(slot);
            if (stack.method_7960() || (tryExportingToBeltFunnel = ((DirectBeltInputBehaviour)this.getBehaviour(DirectBeltInputBehaviour.TYPE)).tryExportingToBeltFunnel(stack, itemMovementFacing.method_10153(), false)) == null) continue;
            if (tryExportingToBeltFunnel.method_7947() != stack.method_7947()) {
                this.inventory.setStackInSlot(slot, tryExportingToBeltFunnel);
                this.notifyUpdate();
                return;
            }
            if (tryExportingToBeltFunnel.method_7960()) continue;
            return;
        }
        class_2338 nextPos = this.field_11867.method_10081((class_2382)class_2338.method_49638((class_2374)itemMovement));
        DirectBeltInputBehaviour behaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((class_1922)this.field_11863, (class_2338)nextPos, (BehaviourType)DirectBeltInputBehaviour.TYPE);
        if (behaviour != null) {
            boolean changed = false;
            if (!behaviour.canInsertFromSide(itemMovementFacing)) {
                return;
            }
            if (this.field_11863.field_9236 && !this.isVirtual()) {
                return;
            }
            for (int slot = 0; slot < this.inventory.getSlots().size(); ++slot) {
                class_1799 remainder;
                class_1799 stack = this.inventory.getStackInSlot(slot);
                if (stack.method_7960() || (remainder = behaviour.handleInsertion(stack, itemMovementFacing, false)).equals(stack)) continue;
                this.inventory.setStackInSlot(slot, remainder);
                changed = true;
            }
            if (changed) {
                this.method_5431();
                this.sendData();
            }
            return;
        }
        class_243 outPos = VecHelper.getCenterOf((class_2382)this.field_11867).method_1019(itemMovement.method_1021(0.5).method_1031(0.0, 0.5, 0.0));
        class_243 outMotion = itemMovement.method_1021(0.0625).method_1031(0.0, 0.125, 0.0);
        for (int slot = 0; slot < this.inventory.getSlots().size(); ++slot) {
            class_1799 stack = this.inventory.getStackInSlot(slot);
            if (stack.method_7960()) continue;
            class_1542 entityIn = new class_1542(this.field_11863, outPos.field_1352, outPos.field_1351, outPos.field_1350, stack);
            entityIn.method_18799(outMotion);
            this.field_11863.method_8649((class_1297)entityIn);
        }
        this.inventory.clear();
        this.field_11863.method_8455(this.field_11867, this.method_11010().method_26204());
        this.inventory.remainingTime = -1.0f;
        this.sendData();
    }

    public void invalidate() {
        super.invalidate();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new SawFilterSlot()).forRecipes();
        behaviours.add((BlockEntityBehaviour)this.filtering);
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this).allowingBeltFunnelsWhen(() -> this.canProcess()));
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.SAW_PROCESSING});
    }

    private void applyRecipe() {
        List<class_1860<?>> recipes = this.getRecipes();
        if (recipes.isEmpty()) {
            return;
        }
        if (this.recipeIndex >= recipes.size()) {
            this.recipeIndex = 0;
        }
        class_1860<?> recipe = recipes.get(this.recipeIndex);
        int rolls = this.inventory.getStackInSlot(0).method_7947();
        this.inventory.clear();
        ArrayList list = new ArrayList();
        for (int roll = 0; roll < rolls; ++roll) {
            List<class_1799> results = new LinkedList();
            if (recipe instanceof CuttingRecipe) {
                results = ((CuttingRecipe)recipe).rollResults();
            } else if (recipe instanceof class_3975 || recipe.method_17716() == woodcuttingRecipeType.get()) {
                results.add(recipe.method_8110(this.field_11863.method_30349()).method_7972());
            }
            for (int i = 0; i < results.size(); ++i) {
                class_1799 stack = (class_1799)results.get(i);
                ItemHelper.addToList((class_1799)stack, list);
            }
        }
        for (int slot = 0; slot < list.size() && slot + 1 < this.inventory.getSlots().size(); ++slot) {
            this.inventory.setStackInSlot(slot + 1, (class_1799)list.get(slot));
        }
        this.award(AllAdvancements.SAW_PROCESSING);
    }

    private List<? extends class_1860<?>> getRecipes() {
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((class_1937)this.field_11863, (class_1799)this.inventory.getStackInSlot(0), (class_3956)AllRecipeTypes.CUTTING.getType(), CuttingRecipe.class);
        if (assemblyRecipe.isPresent() && this.filtering.test(((CuttingRecipe)assemblyRecipe.get()).method_8110(this.field_11863.method_30349()))) {
            return ImmutableList.of((Object)((CuttingRecipe)assemblyRecipe.get()));
        }
        Predicate types = RecipeConditions.isOfType((class_3956[])new class_3956[]{AllRecipeTypes.CUTTING.getType(), (Boolean)DDConfigs.server().recipes.allowStonecuttingOnSaw.get() != false ? class_3956.field_17641 : null, (Boolean)DDConfigs.server().recipes.allowWoodcuttingOnSaw.get() != false ? (class_3956)woodcuttingRecipeType.get() : null});
        List startedSearch = RecipeFinder.get((Object)cuttingRecipesKey, (class_1937)this.field_11863, (Predicate)types);
        return startedSearch.stream().filter(RecipeConditions.outputMatchesFilter((FilteringBehaviour)this.filtering)).filter(RecipeConditions.firstIngredientMatches((class_1799)this.inventory.getStackInSlot(0))).filter(r -> !AllRecipeTypes.shouldIgnoreInAutomation((class_1860)r)).collect(Collectors.toList());
    }

    public void start(class_1799 inserted) {
        class_1860<?> recipe;
        if (!this.canProcess()) {
            return;
        }
        if (this.inventory.method_5442()) {
            return;
        }
        if (this.field_11863.field_9236 && !this.isVirtual()) {
            return;
        }
        List<class_1860<?>> recipes = this.getRecipes();
        boolean valid = !recipes.isEmpty();
        int time = 50;
        if (recipes.isEmpty()) {
            this.inventory.recipeDuration = 10.0f;
            this.inventory.remainingTime = 10.0f;
            this.inventory.appliedRecipe = false;
            this.sendData();
            return;
        }
        if (valid) {
            ++this.recipeIndex;
            if (this.recipeIndex >= recipes.size()) {
                this.recipeIndex = 0;
            }
        }
        if ((recipe = recipes.get(this.recipeIndex)) instanceof CuttingRecipe) {
            time = ((CuttingRecipe)recipe).getProcessingDuration();
        }
        this.inventory.recipeDuration = this.inventory.remainingTime = (float)(time * Math.max(1, inserted.method_7947() / 5));
        this.inventory.appliedRecipe = false;
        this.sendData();
    }
}

