/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.blocks.flywheel;

import com.google.common.collect.Lists;
import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import uwu.lopyluna.create_dd.blocks.flywheel.FlywheelBlock;
import uwu.lopyluna.create_dd.blocks.flywheel.FlywheelBlockEntity;
import uwu.lopyluna.create_dd.client.registry.DDBlockPartials;

public class FlyWheelInstance
extends KineticBlockEntityInstance<FlywheelBlockEntity>
implements DynamicInstance {
    protected final class_2350 facing;
    protected final class_2350 connection;
    protected boolean connectedLeft;
    protected float connectorAngleMult;
    protected final RotatingData shaft;
    protected final ModelData wheel;
    protected List<ModelData> connectors;
    protected ModelData upperRotating;
    protected ModelData lowerRotating;
    protected ModelData upperSliding;
    protected ModelData lowerSliding;
    protected float lastAngle = Float.NaN;

    public FlyWheelInstance(MaterialManager modelManager, FlywheelBlockEntity tile) {
        super(modelManager, (KineticBlockEntity)tile);
        this.facing = (class_2350)this.blockState.method_11654((class_2769)class_2741.field_12481);
        this.shaft = this.setup((RotatingData)this.shaftModel().createInstance());
        class_2680 referenceState = this.blockState.method_26186(class_2470.field_11463);
        this.wheel = (ModelData)this.getTransformMaterial().getModel(DDBlockPartials.FLYWHEEL, referenceState, (class_2350)referenceState.method_11654((class_2769)class_2741.field_12481)).createInstance();
        this.connection = FlywheelBlock.getConnection(this.blockState);
        if (this.connection != null) {
            this.connectedLeft = this.blockState.method_11654(FlywheelBlock.CONNECTION) == FlywheelBlock.ConnectionState.LEFT;
            boolean flipAngle = this.connection.method_10166() == class_2350.class_2351.field_11048 ^ this.connection.method_10171() == class_2350.class_2352.field_11060;
            this.connectorAngleMult = flipAngle ? -1.0f : 1.0f;
            Material mat = this.getTransformMaterial();
            this.upperRotating = (ModelData)mat.getModel(DDBlockPartials.FLYWHEEL_UPPER_ROTATING, this.blockState).createInstance();
            this.lowerRotating = (ModelData)mat.getModel(DDBlockPartials.FLYWHEEL_LOWER_ROTATING, this.blockState).createInstance();
            this.upperSliding = (ModelData)mat.getModel(DDBlockPartials.FLYWHEEL_UPPER_SLIDING, this.blockState).createInstance();
            this.lowerSliding = (ModelData)mat.getModel(DDBlockPartials.FLYWHEEL_LOWER_SLIDING, this.blockState).createInstance();
            this.connectors = Lists.newArrayList((Object[])new ModelData[]{this.upperRotating, this.lowerRotating, this.upperSliding, this.lowerSliding});
        } else {
            this.connectors = Collections.emptyList();
        }
        this.animate(tile.angle);
    }

    public void beginFrame() {
        float partialTicks = AnimationTickHolder.getPartialTicks();
        float speed = ((FlywheelBlockEntity)this.blockEntity).visualSpeed.getValue(partialTicks) * 3.0f / 10.0f;
        float angle = ((FlywheelBlockEntity)this.blockEntity).angle + speed * partialTicks;
        if ((double)Math.abs(angle - this.lastAngle) < 0.001) {
            return;
        }
        this.animate(angle);
        this.lastAngle = angle;
    }

    private void animate(float angle) {
        class_4587 ms = new class_4587();
        TransformStack msr = TransformStack.cast((class_4587)ms);
        msr.translate((class_2382)this.getInstancePosition());
        if (this.connection != null) {
            float rotation = angle * this.connectorAngleMult;
            ms.method_22903();
            this.rotateToFacing(msr, this.connection);
            ms.method_22903();
            this.transformConnector(msr, true, true, rotation, this.connectedLeft);
            this.upperRotating.setTransform(ms);
            ms.method_22909();
            ms.method_22903();
            this.transformConnector(msr, false, true, rotation, this.connectedLeft);
            this.lowerRotating.setTransform(ms);
            ms.method_22909();
            ms.method_22903();
            this.transformConnector(msr, true, false, rotation, this.connectedLeft);
            this.upperSliding.setTransform(ms);
            ms.method_22909();
            ms.method_22903();
            this.transformConnector(msr, false, false, rotation, this.connectedLeft);
            this.lowerSliding.setTransform(ms);
            ms.method_22909();
            ms.method_22909();
        }
        ((TransformStack)((TransformStack)msr.centre()).rotate(class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)this.facing.method_10166()), AngleHelper.rad((double)angle))).unCentre();
        this.wheel.setTransform(ms);
    }

    public void update() {
        this.updateRotation(this.shaft);
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.shaft, this.wheel});
        if (this.connection != null) {
            this.relight(this.pos.method_10093(this.connection), this.connectors.stream());
        }
    }

    public void remove() {
        this.shaft.delete();
        this.wheel.delete();
        this.connectors.forEach(InstanceData::delete);
        this.connectors.clear();
    }

    protected Instancer<RotatingData> shaftModel() {
        class_2350 opposite = this.facing.method_10153();
        return this.getRotatingMaterial().getModel(AllPartialModels.SHAFT_HALF, this.blockState, opposite);
    }

    protected void transformConnector(TransformStack ms, boolean upper, boolean rotating, float angle, boolean flip) {
        float shift = upper ? 0.25f : -0.125f;
        float offset = upper ? 0.25f : 0.25f;
        float radians = (float)((double)(angle / 180.0f) * Math.PI);
        float shifting = class_3532.method_15374((float)radians) * shift + offset;
        float maxAngle = upper ? -5.0f : -15.0f;
        float minAngle = upper ? -45.0f : 5.0f;
        float barAngle = 0.0f;
        if (rotating) {
            barAngle = class_3532.method_16439((float)((class_3532.method_15374((float)((float)((double)radians + 1.5707963267948966))) + 1.0f) / 2.0f), (float)minAngle, (float)maxAngle);
        }
        float pivotX = (upper ? 8.0f : 3.0f) / 16.0f;
        float pivotY = (upper ? 8.0f : 2.0f) / 16.0f;
        float pivotZ = (upper ? 23.0f : 21.5f) / 16.0f;
        ms.translate((double)pivotX, (double)pivotY, (double)(pivotZ + shifting));
        if (rotating) {
            ms.rotate(class_2350.field_11034, AngleHelper.rad((double)barAngle));
        }
        ms.translate((double)(-pivotX), (double)(-pivotY), (double)(-pivotZ));
        if (flip && !upper) {
            ms.translate(0.5625, 0.0, 0.0);
        }
    }

    protected void rotateToFacing(TransformStack buffer, class_2350 facing) {
        ((TransformStack)((TransformStack)buffer.centre()).rotate(class_2350.field_11036, AngleHelper.rad((double)AngleHelper.horizontalAngle((class_2350)facing)))).unCentre();
    }
}

