/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.item.sawtool;

import com.simibubi.create.AllTags;
import com.simibubi.create.compat.Mods;
import com.simibubi.create.compat.dynamictrees.DynamicTree;
import com.simibubi.create.foundation.utility.AbstractBlockBreakQueue;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2211;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2266;
import net.minecraft.class_2279;
import net.minecraft.class_2283;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2391;
import net.minecraft.class_2393;
import net.minecraft.class_2397;
import net.minecraft.class_2523;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import org.jetbrains.annotations.Nullable;

public class TreeCutter {
    public static final Tree NO_TREE = new Tree(Collections.emptyList(), Collections.emptyList());

    public static boolean canDynamicTreeCutFrom(class_2248 startBlock) {
        return Mods.DYNAMICTREES.runIfInstalled(() -> () -> DynamicTree.isDynamicBranch((class_2248)startBlock)).orElse(false);
    }

    @Nonnull
    public static Optional<AbstractBlockBreakQueue> findDynamicTree(class_2248 startBlock, class_2338 pos) {
        if (TreeCutter.canDynamicTreeCutFrom(startBlock)) {
            return Mods.DYNAMICTREES.runIfInstalled(() -> () -> new DynamicTree(pos));
        }
        return Optional.empty();
    }

    @Nonnull
    public static Tree findTree(@Nullable class_1922 reader, class_2338 pos) {
        if (reader == null) {
            return NO_TREE;
        }
        ArrayList<class_2338> logs = new ArrayList<class_2338>();
        ArrayList<class_2338> leaves = new ArrayList<class_2338>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        LinkedList<class_2338> frontier = new LinkedList<class_2338>();
        class_2680 stateAbove = reader.method_8320(pos.method_10084());
        if (TreeCutter.isVerticalPlant(stateAbove)) {
            class_2338 current;
            logs.add(pos.method_10084());
            for (int i = 1; i < 256 && TreeCutter.isVerticalPlant(reader.method_8320(current = pos.method_10086(i))); ++i) {
                logs.add(current);
            }
            Collections.reverse(logs);
            return new Tree(logs, leaves);
        }
        if (TreeCutter.isChorus(stateAbove)) {
            frontier.add(pos.method_10084());
            while (!frontier.isEmpty()) {
                class_2338 current = (class_2338)frontier.remove(0);
                visited.add(current);
                logs.add(current);
                for (class_2350 direction : Iterate.directions) {
                    class_2338 offset = current.method_10093(direction);
                    if (visited.contains(offset) || !TreeCutter.isChorus(reader.method_8320(offset))) continue;
                    frontier.add(offset);
                }
            }
            Collections.reverse(logs);
            return new Tree(logs, leaves);
        }
        if (!TreeCutter.validateCut(reader, pos)) {
            return NO_TREE;
        }
        visited.add(pos);
        class_2338.method_20437((class_2338)pos.method_10069(-1, 0, -1), (class_2338)pos.method_10069(1, 1, 1)).forEach(p -> frontier.add(new class_2338((class_2382)p)));
        while (!frontier.isEmpty()) {
            class_2338 currentPos2 = (class_2338)frontier.remove(0);
            if (visited.contains(currentPos2)) continue;
            visited.add(currentPos2);
            if (!TreeCutter.isLog(reader.method_8320(currentPos2))) continue;
            logs.add(currentPos2);
            TreeCutter.forNeighbours(currentPos2, visited, true, p -> frontier.add(new class_2338((class_2382)p)));
        }
        visited.clear();
        visited.addAll(logs);
        frontier.addAll(logs);
        while (!frontier.isEmpty()) {
            class_2338 prevPos = (class_2338)frontier.remove(0);
            if (!logs.contains(prevPos) && visited.contains(prevPos)) continue;
            visited.add(prevPos);
            class_2680 prevState = reader.method_8320(prevPos);
            int prevLeafDistance = TreeCutter.isLeaf(prevState) ? TreeCutter.getLeafDistance(prevState) : 0;
            TreeCutter.forNeighbours(prevPos, visited, false, currentPos -> {
                class_2680 state = reader.method_8320(currentPos);
                class_2338 subtract = currentPos.method_10059((class_2382)pos);
                class_2338 currentPosImmutable = currentPos.method_10062();
                if (AllTags.AllBlockTags.TREE_ATTACHMENTS.matches(state)) {
                    leaves.add(currentPosImmutable);
                    visited.add(currentPosImmutable);
                    return;
                }
                int horizontalDistance = Math.max(Math.abs(subtract.method_10263()), Math.abs(subtract.method_10260()));
                if (horizontalDistance <= TreeCutter.nonDecayingLeafDistance(state)) {
                    leaves.add(currentPosImmutable);
                    frontier.add(currentPosImmutable);
                    return;
                }
                if (TreeCutter.isLeaf(state) && TreeCutter.getLeafDistance(state) > prevLeafDistance) {
                    leaves.add(currentPosImmutable);
                    frontier.add(currentPosImmutable);
                    return;
                }
            });
        }
        return new Tree(logs, leaves);
    }

    private static int getLeafDistance(class_2680 state) {
        class_2758 distanceProperty = class_2397.field_11199;
        for (class_2769 property : state.method_11656().keySet()) {
            if (!(property instanceof class_2758)) continue;
            class_2758 ip = (class_2758)property;
            if (!property.method_11899().equals("distance")) continue;
            distanceProperty = ip;
        }
        return (Integer)state.method_11654((class_2769)distanceProperty);
    }

    public static boolean isChorus(class_2680 stateAbove) {
        return stateAbove.method_26204() instanceof class_2283 || stateAbove.method_26204() instanceof class_2279;
    }

    public static boolean isVerticalPlant(class_2680 stateAbove) {
        class_2248 block = stateAbove.method_26204();
        if (block instanceof class_2211) {
            return true;
        }
        if (block instanceof class_2266) {
            return true;
        }
        if (block instanceof class_2523) {
            return true;
        }
        if (block instanceof class_2391) {
            return true;
        }
        return block instanceof class_2393;
    }

    private static boolean validateCut(class_1922 reader, class_2338 pos) {
        HashSet<class_2338> visited = new HashSet<class_2338>();
        LinkedList<class_2338> frontier = new LinkedList<class_2338>();
        frontier.add(pos);
        frontier.add(pos.method_10084());
        int posY = pos.method_10264();
        while (!frontier.isEmpty()) {
            boolean lowerLayer;
            class_2338 currentPos = (class_2338)frontier.remove(0);
            visited.add(currentPos);
            boolean bl = lowerLayer = currentPos.method_10264() == posY;
            if (!TreeCutter.isLog(reader.method_8320(currentPos))) continue;
            if (!lowerLayer && !pos.equals((Object)currentPos.method_10074()) && TreeCutter.isLog(reader.method_8320(currentPos.method_10074()))) {
                return false;
            }
            for (class_2350 direction : Iterate.directions) {
                class_2338 offset;
                if (direction == class_2350.field_11033 || direction == class_2350.field_11036 && !lowerLayer || visited.contains(offset = currentPos.method_10093(direction))) continue;
                frontier.add(offset);
            }
        }
        return true;
    }

    private static void forNeighbours(class_2338 pos, Set<class_2338> visited, boolean up, Consumer<class_2338> acceptor) {
        class_2338.method_20437((class_2338)pos.method_10069(-1, up ? 0 : -1, -1), (class_2338)pos.method_10069(1, 1, 1)).filter(((Predicate<class_2338>)visited::contains).negate()).forEach(acceptor);
    }

    public static boolean isLog(class_2680 state) {
        return state.method_26164(class_3481.field_15475) || AllTags.AllBlockTags.SLIMY_LOGS.matches(state) || state.method_27852(class_2246.field_10556);
    }

    private static int nonDecayingLeafDistance(class_2680 state) {
        if (state.method_27852(class_2246.field_10240)) {
            return 2;
        }
        if (state.method_27852(class_2246.field_10580)) {
            return 3;
        }
        if (state.method_26164(class_3481.field_21954) || state.method_27852(class_2246.field_22123) || state.method_27852(class_2246.field_22124)) {
            return 3;
        }
        return -1;
    }

    private static boolean isLeaf(class_2680 state) {
        for (class_2769 property : state.method_11656().keySet()) {
            if (!(property instanceof class_2758) || !property.method_11899().equals("distance")) continue;
            return true;
        }
        return false;
    }

    public static class Tree
    extends AbstractBlockBreakQueue {
        final List<class_2338> logs;
        final List<class_2338> leaves;

        public Tree(List<class_2338> logs, List<class_2338> leaves) {
            this.logs = logs;
            this.leaves = leaves;
        }

        public void destroyBlocks(class_1937 world, class_1799 toDamage, @Nullable class_1657 playerEntity, BiConsumer<class_2338, class_1799> drop) {
            this.logs.forEach(this.makeCallbackFor(world, 0.5f, toDamage, playerEntity, drop));
            this.leaves.forEach(leaf -> {
                if (world.method_8608()) {
                    return;
                }
                class_2248.method_9511((class_2680)world.method_8320(leaf), (class_1937)world, (class_2338)leaf, null, (class_1297)playerEntity, (class_1799)toDamage);
                world.method_8650(leaf, false);
            });
        }
    }
}

