/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.gui;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.storagemod.Config;
import com.tom.storagemod.StorageModClient;
import com.tom.storagemod.gui.ControllMode;
import com.tom.storagemod.gui.CraftingTerminalScreen;
import com.tom.storagemod.gui.GuiButton;
import com.tom.storagemod.gui.StorageTerminalMenu;
import com.tom.storagemod.platform.PlatformContainerScreen;
import com.tom.storagemod.platform.PlatformEditBox;
import com.tom.storagemod.util.ComponentJoiner;
import com.tom.storagemod.util.IAutoFillTerminal;
import com.tom.storagemod.util.IDataReceiver;
import com.tom.storagemod.util.NumberFormatUtil;
import com.tom.storagemod.util.StoredItemStack;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_7919;
import net.minecraft.class_7923;
import org.lwjgl.glfw.GLFW;

public abstract class AbstractStorageTerminalScreen<T extends StorageTerminalMenu>
extends PlatformContainerScreen<T>
implements IDataReceiver {
    private static final LoadingCache<StoredItemStack, List<String>> tooltipCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<StoredItemStack, List<String>>(){

        public List<String> load(StoredItemStack key) throws Exception {
            return key.getStack().method_7950((class_1657)class_310.method_1551().field_1724, AbstractStorageTerminalScreen.getTooltipFlag()).stream().map(class_2561::getString).collect(Collectors.toList());
        }
    });
    private static final LoadingCache<StoredItemStack, String> nbtCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build(CacheLoader.from(key -> String.valueOf(key.getStack().method_7969())));
    private static final LoadingCache<StoredItemStack, List<String>> tagCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build(CacheLoader.from(key -> key.getStack().method_40133().map(t -> t.comp_327().toString()).toList()));
    protected class_310 mc = class_310.method_1551();
    protected float currentScroll;
    protected boolean isScrolling;
    private boolean refreshItemList;
    protected boolean wasClicking;
    protected PlatformEditBox searchField;
    protected int slotIDUnderMouse = -1;
    protected int controllMode;
    protected int rowCount;
    protected int searchType;
    private String searchLast = "";
    protected boolean loadedSearch = false;
    protected boolean ghostItems;
    protected boolean tallMode;
    public final int textureSlotCount;
    public final int guiHeight;
    public final int slotStartX;
    public final int slotStartY;
    private StoredItemStack.IStoredItemStackComparator comparator = new StoredItemStack.ComparatorAmount(false);
    protected GuiButton buttonSortingType;
    protected GuiButton buttonDirection;
    protected GuiButton buttonSearchType;
    protected GuiButton buttonCtrlMode;
    protected GuiButton buttonGhostMode;
    protected GuiButton buttonTallMode;
    private Comparator<StoredItemStack> sortComp;
    private FakeSlot fakeSlotUnderMouse = new FakeSlot();

    public AbstractStorageTerminalScreen(T screenContainer, class_1661 inv, class_2561 titleIn, int textureSlotCount, int guiHeight, int slotStartX, int slotStartY) {
        super(screenContainer, inv, titleIn);
        ((StorageTerminalMenu)screenContainer).onPacket = this::onPacket;
        this.textureSlotCount = textureSlotCount;
        this.guiHeight = guiHeight;
        this.slotStartX = slotStartX;
        this.slotStartY = slotStartY;
    }

    protected void onPacket() {
        boolean tallMode;
        int s = ((StorageTerminalMenu)this.field_2797).terminalData;
        this.controllMode = (s & 3) % ControllMode.VALUES.length;
        boolean rev = (s & 4) > 0;
        int type = (s & 0x18) >> 3;
        this.comparator = StoredItemStack.SortingTypes.VALUES[type % StoredItemStack.SortingTypes.VALUES.length].create(rev);
        this.searchType = (s & 0xE0) >> 5;
        this.ghostItems = (s & 0x200) == 0;
        boolean bl = tallMode = (s & 0x400) != 0;
        if (tallMode != this.tallMode) {
            this.tallMode = tallMode;
            this.method_25426();
        }
        if (!this.searchField.method_25370() && (this.searchType & 1) > 0) {
            this.searchField.method_25365(true);
        }
        this.buttonSortingType.setState(type);
        this.buttonDirection.setState(rev ? 1 : 0);
        this.buttonSearchType.setState(this.searchType);
        this.buttonCtrlMode.setState(this.controllMode);
        this.buttonGhostMode.setState(this.ghostItems ? 1 : 0);
        this.buttonTallMode.setState(tallMode ? 1 : 0);
        if (!this.loadedSearch && ((StorageTerminalMenu)this.field_2797).search != null) {
            this.loadedSearch = true;
            if ((this.searchType & 2) > 0) {
                this.searchField.method_1852(((StorageTerminalMenu)this.field_2797).search);
            }
        }
    }

    protected void sendUpdate() {
        class_2487 c = new class_2487();
        c.method_10569("d", this.updateData());
        class_2487 msg = new class_2487();
        msg.method_10566("c", (class_2520)c);
        ((StorageTerminalMenu)this.field_2797).sendMessage(msg);
    }

    protected int updateData() {
        int d = 0;
        d |= this.controllMode & 3;
        d |= (this.comparator.isReversed() ? 1 : 0) << 2;
        d |= this.comparator.type() << 3;
        d |= (this.searchType & 7) << 5;
        d |= (this.ghostItems ? 0 : 1) << 9;
        return d |= (this.tallMode ? 1 : 0) << 10;
    }

    protected void method_25426() {
        this.method_37067();
        if (this.tallMode) {
            int guiSize = this.guiHeight - this.textureSlotCount * 18;
            this.rowCount = (this.field_22790 - 30 - guiSize) / 18;
            this.field_2779 = guiSize + this.rowCount * 18;
            ((StorageTerminalMenu)this.field_2797).setOffset(0, (this.rowCount - this.textureSlotCount) * 18);
            ((StorageTerminalMenu)this.field_2797).addStorageSlots(this.rowCount, this.slotStartX + 1, this.slotStartY + 1);
        } else {
            this.rowCount = this.textureSlotCount;
            ((StorageTerminalMenu)this.field_2797).setOffset(0, 0);
            ((StorageTerminalMenu)this.field_2797).addStorageSlots(this.rowCount, this.slotStartX + 1, this.slotStartY + 1);
        }
        this.field_25270 = this.field_2779 - 92;
        super.method_25426();
        class_327 class_3272 = this.getFont();
        Objects.requireNonNull(this.getFont());
        this.searchField = new PlatformEditBox(class_3272, this.field_2776 + 82, this.field_2800 + 6, 89, 9, (class_2561)class_2561.method_43471((String)"narrator.toms_storage.terminal_search"));
        this.searchField.method_1880(100);
        this.searchField.method_1858(false);
        this.searchField.method_1862(true);
        this.searchField.method_1868(0xFFFFFF);
        this.searchField.method_1852(this.searchLast);
        this.searchLast = "";
        this.method_25429((class_364)this.searchField);
        this.buttonSortingType = (GuiButton)this.method_37063((class_364)this.makeButton(this.field_2776 - 18, this.field_2800 + 5, 0, b -> {
            this.comparator = StoredItemStack.SortingTypes.VALUES[(this.comparator.type() + 1) % StoredItemStack.SortingTypes.VALUES.length].create(this.comparator.isReversed());
            this.buttonSortingType.setState(this.comparator.type());
            this.sendUpdate();
            this.refreshItemList = true;
        }));
        this.buttonDirection = (GuiButton)this.method_37063((class_364)this.makeButton(this.field_2776 - 18, this.field_2800 + 5 + 18, 1, b -> {
            this.comparator.setReversed(!this.comparator.isReversed());
            this.buttonDirection.setState(this.comparator.isReversed() ? 1 : 0);
            this.sendUpdate();
            this.refreshItemList = true;
        }));
        this.buttonSearchType = (GuiButton)this.method_37063((class_364)new GuiButton(this.field_2776 - 18, this.field_2800 + 5 + 36, 2, b -> {
            this.searchType = this.searchType + 1 & (IAutoFillTerminal.hasSync() || this instanceof CraftingTerminalScreen ? 7 : 3);
            this.buttonSearchType.setState(this.searchType);
            this.sendUpdate();
        }){
            {
                this.texX = 194;
                this.texY = 30;
            }

            @Override
            public void method_48579(class_332 st, int mouseX, int mouseY, float pt) {
                if (this.field_22764) {
                    int x = this.method_46426();
                    int y = this.method_46427();
                    int state = this.getState();
                    this.field_22762 = mouseX >= x && mouseY >= y && mouseX < x + this.field_22758 && mouseY < y + this.field_22759;
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
                    st.method_25302(AbstractStorageTerminalScreen.this.getGui(), x, y, this.texX, this.texY + this.tile * 16, this.field_22758, this.field_22759);
                    if ((state & 1) > 0) {
                        st.method_25302(AbstractStorageTerminalScreen.this.getGui(), x + 1, y + 1, this.texX + 16, this.texY + this.tile * 16, this.field_22758 - 2, this.field_22759 - 2);
                    }
                    if ((state & 2) > 0) {
                        st.method_25302(AbstractStorageTerminalScreen.this.getGui(), x + 1, y + 1, this.texX + 16 + 14, this.texY + this.tile * 16, this.field_22758 - 2, this.field_22759 - 2);
                    }
                    if ((state & 4) > 0) {
                        st.method_25302(AbstractStorageTerminalScreen.this.getGui(), x + 1, y + 1, this.texX + 16 + 28, this.texY + this.tile * 16, this.field_22758 - 2, this.field_22759 - 2);
                    }
                }
            }
        });
        this.buttonCtrlMode = (GuiButton)this.method_37063((class_364)this.makeButton(this.field_2776 - 18, this.field_2800 + 5 + 54, 3, b -> {
            this.controllMode = (this.controllMode + 1) % ControllMode.VALUES.length;
            this.buttonCtrlMode.setState(this.controllMode);
            this.sendUpdate();
        }));
        this.buttonGhostMode = (GuiButton)this.method_37063((class_364)this.makeButton(this.field_2776 - 18, this.field_2800 + 5 + 72, 5, b -> {
            this.ghostItems = !this.ghostItems;
            this.buttonGhostMode.setState(this.ghostItems ? 1 : 0);
            this.sendUpdate();
        }));
        this.buttonTallMode = (GuiButton)this.method_37063((class_364)this.makeButton(this.field_2776 - 18, this.field_2800 + 5 + 90, 6, b -> {
            this.tallMode = !this.tallMode;
            this.buttonTallMode.setState(this.tallMode ? 1 : 0);
            this.sendUpdate();
            this.method_25426();
        }));
        this.buttonSortingType.tooltipFactory = s -> class_7919.method_47407((class_2561)class_2561.method_43471((String)("tooltip.toms_storage.sorting_" + s)));
        this.buttonSearchType.tooltipFactory = s -> class_7919.method_47407((class_2561)class_2561.method_43469((String)("tooltip.toms_storage.search_" + s), (Object[])new Object[]{IAutoFillTerminal.getHandlerName()}));
        this.buttonCtrlMode.tooltipFactory = s -> class_7919.method_47407((class_2561)Arrays.stream(class_1074.method_4662((String)("tooltip.toms_storage.ctrlMode_" + s), (Object[])new Object[0]).split("\\\\")).map(class_2561::method_43470).collect(ComponentJoiner.joining((class_2561)class_2561.method_43473(), (class_2561)class_2561.method_43470((String)"\n"))));
        this.buttonGhostMode.tooltipFactory = s -> class_7919.method_47407((class_2561)class_2561.method_43471((String)("tooltip.toms_storage.ghostMode_" + s)));
        this.buttonTallMode.tooltipFactory = s -> class_7919.method_47407((class_2561)class_2561.method_43471((String)("tooltip.toms_storage.tallMode_" + s)));
        this.updateSearch();
    }

    protected void updateSearch() {
        String searchString = this.searchField.method_1882();
        if (this.refreshItemList || !this.searchLast.equals(searchString)) {
            Pattern m;
            ((StorageTerminalMenu)this.method_17577()).itemListClientSorted.clear();
            boolean searchMod = searchString.startsWith("@");
            boolean searchNbt = !searchMod && searchString.startsWith("$");
            boolean searchTag = !searchMod && !searchNbt && searchString.startsWith("#");
            String search = searchMod || searchNbt || searchTag ? searchString.substring(1) : searchString;
            try {
                m = Pattern.compile(search.toLowerCase(), 2);
            }
            catch (Throwable ignore) {
                try {
                    m = Pattern.compile(Pattern.quote(search.toLowerCase()), 2);
                }
                catch (Throwable __) {
                    return;
                }
            }
            try {
                block6: for (int i = 0; i < ((StorageTerminalMenu)this.method_17577()).itemListClient.size(); ++i) {
                    StoredItemStack is = ((StorageTerminalMenu)this.method_17577()).itemListClient.get(i);
                    if (is == null || is.getStack() == null) continue;
                    String dspName = searchMod ? class_7923.field_41178.method_10221((Object)is.getStack().method_7909()).method_12836() : (searchNbt && is.getStack().method_7985() ? (String)nbtCache.get((Object)is) : is.getStack().method_7964().getString());
                    boolean notDone = true;
                    if (!searchTag && m.matcher(dspName.toLowerCase()).find()) {
                        this.addStackToClientList(is);
                        notDone = false;
                    }
                    if (!notDone || searchMod || searchNbt) continue;
                    List list = searchTag ? (List)tagCache.get((Object)is) : (List)tooltipCache.get((Object)is);
                    for (String lp : list) {
                        if (!m.matcher(lp).find()) continue;
                        this.addStackToClientList(is);
                        continue block6;
                    }
                }
            }
            catch (Exception i) {
                // empty catch block
            }
            Collections.sort(((StorageTerminalMenu)this.method_17577()).itemListClientSorted, ((StorageTerminalMenu)this.field_2797).noSort ? this.sortComp : this.comparator);
            if (!this.searchLast.equals(searchString)) {
                ((StorageTerminalMenu)this.method_17577()).scrollTo(0.0f);
                this.currentScroll = 0.0f;
                if ((this.searchType & 4) > 0) {
                    IAutoFillTerminal.sync(searchString);
                }
                if ((this.searchType & 2) > 0) {
                    class_2487 nbt = new class_2487();
                    nbt.method_10582("s", searchString);
                    ((StorageTerminalMenu)this.field_2797).sendMessage(nbt);
                }
                this.onUpdateSearch(searchString);
            } else {
                ((StorageTerminalMenu)this.method_17577()).scrollTo(this.currentScroll);
            }
            this.refreshItemList = false;
            this.searchLast = searchString;
        }
    }

    private void addStackToClientList(StoredItemStack is) {
        ((StorageTerminalMenu)this.method_17577()).itemListClientSorted.add(is);
    }

    public static class_1836 getTooltipFlag() {
        return class_310.method_1551().field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070;
    }

    protected void method_37432() {
        this.updateSearch();
        this.searchField.method_1865();
    }

    public void method_25394(class_332 st, int mouseX, int mouseY, float partialTicks) {
        boolean flag = GLFW.glfwGetMouseButton((long)class_310.method_1551().method_22683().method_4490(), (int)0) != 0;
        int i = this.field_2776;
        int j = this.field_2800;
        int k = i + 174;
        int l = j + 18;
        int i1 = k + 14;
        int j1 = l + this.rowCount * 18;
        if (this.ghostItems && AbstractStorageTerminalScreen.method_25442()) {
            if (!((StorageTerminalMenu)this.field_2797).noSort) {
                List<StoredItemStack> list = ((StorageTerminalMenu)this.method_17577()).itemListClientSorted;
                Object2IntOpenHashMap map = new Object2IntOpenHashMap();
                map.defaultReturnValue(Integer.MAX_VALUE);
                for (int m = 0; m < list.size(); ++m) {
                    map.put((Object)list.get(m), m);
                }
                this.sortComp = Comparator.comparing(arg_0 -> ((Object2IntMap)map).getInt(arg_0));
                ((StorageTerminalMenu)this.field_2797).noSort = true;
            }
        } else if (((StorageTerminalMenu)this.field_2797).noSort) {
            this.sortComp = null;
            ((StorageTerminalMenu)this.field_2797).noSort = false;
            this.refreshItemList = true;
            ((StorageTerminalMenu)this.field_2797).itemListClient = new ArrayList<StoredItemStack>(((StorageTerminalMenu)this.field_2797).itemList);
        }
        if (!this.wasClicking && flag && mouseX >= k && mouseY >= l && mouseX < i1 && mouseY < j1) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - l) - 7.5f) / ((float)(j1 - l) - 15.0f);
            this.currentScroll = class_3532.method_15363((float)this.currentScroll, (float)0.0f, (float)1.0f);
            ((StorageTerminalMenu)this.method_17577()).scrollTo(this.currentScroll);
        }
        super.method_25394(st, mouseX, mouseY, partialTicks);
        i = k;
        j = l;
        k = j1;
        this.drawScroll(st, i, j + (int)((float)(k - j - 17) * this.currentScroll), this.needsScrollBars());
        this.searchField.method_25394(st, mouseX, mouseY, partialTicks);
        if (((StorageTerminalMenu)this.field_2797).beaconLvl >= 0) {
            int x = 176;
            int y = 24 + this.rowCount * 18;
            st.method_51427(new class_1799((class_1935)class_1802.field_8668), this.field_2776 + x, this.field_2800 + y);
            if (this.method_2378(x, y, 16, 16, mouseX, mouseY)) {
                Object info = Config.get().wirelessTermBeaconLvlDim != -1 && ((StorageTerminalMenu)this.field_2797).beaconLvl >= Config.get().wirelessTermBeaconLvlDim ? "\\" + class_1074.method_4662((String)"tooltip.toms_storage.terminal_beacon.anywhere", (Object[])new Object[0]) : (Config.get().wirelessTermBeaconLvl != -1 && ((StorageTerminalMenu)this.field_2797).beaconLvl >= Config.get().wirelessTermBeaconLvl ? "\\" + class_1074.method_4662((String)"tooltip.toms_storage.terminal_beacon.sameDim", (Object[])new Object[0]) : "");
                st.method_51434(this.field_22793, Arrays.stream(class_1074.method_4662((String)"tooltip.toms_storage.terminal_beacon", (Object[])new Object[]{((StorageTerminalMenu)this.field_2797).beaconLvl, info}).split("\\\\")).map(class_2561::method_43470).collect(Collectors.toList()), mouseX, mouseY);
            }
        }
        if (((StorageTerminalMenu)this.field_2797).method_34255().method_7960() && this.slotIDUnderMouse != -1) {
            StorageTerminalMenu.SlotStorage slot = ((StorageTerminalMenu)this.method_17577()).storageSlotList.get(this.slotIDUnderMouse);
            if (slot.stack != null) {
                if (slot.stack.getQuantity() > 9999L) {
                    StorageModClient.setTooltip(new class_2561[]{class_2561.method_43469((String)"tooltip.toms_storage.amount", (Object[])new Object[]{slot.stack.getQuantity()})});
                }
                st.method_51446(this.field_22793, slot.stack.getActualStack(), mouseX, mouseY);
                StorageModClient.setTooltip(new class_2561[0]);
            }
        } else {
            this.method_2380(st, mouseX, mouseY);
        }
    }

    protected void method_2388(class_332 st, int mouseX, int mouseY) {
        super.method_2388(st, mouseX, mouseY);
        st.method_51448().method_22903();
        this.slotIDUnderMouse = this.drawSlots(st, mouseX, mouseY);
        st.method_51448().method_22909();
    }

    protected int drawSlots(class_332 st, int mouseX, int mouseY) {
        StorageTerminalMenu term = (StorageTerminalMenu)this.method_17577();
        int slotHover = -1;
        for (int i = 0; i < term.storageSlotList.size(); ++i) {
            if (!this.drawSlot(st, term.storageSlotList.get(i), mouseX, mouseY)) continue;
            slotHover = i;
        }
        return slotHover;
    }

    protected boolean drawSlot(class_332 st, StorageTerminalMenu.SlotStorage slot, int mouseX, int mouseY) {
        if (slot.stack != null) {
            class_1799 stack = slot.stack.getStack().method_7972().method_7971(1);
            int i = slot.xDisplayPosition;
            int j = slot.yDisplayPosition;
            st.method_51427(stack, i, j);
            st.method_51431(this.field_22793, stack, i, j);
            this.drawStackSize(st, this.getFont(), slot.stack.getQuantity(), i, j);
        }
        if (mouseX >= this.getGuiLeft() + slot.xDisplayPosition - 1 && mouseY >= this.getGuiTop() + slot.yDisplayPosition - 1 && mouseX < this.getGuiLeft() + slot.xDisplayPosition + 17 && mouseY < this.getGuiTop() + slot.yDisplayPosition + 17) {
            int l = slot.xDisplayPosition;
            int t = slot.yDisplayPosition;
            AbstractStorageTerminalScreen.method_33285((class_332)st, (int)l, (int)t, (int)0);
            return true;
        }
        return false;
    }

    private void drawStackSize(class_332 st, class_327 fr, long size, int x, int y) {
        float scaleFactor = 0.6f;
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        String stackSize = NumberFormatUtil.formatNumber(size);
        st.method_51448().method_22903();
        st.method_51448().method_22905(scaleFactor, scaleFactor, scaleFactor);
        st.method_51448().method_46416(0.0f, 0.0f, 450.0f);
        float inverseScaleFactor = 1.0f / scaleFactor;
        int X = (int)(((float)x + 0.0f + 16.0f - (float)fr.method_1727(stackSize) * scaleFactor) * inverseScaleFactor);
        int Y = (int)(((float)y + 0.0f + 16.0f - 7.0f * scaleFactor) * inverseScaleFactor);
        st.method_51433(fr, stackSize, X, Y, 0xFFFFFF, true);
        st.method_51448().method_22909();
        RenderSystem.enableDepthTest();
    }

    protected boolean needsScrollBars() {
        return ((StorageTerminalMenu)this.method_17577()).itemListClientSorted.size() > this.rowCount * 9;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (this.slotIDUnderMouse > -1) {
            if (this.isPullOne(mouseButton)) {
                if (((StorageTerminalMenu)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack == null) return true;
                if (((StorageTerminalMenu)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack.getQuantity() <= 0L) return true;
                this.storageSlotClick(((StorageTerminalMenu)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack, StorageTerminalMenu.SlotAction.PULL_ONE, this.isTransferOne(mouseButton));
                return true;
            }
            if (this.pullHalf(mouseButton)) {
                if (!((StorageTerminalMenu)this.field_2797).method_34255().method_7960()) {
                    this.storageSlotClick(null, AbstractStorageTerminalScreen.method_25441() ? StorageTerminalMenu.SlotAction.GET_QUARTER : StorageTerminalMenu.SlotAction.GET_HALF, false);
                    return true;
                }
                if (((StorageTerminalMenu)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack == null) return true;
                if (((StorageTerminalMenu)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack.getQuantity() <= 0L) return true;
                this.storageSlotClick(((StorageTerminalMenu)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack, AbstractStorageTerminalScreen.method_25441() ? StorageTerminalMenu.SlotAction.GET_QUARTER : StorageTerminalMenu.SlotAction.GET_HALF, false);
                return true;
            }
            if (!this.pullNormal(mouseButton)) return true;
            if (!((StorageTerminalMenu)this.field_2797).method_34255().method_7960()) {
                this.storageSlotClick(null, StorageTerminalMenu.SlotAction.PULL_OR_PUSH_STACK, false);
                return true;
            }
            if (((StorageTerminalMenu)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack == null) return true;
            if (((StorageTerminalMenu)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack.getQuantity() <= 0L) return true;
            this.storageSlotClick(((StorageTerminalMenu)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack, AbstractStorageTerminalScreen.method_25442() ? StorageTerminalMenu.SlotAction.SHIFT_PULL : StorageTerminalMenu.SlotAction.PULL_OR_PUSH_STACK, false);
            return true;
        }
        if (GLFW.glfwGetKey((long)this.mc.method_22683().method_4490(), (int)32) != 0) {
            this.storageSlotClick(null, StorageTerminalMenu.SlotAction.SPACE_CLICK, false);
            return true;
        }
        int n = this.searchField.method_46426() - this.field_2776;
        int n2 = this.searchField.method_46427() - this.field_2800;
        Objects.requireNonNull(this.getFont());
        if (this.method_2378(n, n2, 89, 9, mouseX, mouseY)) {
            if (mouseButton != 1) return super.method_25402(mouseX, mouseY, mouseButton);
            this.searchField.method_1852("");
            return true;
        }
        this.searchField.method_25365(false);
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    protected void storageSlotClick(StoredItemStack slotStack, StorageTerminalMenu.SlotAction act, boolean mod) {
        ((StorageTerminalMenu)this.field_2797).sync.sendInteract(slotStack, act, mod);
    }

    public boolean isPullOne(int mouseButton) {
        switch (this.ctrlm()) {
            case AE: {
                return mouseButton == 1 && AbstractStorageTerminalScreen.method_25442();
            }
            case RS: {
                return mouseButton == 2;
            }
            case DEF: {
                return mouseButton == 1 && !((StorageTerminalMenu)this.field_2797).method_34255().method_7960();
            }
        }
        return false;
    }

    public boolean isTransferOne(int mouseButton) {
        switch (this.ctrlm()) {
            case AE: {
                return AbstractStorageTerminalScreen.method_25442() && AbstractStorageTerminalScreen.method_25441();
            }
            case RS: {
                return AbstractStorageTerminalScreen.method_25442() && mouseButton == 2;
            }
            case DEF: {
                return mouseButton == 1 && AbstractStorageTerminalScreen.method_25442();
            }
        }
        return false;
    }

    public boolean pullHalf(int mouseButton) {
        switch (this.ctrlm()) {
            case AE: {
                return mouseButton == 1;
            }
            case RS: {
                return mouseButton == 1;
            }
            case DEF: {
                return mouseButton == 1 && ((StorageTerminalMenu)this.field_2797).method_34255().method_7960();
            }
        }
        return false;
    }

    public boolean pullNormal(int mouseButton) {
        switch (this.ctrlm()) {
            case AE: 
            case RS: 
            case DEF: {
                return mouseButton == 0;
            }
        }
        return false;
    }

    private ControllMode ctrlm() {
        return ControllMode.VALUES[this.controllMode];
    }

    public class_327 getFont() {
        return this.field_22793;
    }

    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256) {
            this.method_25419();
            return true;
        }
        if (pKeyCode == 258) {
            return super.method_25404(pKeyCode, pScanCode, pModifiers);
        }
        if (this.searchField.method_25404(pKeyCode, pScanCode, pModifiers) || this.searchField.method_20315()) {
            return true;
        }
        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }

    public boolean method_25400(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.searchField.method_25400(p_charTyped_1_, p_charTyped_2_)) {
            return true;
        }
        return super.method_25400(p_charTyped_1_, p_charTyped_2_);
    }

    public boolean method_25401(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        if (!this.needsScrollBars()) {
            return false;
        }
        int i = (((StorageTerminalMenu)this.field_2797).itemListClientSorted.size() + 9 - 1) / 9 - 5;
        this.currentScroll = (float)((double)this.currentScroll - p_mouseScrolled_5_ / (double)i);
        this.currentScroll = class_3532.method_15363((float)this.currentScroll, (float)0.0f, (float)1.0f);
        ((StorageTerminalMenu)this.field_2797).scrollTo(this.currentScroll);
        return true;
    }

    public abstract class_2960 getGui();

    protected void method_2389(class_332 st, float partialTicks, int mouseX, int mouseY) {
        if (this.tallMode) {
            st.method_25302(this.getGui(), this.field_2776, this.field_2800, 0, 0, this.field_2792, this.slotStartY);
            int guiStart = this.textureSlotCount * 18 + this.slotStartY;
            int guiRStart = this.rowCount * 18 + this.slotStartY;
            int guiSize = this.guiHeight - this.textureSlotCount * 18 - this.slotStartY;
            st.method_25302(this.getGui(), this.field_2776, this.field_2800 + guiRStart, 0, guiStart, this.field_2792, guiSize);
            int scrollbarW = 25;
            st.method_25302(this.getGui(), this.field_2776, this.field_2800 + this.slotStartY, 0, this.slotStartY, this.slotStartX + 162 + scrollbarW, 18);
            for (int i = 1; i < this.rowCount - 1; ++i) {
                st.method_25302(this.getGui(), this.field_2776, this.field_2800 + this.slotStartY + i * 18, 0, this.slotStartY + 18, this.slotStartX + 162 + scrollbarW, 18);
            }
            st.method_25302(this.getGui(), this.field_2776, this.field_2800 + this.slotStartY + (this.rowCount - 1) * 18, 0, this.slotStartY + (this.textureSlotCount - 1) * 18, this.slotStartX + 162 + scrollbarW, 18);
        } else {
            st.method_25302(this.getGui(), this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        }
    }

    public GuiButton makeButton(int x, int y, int tile, class_4185.class_4241 pressable) {
        GuiButton btn = new GuiButton(x, y, tile, pressable);
        btn.texX = 194;
        btn.texY = 30;
        btn.texture = this.getGui();
        return btn;
    }

    protected void onUpdateSearch(String text) {
    }

    @Override
    public void receive(class_2487 tag) {
        ((StorageTerminalMenu)this.field_2797).receiveClientNBTPacket(tag);
        this.refreshItemList = true;
    }

    @Override
    public class_1735 getSlotUnderMouse() {
        class_1735 s = super.getSlotUnderMouse();
        if (s != null) {
            return s;
        }
        if (this.slotIDUnderMouse > -1 && ((StorageTerminalMenu)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack != null) {
            this.fakeSlotUnderMouse.field_7871.method_5447(0, ((StorageTerminalMenu)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack.getStack());
            return this.fakeSlotUnderMouse;
        }
        return null;
    }

    private static class FakeSlot
    extends class_1735 {
        private static final class_1263 DUMMY = new class_1277(1);

        public FakeSlot() {
            super(DUMMY, 0, Integer.MIN_VALUE, Integer.MIN_VALUE);
        }

        public boolean method_32754(class_1657 p_150652_) {
            return false;
        }

        public void method_7673(class_1799 p_40240_) {
        }

        public class_1799 method_7671(int p_40227_) {
            return class_1799.field_8037;
        }
    }
}

