/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat;

import com.copycatsplus.copycats.compat.FlywheelCompat;
import com.copycatsplus.copycats.compat.Mods;
import com.copycatsplus.copycats.compat.SodiumCompat;
import com.copycatsplus.copycats.foundation.copycat.model.kinetic.WrappedRenderWorld;
import com.copycatsplus.copycats.utility.Platform;
import com.mojang.datafixers.util.Either;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2818;

public class CopycatMaterialStore {
    private final Map<class_1923, Map<class_2338, Either<class_2680, Map<String, class_2680>>>> materialMap = new ConcurrentHashMap<class_1923, Map<class_2338, Either<class_2680, Map<String, class_2680>>>>();
    private static final Map<class_1922, CopycatMaterialStore> STORES = Collections.synchronizedMap(new WeakHashMap());

    private void setMaterial(class_2338 pos, class_2680 state) {
        class_1923 chunkPos = new class_1923(pos);
        this.materialMap.computeIfAbsent(chunkPos, p -> new ConcurrentHashMap()).put(pos, Either.left((Object)state));
    }

    private void setMaterial(class_2338 pos, Map<String, class_2680> states) {
        class_1923 chunkPos = new class_1923(pos);
        this.materialMap.computeIfAbsent(chunkPos, p -> new ConcurrentHashMap()).put(pos, Either.right(states));
    }

    private Either<class_2680, Map<String, class_2680>> getMaterial(class_2338 pos) {
        return this.materialMap.getOrDefault(new class_1923(pos), Map.of()).getOrDefault(pos, Either.left((Object)class_2246.field_10124.method_9564()));
    }

    public void unloadChunk(class_1923 chunk) {
        this.materialMap.remove(chunk);
    }

    private static CopycatMaterialStore get(class_1922 level) {
        if (Platform.Environment.CLIENT.isCurrent() && level instanceof WrappedRenderWorld) {
            WrappedRenderWorld wrapped = (WrappedRenderWorld)level;
            level = wrapped.getLevel();
        }
        if (Platform.Environment.CLIENT.isCurrent() && Mods.SODIUM.getLoaded()) {
            try {
                level = SodiumCompat.unwrapSodiumLevel(level);
            }
            catch (Exception wrapped) {
                // empty catch block
            }
        }
        if (level instanceof class_2818) {
            class_2818 chunk = (class_2818)level;
            level = chunk.method_12200();
        }
        if (Platform.Environment.CLIENT.isCurrent() && Mods.FLYWHEEL.getLoaded()) {
            try {
                level = FlywheelCompat.unwrapFlywheelLevel(level);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return STORES.computeIfAbsent(level, l -> new CopycatMaterialStore());
    }

    public static void setMaterial(class_1922 level, class_2338 pos, class_2680 state) {
        CopycatMaterialStore.get(level).setMaterial(pos, state);
    }

    public static void setMaterial(class_1922 level, class_2338 pos, Map<String, class_2680> states) {
        CopycatMaterialStore.get(level).setMaterial(pos, states);
    }

    public static Either<class_2680, Map<String, class_2680>> getMaterial(class_1922 level, class_2338 pos) {
        return CopycatMaterialStore.get(level).getMaterial(pos);
    }

    public static void unloadLevel(class_1922 level) {
        STORES.remove(level);
    }

    public static void unloadChunk(class_1922 level, class_1923 chunk) {
        CopycatMaterialStore.get(level).unloadChunk(chunk);
    }
}

