/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.base.item;

import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import net.minecraft.class_1767;
import net.minecraft.class_1792;

public class DyedItemList<T extends class_1792>
implements Iterable<ItemEntry<T>> {
    private static final int COLOR_AMOUNT = class_1767.values().length;
    private final ItemEntry<?>[] values = new ItemEntry[COLOR_AMOUNT];

    public DyedItemList(Function<class_1767, ItemEntry<? extends T>> filler) {
        for (class_1767 color : class_1767.values()) {
            this.values[color.ordinal()] = filler.apply(color);
        }
    }

    public ItemEntry<T> get(class_1767 color) {
        return this.values[color.ordinal()];
    }

    public boolean contains(class_1792 block) {
        for (ItemEntry<?> entry : this.values) {
            if (!entry.is(block)) continue;
            return true;
        }
        return false;
    }

    public ItemEntry<T>[] toArray() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    @Override
    public Iterator<ItemEntry<T>> iterator() {
        return new Iterator<ItemEntry<T>>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < DyedItemList.this.values.length;
            }

            @Override
            public ItemEntry<T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return DyedItemList.this.values[this.index++];
            }
        };
    }
}

