/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.coins;

import com.simibubi.create.foundation.utility.Couple;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.coins.CoinBag;
import dev.ithundxr.createnumismatics.content.coins.CoinItem;
import dev.ithundxr.createnumismatics.registry.NumismaticsItems;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public class MergingCoinBag
implements CoinBag {
    private int value;

    public MergingCoinBag() {
        this(0);
    }

    public MergingCoinBag(int value) {
        this.setRaw(value);
    }

    @Override
    public void add(Coin coin, int count) {
        this.setRaw(this.getValue() + coin.toSpurs(count));
    }

    @Override
    public void subtract(Coin coin, int count) {
        int value = this.getValue() - coin.toSpurs(count);
        value = Math.max(0, value);
        this.setRaw(value);
    }

    @Override
    public void set(Coin coin, int count, int spurRemainder) {
        count = Math.max(0, count);
        this.setRaw(coin.toSpurs(count) + spurRemainder);
    }

    protected void setRaw(int value) {
        this.value = value;
    }

    @Override
    public Couple<Integer> get(Coin coin) {
        return coin.convert(this.getValue());
    }

    @Override
    public class_1799 asStack(Coin coin) {
        int amt = (Integer)this.get(coin).getFirst();
        if (amt == 0) {
            return class_1799.field_8037;
        }
        return NumismaticsItems.getCoin(coin).asStack(amt);
    }

    public class_1799 asVisualStack(Coin coin) {
        int amt = (Integer)this.get(coin).getFirst();
        if (amt == 0) {
            return class_1799.field_8037;
        }
        return CoinItem.setDisplayedCount(NumismaticsItems.getCoin(coin).asStack(Math.min(64, amt)), amt);
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public class_2487 save(class_2487 nbt) {
        nbt.method_10569("CoinValue", this.getValue());
        return nbt;
    }

    @Override
    public void load(class_2487 nbt) {
        this.setRaw(nbt.method_10550("CoinValue"));
    }

    @Override
    public void clear() {
        this.setRaw(0);
    }
}

