/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class VariableStepTransformer {
    private boolean unsorted;
    private final List<Step> steps = new ArrayList<Step>();
    private final List<Step> reversedSteps = new ArrayList<Step>();

    public void addStep(int change, int max) {
        this.unsorted = true;
        this.steps.add(new Step(change, max));
        this.reversedSteps.add(new Step(change, max));
    }

    public int toStep(int value) {
        if (this.unsorted) {
            this.sortSteps();
        }
        int step = 0;
        int currentChange = 0;
        int currentValue = value;
        for (Step pair : this.reversedSteps) {
            if (currentValue > pair.max && currentChange != 0) {
                step += Math.floorDiv(currentValue - pair.max, currentChange);
                currentValue = pair.max;
            }
            currentChange = pair.change;
        }
        return step += Math.floorDiv(currentValue, currentChange);
    }

    public int toValue(int step) {
        if (this.unsorted) {
            this.sortSteps();
        }
        int value = 0;
        int currentStep = 0;
        for (Step pair : this.steps) {
            int stepsTaken = Math.min(Math.floorDiv(pair.max - value, pair.change), step - currentStep);
            value += stepsTaken * pair.change;
            currentStep += stepsTaken;
        }
        return value;
    }

    private void sortSteps() {
        this.unsorted = false;
        this.steps.sort(new Comparator<Step>(){

            @Override
            public int compare(Step self, Step other) {
                return Integer.compare(self.max, other.max);
            }
        });
        this.reversedSteps.sort(new Comparator<Step>(){

            @Override
            public int compare(Step self, Step other) {
                return Integer.compare(self.max, other.max);
            }
        });
        Collections.reverse(this.reversedSteps);
    }

    private record Step(int change, int max) {
    }
}

