/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.render.shapes;

import java.util.List;
import org.enginehub.worldeditcui.event.listeners.CUIRenderContext;
import org.enginehub.worldeditcui.render.LineStyle;
import org.enginehub.worldeditcui.render.RenderStyle;
import org.enginehub.worldeditcui.render.points.PointRectangle;
import org.enginehub.worldeditcui.render.shapes.RenderRegion;
import org.enginehub.worldeditcui.util.Vector2;

public class Render2DBox
extends RenderRegion {
    private final List<PointRectangle> points;
    private final int min;
    private final int max;

    public Render2DBox(RenderStyle style, List<PointRectangle> points, int min, int max) {
        super(style);
        this.points = points;
        this.min = min;
        this.max = max;
    }

    @Override
    public void render(CUIRenderContext ctx) {
        double off = 0.03 - ctx.cameraPos().getY();
        for (LineStyle line : this.style.getLines()) {
            if (!ctx.apply(line, this.style.getRenderType())) continue;
            ctx.beginLines();
            ctx.color(line);
            for (PointRectangle point : this.points) {
                if (point == null) continue;
                Vector2 pos = point.getPoint();
                double x = pos.getX() - ctx.cameraPos().getX();
                double z = pos.getY() - ctx.cameraPos().getZ();
                ctx.vertex(x + 0.5, (double)this.min + off, z + 0.5).vertex(x + 0.5, (double)(this.max + 1) + off, z + 0.5);
            }
            ctx.endLines();
        }
    }
}

