/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.popupscreenbutton.colorpicker;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.function.Function;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.properties.CoreProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.Texture;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.TextBox;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.IntSliderButton;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import journeymap.common.properties.catagory.Category;
import journeymap.common.properties.config.IntegerField;
import journeymap.common.properties.config.StringField;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5348;
import net.minecraft.class_7842;
import net.minecraft.class_7843;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_7852;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import net.minecraft.class_8667;

public class ColorPickerScreen
extends PopupButtonScreen<ColorPickerResponse> {
    private static final class_2960 BACKGROUND_SPRITE = class_2960.method_60654((String)"popup/background");
    private static final int SLIDERS_WIDTH = 265;
    private final class_8667 layout = class_8667.method_52741();
    private class_8667 historyLayout;
    private final Texture colorwheelTexture;
    private final Texture colorwheelHandlerTexture;
    private final Texture colorBoxTexture;
    private final Texture colorVSliderTexture;
    private final Texture colorVSliderHandlerTexture;
    private final Texture colorHistoryButtonTexture;
    private final String labelOld = Constants.getString("jm.color.old");
    private final String labelNew = Constants.getString("jm.color.new");
    private final class_2561 labelHistory = class_2561.method_43471((String)"jm.color.history");
    private final class_2561 labelHex = class_2561.method_43471((String)"jm.color.hex");
    private final class_2561 labelDec = class_2561.method_43471((String)"jm.color.dec");
    private final String prefixR = Constants.getString("jm.color.red_abbreviated");
    private final String prefixG = Constants.getString("jm.color.green_abbreviated");
    private final String prefixB = Constants.getString("jm.color.blue_abbreviated");
    private final String prefixH = Constants.getString("jm.color.hue_abbreviated");
    private final String prefixS = Constants.getString("jm.color.saturation_abbreviated");
    private final String prefixV = Constants.getString("jm.color.value_abbreviated");
    private final String prefixA = Constants.getString("jm.color.alpha_abbreviated");
    private final class_2561 labelSubmit = class_2561.method_43471((String)"jm.common.submit");
    private final class_2561 labelReset = class_2561.method_43471((String)"jm.common.reset");
    private final class_2561 labelCancel = class_2561.method_43471((String)"jm.common.cancel");
    private final String formatHexNoAlpha = "%06X";
    private final String formatHexAlpha = "%08X";
    private final int maxHistory = 18;
    private TextBox fieldHex;
    private TextBox fieldDec;
    private final IntegerField fieldH = new IntegerField(Category.Hidden, "", 0, 255, 0);
    private final IntegerField fieldS = new IntegerField(Category.Hidden, "", 0, 255, 0);
    private final IntegerField fieldV = new IntegerField(Category.Hidden, "", 0, 255, 0);
    private final IntegerField fieldR = new IntegerField(Category.Hidden, "", 0, 255, 0);
    private final IntegerField fieldG = new IntegerField(Category.Hidden, "", 0, 255, 0);
    private final IntegerField fieldB = new IntegerField(Category.Hidden, "", 0, 255, 0);
    private final IntegerField fieldA = new IntegerField(Category.Hidden, "", 0, 255, 0);
    private IntSliderButton sliderH;
    private IntSliderButton sliderS;
    private IntSliderButton sliderV;
    private IntSliderButton sliderR;
    private IntSliderButton sliderG;
    private IntSliderButton sliderB;
    private IntSliderButton sliderA;
    private double colorwheelHandlerX = 0.0;
    private double colorwheelHandlerY = 0.0;
    private boolean draggingCWHandler = false;
    private final Rectangle2D.Double colorWheelRect;
    private double vSliderHandler = 0.0;
    private boolean draggingVSHandler = false;
    private final Rectangle2D.Double vSliderRect;
    private double aSliderHandler = 0.0;
    private boolean draggingASHandler = false;
    private final Rectangle2D.Double aSliderRect;
    private final int originalColor;
    private int currentColor;
    private int currentColorFullBrightness;
    private boolean withAlpha;

    protected ColorPickerScreen(class_2561 title, Integer color, boolean withAlpha) {
        super(title);
        this.response = new ColorPickerResponse(0, true);
        this.colorwheelTexture = TextureCache.getTexture(TextureCache.ColorWheel);
        this.colorwheelHandlerTexture = TextureCache.getTexture(TextureCache.ColorWheelHandler);
        this.colorBoxTexture = TextureCache.getTexture(TextureCache.ColorBox);
        this.colorVSliderTexture = TextureCache.getTexture(TextureCache.ColorVSlider);
        this.colorVSliderHandlerTexture = TextureCache.getTexture(TextureCache.ColorVSliderHandler);
        this.colorHistoryButtonTexture = TextureCache.getTexture(TextureCache.ColorHistoryButton);
        this.colorWheelRect = new Rectangle2D.Double();
        this.vSliderRect = new Rectangle2D.Double();
        this.aSliderRect = new Rectangle2D.Double();
        this.originalColor = color;
        this.currentColor = color;
        this.withAlpha = withAlpha;
    }

    public void method_25426() {
        this.layout.method_52735(4).method_52740().method_46461();
        this.layout.method_52736((class_8021)new class_7852(265, 69));
        this.fieldHex = new TextBox("", this.field_22793, 76, 20, false, false);
        this.fieldHex.method_1880(this.withAlpha ? 8 : 6);
        this.fieldDec = new TextBox("", this.field_22793, 76, 20, true, true);
        this.fieldDec.method_1880(this.withAlpha ? 11 : 9);
        ColorPickerScreen.addTextBoxWithLabel(this.layout, this.field_22793, this.labelHex, this.fieldHex);
        ColorPickerScreen.addTextBoxWithLabel(this.layout, this.field_22793, this.labelDec, this.fieldDec);
        this.sliderH = this.createCenteredSlider(this.fieldH, this.prefixH, this::listenerHSV);
        this.sliderS = this.createCenteredSlider(this.fieldS, this.prefixS, this::listenerHSV);
        this.sliderV = this.createCenteredSlider(this.fieldV, this.prefixV, this::listenerHSV);
        this.sliderR = this.createCenteredSlider(this.fieldR, this.prefixR, this::listenerRGB);
        this.sliderG = this.createCenteredSlider(this.fieldG, this.prefixG, this::listenerRGB);
        this.sliderB = this.createCenteredSlider(this.fieldB, this.prefixB, this::listenerRGB);
        ColorPickerScreen.addSliderGroup(this.layout, this.sliderH, this.sliderS, this.sliderV);
        ColorPickerScreen.addSliderGroup(this.layout, this.sliderR, this.sliderG, this.sliderB);
        if (this.withAlpha) {
            this.sliderA = this.createCenteredSlider(this.fieldA, this.prefixA, this::listenerAlpha);
            this.layout.method_52736((class_8021)this.sliderA);
        }
        class_7843 bottomButtomsFrame = new class_7843();
        bottomButtomsFrame.method_46449(265);
        class_8667 bottomButtons = class_8667.method_52742();
        bottomButtons.method_52735(12);
        bottomButtons.method_52736((class_8021)Button.method_46430((class_2561)this.labelSubmit, b -> this.submit()).method_46432(this.field_22793.method_27525((class_5348)this.labelSubmit) + 10).method_46431());
        bottomButtons.method_52736((class_8021)Button.method_46430((class_2561)this.labelReset, b -> this.reset()).method_46432(this.field_22793.method_27525((class_5348)this.labelReset) + 10).method_46431());
        bottomButtons.method_52736((class_8021)Button.method_46430((class_2561)this.labelCancel, b -> this.setResponseAndClose(new ColorPickerResponse(0, true))).method_46432(this.field_22793.method_27525((class_5348)this.labelCancel) + 10).method_46431());
        bottomButtomsFrame.method_46441((class_8021)bottomButtons);
        this.layout.method_52736((class_8021)bottomButtomsFrame);
        CoreProperties properties = JourneymapClient.getInstance().getCoreProperties();
        List<StringField> history = properties.colorPickerHistory;
        if (!history.isEmpty()) {
            this.historyLayout = class_8667.method_52741();
            this.historyLayout.method_52740().method_46467();
            this.historyLayout.method_52736((class_8021)new class_7842(this.labelHistory, this.field_22793).method_46438(Color.cyan.getRGB()));
            for (int i = 0; i < history.size(); ++i) {
                this.historyLayout.method_52736((class_8021)new HistoryButton(this.colorHistoryButtonTexture, RGB.hexToInt(history.get(i).get()), b -> this.historySelected((HistoryButton)b)));
            }
            this.historyLayout.method_48206(x$0 -> {
                class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
            });
        }
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.method_48640();
        this.updateHSVfields();
        this.updateFullBrightness();
        this.updateRGBfields();
        this.updateHexField();
        this.updateDecField();
        this.updateColorWheelHandler();
        this.updateAlphaField();
        this.updateVSliderHandler();
        this.updateASliderHandler();
    }

    @Override
    public void renderPopupScreenBackground(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_52752(graphics);
        graphics.method_52706(BACKGROUND_SPRITE, this.layout.method_46426() - 18, this.layout.method_46427() - 18, this.layout.method_25368() + 36, this.layout.method_25364() + 36);
        if (this.historyLayout != null) {
            graphics.method_52706(BACKGROUND_SPRITE, this.historyLayout.method_46426() - 18, this.historyLayout.method_46427() - 15, this.historyLayout.method_25368() + 36, this.historyLayout.method_25364() + 33);
        }
    }

    protected void method_48640() {
        this.layout.method_48222();
        class_7843.method_48634((class_8021)this.layout, (class_8030)this.method_48202());
        if (this.historyLayout != null) {
            this.historyLayout.method_48222();
            this.historyLayout.method_48229(this.layout.method_46426() + this.layout.method_25368() + 48, this.layout.method_46427() - 3);
        }
    }

    private static void addTextBoxWithLabel(class_8667 layout, class_327 font, class_2561 label, TextBox textBox) {
        class_7845 gridLayout = new class_7845();
        gridLayout.method_46457().method_46474();
        gridLayout.method_48637(4);
        gridLayout.method_46455((class_8021)new class_7842(label, font).method_48596().method_46438(Color.cyan.getRGB()), 0, 0, class_7847.method_46481().method_46474());
        gridLayout.method_46452((class_8021)textBox, 0, 1);
        layout.method_52736((class_8021)gridLayout);
    }

    private static void addSliderGroup(class_8667 layout, IntSliderButton slider1, IntSliderButton slider2, IntSliderButton slider3) {
        class_8667 linearLayout = class_8667.method_52741();
        linearLayout.method_52736((class_8021)slider1);
        linearLayout.method_52736((class_8021)slider2);
        linearLayout.method_52736((class_8021)slider3);
        layout.method_52736((class_8021)linearLayout);
    }

    private void submit() {
        StringField field = new StringField(Category.Hidden, "");
        field.set(RGB.toHexStringRGBA(this.currentColor));
        CoreProperties properties = JourneymapClient.getInstance().getCoreProperties();
        properties.colorPickerHistory.removeIf(f -> f.get().equals(field.get()));
        properties.colorPickerHistory.add(0, field);
        if (properties.colorPickerHistory.size() > 18) {
            properties.colorPickerHistory.remove(18);
        }
        properties.save();
        this.setResponseAndClose(new ColorPickerResponse(this.currentColor, false));
    }

    private void reset() {
        this.currentColor = this.originalColor;
        this.updateHSVfields();
        this.updateFullBrightness();
        this.updateRGBfields();
        this.updateHexField();
        this.updateDecField();
        this.updateColorWheelHandler();
        this.updateAlphaField();
        this.updateVSliderHandler();
        this.updateASliderHandler();
    }

    @Override
    public void renderPopupScreen(class_332 graphics, int x, int y, float partialTicks) {
        super.renderPopupScreen(graphics, x, y, partialTicks);
        this.renderColorBoxes(graphics, this.layout.method_46426() + 1, this.layout.method_46427() + 20);
        this.renderColorWheel(graphics, this.layout.method_46426() + 121, this.layout.method_46427() - 6);
        this.renderSlider(graphics, this.layout.method_46426() + 249, this.layout.method_46427(), this.vSliderRect, this.vSliderHandler, this.currentColorFullBrightness, -16777216);
        if (this.withAlpha) {
            this.renderSlider(graphics, this.layout.method_46426() + 109, this.layout.method_46427(), this.aSliderRect, this.aSliderHandler, this.currentColor | 0xFF000000, this.currentColor & 0xFFFFFF);
        }
    }

    private IntSliderButton createCenteredSlider(IntegerField field, String prefix, Function<Button, Boolean> listener) {
        IntSliderButton slider = new IntSliderButton(field, prefix + " ", "");
        slider.method_25358(265);
        slider.method_53533(15);
        slider.setDefaultStyle(false);
        slider.setDrawBackground(false);
        slider.addClickListener(listener);
        return slider;
    }

    private void renderColorBoxes(class_332 graphics, int x, int y) {
        int texWidth = this.colorBoxTexture.getWidth();
        int texHeight = this.colorBoxTexture.getHeight();
        int colorWidth = (texWidth - 2) / 2;
        int colorHeight = (texHeight - 2) / 2;
        int x2 = x + colorWidth;
        int y2 = y + colorHeight;
        DrawUtil.drawImage(graphics.method_51448(), this.colorBoxTexture, (double)(x - 1), (double)(y - 1), false, 1.0f, 0.0, false);
        graphics.method_25294(x, y, x + colorWidth, y + colorHeight, this.originalColor | 0xFF000000);
        graphics.method_25294(x2, y, x2 + colorWidth, y + colorHeight, this.currentColor | 0xFF000000);
        graphics.method_25294(x, y2, x + colorWidth, y2 + colorHeight, this.originalColor);
        graphics.method_25294(x2, y2, x2 + colorWidth, y2 + colorHeight, this.currentColor);
        graphics.method_25303(this.field_22793, this.labelOld, x + 2, y - 10, Color.cyan.getRGB());
        graphics.method_25303(this.field_22793, this.labelNew, x + texWidth - 1 - this.field_22793.method_1727(this.labelNew), y - 10, Color.cyan.getRGB());
    }

    private void renderColorWheel(class_332 graphics, int x, int y) {
        int cwWidth = this.colorwheelTexture.getWidth();
        int cwHeight = this.colorwheelTexture.getHeight();
        DrawUtil.drawImage(graphics.method_51448(), this.colorwheelTexture, x, y, false, 1.0f, 0.0);
        this.colorWheelRect.setRect(x + 6, y + 6, cwWidth - 12, cwHeight - 12);
        int handlerX = (int)((double)(x + (cwWidth >> 1)) + this.colorwheelHandlerX - 2.0);
        int handlerY = (int)((double)(y + (cwHeight >> 1)) + this.colorwheelHandlerY - 2.0);
        graphics.method_25294(handlerX + 2, handlerY + 2, handlerX + 3, handlerY + 3, this.currentColorFullBrightness);
        DrawUtil.drawImage(graphics.method_51448(), this.colorwheelHandlerTexture, (double)handlerX, (double)handlerY, false, 1.0f, 0.0, false);
    }

    private void renderSlider(class_332 graphics, int x, int y, Rectangle2D.Double rect, double handler, int colorTop, int colorBottom) {
        int vSliderWidth = this.colorVSliderTexture.getWidth();
        int vSliderHeight = this.colorVSliderTexture.getHeight();
        DrawUtil.drawImage(graphics.method_51448(), this.colorVSliderTexture, (double)x, (double)y, false, 1.0f, 0.0, false);
        graphics.method_25296(x + 1, y + 1, x + vSliderWidth - 1, y + vSliderHeight - 1, colorTop, colorBottom);
        rect.setRect(x, y, vSliderWidth, vSliderHeight);
        int handlerX = x + 1;
        int handlerY = (int)((double)y + handler + 1.5);
        graphics.method_25294(handlerX + 2, handlerY + 2, handlerX + 9, handlerY + 3, colorTop);
        DrawUtil.drawImage(graphics.method_51448(), this.colorVSliderHandlerTexture, (double)handlerX, (double)handlerY, false, 1.0f, 0.0, false);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.fieldHex.method_25404(keyCode, scanCode, modifiers)) {
            this.listenerHex();
            return true;
        }
        if (this.fieldDec.method_25404(keyCode, scanCode, modifiers)) {
            this.listenerDec();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char typedChar, int keyCode) {
        if (this.fieldHex.method_25400(typedChar, keyCode)) {
            this.listenerHex();
            return true;
        }
        if (this.fieldDec.method_25400(typedChar, keyCode)) {
            this.listenerDec();
            return true;
        }
        return super.method_25400(typedChar, keyCode);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.method_48267();
            if (this.colorWheelRect.contains(mouseX, mouseY)) {
                return this.updateCWHandler(mouseX, mouseY);
            }
            if (this.vSliderRect.contains(mouseX, mouseY)) {
                return this.updateVSHandler(mouseX, mouseY);
            }
            if (this.withAlpha && this.aSliderRect.contains(mouseX, mouseY)) {
                return this.updateASHandler(mouseX, mouseY);
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.draggingCWHandler = false;
            this.draggingVSHandler = false;
            this.draggingASHandler = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0) {
            if (this.draggingCWHandler) {
                return this.updateCWHandler(mouseX, mouseY);
            }
            if (this.draggingVSHandler) {
                return this.updateVSHandler(mouseX, mouseY);
            }
            if (this.draggingASHandler) {
                return this.updateASHandler(mouseX, mouseY);
            }
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    private boolean updateCWHandler(double mouseX, double mouseY) {
        double localY;
        double localX = mouseX - this.colorWheelRect.getCenterX();
        double dist = Math.sqrt(localX * localX + (localY = mouseY - this.colorWheelRect.getCenterY()) * localY);
        if (dist < 57.0) {
            this.draggingCWHandler = true;
        }
        if (this.draggingCWHandler) {
            if (dist >= 57.0) {
                localX = localX / dist * 57.0;
                localY = localY / dist * 57.0;
            }
            this.colorwheelHandlerX = localX;
            this.colorwheelHandlerY = localY;
            double angle = Math.atan2(this.colorwheelHandlerX, -this.colorwheelHandlerY) / (Math.PI * 2);
            angle = angle < 0.0 ? angle + 1.0 : angle;
            this.sliderH.setValue((int)(angle * 255.0));
            this.sliderS.setValue((int)(dist / 57.0 * 255.0));
            this.currentColor = Color.HSBtoRGB((float)this.fieldH.get().intValue() / 255.0f, (float)this.fieldS.get().intValue() / 255.0f, (float)this.fieldV.get().intValue() / 255.0f);
            this.currentColor = this.currentColor & 0xFFFFFF | this.fieldA.get() << 24;
            this.updateFullBrightness();
            this.updateRGBfields();
            this.updateHexField();
            this.updateDecField();
            return true;
        }
        return false;
    }

    private boolean updateVSHandler(double mouseX, double mouseY) {
        this.draggingVSHandler = true;
        double localY = mouseY - this.vSliderRect.getY() - 3.0;
        if (localY < 0.0) {
            localY = 0.0;
        } else if (localY > 110.0) {
            localY = 110.0;
        }
        this.vSliderHandler = localY;
        this.sliderV.setValue((int)((1.0 - this.vSliderHandler / 110.0) * 255.0));
        this.currentColor = Color.HSBtoRGB((float)this.fieldH.get().intValue() / 255.0f, (float)this.fieldS.get().intValue() / 255.0f, (float)this.fieldV.get().intValue() / 255.0f);
        this.currentColor = this.currentColor & 0xFFFFFF | this.fieldA.get() << 24;
        this.updateFullBrightness();
        this.updateRGBfields();
        this.updateHexField();
        this.updateDecField();
        return true;
    }

    private boolean updateASHandler(double mouseX, double mouseY) {
        this.draggingASHandler = true;
        double localY = mouseY - this.aSliderRect.getY() - 3.0;
        if (localY < 0.0) {
            localY = 0.0;
        } else if (localY > 110.0) {
            localY = 110.0;
        }
        this.aSliderHandler = localY;
        this.sliderA.setValue((int)((1.0 - this.aSliderHandler / 110.0) * 255.0));
        this.currentColor = this.currentColor & 0xFFFFFF | this.fieldA.get() << 24;
        this.updateHexField();
        this.updateDecField();
        return true;
    }

    private boolean historySelected(HistoryButton button) {
        int color = button.getColor();
        if (!this.withAlpha) {
            color = color & 0xFFFFFF | this.currentColor & 0xFF000000;
        }
        this.currentColor = color;
        this.updateHSVfields();
        this.updateFullBrightness();
        this.updateRGBfields();
        this.updateColorWheelHandler();
        this.updateAlphaField();
        this.updateVSliderHandler();
        this.updateASliderHandler();
        this.updateHexField();
        this.updateDecField();
        return true;
    }

    private void updateColorWheelHandler() {
        double angle = (double)this.fieldH.get().intValue() / 255.0 * Math.PI * 2.0;
        double dist = (double)this.fieldS.get().intValue() / 255.0 * 57.0;
        this.colorwheelHandlerX = dist * Math.sin(angle);
        this.colorwheelHandlerY = dist * -Math.cos(angle);
    }

    private void updateVSliderHandler() {
        this.vSliderHandler = (1.0 - (double)this.fieldV.get().intValue() / 255.0) * 110.0;
    }

    private void updateASliderHandler() {
        if (this.withAlpha) {
            this.aSliderHandler = (1.0 - (double)this.fieldA.get().intValue() / 255.0) * 110.0;
        }
    }

    private boolean listenerHSV(Button button) {
        this.currentColor = Color.HSBtoRGB((float)this.fieldH.get().intValue() / 255.0f, (float)this.fieldS.get().intValue() / 255.0f, (float)this.fieldV.get().intValue() / 255.0f);
        this.currentColor = this.currentColor & 0xFFFFFF | this.fieldA.get() << 24;
        this.updateFullBrightness();
        this.updateRGBfields();
        this.updateColorWheelHandler();
        this.updateVSliderHandler();
        this.updateHexField();
        this.updateDecField();
        return true;
    }

    private boolean listenerRGB(Button button) {
        this.currentColor = this.fieldA.get() << 24 | this.fieldR.get() << 16 | this.fieldG.get() << 8 | this.fieldB.get();
        this.updateHSVfields();
        this.updateFullBrightness();
        this.updateColorWheelHandler();
        this.updateVSliderHandler();
        this.updateHexField();
        this.updateDecField();
        return true;
    }

    private boolean listenerAlpha(Button button) {
        this.currentColor = this.currentColor & 0xFFFFFF | this.fieldA.get() << 24;
        this.updateASliderHandler();
        this.updateHexField();
        this.updateDecField();
        return true;
    }

    private boolean listenerHex() {
        this.currentColor = this.getSafeColorHex(this.fieldHex);
        this.updateHSVfields();
        this.updateFullBrightness();
        this.updateRGBfields();
        this.updateColorWheelHandler();
        this.updateAlphaField();
        this.updateVSliderHandler();
        this.updateASliderHandler();
        this.updateDecField();
        return true;
    }

    private boolean listenerDec() {
        this.currentColor = this.getSafeColorDec(this.fieldDec);
        this.updateHSVfields();
        this.updateFullBrightness();
        this.updateRGBfields();
        this.updateColorWheelHandler();
        this.updateAlphaField();
        this.updateVSliderHandler();
        this.updateASliderHandler();
        this.updateHexField();
        return true;
    }

    private void updateRGBfields() {
        this.sliderR.setValue(this.currentColor >> 16 & 0xFF);
        this.sliderG.setValue(this.currentColor >> 8 & 0xFF);
        this.sliderB.setValue(this.currentColor & 0xFF);
    }

    private void updateHSVfields() {
        float[] hsv = Color.RGBtoHSB(this.currentColor >> 16 & 0xFF, this.currentColor >> 8 & 0xFF, this.currentColor & 0xFF, null);
        this.sliderH.setValue((int)(hsv[0] * 255.0f));
        this.sliderS.setValue((int)(hsv[1] * 255.0f));
        this.sliderV.setValue((int)(hsv[2] * 255.0f));
    }

    private void updateHexField() {
        String format = this.withAlpha ? "%08X" : "%06X";
        int color = this.withAlpha ? this.currentColor : this.currentColor & 0xFFFFFF;
        this.fieldHex.setText(String.format(format, color));
    }

    private void updateDecField() {
        int color = this.withAlpha ? this.currentColor : this.currentColor & 0xFFFFFF;
        this.fieldDec.setText(String.valueOf(color));
    }

    private void updateAlphaField() {
        if (this.withAlpha) {
            this.sliderA.setValue(this.currentColor >> 24 & 0xFF);
        } else {
            this.fieldA.set((Object)(this.currentColor >> 24 & 0xFF));
        }
    }

    private void updateFullBrightness() {
        this.currentColorFullBrightness = Color.HSBtoRGB((float)this.fieldH.get().intValue() / 255.0f, (float)this.fieldS.get().intValue() / 255.0f, 1.0f);
    }

    private int getSafeColorHex(TextBox field) {
        field.clamp();
        String text = field.method_1882();
        int color = RGB.hexToInt(text);
        if (this.withAlpha) {
            return color;
        }
        return color & 0xFFFFFF | this.fieldA.get() << 24;
    }

    private int getSafeColorDec(TextBox field) {
        field.clamp();
        String text = field.method_1882();
        if (text.isEmpty()) {
            return 0;
        }
        int val = 0;
        try {
            val = Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!this.withAlpha) {
            val = val & 0xFFFFFF | this.fieldA.get() << 24;
        }
        return val;
    }

    public record ColorPickerResponse(int color, boolean canceled) {
    }

    private static class HistoryButton
    extends Button {
        private final Texture texture;
        private final int color;

        public HistoryButton(Texture texture, int color, class_4185.class_4241 onPress) {
            super(texture.getWidth(), texture.getHeight(), "", onPress);
            this.color = color;
            this.texture = texture;
        }

        @Override
        public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            int colorWidth = (this.field_22758 - 4) / 2;
            int colorHeight = this.field_22759 - 4;
            DrawUtil.drawImage(graphics.method_51448(), this.texture, (double)super.method_46426(), (double)super.method_46427(), false, 1.0f, 0.0, false);
            int colorX = super.method_46426() + 2;
            int colorY = super.method_46427() + 2;
            graphics.method_25294(colorX, colorY, colorX + colorWidth, colorY + colorHeight, this.color | 0xFF000000);
            graphics.method_25294(colorX + colorWidth, colorY, colorX + colorWidth * 2, colorY + colorHeight, this.color);
            if (this.method_25367()) {
                DrawUtil.drawRectangle(graphics, super.method_46426(), super.method_46427(), this.field_22758, 1.0, 0xFFFFFF, 1.0f);
                DrawUtil.drawRectangle(graphics, super.method_46426(), super.method_46427(), 1.0, this.field_22759, 0xFFFFFF, 1.0f);
                DrawUtil.drawRectangle(graphics, super.method_46426(), super.method_46427() + this.field_22759 - 1, this.field_22758 - 1, 1.0, 0xFFFFFF, 1.0f);
                DrawUtil.drawRectangle(graphics, super.method_46426() + this.field_22758 - 1, super.method_46427() + 1, 1.0, this.field_22759 - 1, 0xFFFFFF, 1.0f);
            }
        }

        public int getColor() {
            return this.color;
        }
    }
}

