/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.minimap;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.io.ThemeLoader;
import journeymap.client.model.MapType;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.Texture;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.minimap.LabelVars;
import journeymap.client.ui.minimap.Orientation;
import journeymap.client.ui.minimap.Position;
import journeymap.client.ui.minimap.Shape;
import journeymap.client.ui.option.LocationFormat;
import journeymap.client.ui.theme.Theme;
import journeymap.client.ui.theme.ThemeCompassPoints;
import journeymap.client.ui.theme.ThemeLabelSource;
import journeymap.client.ui.theme.ThemeMinimapFrame;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_4597;

public class DisplayVars {
    final Position position;
    final Shape shape;
    final Orientation orientation;
    final double fontScale;
    final double infoSlotFontScale;
    final int displayWidth;
    final int displayHeight;
    final float terrainAlpha;
    final class_1041 mainWindow;
    public final int minimapWidth;
    public final int minimapHeight;
    public final int textureX;
    public final int textureY;
    final int translateX;
    final int translateY;
    final double reticleSegmentLength;
    public final Point2D.Double centerPoint;
    final boolean showCompass;
    final boolean showReticle;
    final List<class_3545<LabelVars, ThemeLabelSource.InfoSlot>> labels = new ArrayList<class_3545<LabelVars, ThemeLabelSource.InfoSlot>>(4);
    final Theme theme;
    final ThemeMinimapFrame minimapFrame;
    final ThemeCompassPoints minimapCompassPoints;
    final Theme.Minimap.MinimapSpec minimapSpec;
    final LocationFormat.LocationFormatKeys locationFormatKeys;
    final boolean locationFormatVerbose;
    final boolean frameRotates;
    public int marginX;
    public int marginY;
    MapTypeStatus mapTypeStatus;
    MapPresetStatus mapPresetStatus;
    float positionY;
    float positionX;

    DisplayVars(class_310 mc, MiniMapProperties miniMapProperties) {
        int startY;
        this.mainWindow = mc.method_22683();
        this.showCompass = miniMapProperties.showCompass.get();
        this.showReticle = miniMapProperties.showReticle.get();
        this.position = (Position)((Object)miniMapProperties.position.get());
        this.orientation = (Orientation)((Object)miniMapProperties.orientation.get());
        this.displayWidth = mc.method_22683().method_4480();
        this.displayHeight = mc.method_22683().method_4507();
        this.terrainAlpha = Math.max(0.0f, Math.min(1.0f, (float)miniMapProperties.terrainAlpha.get().intValue() / 100.0f));
        this.locationFormatKeys = new LocationFormat().getFormatKeys(miniMapProperties.locationFormat.get());
        this.locationFormatVerbose = miniMapProperties.locationFormatVerbose.get();
        this.theme = ThemeLoader.getCurrentTheme();
        this.positionY = miniMapProperties.positionY.get().floatValue();
        this.positionX = miniMapProperties.positionX.get().floatValue();
        switch ((Shape)((Object)miniMapProperties.shape.get())) {
            case Rectangle: {
                if (this.theme.minimap.square != null) {
                    this.shape = Shape.Rectangle;
                    this.minimapSpec = this.theme.minimap.square;
                    double ratio = (double)mc.method_22683().method_4480() * 1.0 / (double)mc.method_22683().method_4507();
                    this.minimapHeight = miniMapProperties.getSize();
                    this.minimapWidth = (int)((double)this.minimapHeight * ratio);
                    this.reticleSegmentLength = (double)this.minimapWidth / 1.5;
                    break;
                }
            }
            case Circle: {
                if (this.theme.minimap.circle != null) {
                    this.shape = Shape.Circle;
                    this.minimapSpec = this.theme.minimap.circle;
                    this.minimapWidth = miniMapProperties.getSize();
                    this.minimapHeight = miniMapProperties.getSize();
                    this.reticleSegmentLength = this.minimapHeight / 2;
                    break;
                }
            }
            default: {
                this.shape = Shape.Square;
                this.minimapSpec = this.theme.minimap.square;
                this.minimapWidth = miniMapProperties.getSize();
                this.minimapHeight = miniMapProperties.getSize();
                this.reticleSegmentLength = Math.sqrt(this.minimapHeight * this.minimapHeight + this.minimapWidth * this.minimapWidth) / 2.0;
            }
        }
        this.fontScale = miniMapProperties.fontScale.get().floatValue();
        this.infoSlotFontScale = miniMapProperties.infoSlotFontScale.get().floatValue();
        class_327 fontRenderer = mc.field_1772;
        int topInfoLabelsHeight = this.getInfoLabelAreaHeight(fontRenderer, this.minimapSpec.labelTop, ThemeLabelSource.values.get(miniMapProperties.info1Label.get()), ThemeLabelSource.values.get(miniMapProperties.info2Label.get()));
        int bottomInfoLabelsHeight = this.getInfoLabelAreaHeight(fontRenderer, this.minimapSpec.labelBottom, ThemeLabelSource.values.get(miniMapProperties.info3Label.get()), ThemeLabelSource.values.get(miniMapProperties.info4Label.get()));
        float compassFontScale = miniMapProperties.compassFontScale.get().floatValue();
        float compassLabelHeight = 0.0f;
        if (this.showCompass) {
            compassLabelHeight = (float)DrawUtil.getLabelHeight(fontRenderer, this.minimapSpec.compassLabel.shadow) * compassFontScale;
        }
        this.minimapFrame = new ThemeMinimapFrame(this.theme, this.minimapSpec, miniMapProperties, this.minimapWidth, this.minimapHeight);
        this.marginX = this.marginY = this.minimapSpec.margin;
        if (this.showCompass) {
            double compassPointMargin;
            boolean compassExists;
            boolean bl = compassExists = this.minimapSpec.compassPoint != null && this.minimapSpec.compassPoint.width > 0;
            if (compassExists) {
                Texture compassPointTex = this.minimapFrame.getCompassPoint();
                float compassPointScale = ThemeCompassPoints.getCompassPointScale(compassLabelHeight, this.minimapSpec, compassPointTex);
                compassPointMargin = (float)(compassPointTex.getWidth() / 2) * compassPointScale;
            } else {
                compassPointMargin = compassLabelHeight;
            }
            this.marginX = (int)Math.max((double)this.marginX, Math.ceil(compassPointMargin));
            this.marginY = (int)Math.max((double)this.marginY, Math.ceil(compassPointMargin) + (double)(compassLabelHeight / 2.0f));
        }
        if (!this.minimapSpec.labelBottomInside) {
            this.marginY += bottomInfoLabelsHeight;
        }
        int halfWidth = this.minimapWidth / 2;
        int halfHeight = this.minimapHeight / 2;
        int screenHeight = mc.method_22683().method_4507();
        int screenWidth = mc.method_22683().method_4480();
        double scale = mc.method_22683().method_4495();
        switch (this.position) {
            case BottomRight: {
                if (!this.minimapSpec.labelBottomInside) {
                    this.marginY += bottomInfoLabelsHeight;
                }
                this.textureX = screenWidth - this.minimapWidth - this.marginX;
                this.textureY = screenHeight - this.minimapHeight - this.marginY;
                this.translateX = screenWidth / 2 - halfWidth - this.marginX;
                this.translateY = screenHeight / 2 - halfHeight - this.marginY;
                break;
            }
            case TopLeft: {
                if (!this.minimapSpec.labelTopInside) {
                    this.marginY = Math.max(this.marginY, topInfoLabelsHeight + 2 * this.minimapSpec.margin);
                }
                this.textureX = this.marginX;
                this.textureY = this.marginY;
                this.translateX = -(screenWidth / 2) + halfWidth + this.marginX;
                this.translateY = -(screenHeight / 2) + halfHeight + this.marginY;
                break;
            }
            case BottomLeft: {
                if (!this.minimapSpec.labelBottomInside) {
                    this.marginY += bottomInfoLabelsHeight;
                }
                this.textureX = this.marginX;
                this.textureY = screenHeight - this.minimapHeight - this.marginY;
                this.translateX = -(screenWidth / 2) + halfWidth + this.marginX;
                this.translateY = screenHeight / 2 - halfHeight - this.marginY;
                break;
            }
            case TopCenter: {
                if (!this.minimapSpec.labelTopInside) {
                    this.marginY = Math.max(this.marginY, topInfoLabelsHeight + 2 * this.minimapSpec.margin);
                }
                this.textureX = (screenWidth - this.minimapWidth) / 2;
                this.textureY = this.marginY;
                this.translateX = 0;
                this.translateY = -(screenHeight / 2) + halfHeight + this.marginY;
                break;
            }
            case Center: {
                this.textureX = (screenWidth - this.minimapWidth) / 2;
                this.textureY = (screenHeight - this.minimapHeight) / 2;
                this.translateX = 0;
                this.translateY = 0;
                break;
            }
            case Custom: {
                this.textureX = (int)((float)screenWidth * this.positionX);
                this.textureY = (int)((float)screenHeight * this.positionY);
                this.translateX = this.textureX - screenWidth / 2 + halfWidth;
                this.translateY = this.textureY - screenHeight / 2 + halfHeight;
                break;
            }
            default: {
                if (!this.minimapSpec.labelTopInside) {
                    this.marginY = Math.max(this.marginY, topInfoLabelsHeight + 2 * this.minimapSpec.margin);
                }
                this.textureX = screenWidth - this.minimapWidth - this.marginX;
                this.textureY = this.marginY;
                this.translateX = screenWidth / 2 - halfWidth - this.marginX;
                this.translateY = -(screenHeight / 2) + halfHeight + this.marginY;
            }
        }
        this.minimapFrame.setPosition(this.textureX, this.textureY);
        this.centerPoint = new Point2D.Double(this.textureX + halfWidth, this.textureY + halfHeight);
        this.minimapCompassPoints = new ThemeCompassPoints(this.textureX, this.textureY, halfWidth, halfHeight, this.minimapSpec, miniMapProperties, this.minimapFrame.getCompassPoint(), compassLabelHeight);
        this.frameRotates = this.shape == Shape.Circle ? ((Theme.Minimap.MinimapCircle)this.minimapSpec).rotates : false;
        int centerX = (int)Math.floor(this.textureX + this.minimapWidth / 2);
        if (topInfoLabelsHeight > 0) {
            startY = this.minimapSpec.labelTopInside ? this.textureY + this.minimapSpec.margin : this.textureY - this.minimapSpec.margin - topInfoLabelsHeight;
            this.positionLabels(fontRenderer, centerX, startY, this.minimapSpec.labelTop, ThemeLabelSource.values.get(miniMapProperties.info1Label.get()), ThemeLabelSource.values.get(miniMapProperties.info2Label.get()));
        }
        if (bottomInfoLabelsHeight > 0) {
            startY = this.textureY + this.minimapHeight;
            this.positionLabels(fontRenderer, centerX, startY += this.minimapSpec.labelBottomInside ? -this.minimapSpec.margin - bottomInfoLabelsHeight : this.minimapSpec.margin, this.minimapSpec.labelBottom, ThemeLabelSource.values.get(miniMapProperties.info3Label.get()), ThemeLabelSource.values.get(miniMapProperties.info4Label.get()));
        }
        ThemeLabelSource.resetCaches();
    }

    public Shape getShape() {
        return this.shape;
    }

    public int getInfoLabelAreaHeight(class_327 fontRenderer, Theme.LabelSpec labelSpec, ThemeLabelSource.InfoSlot ... themeLabelSources) {
        int labelHeight = this.getInfoLabelHeight(fontRenderer, labelSpec);
        int areaHeight = 0;
        for (ThemeLabelSource.InfoSlot themeLabelSource : themeLabelSources) {
            areaHeight += themeLabelSource.isShown() ? labelHeight : 0;
        }
        return areaHeight;
    }

    private int getInfoLabelHeight(class_327 fontRenderer, Theme.LabelSpec labelSpec) {
        return (int)((double)(DrawUtil.getLabelHeight(fontRenderer, labelSpec.shadow) + labelSpec.margin) * this.infoSlotFontScale);
    }

    private void positionLabels(class_327 fontRenderer, int centerX, int startY, Theme.LabelSpec labelSpec, ThemeLabelSource.InfoSlot ... themeLabelSources) {
        int labelHeight = this.getInfoLabelHeight(fontRenderer, labelSpec);
        int labelY = startY;
        for (ThemeLabelSource.InfoSlot themeLabelSource : themeLabelSources) {
            if (!themeLabelSource.isShown()) continue;
            LabelVars labelVars = new LabelVars(this, centerX, labelY, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, this.infoSlotFontScale, labelSpec);
            class_3545 tuple = new class_3545((Object)labelVars, (Object)themeLabelSource);
            this.labels.add((class_3545<LabelVars, ThemeLabelSource.InfoSlot>)tuple);
            labelY += labelHeight;
        }
    }

    public void drawInfoLabels(class_332 graphics, class_4597 buffers, long currentTimeMillis) {
        for (class_3545<LabelVars, ThemeLabelSource.InfoSlot> label : this.labels) {
            ((LabelVars)label.method_15442()).draw(graphics, buffers, ((ThemeLabelSource.InfoSlot)label.method_15441()).getLabelText(currentTimeMillis));
        }
    }

    MapPresetStatus getMapPresetStatus(MapType mapType, int miniMapId) {
        if (this.mapPresetStatus == null || !mapType.equals(this.mapPresetStatus.mapType) || miniMapId != this.mapPresetStatus.miniMapId) {
            this.mapPresetStatus = new MapPresetStatus(this, mapType, miniMapId);
        }
        return this.mapPresetStatus;
    }

    MapTypeStatus getMapTypeStatus(MapType mapType) {
        if (this.mapTypeStatus == null || !mapType.equals(this.mapTypeStatus.mapType)) {
            this.mapTypeStatus = new MapTypeStatus(this, mapType);
        }
        return this.mapTypeStatus;
    }

    class MapPresetStatus {
        private int miniMapId;
        private int scale = 4;
        private MapType mapType;
        private String name;
        private Integer color;

        MapPresetStatus(DisplayVars this$0, MapType mapType, int miniMapId) {
            this.miniMapId = miniMapId;
            this.mapType = mapType;
            this.color = 0xFFFFFF;
            this.name = Integer.toString(miniMapId);
        }

        void draw(class_332 graphics, Point2D.Double mapCenter, float alpha, double rotation) {
            DrawUtil.drawLabel(graphics, this.name, mapCenter.getX(), mapCenter.getY() + 8.0, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.0f, this.color, alpha, this.scale, true, rotation);
        }
    }

    class MapTypeStatus {
        private MapType mapType;
        private String name;
        private Texture tex;
        private Integer color;
        private Integer opposite;
        private double x;
        private double y;
        private float bgScale;
        private float scaleHeightOffset;

        MapTypeStatus(DisplayVars this$0, MapType mapType) {
            this.mapType = mapType;
            this.name = mapType.isUnderground() ? "caves" : mapType.name();
            this.tex = TextureCache.getThemeTexture(this$0.theme, String.format("icon/%s.png", this.name));
            this.color = 0xFFFFFF;
            this.opposite = 0x404040;
            this.bgScale = 1.15f;
            this.scaleHeightOffset = ((float)this.tex.getHeight() * this.bgScale - (float)this.tex.getHeight()) / 2.0f;
        }

        void draw(class_332 graphics, Point2D.Double mapCenter, float alpha, double rotation) {
            this.x = mapCenter.getX() - (double)(this.tex.getWidth() / 2);
            this.y = mapCenter.getY() - (double)this.tex.getHeight() - 8.0;
            DrawUtil.drawColoredImage(graphics.method_51448(), this.tex, this.opposite, alpha, mapCenter.getX() - (double)((float)this.tex.getWidth() * this.bgScale / 2.0f), mapCenter.getY() - (double)((float)this.tex.getHeight() * this.bgScale) + (double)this.scaleHeightOffset - 8.0, this.bgScale, rotation);
            DrawUtil.drawColoredImage(graphics.method_51448(), this.tex, this.color, alpha, this.x, this.y, 1.0f, 0.0);
        }
    }
}

