/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.objects.dataStreams;

import DistantHorizons.libraries.jpountz.lz4.LZ4FrameInputStream;
import com.seibel.distanthorizons.api.enums.config.EDhApiDataCompressionMode;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.tukaani.xz.XZInputStream;

public class DhDataInputStream
extends DataInputStream {
    private static final Logger LOGGER = LogManager.getLogger();

    public DhDataInputStream(InputStream stream, EDhApiDataCompressionMode compressionMode) throws IOException {
        super(DhDataInputStream.warpStream(new BufferedInputStream(stream), compressionMode));
    }

    private static InputStream warpStream(InputStream stream, EDhApiDataCompressionMode compressionMode) throws IOException {
        try {
            switch (compressionMode) {
                case UNCOMPRESSED: {
                    return stream;
                }
                case LZ4: {
                    return new LZ4FrameInputStream(stream);
                }
                case LZMA2: {
                    return new XZInputStream(stream);
                }
            }
            throw new IllegalArgumentException("No compressor defined for [" + (Object)((Object)compressionMode) + "]");
        }
        catch (Error e) {
            LOGGER.error("Unexpected error when wrapping DhDataInputStream, error: [" + e.getMessage() + "].", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
    }
}

