/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.cache;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.util.Arrays;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.Logger;

public class ServerBlockStateCache {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public final BlockState state;
    public final LevelReader level;
    public final BlockPos pos;
    boolean noCollision = false;
    boolean[] occludeFaces = null;
    boolean[] fullFaces = null;
    boolean isShapeResolved = false;

    public ServerBlockStateCache(BlockState blockState, ILevelWrapper samplingLevel, DhBlockPos samplingPos) {
        this.state = blockState;
        this.level = (LevelReader)samplingLevel.getWrappedMcObject();
        this.pos = McObjectConverter.Convert(samplingPos);
        this.resolveShapes();
    }

    public void resolveShapes() {
        if (this.isShapeResolved) {
            return;
        }
        if (this.state.getFluidState().isEmpty()) {
            this.noCollision = this.state.getCollisionShape((BlockGetter)this.level, this.pos).isEmpty();
            this.occludeFaces = new boolean[6];
            if (this.state.canOcclude()) {
                for (Direction dir : Direction.values()) {
                    this.occludeFaces[McObjectConverter.Convert((Direction)dir).ordinal()] = !this.state.getFaceOcclusionShape((BlockGetter)this.level, this.pos, dir).isEmpty();
                }
            }
            VoxelShape voxelShape = this.state.getShape((BlockGetter)this.level, this.pos);
            this.fullFaces = new boolean[6];
            if (!voxelShape.isEmpty()) {
                for (Direction dir : Direction.values()) {
                    VoxelShape faceShape = voxelShape.getFaceShape(dir);
                    AABB aabb = faceShape.bounds();
                    boolean xFull = aabb.minX <= 0.01 && aabb.maxX >= 0.99;
                    boolean yFull = aabb.minY <= 0.01 && aabb.maxY >= 0.99;
                    boolean zFull = aabb.minZ <= 0.01 && aabb.maxZ >= 0.99;
                    this.fullFaces[McObjectConverter.Convert((Direction)dir).ordinal()] = !(!xFull && !dir.getAxis().equals((Object)Direction.Axis.X) || !yFull && !dir.getAxis().equals((Object)Direction.Axis.Y) || !zFull && !dir.getAxis().equals((Object)Direction.Axis.Z));
                }
            }
        } else {
            this.occludeFaces = new boolean[6];
            Arrays.fill(this.occludeFaces, true);
            this.fullFaces = new boolean[6];
            Arrays.fill(this.fullFaces, true);
        }
    }
}

