/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.api.ingredients;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.constants.Tags;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public interface IIngredientHelper<V> {
    public IIngredientType<V> getIngredientType();

    public String getDisplayName(V var1);

    public String getUniqueId(V var1, UidContext var2);

    default public boolean hasSubtypes(V ingredient) {
        return this.getIngredientType() instanceof IIngredientTypeWithSubtypes;
    }

    default public String getWildcardId(V ingredient) {
        return this.getUniqueId(ingredient, UidContext.Ingredient);
    }

    default public String getDisplayModId(V ingredient) {
        return this.getResourceLocation(ingredient).method_12836();
    }

    default public long getAmount(V ingredient) {
        return -1L;
    }

    default public V copyWithAmount(V ingredient, long amount) {
        return this.copyIngredient(ingredient);
    }

    default public Iterable<Integer> getColors(V ingredient) {
        return Collections.emptyList();
    }

    public class_2960 getResourceLocation(V var1);

    default public class_1799 getCheatItemStack(V ingredient) {
        return class_1799.field_8037;
    }

    public V copyIngredient(V var1);

    default public V normalizeIngredient(V ingredient) {
        return this.copyIngredient(ingredient);
    }

    default public boolean isValidIngredient(V ingredient) {
        return true;
    }

    default public boolean isIngredientOnServer(V ingredient) {
        return true;
    }

    default public Stream<class_2960> getTagStream(V ingredient) {
        return Stream.empty();
    }

    default public boolean isHiddenFromRecipeViewersByTags(V ingredient) {
        return this.getTagStream(ingredient).anyMatch(arg_0 -> ((class_2960)Tags.HIDDEN_FROM_RECIPE_VIEWERS).equals(arg_0));
    }

    public String getErrorInfo(@Nullable V var1);

    default public Optional<class_2960> getTagEquivalent(Collection<V> ingredients) {
        return Optional.empty();
    }
}

