/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import mezz.jei.common.config.BookmarkTooltipFeature;
import mezz.jei.common.config.GiveMode;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IngredientSortStage;
import mezz.jei.common.config.RecipeSorterStage;
import mezz.jei.common.config.file.ConfigValue;
import mezz.jei.common.config.file.IConfigCategoryBuilder;
import mezz.jei.common.config.file.IConfigSchemaBuilder;
import mezz.jei.common.config.file.serializers.EnumSerializer;
import mezz.jei.common.config.file.serializers.ListSerializer;
import mezz.jei.common.platform.Services;
import org.jetbrains.annotations.Nullable;

public final class ClientConfig
implements IClientConfig {
    @Nullable
    private static IClientConfig instance;
    private final Supplier<Boolean> centerSearchBarEnabled;
    private final Supplier<Boolean> lowMemorySlowSearchEnabled;
    private final Supplier<Boolean> catchRenderErrorsEnabled;
    private final Supplier<Boolean> cheatToHotbarUsingHotkeysEnabled;
    private final Supplier<Boolean> addBookmarksToFrontEnabled;
    private final Supplier<Boolean> lookupFluidContentsEnabled;
    private final Supplier<Boolean> lookupBlockTagsEnabled;
    private final Supplier<GiveMode> giveMode;
    private final Supplier<List<BookmarkTooltipFeature>> bookmarkTooltipFeatures;
    private final Supplier<Boolean> holdShiftToShowBookmarkTooltipFeaturesEnabled;
    private final Supplier<Integer> maxRecipeGuiHeight;
    private final Supplier<List<IngredientSortStage>> ingredientSorterStages;
    private final ConfigValue<List<RecipeSorterStage>> recipeSorterStages;
    private final Supplier<Boolean> tagContentTooltipEnabled;
    private final Supplier<Boolean> hideSingleIngredientTagsEnabled;

    public ClientConfig(IConfigSchemaBuilder schema) {
        instance = this;
        boolean isDev = Services.PLATFORM.getModHelper().isInDev();
        IConfigCategoryBuilder advanced = schema.addCategory("advanced");
        this.centerSearchBarEnabled = advanced.addBoolean("CenterSearch", false, "Display search bar in the center");
        this.lowMemorySlowSearchEnabled = advanced.addBoolean("LowMemorySlowSearchEnabled", false, "Set low-memory mode (makes search very slow, but uses less RAM)");
        this.catchRenderErrorsEnabled = advanced.addBoolean("CatchRenderErrorsEnabled", !isDev, "Catch render errors from ingredients and attempt to recover from them instead of crashing.");
        this.cheatToHotbarUsingHotkeysEnabled = advanced.addBoolean("CheatToHotbarUsingHotkeysEnabled", false, "Enable cheating items into the hotbar by using the shift+number keys.");
        this.addBookmarksToFrontEnabled = advanced.addBoolean("AddBookmarksToFrontEnabled", false, "Add new bookmarks to the front of the bookmark list instead of the end.");
        this.lookupFluidContentsEnabled = advanced.addBoolean("lookupFluidContentsEnabled", false, "When looking up recipes with items that contain fluids, also look up recipes for the fluids.");
        this.lookupBlockTagsEnabled = advanced.addBoolean("lookupBlockTagsEnabled", true, "When searching for item tags, also include tags for the default blocks contained in the items.");
        this.giveMode = advanced.addEnum("GiveMode", GiveMode.defaultGiveMode, "How items should be handed to you");
        this.maxRecipeGuiHeight = advanced.addInteger("RecipeGuiHeight", 350, 175, Integer.MAX_VALUE, "Max. recipe gui height");
        IConfigCategoryBuilder bookmarkTooltips = schema.addCategory("bookmark_tooltips");
        this.bookmarkTooltipFeatures = bookmarkTooltips.addList("BookmarkTooltipFeatures", BookmarkTooltipFeature.DEFAULT_BOOKMARK_TOOLTIP_FEATURES, new ListSerializer<BookmarkTooltipFeature>(new EnumSerializer<BookmarkTooltipFeature>(BookmarkTooltipFeature.class)), "Extra features for bookmark tooltips");
        this.holdShiftToShowBookmarkTooltipFeaturesEnabled = bookmarkTooltips.addBoolean("HoldShiftToShowBookmarkTooltipFeatures", true, "Hold shift to show bookmark tooltip features");
        IConfigCategoryBuilder sorting = schema.addCategory("sorting");
        this.ingredientSorterStages = sorting.addList("IngredientSortStages", IngredientSortStage.defaultStages, new ListSerializer<IngredientSortStage>(new EnumSerializer<IngredientSortStage>(IngredientSortStage.class)), "Sorting order for the ingredient list");
        this.recipeSorterStages = sorting.addList("RecipeSorterStages", RecipeSorterStage.defaultStages, new ListSerializer<RecipeSorterStage>(new EnumSerializer<RecipeSorterStage>(RecipeSorterStage.class)), "Sorting order for displayed recipes");
        IConfigCategoryBuilder tags = schema.addCategory("tags");
        this.tagContentTooltipEnabled = tags.addBoolean("TagContentTooltipEnabled", true, "Show tag content in tooltips");
        this.hideSingleIngredientTagsEnabled = tags.addBoolean("HideSingleIngredientTagsEnabled", true, "Hide tag content in tooltips if the tag has 1 ingredient");
    }

    @Deprecated
    public static IClientConfig getInstance() {
        Preconditions.checkNotNull((Object)instance);
        return instance;
    }

    @Override
    public boolean isCenterSearchBarEnabled() {
        return this.centerSearchBarEnabled.get();
    }

    @Override
    public boolean isLowMemorySlowSearchEnabled() {
        return this.lowMemorySlowSearchEnabled.get();
    }

    @Override
    public boolean isCatchRenderErrorsEnabled() {
        return this.catchRenderErrorsEnabled.get();
    }

    @Override
    public boolean isCheatToHotbarUsingHotkeysEnabled() {
        return this.cheatToHotbarUsingHotkeysEnabled.get();
    }

    @Override
    public boolean isAddingBookmarksToFrontEnabled() {
        return this.addBookmarksToFrontEnabled.get();
    }

    @Override
    public boolean isLookupFluidContentsEnabled() {
        return this.lookupFluidContentsEnabled.get();
    }

    @Override
    public boolean isLookupBlockTagsEnabled() {
        return this.lookupBlockTagsEnabled.get();
    }

    @Override
    public GiveMode getGiveMode() {
        return this.giveMode.get();
    }

    @Override
    public List<BookmarkTooltipFeature> getBookmarkTooltipFeatures() {
        return this.bookmarkTooltipFeatures.get();
    }

    @Override
    public boolean isHoldShiftToShowBookmarkTooltipFeaturesEnabled() {
        return this.holdShiftToShowBookmarkTooltipFeaturesEnabled.get();
    }

    @Override
    public int getMaxRecipeGuiHeight() {
        return this.maxRecipeGuiHeight.get();
    }

    @Override
    public List<IngredientSortStage> getIngredientSorterStages() {
        return this.ingredientSorterStages.get();
    }

    @Override
    public Set<RecipeSorterStage> getRecipeSorterStages() {
        return Set.copyOf((Collection)this.recipeSorterStages.getValue());
    }

    @Override
    public void enableRecipeSorterStage(RecipeSorterStage stage) {
        List<RecipeSorterStage> recipeSorterStages = this.recipeSorterStages.get();
        if (!recipeSorterStages.contains((Object)stage)) {
            recipeSorterStages = new ArrayList<RecipeSorterStage>(recipeSorterStages);
            recipeSorterStages.add(stage);
            this.recipeSorterStages.set(recipeSorterStages);
        }
    }

    @Override
    public void disableRecipeSorterStage(RecipeSorterStage stage) {
        List<RecipeSorterStage> recipeSorterStages = this.recipeSorterStages.get();
        if (recipeSorterStages.contains((Object)stage)) {
            recipeSorterStages = new ArrayList<RecipeSorterStage>(recipeSorterStages);
            recipeSorterStages.remove((Object)stage);
            this.recipeSorterStages.set(recipeSorterStages);
        }
    }

    @Override
    public boolean isTagContentTooltipEnabled() {
        return this.tagContentTooltipEnabled.get();
    }

    @Override
    public boolean isHideSingleIngredientTagsEnabled() {
        return this.hideSingleIngredientTagsEnabled.get();
    }
}

