/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.fabric.platform;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.fabric.ingredients.fluids.IJeiFluidIngredient;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.fabric.ingredients.fluid.JeiFluidIngredient;
import mezz.jei.library.render.FluidTankRenderer;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1058;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import net.minecraft.class_6880;
import net.minecraft.class_9326;

public class FluidHelper
implements IPlatformFluidHelperInternal<IJeiFluidIngredient> {
    @Override
    public IIngredientTypeWithSubtypes<class_3611, IJeiFluidIngredient> getFluidIngredientType() {
        return FabricTypes.FLUID_STACK;
    }

    @Override
    public IIngredientRenderer<IJeiFluidIngredient> createRenderer(long capacity, boolean showCapacity, int width, int height) {
        return new FluidTankRenderer<IJeiFluidIngredient>(this, capacity, showCapacity, width, height);
    }

    @Override
    public Optional<class_1058> getStillFluidSprite(IJeiFluidIngredient ingredient) {
        FluidVariant fluidVariant = ingredient.getFluidVariant();
        class_1058 sprite = FluidVariantRendering.getSprite((FluidVariant)fluidVariant);
        return Optional.ofNullable(sprite);
    }

    @Override
    public class_2561 getDisplayName(IJeiFluidIngredient ingredient) {
        FluidVariant fluidVariant = ingredient.getFluidVariant();
        return FluidVariantAttributes.getName((FluidVariant)fluidVariant);
    }

    @Override
    public int getColorTint(IJeiFluidIngredient ingredient) {
        FluidVariant fluidVariant = ingredient.getFluidVariant();
        int fluidColor = FluidVariantRendering.getColor((FluidVariant)fluidVariant);
        return fluidColor | 0xFF000000;
    }

    @Override
    public List<class_2561> getTooltip(IJeiFluidIngredient ingredient, class_1836 tooltipFlag) {
        FluidVariant fluidVariant = ingredient.getFluidVariant();
        return FluidVariantRendering.getTooltip((FluidVariant)fluidVariant, (class_1836)tooltipFlag);
    }

    @Override
    public long getAmount(IJeiFluidIngredient ingredient) {
        return ingredient.getAmount();
    }

    @Override
    public class_9326 getComponentsPatch(IJeiFluidIngredient ingredient) {
        FluidVariant fluid = ingredient.getFluidVariant();
        return fluid.getComponents();
    }

    @Override
    public long bucketVolume() {
        return 81000L;
    }

    @Override
    public IJeiFluidIngredient create(class_6880<class_3611> fluid, long amount, class_9326 patch) {
        FluidVariant fluidVariant = FluidVariant.of((class_3611)((class_3611)fluid.comp_349()), (class_9326)patch);
        return new JeiFluidIngredient(fluidVariant, amount);
    }

    @Override
    public IJeiFluidIngredient create(class_6880<class_3611> fluid, long amount) {
        FluidVariant fluidVariant = FluidVariant.of((class_3611)((class_3611)fluid.comp_349()));
        return new JeiFluidIngredient(fluidVariant, amount);
    }

    @Override
    public IJeiFluidIngredient copy(IJeiFluidIngredient ingredient) {
        return new JeiFluidIngredient(ingredient.getFluidVariant(), ingredient.getAmount());
    }

    @Override
    public IJeiFluidIngredient normalize(IJeiFluidIngredient ingredient) {
        return new JeiFluidIngredient(ingredient.getFluidVariant(), this.bucketVolume());
    }

    @Override
    public Optional<IJeiFluidIngredient> getContainedFluid(ITypedIngredient<?> ingredient) {
        return ingredient.getItemStack().map(ContainerItemContext::withConstant).map(c -> (Storage)c.find(FluidStorage.ITEM)).map(Storage::iterator).filter(Iterator::hasNext).map(Iterator::next).map(view -> {
            FluidVariant resource = (FluidVariant)view.getResource();
            return new JeiFluidIngredient(resource, view.getAmount());
        });
    }

    @Override
    public IJeiFluidIngredient copyWithAmount(IJeiFluidIngredient ingredient, long amount) {
        return new JeiFluidIngredient(ingredient.getFluidVariant(), amount);
    }
}

