/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.gui.filter.IFilterTextSource;
import mezz.jei.gui.ingredients.DisplayNameUtil;
import mezz.jei.gui.ingredients.IIngredientSorter;
import mezz.jei.gui.ingredients.IListElement;
import mezz.jei.gui.ingredients.IListElementInfo;
import mezz.jei.gui.ingredients.IngredientListElementFactory;
import mezz.jei.gui.ingredients.ListElementInfo;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.gui.overlay.elements.IElement;
import mezz.jei.gui.overlay.elements.IngredientElement;
import mezz.jei.gui.search.ElementPrefixParser;
import mezz.jei.gui.search.ElementSearch;
import mezz.jei.gui.search.ElementSearchLowMem;
import mezz.jei.gui.search.IElementSearch;
import net.minecraft.class_2371;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class IngredientFilter
implements IIngredientGridSource,
IIngredientManager.IIngredientListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern QUOTE_PATTERN = Pattern.compile("\"");
    private static final Pattern FILTER_SPLIT_PATTERN = Pattern.compile("(-?\".*?(?:\"|$)|\\S+)");
    private final IClientConfig clientConfig;
    private final IFilterTextSource filterTextSource;
    private final IIngredientManager ingredientManager;
    private final IIngredientSorter sorter;
    private final IModIdHelper modIdHelper;
    private final IIngredientVisibility ingredientVisibility;
    private final ElementPrefixParser elementPrefixParser;
    private final Set<String> modNamesForSorting = new HashSet<String>();
    private IElementSearch elementSearch;
    @Nullable
    private List<IElement<?>> ingredientListCached;
    private final List<IIngredientGridSource.SourceListChangedListener> listeners = new ArrayList<IIngredientGridSource.SourceListChangedListener>();

    public IngredientFilter(IFilterTextSource filterTextSource, IClientConfig clientConfig, IIngredientFilterConfig config, IIngredientManager ingredientManager, IIngredientSorter sorter, class_2371<IListElement<?>> ingredients, IModIdHelper modIdHelper, IIngredientVisibility ingredientVisibility, IColorHelper colorHelper) {
        this.filterTextSource = filterTextSource;
        this.clientConfig = clientConfig;
        this.ingredientManager = ingredientManager;
        this.sorter = sorter;
        this.modIdHelper = modIdHelper;
        this.ingredientVisibility = ingredientVisibility;
        this.elementPrefixParser = new ElementPrefixParser(ingredientManager, config, colorHelper, modIdHelper);
        this.elementSearch = IngredientFilter.createElementSearch(clientConfig, this.elementPrefixParser);
        LOGGER.info("Adding {} ingredients", (Object)ingredients.size());
        for (IListElement ingredient : ingredients) {
            IListElementInfo info = ListElementInfo.create(ingredient, ingredientManager, modIdHelper);
            if (info == null) continue;
            this.addIngredient(info);
        }
        LOGGER.info("Added {} ingredients", (Object)ingredients.size());
        this.filterTextSource.addListener(filterText -> {
            this.ingredientListCached = null;
            this.notifyListenersOfChange();
        });
    }

    private static IElementSearch createElementSearch(IClientConfig clientConfig, ElementPrefixParser elementPrefixParser) {
        if (clientConfig.isLowMemorySlowSearchEnabled()) {
            return new ElementSearchLowMem();
        }
        return new ElementSearch(elementPrefixParser);
    }

    public <V> void addIngredient(IListElementInfo<V> info) {
        IListElement<V> element = info.getElement();
        this.updateHiddenState(element);
        this.elementSearch.add(info);
        String modNameForSorting = info.getModNameForSorting();
        this.modNamesForSorting.add(modNameForSorting);
        this.invalidateCache();
    }

    public void invalidateCache() {
        this.ingredientListCached = null;
        this.sorter.invalidateCache();
    }

    public void rebuildItemFilter() {
        this.invalidateCache();
        Collection<IListElementInfo<?>> ingredients = this.elementSearch.getAllIngredients();
        this.elementSearch = IngredientFilter.createElementSearch(this.clientConfig, this.elementPrefixParser);
        this.elementSearch.addAll(ingredients);
    }

    public <V> Optional<IListElementInfo<V>> searchForMatchingElement(IIngredientHelper<V> ingredientHelper, ITypedIngredient<V> typedIngredient) {
        V ingredient = typedIngredient.getIngredient();
        IIngredientType type = typedIngredient.getType();
        Function<ITypedIngredient, String> uidFunction = i -> ingredientHelper.getUniqueId(i.getIngredient(), UidContext.Ingredient);
        String ingredientUid = uidFunction.apply(typedIngredient);
        String lowercaseDisplayName = DisplayNameUtil.getLowercaseDisplayNameForSearch(ingredient, ingredientHelper);
        ElementPrefixParser.TokenInfo tokenInfo = new ElementPrefixParser.TokenInfo(lowercaseDisplayName, ElementPrefixParser.NO_PREFIX);
        return this.elementSearch.getSearchResults(tokenInfo).stream().map(elementInfo -> IngredientFilter.checkForMatch(elementInfo, type, ingredientUid, uidFunction)).flatMap(Optional::stream).findFirst();
    }

    public void updateHidden() {
        boolean changed = false;
        for (IListElementInfo<?> info : this.elementSearch.getAllIngredients()) {
            IListElement<?> element = info.getElement();
            changed |= this.updateHiddenState(element);
        }
        if (changed) {
            this.ingredientListCached = null;
            this.notifyListenersOfChange();
        }
    }

    public <V> boolean updateHiddenState(IListElement<V> element) {
        ITypedIngredient<V> typedIngredient = element.getTypedIngredient();
        boolean visible = this.ingredientVisibility.isIngredientVisible(typedIngredient);
        if (element.isVisible() != visible) {
            element.setVisible(visible);
            return true;
        }
        return false;
    }

    public <V> void onIngredientVisibilityChanged(ITypedIngredient<V> ingredient, boolean visible) {
        IIngredientType<V> ingredientType = ingredient.getType();
        IIngredientHelper<V> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredientType);
        this.searchForMatchingElement(ingredientHelper, ingredient).ifPresent(matchingElementInfo -> {
            IListElement element = matchingElementInfo.getElement();
            if (element.isVisible() != visible) {
                element.setVisible(visible);
                this.notifyListenersOfChange();
            }
        });
    }

    @Override
    public List<IElement<?>> getElements() {
        String filterText = this.filterTextSource.getFilterText();
        filterText = filterText.toLowerCase();
        if (this.ingredientListCached == null) {
            this.ingredientListCached = this.getIngredientListUncached(filterText).map(IngredientElement::new).toList();
        }
        return this.ingredientListCached;
    }

    public @Unmodifiable List<IListElementInfo<?>> getIngredientListPreSort(Comparator<IListElementInfo<?>> directComparator) {
        return this.elementSearch.getAllIngredients().stream().sorted(directComparator).toList();
    }

    public Set<String> getModNamesForSorting() {
        return Collections.unmodifiableSet(this.modNamesForSorting);
    }

    public <T> List<T> getFilteredIngredients(IIngredientType<T> ingredientType) {
        return this.getElements().stream().map(IElement::getTypedIngredient).map(i -> i.getIngredient(ingredientType)).flatMap(Optional::stream).toList();
    }

    private Stream<ITypedIngredient<?>> getIngredientListUncached(String filterText) {
        String[] filters = filterText.split("\\|");
        List<SearchTokens> searchTokens = Arrays.stream(filters).map(this::parseSearchTokens).filter(s -> !s.toSearch.isEmpty()).toList();
        Stream<IListElementInfo<Object>> elementInfoStream = searchTokens.isEmpty() ? this.elementSearch.getAllIngredients().parallelStream() : searchTokens.stream().map(this::getSearchResults).flatMap(Collection::stream).distinct();
        return elementInfoStream.filter(info -> info.getElement().isVisible()).sorted(this.sorter.getComparator(this, this.ingredientManager)).map(IListElementInfo::getTypedIngredient);
    }

    private static <T> Optional<IListElementInfo<T>> checkForMatch(IListElementInfo<?> info, IIngredientType<T> ingredientType, String uid, Function<ITypedIngredient<T>, String> uidFunction) {
        return IngredientFilter.optionalCast(info, ingredientType).filter(cast -> {
            ITypedIngredient typedIngredient = cast.getTypedIngredient();
            String elementUid = (String)uidFunction.apply(typedIngredient);
            return uid.equals(elementUid);
        });
    }

    private static <T> Optional<IListElementInfo<T>> optionalCast(IListElementInfo<?> info, IIngredientType<T> ingredientType) {
        ITypedIngredient<?> typedIngredient = info.getTypedIngredient();
        if (typedIngredient.getType() == ingredientType) {
            IListElementInfo<?> cast = info;
            return Optional.of(cast);
        }
        return Optional.empty();
    }

    @Override
    public <V> void onIngredientsAdded(IIngredientHelper<V> ingredientHelper, Collection<ITypedIngredient<V>> ingredients) {
        for (ITypedIngredient<V> value : ingredients) {
            Optional<IListElementInfo<V>> matchingElementInfo = this.searchForMatchingElement(ingredientHelper, value);
            if (matchingElementInfo.isPresent()) {
                IListElement<V> matchingElement = matchingElementInfo.get().getElement();
                this.updateHiddenState(matchingElement);
                if (!DebugConfig.isDebugModeEnabled()) continue;
                LOGGER.debug("Updated ingredient: {}", (Object)ingredientHelper.getErrorInfo(value.getIngredient()));
                continue;
            }
            IListElement<V> element = IngredientListElementFactory.createOrderedElement(value);
            IListElementInfo<V> listElementInfo = ListElementInfo.create(element, this.ingredientManager, this.modIdHelper);
            if (listElementInfo == null) continue;
            this.addIngredient(listElementInfo);
            if (!DebugConfig.isDebugModeEnabled()) continue;
            LOGGER.debug("Added ingredient: {}", (Object)ingredientHelper.getErrorInfo(value.getIngredient()));
        }
        this.invalidateCache();
    }

    @Override
    public <V> void onIngredientsRemoved(IIngredientHelper<V> ingredientHelper, Collection<ITypedIngredient<V>> ingredients) {
        for (ITypedIngredient<V> typedIngredient : ingredients) {
            Optional<IListElementInfo<V>> matchingElementInfo = this.searchForMatchingElement(ingredientHelper, typedIngredient);
            if (matchingElementInfo.isEmpty()) {
                String errorInfo = ingredientHelper.getErrorInfo(typedIngredient.getIngredient());
                LOGGER.error("Could not find a matching ingredient to remove: {}", (Object)errorInfo);
                continue;
            }
            if (DebugConfig.isDebugModeEnabled()) {
                LOGGER.debug("Removed ingredient: {}", (Object)ingredientHelper.getErrorInfo(typedIngredient.getIngredient()));
            }
            IListElement<V> matchingElement = matchingElementInfo.get().getElement();
            matchingElement.setVisible(false);
        }
        this.invalidateCache();
    }

    private SearchTokens parseSearchTokens(String filterText) {
        SearchTokens searchTokens = new SearchTokens(new ArrayList<ElementPrefixParser.TokenInfo>(), new ArrayList<ElementPrefixParser.TokenInfo>());
        if (filterText.isEmpty()) {
            return searchTokens;
        }
        Matcher filterMatcher = FILTER_SPLIT_PATTERN.matcher(filterText);
        while (filterMatcher.find()) {
            String string = filterMatcher.group(1);
            boolean remove = string.startsWith("-");
            if (remove) {
                string = string.substring(1);
            }
            if ((string = QUOTE_PATTERN.matcher(string).replaceAll("")).isEmpty()) continue;
            this.elementPrefixParser.parseToken(string).ifPresent(result -> {
                if (remove) {
                    searchTokens.toRemove.add((ElementPrefixParser.TokenInfo)result);
                } else {
                    searchTokens.toSearch.add((ElementPrefixParser.TokenInfo)result);
                }
            });
        }
        return searchTokens;
    }

    private Set<IListElementInfo<?>> getSearchResults(SearchTokens searchTokens) {
        List resultsPerToken = searchTokens.toSearch.stream().map(this.elementSearch::getSearchResults).toList();
        Set<IListElementInfo<IListElementInfo<?>>> results = IngredientFilter.intersection(resultsPerToken);
        if (!results.isEmpty() && !searchTokens.toRemove.isEmpty()) {
            for (ElementPrefixParser.TokenInfo tokenInfo : searchTokens.toRemove) {
                Set<IListElementInfo<?>> resultsToRemove = this.elementSearch.getSearchResults(tokenInfo);
                results.removeAll(resultsToRemove);
                if (!results.isEmpty()) continue;
                break;
            }
        }
        return results;
    }

    private static <T> Set<T> intersection(List<Set<T>> sets) {
        Set<T> set;
        Set smallestSet = sets.stream().min(Comparator.comparing(Set::size)).orElseGet(Set::of);
        Set results = Collections.newSetFromMap(new IdentityHashMap());
        results.addAll(smallestSet);
        Iterator<Set<T>> iterator = sets.iterator();
        while (!(!iterator.hasNext() || (set = iterator.next()) != smallestSet && results.retainAll(set) && results.isEmpty())) {
        }
        return results;
    }

    @Override
    public void addSourceListChangedListener(IIngredientGridSource.SourceListChangedListener listener) {
        this.listeners.add(listener);
    }

    private void notifyListenersOfChange() {
        for (IIngredientGridSource.SourceListChangedListener listener : this.listeners) {
            listener.onSourceListChanged();
        }
    }

    private record SearchTokens(List<ElementPrefixParser.TokenInfo> toSearch, List<ElementPrefixParser.TokenInfo> toRemove) {
    }
}

